 $   ver = 'F$VERIFY(0) $   GOTO COPYTAPES $! $!  PROCEDURE 'COPYTAPES'  $!F $!  Performs a tape-to-tape copy of a VAX SIG tape.  The SIG tape must; $!  have been created using the BACKUP/INTERCHANGE command.  $!G $!  This procedure handles both 1600 bpi and 6250 bpi tapes; the output : $!  tape is created at the same density as the input tape. $!F $!  If invoked as a batch job, P1 must be the input tape drive, P2 theF $!  output tape drive, and P3 can optionally be a priority for the job $!  to run at. $! $!3 $!  Alan L. Zirkle     Naval Surface Warfare Center $ $!		       Dahlgren, Virginia  22448 $!			(703) 663-8023  $! $! $! NOTE:C $! As of Fall 1987 and for later tapes, VAX SIG tapes are generally F $! produced with large blocksizes. To duplicate these tapes, I suggestE $! using the TCOPY utility in [VAX000.TOOLS]. It does double buffered C $! tape to tape copy. For sites with one tape and lots of free disk B $! space, the VMSTPC utility is the fastest way to duplicate tape.B $!   You can also use Backup to copy the files on tape to disk and, $! run Backup to create new tapes from them. $!C $!  The tape format has been changed owing to the VERY large volume = $! of material submitted to the tape copy. BACKUP/INTERCHANGE B $! puts much less material on tape (especially at 6250) than blockD $! sizes of 16384 or larger.  Compression of submitted materials hasD $! been largely abandoned because it causes operational problems forG $! sites with little free disk space, and because the number of volumes C $! at 1600 BPI cannot be reduced to 2 any longer even if everything  $! is compressed.  $!% $!  Glenn Everhart, VAX SIG librarian  $!   215 354 7610 work $! $ COPYTAPES:" $   batch = F$MODE() .EQS. "BATCH"A $   IF batch .AND. (p1 .EQS. "" .OR. p2 .EQS. "") THEN  GOTO EXIT  $!? $   IF batch .AND. p3 .NES. "" THEN  SET PROCESS /PRIORITY='p3'  $! $   in  = p1 $   out = p2 $! $ IN: ! $   IF in .NES. "" THEN  GOTO OUT ' $   INQUIRE in "Enter input tape drive"  $   GOTO IN  $! $ OUT:$ $   IF out .NES. "" THEN  GOTO START) $   INQUIRE out "Enter output tape drive"  $   GOTO OUT $! $ START: $   WRITE SYS$OUTPUT " " $!6 $   in  = F$GETDVI(in, "DEVNAM")		! In case IN and OUT: $   out = F$GETDVI(out,"DEVNAM")		!  contain logical names $! $   in_  = in  - "_" - ":" $   out_ = out - "_" - ":" $! $   IF .NOT. batch THEN - E 	INQUIRE x "Load old tape on ''in_', new tape on ''out_', enter <CR>"  $! $   WRITE SYS$OUTPUT " " $!$ $   start = F$EXTRACT(0,17,F$TIME()) $!7 $   MOUNT /NOWRITE /OVERRIDE=ID /CACHE=TAPE 'in' VAX000  $!" $   volnam = F$GETDVI(in,"VOLNAM") $!= $   density = (F$GETDVI(in,"DEVDEPEND") .AND. %X1F00) / %X100  $!
 $   dens = "" ) $   IF density .EQ. 4 THEN  dens = "1600" ) $   IF density .EQ. 5 THEN  dens = "6250" " $   IF dens .NES. "" THEN  GOTO GO $! $   WRITE SYS$OUTPUT "  ***** ERROR -- ",- 2 			"Could not determine input tape's density ***** " 
 $   GOTO EXIT  $! $ GO:  $   WRITE SYS$OUTPUT "+ Output tape will be written at ",dens," bpi  "  $!% $   errcount = F$GETDVI(out,"ERRCNT")  $!* $   INITIALIZE /DENS='dens' 'out' 'volnam' $!0 $   MOUNT /BLOCK=8192 /CACHE=TAPE 'out' 'volnam' $! $   WRITE SYS$OUTPUT " " $! $   COPY 'in'*.*;* 'out'*.*;*  $! $   DISMOUNT 'in'  $   DISMOUNT 'out' $! $   WRITE SYS$OUTPUT "   Copy started ",start? $   WRITE SYS$OUTPUT "         ended ",F$EXTRACT(0,17,F$TIME())  $!0 $   errcount = F$GETDVI(out,"ERRCNT") - errcount $!& $   IF errcount .EQ. 0 THEN  GOTO EXIT $! $   IF batch THEN  GOTO BATCH  $! $   WRITE SYS$OUTPUT "" [1;7m     There were ",errcount,-$ 				" errors writing ",out,"     [m " 
 $   GOTO EXIT  $! $ BATCH: $   WRITE SYS$OUTPUT "5 ----------------------------------------------------" C $   WRITE SYS$OUTPUT "	There were ",errcount," errors writing ",out J $   WRITE SYS$OUTPUT "---------------------------------------------------- "  $! $ EXIT:  $   IF ver THEN  SET VERIFY 