Q -h- lzcmp1.c	Sat Mar 26 16:57:00 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZCMP1.C;82  /*$  *		lzcomp [-options] infile outfile  */  /*  * Edit History +  *  4-Sep-1985 MM	First (Beta test) release <  * 24-Oct-1985 MM	Save and restore xab longest record length1  *			(Note: files written with this version can't %  *			be read with previous versions.) C  * 07-Nov-1985 MM	Can now compress VMS ISAM files.  Added -s option *  *			courtesy of Arthur Olsen (elsie!ado).  */    #ifdef	DOCUMENTATION   title	lzcomp	File Compression  index		File compression    synopsis 	.s.nf% 	lzcomp [-options] [infile [outfile]]  	.s.f  description   = 	lzcomp implements the Lempel-Ziv file compression algorithm. 9 	(Files compressed by lzcomp are uncompressed by lzdcmp.) ; 	It operates by finding common substrings and replaces them 7 	with a variable-size code.  This is deterministic, and 5 	can be done with a single pass over the file.  Thus, 6 	the decompression procedure needs no input table, but' 	can track the way the table was built.   % 	Options may be given in either case.  	.lm +8  	.p -86 	-B	Input file is "binary", not "human readable text".< 	This is necessary on Dec operating systems, such as VMS and@ 	RSX-11M, that treat these files differently.  (Note that binary: 	support is rudamentary and probably insufficient as yet.); 	(On VMS version 4, this is ignored unless the -x option is 1 	specified or the input file is record-oriented.)  	.p -88 	-M bits	Write using the specified number of bits in the; 	code -- necessary for big machines making files for little 5 	machines.  For example, if compressing a file on VMS : 	which is to be read on a PDP-11, you should select -M 12. 	.p -87 	-V [n]	Verbose if specified.  If a value is specified, < 	it will enable debugging code (if compiled in).  The values 	are bit-encoded as follows: 	  -V  0	Don't print anything ) 	  -V  1	Print a summary of the operation , 	  -V  2	Print a running status on occassion& 	  -V  4	Print some debug information.) 	  -V  8	Print too much debug information " 	  -V 16 Dump the compressed files 	.p -86 	-S	Perform a transformation on the input file whereby9 	each byte is subtracted from its predecessor.  I.e., the : 	difference between bytes is compressed, rather than their> 	actual value.  This improves the performance of the algorithm9 	on certain kinds of data files.  However, it will worsen > 	the compression of most other kinds of data.  Note that filesA 	compressed with the -S option cannot be decompressed on versions > 	of Unix compress (or lzdcmp) that do not support this option. 	.s ? 	The -S option is useful for digitized video images, where each ? 	pixel element is represented as a single byte.  It may also be = 	useful when compressing digitized encoding of similar analog 7 	data, where each sample is contained in a single byte.  	.p -8; 	-X [n]	"Export" -- write a file format that can be read by A 	other operating systems.  Only the bytes in the file are copied; < 	file attributes are not preserved.  If specified, the value9 	determines the level of compatiblity.  If not specified, ; 	or specified with an explicit value of zero, and lzcomp is ; 	running on Vax/VMS version 4 under VaxC and the input file A 	is a disk or magtape file (block-oriented), a VMS-private output < 	format is used which is incompatible with the Unix compress: 	utility, but which preserves VMS file attributes.  -X may 	take on the following values:	 	.lm +4.s > 	.i -4;#0##Choose VMS private format.  See restrictions below.< 	.i -4;#1##Compatible with Unix compress version 3.0, except< 	that an end code is written that may not be compatible withC 	Unix compress. This is the default if -x is given without a value. @ 	This is the correct mode to use when transferring files between= 	VMS and RSX-11M, RSTS/E, or RT11, or when transferring files  	to LZDCMP running on Unix. 9 	.i -4;#2##As above, but do not write the extra end code. ; 	This will cause problems when decompressing on RSX-11M and  	RT11 systems.= 	.i -4;#3##As in (2) above, but suppress "block compression". - 	.i -4;#4##As in (3) above, but do not output 3 	a compress header block.  This is for compatiblity : 	with a quite early version of Unix compress (and requires! 	conditional-compilation to use). 	 	.lm -4.s 3 	Note that the -B (binary) option is ignored unless 8 	the input file is "record-oriented", such as a terminal 	or mailbox.	 	.lm -8.s 1 	The other two arguments are the input and output 3 	filenames respectively.  Redirection is supported, . 	however, the output must be a disk/tape file.  3 	The file format is almost identical to the current 7 	Unix implementation of compress (V4.0).  Files written 6 	by Unix compress should be readable by lzdcmp.  Files0 	written by lzcomp in export (-x) format will be6 	readable by Unix compress (except that lzcomp outputs0 	two "clear" codes to mark EOF.  A patch to Unix 	compress is available.)   VMS Command Language Interface  3 	In addition to the above (Unix-style) command line 9 	interface, lzcomp supports a VMS command line interface. % 	The following options are available:  	.lm +8  	.p -8 	/BITS=<value> 	.p -8. 	/EXPORT=(VMS, UNIX, BLOCK, HEADER, ENDMARKER) 	.p -8 	/MODE=(DELTA) 	.p -8' 	/SHOW=(ALL, PROGRESS, STATISTICS, FDL, ! 		DEBUG, DEBUG_SERIOUS, DEBUG_IO)  	.lm -8    VMS Restrictions  5 	VMS Private mode stores the true name and attributes 6 	of the input file into the compressed file and lzdcmp5 	restores the attributes (and filename if requested). 7 	The following restrictions apply -- they may be lifted 8 	in the future as they are primarily due to the author's8 	lack of understanding of the intricacies of of VMS I/O:  & 	    All files must be stored on disk.7 	    The lzcomp output file must be specified directly.   5 	Also, for all usage on VMS, the compressed file must # 	be written to, and read from disk.   3 	The following file attributes are not preserved by  	lzcomp:  ) 	    File ownership and protection codes. * 	    Date of creation, access, and backup. 	    Access control lists.   RSX-11M restrictions  4 	lzcomp cannot determine the file attributes and may5 	not correctly read certain specialized file formats, 8 	such as "print image".  If a binary file is compressed,3 	note that it will be decompressed as "fixed-block,  	512 byte" records.    LZW compression algorithm   6 	This section is abstracted from Terry Welch's article1 	referenced below.  The algorithm builds a string 4 	translation table that maps substrings in the input5 	into fixed-length codes.  The compress algorithm may  	be described as follows:   2 	  1. Initialize table to contain single-character 	     strings.4 	  2. Read the first character.  Set <w> (the prefix  	     string) to that character.+ 	  3. (step): Read next input character, K. 1  	  4. If at end of file, output code(<w>); exit. % 	  5. If <w>K is in the string table:  		Set <w> to <w>K; goto step 3. + 	  6. Else <w>K is not in the string table.  		Output code(<w>); ! 		Put <w>K into the string table;  		Set <w> to K; Goto step 3.  9 	"At each execution of the basic step an acceptable input 9 	string <w> has been parsed off.  The next character K is 9 	read and the extended string <w>K is tested to see if it 6 	exists in the string table.  If it is there, then the6 	extended string becomes the parsed string <w> and the7 	step is repeated.  If <w>K is not in the string table, 2 	then it is entered, the code for the successfully5 	parsed string <w> is put out as compressed data, the 6 	character K becomes the beginning of the next string, 	and the step is repeated."   5 	The decompression algorithm translates each received < 	code into a prefix string and extension [suffix] character.: 	The extension character is stored (in a push-down stack),7 	and the prefix translated again, until the prefix is a 8 	single character, which completes decompression of this5 	code.  The entire code is then output by popping the  	stack.   > 	"An update to the string table is made for each code received: 	(except the first one).  When a code has been translated,8 	its final character is used as the extension character,7 	combined with the prior string, to add a new string to]8 	the string table.  This new string is assigned a unique7 	code value, which is the same code that the compressore8 	assigned to that string.  In this way, the decompressor6 	incrementally reconstructs the same string table that< 	the decompressor used.... Unfortunately ... [the algorithm]$ 	does not work for an abnormal case.  < 	The abnormal case occurs whenever an input character string4 	contains the sequence K<w>K<w>K, where K<w> already) 	appears in the compressor string table."y  1 	The decompression algorithm, augmented to handle " 	the abnormal case, is as follows:   	  1. Read first input code;  	     Store in CODE and OLDcode;3 	     With CODE = code(K), output(K);  FINchar = K;p, 	  2. Read next code to CODE; INcode = CODE; 	     If at end of file, exit;5 	  3. If CODE not in string table (special case) then  		Output(FINchar); 		CODE = OLDcode;e" 		INcode = code(OLDcode, FINchar); 	   	  4. If CODE == code(<w>K) then 		Push K onto the stack; 		CODE == code(<w>);	 		Goto 4.    	  5. If CODE == code(K) thene 		Output K;  		FINchar = K;   	  6. While stack not emptyo 		Output top of stack; 		Pop stack;  * 	  7. Put OLDcode,K into the string table. 	     OLDcode = INcode;s
 	     Goto 2.e  < 	The algorithm as implemented here introduces two additional 	complications.e  9 	The actual codes are transmitted using a variable-lengtho9 	encoding.  The lowest-level routines increase the numbere6 	of bits in the code when the largest possible code is
 	transmitted.l  7 	Periodically, the algorithm checks that compression isM9 	still increasing.  If the ratio of input bytes to output18 	bytes decreases, the entire process is reset.  This can8 	happen if the characteristics of the input file change.   VMS Private File Structure  7 	In VMS Private mode, the compressed data file containsi8 	a variable-length (but compressed) file header with the4 	file "attributes" needed by the operating system to4  	construct the file.  This allows the decompression5 	program to recreate the file in its original format,r5 	which is essential if ISAM databases are compressed.u  ' 	The overall file format is as follows:  	.lm +8c 	.p -8: 	LZ_SOH	"start of header" signal (this value cannot appear 	in user data).e  2 	A variable-length data record (maximum 256 bytes)= 	containing the header name, followed by whitespace, followedr8 	by header-specific information.  In this case, the name9 	record will contain the string "vms$attributes" followeds4 	by the number of bytes in the attribute data block.: 	(I assume that the name record will consist of a facility9 	name, such as "vms", followed by a dollar sign, followeda 	by a facility-unique word.) 	.p -8  	LZ_EOR	Signals "end of record".  < 	This is followed by a VMS file attributes record (generated" 	by a VMS system library	routine). 	.p -8+ 	LZ_EOR	Signals "end of record" (optional).e 	 < 	This is followed by another "header record" with additional7 	information.  Currently, this is only used to transmit 7 	the "longest record length" field from the input file.   8 	Additional header records may be defined in the future. 	.p -8! 	LZ_ETX	Signals "end of segment".f 	.p -8; 	ST_STX	Signals "start of text" (i.e., start of data file).u  ( 	This is followed by the user data file. 	.p -8  	LZ_ETX	Signals "end of segment" 	.p -8+ 	LZ_ETX	Two in a row signals "end of file".f	 	.s.lm -8l8 	Note that this format can easily be extended to include8 	trailer records (with file counts and checksums) and/or, 	multiple data files in one compressed file.  7 	Note also that the LZ_CLEAR code may appear in headers 4 	or data files to cause the decompression program to4 	"readapt" to the characteristics of the input data.3 	LZ_STX and LZ_SOH reset the compression algorithm.n 	LZ_EOR does not.    AuthorsP  8 	The algorithm is from "A Technique for High Performance: 	Data Compression."  Terry A. Welch. IEEE Computer Vol 17, 	No. 6 (June 1984), pp 8-19.  " 	This revision is by Martin Minow.  & 	Unix Compress authors are as follows: 	.s.nf8 	Spencer W. Thomas	(decvax!harpo!utah-cs!utah-gr!thomas) 	Jim McKie		(decvax!mcvax!jim). 	Steve Davies		(decvax!vax135!petsd!peora!srd)- 	Ken Turkowski		(decvax!decwrl!turtlevax!ken)m( 	James A. Woods		(decvax!ihnp4!ames!jaw)% 	Joe Orost		(decvax!vax135!petsd!joe)" 	.s.fo   #endif   /*,  * Compatible with compress.c, v3.0 84/11/27  */t   /*)BUILD 		$(PROGRAM) = lzcompu 		$(INCLUDE) = lz.ht 		$(CPP) = 1 		$(RMS) = 1: 		$(FILES) = { lzcmp1.c lzcmp2.c lzcmp3.c lzio.c lzvio.c } */   #include	"lz.h"i     #ifdef unixu #include <sys/types.h> #include <sys/stat.h>. #endif   /*>  * These global parameters are written to the compressed file.D  * The decompressor needs them.  The initialized values are defaults.  * and are modified by command line arguments.  */ 6 short		maxbits = BITS;		/* settable max # bits/code	*/< code_int maxmaxcode = 1 << BITS; 	/* Totally largest code	*/5 code_int	hsize = HSIZE;		/* Actual hash table size	*/    /*9  * Flags (command line arguments) to control compression.e  */.
 #if VMS_V49 flag		export = EXPORT_VMS	/* Assume vms "private" mode	*/D 			| EXPORT_HEADER 			| EXPORT_BLOCK  			| EXPORT_ENDMARKER; #elseS< flag		export = EXPORT_UNIX	/* Assume Unix compatible mode	*/ 			| EXPORT_HEADER 			| EXPORT_BLOCKd 			| EXPORT_ENDMARKER; #endif+ flag		method = METHOD_LZ;	/* Of course			*/d flag		mode = MODE_TEXT;e flag		show = 0;(7 flag		background = FALSE;	/* TRUE (Unix) if detached	*/ < readonly flag	is_compress = TRUE;	/* for lzdcl and lzvio		*/- long		fsize;			/* Input file size in bytes	*/g4 char		*infilename = NULL;	/* For error printouts		*/: char		*outfilename = NULL;	/* For openoutput and errors	*/1 int		firstcode;		/* First code after internals	*/,< count_int	tot_incount = 0;	/* Total number of input bytes	*/> count_int	tot_outcount = 0;	/* Total number of output codes	*/ extern count_int in_count; extern count_int out_count;D8 static long	start_time;		/* Time we started (in msec)	*/: extern long	cputime();		/* Returns process time in msec	*/ STREAM		instream;a STREAM		outstream; char_type	inbuffer[MAXIO]; char_type	outbuffer[MAXIO];n
 #if VMS_V4 static STREAM	mem_stream;e #endif jmp_buf		failure;e
 #if VMS_V4 #include types
 #include statc #ifndef FDLSTUFF #define FDLSTUFF charT #endif FDLSTUFF	*fdl_input; FDLSTUFF	*fdl_output; , static struct dsc$descriptor fdl_descriptor; #endif s main(argc, argv)
 int		argc; char		*argv[]; /*  * Compress mainline  */e {m
 	int		status;   
 #ifndef	decuse 	/*fE 	 * background is TRUE if running detached from the command terminal.t 	 */B 	background = (signal(SIGINT, SIG_IGN) == SIG_IGN) ? TRUE : FALSE; 	if (!background).* 	    background = !isatty(fileno(stderr)); 	if (!background) {oI 	    if ((show & (SHOW_DEBUG | SHOW_SERIOUS_DEBUG | SHOW_IO_DEBUG)) != 0)	 		signal(SIGINT, abort); 	    else {l 		signal(SIGINT, interrupt);! 		signal(SIGSEGV, address_error);  	    } 	} #endif' 	if ((status = setjmp(failure)) == 0) { 6 	    setup(argc, argv);		/* Command line parameters	*/	 #if DEBUG  	    if (show & SHOW_DEBUG)  		dumpoptions(); #endif1 	    openinput();		/* Open input, set instream	*/i/ 	    getfilesize();		/* Get input file size		*/ 5 	    gethashsize();		/* Get actual hash table size	*/>2 	    initialize();		/* Set maxbits and the like	*/+ 	    openoutput();		/* Open output file		*/ ' 	    if ((show & SHOW_STATISTICS) != 0)i 		start_time = cputime();a 	    put_magic_header(); 	    init_compress(TRUE);t 	    compress(&instream);r
 #if VMS_V4& 	    if ((export & EXPORT_VMS) != 0) {  		outputcode((code_int) LZ_ETX);  		outputcode((code_int) LZ_ETX); 		fdl_close(fdl_input);n 	    }	 	    elsed #endif, 	    if ((export & EXPORT_ENDMARKER) != 0) {" 		outputcode((code_int) LZ_CLEAR);" 		outputcode((code_int) LZ_CLEAR); 	    }; 	    outputcode((code_int) -1);		/* Flush output buffers	*/ 
 #if VMS_V4$ 	    if ((export & EXPORT_VMS) != 0) 		fdl_close(fdl_output); 	    else {e 		fclose(stdout);a 	    } #elset 	    fclose(stdout); #endif' 	    if ((show & SHOW_STATISTICS) != 0)c 		report();t 	    exit(EXIT_SUCCESS); 	} 	else {]A 	    fprintf(stderr, "Error when compressing \"%s\" to \"%s\"\n",a 		(infilename  == NULL) ? * 		    "<input file unknown>" : infilename, 		(outfilename == NULL) ?p- 		    "<output file unknown>" : outfilename);r 	    exit(status); 	} }r o report() /*  * Print verbose report.  */  {e% 	start_time = cputime() - start_time;e 	tot_incount += in_count;v 	tot_outcount += out_count; 6 	fprintf(stderr, "%8ld chars, %5ld blocks processed.",/ 	    tot_incount, (tot_incount + 511L) / 512L);d 	if (tot_outcount > 0) {$ 	    divout("  Compression ratio: ",/ 		(long) tot_incount, (long) tot_outcount, "");  	    divout(" (", 3 		((long) tot_incount - (long) tot_outcount) * 100,F 		(long) tot_incount, "%),");o 	}6 	fprintf(stderr, "\n%8ld chars, %5ld blocks output\n",1 	    tot_outcount, (tot_outcount + 511L) / 512L);e 	fprintf(stderr,9 	    "%ld.%02ld seconds (process time) for compression.",;5 	    start_time / 1000L, (start_time % 1000L) / 10L);h 	if (start_time > 0) {+ 	    divout("  ", (long) tot_incount * 10L,) 		(start_time + 50L) / 100L, 		" input bytes/sec.\n");  	} }t  % divout(leader, numer, denom, trailer)  char		*leader; long		numer; long		denom; char		*trailer;  /*>  * Print numer/denom without floating point on small machines.  */  {  	register int 	negative;   	negative = FALSE; 	if (numer < 0) {s 	    numer = -numer; 	    negative = TRUE;t 	} 	if (denom < 0) {e 	    denom = -denom; 	    negative = !negative; 	}# 	fprintf(stderr, "%s%s%ld.%02ld%s",r# 	    leader, (negative) ? "-" : "",c? 	    numer / denom, ((numer % denom) * 100L) / denom, trailer);o }t   static initialize() /*  * Mung some global values.s  */  {p9 	if (maxbits < INIT_BITS)	/* maxbits is set by the -M 	*/ 7 	    maxbits = INIT_BITS;	/* option.  Make sure it's	*/e5 	if (maxbits > BITS)		/* within a reasonable range	*/e 	    maxbits = BITS;5 	maxmaxcode = 1 << maxbits;	/* Truly biggest code		*/   	if ((export & EXPORT_VMS) != 0). 	    firstcode = LZ_FIRST;	/* VMS private			*/' 	else if ((export & EXPORT_BLOCK) != 0) . 	    firstcode = LZ_CLEAR + 1;	/* Default			*/ 	elsee2 	    firstcode = 256;		/* Backwards compatible		*/ }_ 	 put_magic_header() /*  * Write the magic header bits.s  */t {e@ 	if ((export & (EXPORT_VMS | EXPORT_HEADER)) == EXPORT_HEADER) {" 	    PUT(HEAD1_MAGIC, &outstream);" 	    PUT(HEAD2_MAGIC, &outstream); 	    PUT(maxbits6 		| (((export & EXPORT_HEADER) != 0) ? BLOCK_MASK : 0)7 		| (((mode   & MODE_DELTA)    != 0) ? DIFF_MASK  : 0),a 		&outstream); 	}
 #if VMS_V4' 	else if ((export & EXPORT_VMS) != 0) {a 	    char		text[256];" 	    /*l/ 	     * VMS private mode (with attribute block)u 	     */" 	    PUT(HEAD1_MAGIC, &outstream);& 	    PUT(VMS_HEAD2_MAGIC, &outstream); 	    PUT(maxbits 		| BLOCK_MASK2 		| (((mode & MODE_DELTA) != 0) ? DIFF_MASK  : 0), 		&outstream);( 	    PUT(firstcode - 0x100, &outstream); 	    init_compress();c 	    outputcode(LZ_SOH);	 #if DEBUGC( 	    if (strlen(ATT_NAME) != ATT_SIZE) {* 		fprintf("\"%s\", expected %d, got %d\n",, 		    ATT_NAME, ATT_SIZE, strlen(ATT_NAME)); 	    } #endifC 	    sprintf(text, "%s%d;", ATT_NAME, fdl_descriptor.dsc$w_length);T& 	    mem_compress(text, strlen(text)); 	    outputcode(LZ_EOR);/ 	    mem_compress(fdl_descriptor.dsc$a_pointer,	! 			 fdl_descriptor.dsc$w_length);L 	    fdl_free(&fdl_descriptor);f, 	    if (fdl_input->xabfhc.xab$w_lrl != 0) { 		outputcode(LZ_EOR);o@ 		sprintf(text, "xabfhc$w_lrl %d", fdl_input->xabfhc.xab$w_lrl); 		if ((show & SHOW_FDL) != 0)o7 		    fprintf(stderr, "Additional header: %s\n", text);p# 		mem_compress(text, strlen(text));a 	    } 	    outputcode(LZ_ETX); 	    outputcode(LZ_STX); 	} #endif }i  
 #if VMS_V4 mem_compress(datum, length)m char_type	*datum;n int		length; /*  * Compress from memoryg  */m { + 	mem_stream.bp = mem_stream.bstart = datum;  	mem_stream.bsize = length;." 	mem_stream.bend = datum + length; 	mem_stream.func = lz_eof; 	compress(&mem_stream);. }  #endif e /*@  * This routine is used to tune the hash table size according to>  * the file size.  If the filesize is unknown, fsize should be  * set to zero.x  */e   typedef struct TUNETAB {     long	fsize;l     code_int	hsize;m
 } TUNETAB;  % static readonly TUNETAB tunetab[] = {c #if HSIZE > 5003     {	1 << 12,	 5003	},  #endif #if HSIZE > 9001     {	1 << 13,	 9001	},* #endif #if HSIZE > 18013)     {	1 << 14,	18013	},= #endif #if HSIZE > 35023M     {	1 << 15,	35023	},c     {	  47000,	50021	},z #endif     {	      0,	    0	}," };   static
 gethashsize()c /*2  * Tune the hash table parameters for small files.<  * We don't have a good way to find the file size on vms V3.,  * fsize is set to zero if we can't find it.  */d {l 	register TUNETAB	*tunep;e   	hsize = HSIZE;d 	if (fsize > 0) {*8 	    for (tunep = tunetab; tunep->fsize != 0; tunep++) { 		if (fsize < tunep->fsize) {T 		    hsize = tunep->hsize;/ 		    break; 		}H 	    } 	} }l s static
 getfilesize()  /*:  * Set fsize to the input filesize (in bytes) if possible.#  * Magic for all operating systems.M  */A {m
 #ifdef	rsx: 	extern char	f_efbk;	/* F.EFBK -- highest block in file	*/A #define	fdb(p,offset)	(stdin->io_fdb[((int) &p + offset)] & 0xFF) ( #define efbk(offset)	fdb(f_efbk, offset)1 	extern char	f_rtyp;	/* F.RTYP -- Record type		*/l7 	extern char	f_ratt;	/* F.RATT -- Record attributes		*/M 	/*E7 	 * Note: Block number is stored high-order word first.  	 */ 	fsize = efbk(2) 	    + (efbk(3) << 8)s 	    + (efbk(0) << 16) 	    + (efbk(1) << 24);; 	fsize *= 512; #endif #ifdef	rt11h/ 	fsize = stdin->io_size;		/* Set by Decus C		*// 	fsize *= 512; #endif
 #ifdef	vms
 #if VMS_V4 	struct stat	statbuf;t   	fsize = 0; " 	if ((export & EXPORT_VMS) == 0) {- 	    if (fstat(fileno(stdin), &statbuf) == 0)	! 		fsize = (long) statbuf.st_size;T 	} 	else {f) 	    fsize = (long) fdl_fsize(fdl_input);; 	} #elseu( 	fsize = 0;				/* Can't find filesize	*/ #endif #endif #ifdef	unixc 	struct stat	statbuf;m   	fsize = 0;s) 	if (fstat(fileno(stdin), &statbuf) == 0)a$ 	    fsize = (long) statbuf.st_size; #endif }  r$ static readonly char *helptext[] = {$ 	"The following options are valid:",; 	"-B\tBinary file (important on VMS/RSX, ignored on Unix)", : 	"-M val\tExplicitly set the maximum number of code bits",) 	"-S\tCompress difference between bytes",s= 	"-V val\tPrint status information (or debugging) to stderr",g+ 	"-X val\tSet export (compatiblity) mode:",s
 #if VMS_V4. 	"  -X 0\tExplicitly choose VMS Private mode", #endifA 	"  -X 1\t(default if -X specified, output format is compatible", I 	      "\twith Unix compress V3.0, except that two endcodes are written", A 	"  -X 2\t(default if -X specified, output format is compatible",a# 	      "\twith Unix compress V3.0",D@ 	"  -X 3\tCompatible with Unix compress 3.0, block compression", 	      "\tsuppressed.", 6 	"  -X 4No header (file is readable by old compress)", 	NULL, };   static setup(argc, argv)s
 int		argc; char		*argv[]; /*:  * Get parameters and open files.  Exit fatally on errors.  */  {  	register char	*ap;G 	register int	c; 	char		**hp; 	auto int	i; 	int		j; 	int		temp;n  
 #ifdef	vms# 	argc = getredirection(argc, argv);s 	/**2 	 * Prescan to see whether we must do a DCL parse. 	 */( 	for (j = FALSE, i = 1; i < argc; i++) { 	    if (argv[i][0] == '-') {	 		j = TRUE;t 		break; 	    } 	} 	if (j == FALSE) {/ 	    if ((i = lzdcl(argc, argv)) != SS$_NORMAL)m
 		exit(i); 	    return; 	} #endif! 	for (i = j = 1; i < argc; i++) {i 	    ap = argv[i];5 	    if (*ap++ != '-' || *ap == EOS)	/* Filename?		*/Z+ 		argv[j++] = argv[i];		/* Just copy it		*/d 	    else {n 		while ((c = *ap++) != EOS) { 		    if (islower(c))E 			c = toupper(c); 		    switch (c) { 		    case 'B':R 			mode |= MODE_BINARY;t	 			break;;   		    case 'M':u$ 			maxbits = getvalue(ap, &i, argv); 			if (maxbits < MIN_BITS) {- 			    fprintf(stderr, "Illegal -M value\n");d 			    goto usage; 			}	 			break;d   		    case 'S':s 			mode |= MODE_DELTA;	 			break;    		    case 'V':_! 			show = getvalue(ap, &i, argv); 	 			break;T   		    case 'X':s- 			switch ((temp = getvalue(ap, &i, argv))) {i 			case 0:	export = EXPORT_VMS 					| EXPORT_BLOCK  					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break; 			case 1:	export = EXPORT_UNIXn 					| EXPORT_BLOCK) 					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break;   			case 2: export = EXPORT_UNIXm 					| EXPORT_BLOCK_ 					| EXPORT_HEADER; 
 				break; 			case 3:	export = EXPORT_UNIXr 					| EXPORT_HEADER;s
 				break;  			case 4:	export = EXPORT_UNIX;
 				break; 			default:27 			    fprintf(stderr, "Illegal -X value: %d\n", temp);n 			    goto usage; 			}	 			break;n   		    default:5 			fprintf(stderr, "Unknown option '%c' in \"%s\"\n",) 				*ap, argv[i]);/ usage:			for (hp = helptext; *hp != NULL; hp++)s$ 			    fprintf(stderr, "%s\n", *hp); 			FAIL("usage", EXIT_FAILURE);u" 		    }				/* Switch on options	*/  		}				/* Everything for -xxx	*/ 	    }					/* If -option		*/ 	}					/* For all argc's	*/(5 	/*  infilename = NULL; */		/* Set "stdin"  signal	*/ 5 	/* outfilename = NULL; */		/* Set "stdout" signal	*/m* 	switch (j) {				/* Any file arguments?	*/# 	case 3:					/* both files given	*/o8 	    if (!streq(argv[2], "-"))		/* But - means stdout	*/ 		outfilename = argv[2];# 	case 2:					/* Input file given	*/n 	    if (!streq(argv[1], "-")) 		infilename = argv[1];  	    break;    	case 0:					/* None!		*/ $ 	case 1:					/* No file arguments	*/ 	    break;   	 	default:e2 	    fprintf(stderr, "Too many file arguments\n");* 	    FAIL("too many files", EXIT_FAILURE); 	} }e (
 static int getvalue(ap, ip, argv) register char		*ap;o
 int			*ip; char			*argv[];o /*H  * Compile a "value".  We are currently scanning *ap, part of argv[*ip].  * The following are possible:7  *	-x123		return (123) and set *ap to EOS so the callero$  *	ap^		cycles to the next argument.  *6  *	-x 123		*ap == EOS and argv[*ip + 1][0] is a digit.3  *			return (123) and increment *i to skip over the	  *			next argument.E  *1  *	-xy or -x y	return(1), don't touch *ap or *ip.v  *D  * Note that the default for "flag option without value" is 1.  This@  * can only cause a problem for the -M option where the value is@  * mandatory.  However, the result of 1 is illegal as it is less  * than INIT_BITS.  */  {  	register int	result;V 	register int	i;  
 	i = *ip + 1;E 	if (isdigit(*ap)) { 	    result = atoi(ap);P 	    *ap = EOS;o 	} 	else if (*ap == EOS 	      && argv[i] != NULLH  	      && isdigit(argv[i][0])) { 	    result = atoi(argv[i]);
 	    *ip = i;K 	} 	else {o 	    result = 1; 	} 	return (result);p }  X openinput()0 {a #ifdef decus 	if (infilename == NULL) {" 	    infilename = malloc(256 + 1);! 	    fgetname(stdin, infilename);G> 	    infilename = realloc(infilename, strlen(infilename) + 1); 	} 	else {	 	    if (freopen(infilename,, 			((mode & MODE_BINARY) != 0) ? "rb" : "r", 			stdin) == NULL) { 		perror(infilename);;) 		FAIL("can't reopen input", ERROR_EXIT);Z 	    } 	} #else 
 #ifdef vms
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) { 	    char		*fname; 	    char		filename[256];I  ( 	    if ((fname = infilename) == NULL) { 		fgetname(stdin, filename); 		fname = filename;c 	    }B 	    if ((fdl_input = fdl_open(fname, &fdl_descriptor)) == NULL) {) 		if (!$VMS_STATUS_SUCCESS(fdl_status)) {p) 		    FAIL("can't fdl_open", fdl_status);L 		}  		fprintf(stderr,r: 		    "Cannot open \"%s\" in vms private format,", fname);. 		fprintf(stderr, " trying export format.\n"); 		export = TRUE; 		goto try_export; 	    } 	    fclose(stdin);o 	    stdin = NULL;, 	    infilename = malloc(strlen(fname) + 1); 	    strcpy(infilename, fname); " 	    if ((show & SHOW_FDL) != 0) {> 		fprintf(stderr, "FDL information for \"%s\"\n", infilename);$ 		fdl_dump(&fdl_descriptor, stderr); 	    } 	    goto opened;s 	} try_export:* #endif 	if (infilename == NULL) {" 	    infilename = malloc(256 + 1);! 	    fgetname(stdin, infilename);m> 	    infilename = realloc(infilename, strlen(infilename) + 1); 	} 	else { 
 #if VMS_V4% 	    if ((stdin = freopen(infilename,b> 		((mode & MODE_BINARY) != 0) ? "rb" : "r", stdin)) == NULL) { #elsei3 	    if (freopen(infilename, "r", stdin) == NULL) {t #endif 		perror(infilename);  		exit(ERROR_EXIT);  	    } 	} #elser 	if (infilename == NULL) 	    infilename = "stdin"; 	else {,3 	    if (freopen(infilename, "r", stdin) == NULL) {  		perror(infilename);S 		exit(ERROR_EXIT);  	    }		     	} #endif #endif
 #if VMS_V4- opened:	;				/* Exit from VMS-private open	*/} #endif$ 	instream.bp = instream.bend = NULL; 	instream.bstart = inbuffer;" 	instream.bsize = sizeof inbuffer; 	instream.func = lz_fill;e }g   openoutput() /*?  * Open the output file (after the input file has been opened). 7  * if outfilename == NULL, it's already open on stdout.   */f {e 	int			ttytest;r  1 	ttytest = TRUE;			/* Need to test output file	*/f 	if (outfilename == NULL) {	
 #if VMS_V4 	    fprintf(stderr,7 		"Restriction: The output file must be specified.\n"); 4 	    FAIL("can't redirect on VMS V4", EXIT_FAILURE); #else.
 #ifdef	vms# 	    outfilename = malloc(256 + 1); # 	    fgetname(stdout, outfilename);.A 	    outfilename = realloc(outfilename, strlen(outfilename) + 1);f #elset #ifdef decus# 	    outfilename = malloc(256 + 1);f# 	    fgetname(stdout, outfilename);/A 	    outfilename = realloc(outfilename, strlen(outfilename) + 1);o #elsei 	    outfilename = "<stdout>"; #endif #endif #endif 	} 	else {r
 #if VMS_V4& 	    if ((export & EXPORT_VMS) != 0) { 		fclose(stdout);<5 		ttytest = FALSE;	/* Can't do terminal test below	*/ @ 		if ((fdl_output = fdl_create(NULL, outfilename, 0)) == NULL) { 		    fprintf(stderr,i7 			"Can't create \"%s\" (VMS private)\n", outfilename);0+ 		    FAIL("can't fdl_create", fdl_status);i 		}t 	    } 	    else {a2 		if (freopen(outfilename, "w", stdout) == NULL) { 		    perror(outfilename);' 		    FAIL("can't create", ERROR_EXIT);f 		}= 	    } #else  #ifdef decus6 	    if (freopen(outfilename, "wb", stdout) == NULL) { 		perror(outfilename);# 		FAIL("can't create", ERROR_EXIT);  	    } #elseo5 	    if (freopen(outfilename, "w", stdout) == NULL) {h 		perror(outfilename);# 		FAIL("can't create", ERROR_EXIT);B 	    } #endif #endif 	}) 	if (ttytest && isatty(fileno(stdout))) {l8 	    fprintf(stderr, "%s: is a terminal.  We object.\n", 		outfilename);w( 	    FAIL("can't create", EXIT_FAILURE); 	}- 	outstream.bp = outstream.bstart = outbuffer;x/ 	outstream.bend = outbuffer + sizeof outbuffer;0$ 	outstream.bsize = sizeof outbuffer; 	outstream.func = lz_flush;i }X  Q -h- lzcmp2.c	Sat Mar 26 16:57:00 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZCMP2.C;15  /*  *		l z c m p 2 . ct  *9  * Actually do compression.  Terminology (and algorithm):m  *E  * Assume the input string is "abcd", we have just processed "ab" and F  * read 'c'.  At this point, a "prefix code" will be assigned to "ab".E  * Search in the prefix:character memory (either the "fast memory" or D  * the hash-code table) for the code followed by this character.  IfA  * found, assign the code found to the "prefix code" and read the*A  * next character.  If not found, output the current prefix code,	@  * generate a new prefix code and store "old_prefix:char" in the-  * table with "new_prefix" as its definition.s  *  * Naming conventions:-  *   code	a variable containing a prefix code'0  *   c or char	a variable containing a character  *F  * There are three tables that are searched (dependent on compile-time&  * and execution time considerations):C  *   fast	Direct table-lookup -- requires a huge amount of physicalp)  *		(non-paged) memory, but is very fast.r"  *   hash	Hash-coded table-lookup.A  *   cache	A "look-ahead" cache for the hash table that optimizescA  *		searching for the most frequent character.  This considerablyD;  *		speeds up processing for raster-images (for example) ata  *		a modest amount of memory.I  * Structures are used to hold the actual tables to simplify organizationt  * of the program.  *  * Subroutines:'B  *    compress()	performs data compression on an input datastream.C  *    init_compress()	called by the output routine to clear tables.c  */e   #include	"lz.h"i   /*  * General variables6  * Cleared by init_compress on a "hard initialization"0  * outputcode() in lzcmp3.c refers to next_code.  */e  * long int	in_count;		/* Length of input		*/7 long int	out_count;		/* Bytes written to output file	*/ ; static flag	first_clear = TRUE;	/* Don't zero first time	*/	, code_int	next_code;		/* Next output code		*/G static count_int checkpoint = CHECK_GAP; /* When to test ratio again	*/ 4 static long	ratio = 0;		/* Ratio for last segment	*/   /*E  * These global parameters are set by mainline code.  Unchanged here.e  */ = extern code_int	maxmaxcode;		/* Actual maximum output code	*/%2 extern long	tot_incount;		/* Total input count		*/4 extern long	tot_outcount;		/* Total output count		*/5 extern code_int	hsize;			/* Actual hash table size	*/	   #ifdef XENIX_16n static count_int htab0[8192];- static count_int htab1[8192];n static count_int htab2[8192];* static count_int htab3[8192];	 static count_int htab4[8192];  static count_int htab5[8192];" static count_int htab6[8192];  static count_int htab7[8192]; & static count_int htab8[HSIZE - 65536];  static count_int *hashtab[9] = {A     htab0, htab1, htab2, htab3, htab4, htab5, htab6, htab7, htab8u };   static U_short code0[16384]; static U_short code1[16384]; static U_short code2[16384]; static U_short code3[16384];$ static U_short code4[HSIZE - 65536]; static U_short *codetab[5] = {%     code0, code1, code3, code3, code4; }   @ #define HASH(i)		(hashtab[((unsigned) (i)) >> 13][(i) & 0x1FFF])@ #define CODE(i)		(codetab[((unsigned) (i)) >> 14][(i) & 0x3FFF])   #else* count_int	hashtab[HSIZE];  U_short		codetab[HSIZE];   #define HASH(i)		hashtab[i]l #define CODE(i)		codetab[i]3 #endif 2 /*  * compress a datastream  *M  * Algorithm:  on large machines, for maxbits <= FBITS, use fast direct tablepL  * lookup on the prefix code / next character combination.  For smaller codeO  * size, use open addressing modular division double hashing (no chaining), ala*M  * Knuth vol. 3, sec. 6.4 Algorithm D, along with G. Knott's relatively-prime M  * secondary probe.  Do block compression with an adaptive reset, whereby thehL  * code table is cleared when the compression ratio decreases, but after theM  * table fills.  The variable-length output codes are re-sized at this point,rJ  * and a special LZ_CLEAR code is generated for the decompressor.  For theG  * megamemory version, the sparse array is cleared indirectly through a[G  * "shadow" output code history.  Late additions: for the hashing code,)N  * construct the table according to file size for noticeable speed improvementH  * on small files.  Also detect and cache codes associated with the mostO  * common character to bypass hash calculation on these codes (a characteristicpM  * of highly-compressable raster images).  Please direct questions about this)  * implementation to ames!jaw.  */a   compress(in)+ STREAM		*in;		/* Input stream structure		*/v /*F  * Compress driver.  Global fsize is the size of the entire datastream?  * (from LZ_STX or LZ_SOH to the terminating LZ_ETX).  You must{K  * force a reinitialization -- by calling outputcode() with a new header --nD  * if size is changed.  If the "newer" output format is chosen (withA  * data streams delimited by LZ_SOH/LZ_STX, init_compress will beLF  * called automatically.  Otherwise, you must call init_compress(TRUE)0  * before calling compress() for the first time.  */t {"1 	register long		hash_code;	/* What we look for	*/ / 	register code_int	i;		/* Index into vectors	*/l3 	register unsigned int	c;		/* Current input char	*/e. 	register code_int	code;		/* Substring code	*/5 	register int		displacement;	/* For secondary hash	*/n6 	register code_int	hsize_reg;	/* Size of hash table	*/, 	register int		hshift;		/* For xor hasher	*/; 	register unsigned int	previous;	/* Prev. char for diffs	*/1< 	register unsigned int	difference;	/* Temp for difference	*/  ( 	if ((code = GET(in)) == (unsigned) EOF) 	    return; 	previous = code;( 	in_count++; 	hsize_reg = hsize;o 	/*M 	 * Set hash code range bound  	 */ 	hshift = 0;D 	for (hash_code = (long) hsize; hash_code < 65536L; hash_code <<= 1) 	    hshift++; 	hshift = 8 - hshift;I* 	while ((c = GET(in)) != (unsigned) EOF) { 	    in_count++;$ 	    if ((mode & MODE_DELTA) != 0) {	 #if UCHARl. 		difference = (unsigned char) (c - previous); #else % 		difference = (c - previous) & 0xFF;  #endif 		previous = c;4 		c = difference;x 	    }7 	    hash_code = (long) (((long) c << maxbits) + code);d2 	    i = (c << hshift) ^ code;		/* XOR hashing		*/< 	    if (HASH(i) == hash_code) {		/* Found at first slot?	*/ 		code = CODE(i);O 		continue;t 	    }3 	    else if ((long) HASH(i) < 0)	/* empty slot		*/n 		goto nomatch; 7 	    displacement = hsize_reg - i;	/* secondary hash	*/t 	    if (i == 0) 		displacement = 1;  probe:5 	    if ((i -= displacement) < 0)	/* Wrap around?		*/f 		i += hsize_reg;c< 	    if (HASH(i) == hash_code) {		/* Found in hash table?	*/- 		code = CODE(i);			/* Set new prefix code	*/ ( 		continue;			/* Read next input char	*/ 	    }; 	    else if ((long) HASH(i) > 0)	/* If slot is occupied	*/l) 		goto probe;			/* Look somewhere else	*/  nomatch: 	    /*s= 	     * Output the current prefix and designate a new prefix.u< 	     * If the input character was the "hog", save it in the> 	     * look-ahead cache table.  Then, save in the hash table. 	     */< 	    outputcode((code_int) code);	/* No match, put prefix	*/ #if SIGNED_COMPARE_SLOWd8 	    if ((unsigned) next_code < (unsigned) maxmaxcode) { #else	" 	    if (next_code < maxmaxcode) { #endif1 		CODE(i) = next_code++;		/* code -> hashtable	*/' 		HASH(i) = hash_code; 	    }* 	    else if ((export & EXPORT_BLOCK) != 0, 		  && (count_int) in_count >= checkpoint) {
 		clear(); 	    }+ 	    code = c;				/* Start new substring	*/r 	} 	/*a# 	 * At EOF, put out the final code.R 	 */ 	outputcode((code_int) code);f }c   clear()f /*<  * Check the compression ratio to see whether it is going up:  * or staying the same.  If it is going down, the internal8  * statistics of the file have changed, so clear out our9  * tables and start over.  Inform the decompressor of the )  * change by sending out a LZ_CLEAR code.s  */f {n 	register long int	rat;n  # 	checkpoint = in_count + CHECK_GAP;c2 	if ((show & (SHOW_PROGRESS | SHOW_DEBUG)) != 0) {F 	    divout("at compression ratio test ",  in_count, out_count, "\n"); 	}8 	if (in_count > 0x007FFFFL) {		/* Shift will overflow	*/ 	    rat = out_count >> 8; 	    if (rat == 0) 		rat = 0x7FFFFFFFL; 	    else {6 		rat = in_count / rat;P 	    } 	} 	else {M' 	    rat = (in_count << 8) / out_count;* 	} 	if (rat > ratio)n 	    ratio = rat;  	else {)6 	    if ((show & (SHOW_PROGRESS | SHOW_DEBUG)) != 0) {= 		fprintf(stderr, "Resetting compression, in %ld, out %ld\n",c 		    in_count, out_count);.) 		fprintf(stderr, "Old ratio: %ld.%02ld",(4 		    ratio / 256L, ((ratio & 255L) * 100L) / 256L);6 		fprintf(stderr, ", test ratio: %ld.%02ld, gap %d\n",; 		    rat / 256L, ((rat & 255L) * 100L) / 256L, CHECK_GAP);n 	    }? 	    outputcode((code_int) LZ_CLEAR);	/* Calls init_compress	*/t 	} }  f init_compress(full_init)4 flag		full_init;	/* TRUE for full initialization		*/ /*>  * Clear the tables.  Called by outputcode() on LZ_SOH, LZ_STX5  * (full_init TRUE) or on LZ_CLEAR (full_init FALSE).g+  * init_compress() is not called on LZ_EOR.h  */e {a #ifdef XENIX_16o 	register count_int	*hp; 	register int		n;r 	register int		j;	 	register code_int	k;r   	k = hsize;a  	for (j = 0; k > 0; k -= 8192) { 	    i = (k < 8192) ? k : 8192;  	    hp = hashtab[j++];o 	    n = i >> 4; 	    switch (i & 15) { 	    case 15:	*hp++ = -1;e 	    case 14:	*hp++ = -1;o 	    case 13:	*hp++ = -1;s 	    case 12:	*hp++ = -1;u 	    case 11:	*hp++ = -1;g 	    case 10:	*hp++ = -1;  	    case  9:	*hp++ = -1;* 	    case  8:	*hp++ = -1;d 	    case  7:	*hp++ = -1;i 	    case  6:	*hp++ = -1;  	    case  5:	*hp++ = -1;s 	    case  4:	*hp++ = -1;m 	    case  3:	*hp++ = -1;p 	    case  2:	*hp++ = -1;c 	    case  1:	*hp++ = -1;p 	    } 	    while (--n >= 0) {e1 		*hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;*1 		*hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;"1 		*hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1; 1 		*hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;  	   }t 	} #else	 	register count_int	*hp; 	register code_int	n;	   	hp = &hashtab[0];' 	n = hsize >> 4;			/* divide by 16			*/_ 	switch (hsize & 15) { 	case 15:	*hp++ = -1;t 	case 14:	*hp++ = -1;; 	case 13:	*hp++ = -1;a 	case 12:	*hp++ = -1;a 	case 11:	*hp++ = -1;l 	case 10:	*hp++ = -1;* 	case  9:	*hp++ = -1;s 	case  8:	*hp++ = -1;d 	case  7:	*hp++ = -1;* 	case  6:	*hp++ = -1;m 	case  5:	*hp++ = -1;m 	case  4:	*hp++ = -1;e 	case  3:	*hp++ = -1;* 	case  2:	*hp++ = -1;  	case  1:	*hp++ = -1;t 	} 	while (--n >= 0) {	4 	    *hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;4 	    *hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;4 	    *hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1;4 	    *hp++ = -1; *hp++ = -1; *hp++ = -1; *hp++ = -1; 	} #endif 	if (full_init) {c 	    tot_incount += in_count;c 	    tot_outcount += out_count;u 	    in_count = 0; 	    out_count = 0;a 	    ratio = 0;; 	} 	first_clear = FALSE;[ 	next_code = firstcode;  }bQ -h- lzcmp3.c	Sat Mar 26 16:57:00 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZCMP3.C;19t /*  * 			l z c m p 3 . c   * Output a given code.4  */t #include "lz.h"3   extern STREAM	outstream; extern code_int	next_code;= extern code_int	maxmaxcode;		/* Actual maximum output code	*/  extern short	maxbits;( extern count_int out_count;3   static char_type buf[BITS];i static int	offset;C static short	n_bits = INIT_BITS;	/* # of bits in compressed file	*/ & static short	n_8bits = INIT_BITS << 3;- static code_int	maxcode = MAXCODE(INIT_BITS);    #if !vax_asm && !vms_asm& static readonly char_type lmask[9] = {8     0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80, 0x00 };& static readonly char_type rmask[9] = {8     0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF }; #endif  	 #if DEBUGb( extern int	col;			/* Printout column		*/7 static int	todump;			/* Dump start of the code range	*/v #endif   outputcode(code) code_int  code;p /*  * Output the given code. 
  * Inputs:B  * 	code:	A n_bits-bit integer.  If == -1, then EOF.  This assumes&  *		that n_bits <= (long)wordsize - 1.C  * Note: if not in "export" mode, the following values are special:L8  *	LZ_CLEAR	(also in export mode if block_compress TRUE)3  *			(soft) clear out compress tables and reset thed,  *			number of bits per code to the minimum.F  *	LZ_SOH, LZ_STX	(hard) clear out compress tables and reset as above.A  *	LZ_ETX, LZ_EOR	force out the current output segment, analogous   *			to fflush.c  *			a  * Outputs:o:  * 	Outputs code to the file.  If the codespace has filled0  *	(next_code >= (1 << n_bits), increase n_bits.7  *	If LZ_CLEAR, LZ_SOH, or LZ_STX is seen, reset n_bitso7  *	to the initial value and call init_compress to reseto  *	the lookup and cache tables.t  *  * Assumptions:v:  *	Output chars are 8 bits long.  This is deeply hardwired:  *	into the algorithm.  It is independent, however, of the  *	size of the input data.  *
  * Algorithm:t?  * 	Maintain a BITS character long buffer (so that 8 codes williC  *	fit in it exactly).  Use the VAX insv instruction to insert eacheC  *	code in turn.  When the buffer fills up empty it and start over.o  */a {. 	/*eH 	 * On the VAX (Unix), it is important to have the register declarations6 	 * in exactly the order given, or the asm will break. 	 */* 	register int	r_off;			/* R11 -- offset	*/, 	register int	bits;			/* R10 -- bits/code	*/- 	register char_type	*bp;		/* R09 -- buffer	*/i #if !vax_asm 	register code_int	r_code; #endif   	r_off = offset; 	bits = n_bits; 
 	bp = buf; 	if (code >= 0) {* 	    /*h  	     * Not at EOF, add the code 	     */	 #if DEBUG	, 	    if ((show & SHOW_SERIOUS_DEBUG) != 0) { 		fprintf(stderr, "%c%5d %5d",2 		    ((col += 12) >= 72) ? (col = 0, '\n') : ' ', 		    code, next_code);(- 		if (code >= LZ_CLEAR && code < firstcode) {(: 		    fprintf(stderr, " = %s", lz_names[code - LZ_CLEAR]); 		    col = 74;  		}h 	    } #endif #if vax_asm  	    /*i9 	     * VAX (4.x bsd) DEPENDENT!! Implementation on otherh7 	     * machines or operating systems may be difficult.  	     * C 	     * Translation: Insert BITS bits from the argument starting ati. 	     * offset bits from the beginning of buf. 	     */# 	    0;					/* C compiler bug ??	*/d$ 	    asm("insv	4(ap),r11,r10,(r9)"); #else  #if vms_asm_) 	    lib$insv(&code, &offset, &bits, bp);) #else  	    /*<; 	     * WARNING: byte/bit numbering on the vax is simulatedh 	     * by the following codet 	     */5 	    bp += (r_off >> 3);			/* -> first output slot	*/n 	    r_off &= 7; 	    /*oC 	     * Since code is always >= 8 bits, only need to mask the firstd 	     * hunk on the left.  	     */ 	    r_code = code;:C 	    *bp = (*bp & rmask[r_off]) | (r_code << r_off) & lmask[r_off];e
 	    bp++; 	    bits -= (8 - r_off);{ 	    r_code >>= 8 - r_off; 	    /*=D 	     * Get any 8 bit parts in the middle ( <= 1 for up to 16 bits). 	     */ 	    if (bits >= 8) {( 		*bp++ = r_code;	 		r_code >>= 8;u 		bits -= 8; 	    }' 	    if (bits != 0)				/* Last bits. */  		*bp = r_code;  #endif #endif 	    offset += n_bits; 	    if (offset == n_8bits) {i 		out_count += n_bits;% 		lz_putbuf(buf, n_bits, &outstream);d	 #if DEBUGe 		if (todump > 0) {h# 		    dumphex(buf, n_bits, stderr);( 		    todump -= n_bits;a 		}p #endif
 		offset = 0;D 	    } 	    /* C 	     * If the next entry is going to be too big for the code size,i- 	     * then increase it, if possible.  Note: + 	     *     !export			firstcode == LZ_FIRSTA= 	     *	   export && block_compress	firstcode == LZ_CLEAR + 1K: 	     *	   export && !block_compress	firstcode == LZ_CLEAR 	     */ 	    if (next_code > maxcode) {w 		if (offset > 0) {/) 		    lz_putbuf(buf, n_bits, &outstream);  		    out_count += n_bits; 		    offset = 0;a	 #if DEBUG* 		    if (todump > 0) {t  			dumphex(buf, n_bits, stderr); 			todump -= n_bits; 		    }i #endif 		} " 		n_bits++;			/* Need more bits	*/ 		n_8bits += (1 << 3); 		if (n_bits == maxbits) 		    maxcode = maxmaxcode;p 		else  		    maxcode = MAXCODE(n_bits);	 #if DEBUGo! 		if ((show & SHOW_DEBUG) != 0) {r 		    fprintf(stderr,n5 			"%snext_code is %d, changing to %d bits (max %d)",W$ 			(col > 0) ? "\n" : "", next_code, 			n_bits, maxcode); 		    col = 74;u 		}\ #endif 	    }0 	    if (code >= LZ_CLEAR && code < firstcode) { 		switch (code) {u 		case LZ_SOH: 		case LZ_STX: 		case LZ_CLEAR: 		    if (offset > 0) {n& 			lz_putbuf(buf, n_bits, &outstream); 			out_count += n_bits;/ 			offset = 0;	 #if DEBUG> 			if (todump > 0) {$ 			    dumphex(buf, n_bits, stderr); 			    todump -= n_bits; 			} #endif 		    }e- 		    n_bits = INIT_BITS;		/* Reset codes		*/c 		    n_8bits = INIT_BITS << 3;	# 		    maxcode = MAXCODE(INIT_BITS);"& 		    init_compress(code != LZ_CLEAR);	 #if DEBUG5% 		    if ((show & SHOW_DEBUG) != 0) {% 			fprintf(stderr,= 		    "\n(%s) Change to %d bits, maxcode %d, next_code = %d", ! 			    lz_names[code - LZ_CLEAR],L# 			    n_bits, maxcode, next_code);  			col = 74; 			todump = 32;i 		    }g #endif 		    break;   		case LZ_EOR:' 		case LZ_ETX:			/* Just written out	*/d 		    break;  
 		default:$ 		    abort();			/* Can't happen		*/ 		}( 	    } 	} 	else {* 	    /*p- 	     * At EOF, write the rest of the buffer.d 	     */  	    if ((r_off = offset) > 0) {
 		r_off += 7;  		r_off >>= 3;$ 		lz_putbuf(buf, r_off, &outstream); 		out_count += r_off;0	 #if DEBUG) 		if (todump > 0) {2" 		    dumphex(buf, r_off, stderr); 		    todump -= r_off; 		}s #endif 	    } 	    offset = 0;5 	    lz_flush(&outstream);		/* Flush output buffer	*/h	 #if DEBUG ) 	    if ((show & SHOW_SERIOUS_DEBUG) != 0h 	     || todump > 0) { 		fprintf(stderr, "\n*EOF*\n");+
 		col = 0; 	    } #endif 	} }d