Q -h- lzdcm1.c	Sat Mar 26 16:57:08 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZDCM1.C;63  /*(  *		lzdcmp [-options] [infile [outfile]]  */  #ifdef	DOCUMENTATION   title	lzdcmp	File Decompression  index		File decompression    synopsis 	.s.nf% 	lzdcmp [-options] [infile [outfile]]  	.s.f  description   5 	lzdcmp decompresses files compressed by lzcomp.  The 2 	documentation for lzcomp describes the process in 	greater detail.  % 	Options may be given in either case.  	.lm +8  	.p -80 	-B	Output file is "binary", not text.  (Ignored7 	in VMS private mode.)  On VMS, this generates a stream 6 	file without carriage-control attributes.  On Decus C7 	systems, it generates a "fixed block, 512 byte record"  	file.  It is unneeded on Unix.  	.p -85 	-F	Output file is "fixed block, 512 bytes."  This is < 	used only by VMS for reading files created by Unix compress< 	or by "export" mode.  It is identical to binary on Decus C. 	.p -85 	-X 3	To read files compressed by an old Unix version & 	that doesn't generate header records. 	.p -84 	-V val	Verbose (print status messages and debugging: 	information).  The value selects the amount of verbosity.* 	See the lzcomp documentation for details.   VMS Command Language Interface  3 	In addition to the above (Unix-style) command line 9 	interface, lzcomp supports a VMS command line interface. % 	The following options are available:  	.lm +8  	.p -8 	/EXPORT=(VMS, UNIX, HEADER) 	.p -8 	/MODE=(TEXT, BINARY, FIXED) 	.p -8' 	/SHOW=(ALL, PROGRESS, STATISTICS, FDL, ! 		DEBUG, DEBUG_SERIOUS, DEBUG_IO)  	.lm -8    VMS private mode  @ 	If the file was compressed in VMS private mode, all information; 	needed to reconstruct the file is stored in the compressed ? 	file, using the VMS run-time library FDL routines.  This means = 	that the expanded file will have the same name and directory = 	location it had originally.  If the directory structure does > 	not exist (for example, because you have moved the compressed? 	file to another machine), you must specify the second argument $ 	to lzdcmp to specify the file name.   Author  3 	This version by Martin Minow.  See lzcomp for more 	 	details.    #endif   /*,  * Compatible with compress.c, v3.0 84/11/27  */    /*)BUILD 		$(PROGRAM) = lzdcmp  		$(INCLUDE) = lz.h  		$(CPP) = 1 		$(RMS) = 1: 		$(FILES) = { lzdcm1.c lzdcm2.c lzdcm3.c lzio.c lzvio.c } */   #include	"lz.h"    /*=  * These global parameters are read from the compressed file.   * The decompressor needs them.   */ 6 short		maxbits = BITS;		/* settable max # bits/code	*/  code_int	maxmaxcode = 1 << BITS;   /*B  * Note, if export is zero or 1, the "true" value will be set from8  * the file header.  If it is 2, no header will be read.  */ 
 #if VMS_V43 flag		export = EXPORT_VMS	/* Assume VMS private		*/  			| EXPORT_HEADER 			| EXPORT_BLOCK  			| EXPORT_ENDMARKER; #else 6 flag		export = EXPORT_UNIX	/* Assume standard Unix		*/ 			| EXPORT_HEADER 			| EXPORT_BLOCK  			| EXPORT_ENDMARKER; #endif+ flag		method = METHOD_LZ;	/* Of course			*/  flag		mode = MODE_TEXT; % flag		show = 0;		/* No statistics		*/ 7 flag		background = FALSE;	/* TRUE (Unix) if detached	*/ 7 flag		is_compress = FALSE;	/* For lzio.c and lzdcl.c	*/ 4 char		*infilename = NULL;	/* For error printouts		*/: char		*outfilename = NULL;	/* For openoutput and errors	*/1 int		firstcode;		/* First code after internals	*/ 8 static long	start_time;		/* Time we started (in msec)	*/: extern long	cputime();		/* Returns process time in msec	*/ jmp_buf		failure;  STREAM		instream;  STREAM		outstream; char_type	inbuffer[MAXIO]; char_type	outbuffer[MAXIO]; 
 #if VMS_V4 FDLSTUFF	*fdl_input; FDLSTUFF	*fdl_output; , static struct dsc$descriptor fdl_descriptor; int		xab_lrl = 0;  static STREAM	mem_stream;     typedef struct more_attributes {     char	*name;      int		type;8     char	*result;	/* Actually a union (int *, char *)	*/ } MORE_ATTRIBUTES;   #define	STRING	0 #define INTEGER	1    /*A  * Additional attributes (put into the compressed file by lzcomp) -  * are extracted using this extensible table.   */   , static MORE_ATTRIBUTES more_attributes[] = {*     { "xabfhc$w_lrl", INTEGER, &xab_lrl },     NULL };   #endif   main(argc, argv)
 int		argc; char		*argv[]; /*  * Decompress mainline  */  { 
 	int		result; 
 	int		status;  	extern code_int	getcode();   
 #ifndef	decus  	/* E 	 * background is TRUE if running detached from the command terminal.  	 */B 	background = (signal(SIGINT, SIG_IGN) == SIG_IGN) ? TRUE : FALSE; 	if (!background) * 	    background = !isatty(fileno(stderr)); 	if (!background) { I 	    if ((show & (SHOW_DEBUG | SHOW_SERIOUS_DEBUG | SHOW_IO_DEBUG)) != 0)  		signal(SIGINT, abort); 	    else {  		signal(SIGINT, interrupt);! 		signal(SIGSEGV, address_error);  	    } 	} #endif' 	if ((status = setjmp(failure)) == 0) {  	    setup(argc, argv); 	 #if DEBUG  	    if (show & SHOW_DEBUG)  		dumpoptions(); #endif	 	    do {  	        openinput(); : 	    } while (get_magic_header());	/* Sets export, etc.	*/ 	    openoutput();' 	    if ((show & SHOW_STATISTICS) != 0)  		start_time = cputime();  	    init_decompress(); % 	    result = decompress(&outstream); ) 	    if ((export & EXPORT_ENDMARKER) != 0  	     && result != LZ_ETX * 	     && getcode() != (code_int) LZ_ETX) {; 		fprintf(stderr, "Decompress didn't finish correctly.\n");  		goto fail; 	    } 	    lz_flush(&outstream);
 #if VMS_V4$ 	    if ((export & EXPORT_VMS) != 0) 		fdl_close(fdl_output); 	    else {  		fclose(stdout);  	    } #else  	    fclose(stdout); #endif	 #if DEBUG * 	    if ((show & SHOW_SERIOUS_DEBUG) != 0) 		dump_tab(stderr);  #endif) 	    if ((show & SHOW_STATISTICS) != 0) { & 		start_time = cputime() - start_time; 		fprintf(stderr, > 		    "%ld.%02ld seconds (process time) for decompression.\n",6 		    start_time / 1000L, (start_time % 1000L) / 10L); 	    } 	    exit(EXIT_SUCCESS); 	} 	else { H fail:	    fprintf(stderr, "Error when decompressing \"%s\" to \"%s\"\n", 		(infilename  == NULL) ? * 		    "<input file unknown>" : infilename, 		(outfilename == NULL) ? ( 		    "<no output file>" : outfilename); 	    exit(status); 	} }   
 static int get_magic_header() /*<  * Read the compressed file header.  Note: if we switch from;  * Unix to VMS (or vice-versa), we must re-open the file in   * the new mode.  */  {  	int		head1; 	int		head2; 	int		head3;
 #if VMS_V47 	int		old_export = export & (EXPORT_VMS | EXPORT_UNIX);  #endif   	head2 = 0; % 	if ((export & EXPORT_HEADER) != 0) { 3 	    if ((head1 = GET(&instream)) != HEAD1_MAGIC) { 7 		fprintf(stderr, "Incorrect first header byte 0x%x\n", 
 		    head1); ) 		FAIL("can't get header", EXIT_FAILURE);  	    } 	    head2 = GET(&instream); 	    head3 = GET(&instream); 	    switch (head2) {  	    case HEAD2_MAGIC:) 		export &= ~(EXPORT_VMS | EXPORT_BLOCK);  		export |= EXPORT_UNIX; 		mode &= ~MODE_DELTA; 		break;   	    case VMS_HEAD2_MAGIC:* 		export &= ~(EXPORT_UNIX | EXPORT_BLOCK); 		export |= EXPORT_VMS;  		mode &= ~MODE_DELTA; 		break;  
 	    default: 8 		fprintf(stderr, "Incorrect second header byte 0x%x\n",
 		    head2); ) 		FAIL("can't get header", EXIT_FAILURE);  	    }
 #if VMS_V4 	    /* A 	     * If export status changes, we must re-open the input file.  	     */= 	    if ((export & (EXPORT_VMS | EXPORT_UNIX)) != old_export)  		return (TRUE); #endif  	    maxbits = head3 & BIT_MASK;# 	    if ((head3 & BLOCK_MASK) != 0)  		export |= EXPORT_BLOCK; " 	    if ((head3 & DIFF_MASK) != 0) 		mode |= MODE_DELTA; 	 #if DEBUG $ 	    if ((show & SHOW_DEBUG) != 0) {1 		fprintf(stderr, "%s: compressed with %d bits,",  		   infilename, maxbits);- 		fprintf(stderr, " block compression %s.\n", 8 		    (export & EXPORT_BLOCK) ? "enabled" : "disabled");4 		fprintf(stderr, " differential compression %s.\n",4 		    (mode & MODE_DELTA) ? "enabled" : "disabled"); 	    } #endif 	} 	if (maxbits > BITS) {4 	    fprintf(stderr, "%s: compressed with %d bits,", 		infilename, maxbits); @ 	    fprintf(stderr, " lzdcmp can only handle %d bits\n", BITS);) 	    FAIL("too many bits", EXIT_FAILURE);  	} 	maxmaxcode = 1 << maxbits;c  	if ((export & EXPORT_VMS) != 0)C 	    firstcode = GET(&instream) + 0x100;	/* From compressed file	*/l' 	else if ((export & EXPORT_BLOCK) != 0) . 	    firstcode = LZ_CLEAR + 1;		/* Default		*/ 	elsee2 	    firstcode = 256;			/* Backwards compatible	*/
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) { 	    register code_int	code; 	    char		text[256];m 	    extern code_int	getcode();  	    auto int		termin; 	    /*O! 	     * Get the attribute record.  	     */( 	    if ((code = getcode()) != LZ_SOH) {8 		fprintf(stderr, "Expected header, read 0x%x\n", code);3 		FAIL("can't get header (private)", EXIT_FAILURE);i 	    } 	    init_decompress();g7 	    code = mem_decompress(text, sizeof text, &termin);  	    text[code] = EOS;2 	    if (strncmp(text, ATT_NAME, ATT_SIZE) != 0) {5 		fprintf(stderr, "Expected \"%s\", read \"%.*s\"\n",U 		    ATT_NAME, code, text);9 		FAIL("can't get attribute block header", EXIT_FAILURE);	 	    }" 	    code = atoi(text + ATT_SIZE);0 	    fdl_descriptor.dsc$b_class = DSC$K_CLASS_S;0 	    fdl_descriptor.dsc$b_dtype = DSC$K_DTYPE_T; 	    /*i1 	     * Note: malloc should probably be lib$getvms 	     */1 	    fdl_descriptor.dsc$a_pointer = malloc(code);n( 	    fdl_descriptor.dsc$w_length = code;H 	    code = mem_decompress(fdl_descriptor.dsc$a_pointer, code, &termin);/ 	    if (code != fdl_descriptor.dsc$w_length) {a; 		fprintf(stderr, "\nError reading fdl attributes block,");.8 		fprintf(stderr, " expected %d bytes, read %d bytes\n",) 		    fdl_descriptor.dsc$w_length, code);S7 		FAIL("can't get attribute block data", EXIT_FAILURE);h 	    }" 	    if ((show & SHOW_FDL) != 0) {9 		fprintf(stderr, "\nFDL information read from \"%s\"\n",n 		    infilename);$ 		fdl_dump(&fdl_descriptor, stderr); 	    } 	    while (termin == LZ_EOR) {d 		MORE_ATTRIBUTES		*p; 		int			len;  8 		code = mem_decompress(text, sizeof text - 1, &termin); 		text[code] = EOS;i 		if ((show & SHOW_FDL) != 0)v; 		    fprintf(stderr, "Additional header: \"%s\"\n", text);p# 		for (p = more_attributes;; p++) {p 		    if (p->name == NULL) { 		        fprintf(stderr,M7 			    "\nIgnoring unknown descriptor \"%s\"\n", text); 	 			break;m 		    }i 		    len = strlen(p->name);- 		    if (strncmp(p->name, text, len) == 0) {N 			switch (p->type) {) 			case INTEGER:. 			    *((int *)p->result) = atoi(&text[len]);
 			    break;/   			case STRING: % 			    strcpy(p->result, &text[len]);r
 			    break;m 			}	 			break;* 		    }m 		}o 	    }( 	    if ((code = getcode()) != LZ_STX) {A 		fprintf(stderr, "\nExpecting start of text, got 0x%x\n", code); ) 		FAIL("no start of text", EXIT_FAILURE);  	    } 	} #elser  	if ((export & EXPORT_VMS) != 0): 	    FAIL("VMS private mode not supported", EXIT_FAILURE); #endif 	return (FALSE); }v 	
 #if VMS_V4 int_$ mem_decompress(buffer, size, termin) char_type	*buffer;
 int		size;
 int		*termin;X /*>  * Decompress up to size bytes to buffer.  Return actual size.  */| {P, 	mem_stream.bp = mem_stream.bstart = buffer;! 	mem_stream.bend = buffer + size;= 	mem_stream.bsize = size;0 	mem_stream.func = lz_fail;g2 	if ((*termin = decompress(&mem_stream)) == LZ_EOR 	 || *termin == LZ_ETX)S% 	    return (mem_stream.bp - buffer);	 	else {m7 	    fprintf(stderr, "Decompress to memory failed.\n");=6 	    FAIL("can't decompress to memory", EXIT_FAILURE); 	}$ 	return (-1);				/* Can't happen		*/ }n #endif e$ static readonly char *helptext[] = {$ 	"The following options are valid:",; 	"-B\tBinary file (important on VMS/RSX, ignored on Unix)",T< 	"-F\tOutput fixed-block 512 byte records (VMS export only",G 	"-M val\tSet the maximum number of code bits (unless header present)",t7 	"-V val\tPrint status information or debugging data.",=, 	"-X val\tSet export (compatibility) mode:", 	"-X 0\tVMS private mode",* 	"-X 1\tCompatibility with Unix compress",? 	"-X 2\tDo not read a header, disable \"block-compress\" mode", E 	"\t(If a header is present, lzdcmp will properly configure itself,",u/ 	"\toverriding the -X, -B and -M flag values.",t 	NULL, };   static setup(argc, argv) 
 int		argc; char		*argv[]; /*:  * Get parameters and open files.  Exit fatally on errors.  */  {L 	register char	*ap;a 	register int	c; 	char		**hp; 	auto int	i; 	int		j; 	int		temp;e  
 #ifdef	vms# 	argc = getredirection(argc, argv);  	/*i2 	 * Prescan to see whether we must do a DCL parse. 	 */( 	for (j = FALSE, i = 1; i < argc; i++) { 	    if (argv[i][0] == '-') {  		j = TRUE;T 		break; 	    } 	} 	if (j == FALSE) {/ 	    if ((i = lzdcl(argc, argv)) != SS$_NORMAL)o
 		exit(i); 	    return; 	} #endif! 	for (i = j = 1; i < argc; i++) {I 	    ap = argv[i];5 	    if (*ap++ != '-' || *ap == EOS)	/* Filename?		*/ + 		argv[j++] = argv[i];		/* Just copy it		*/V 	    else {o 		while ((c = *ap++) != EOS) { 		    if (islower(c))) 			c = toupper(c); 		    switch (c) { 		    case 'B':  			mode |= MODE_BINARY;u	 			break;;   		    case 'F':  			mode |= MODE_FIXED;	 			break;i   		    case 'M':r$ 			maxbits = getvalue(ap, &i, argv); 			if (maxbits < MIN_BITS) {- 			    fprintf(stderr, "Illegal -M value\n");) 			    goto usage; 			}	 			break;s   		    case 'V':u! 			show = getvalue(ap, &i, argv);R	 			break;)   		    case 'X':s- 			switch ((temp = getvalue(ap, &i, argv))) {) 			case 0:	export = EXPORT_VMS 					| EXPORT_BLOCKs 					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break; 			case 1:	export = EXPORT_UNIXx 					| EXPORT_BLOCK  					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break;   			case 2: export = EXPORT_UNIXo 					| EXPORT_BLOCKU 					| EXPORT_HEADER;O
 				break; 			case 3:	export = EXPORT_UNIX  					| EXPORT_HEADER;&
 				break;  			case 4:	export = EXPORT_UNIX;
 				break; 			default:p7 			    fprintf(stderr, "Illegal -X value: %d\n", temp);o 			    goto usage; 			}	 			break;e   		    default:5 			fprintf(stderr, "Unknown option '%c' in \"%s\"\n",  				*ap, argv[i]);/ usage:			for (hp = helptext; *hp != NULL; hp++)s$ 			    fprintf(stderr, "%s\n", *hp);( 			FAIL("unknown option", EXIT_FAILURE);" 		    }				/* Switch on options	*/  		}				/* Everything for -xxx	*/ 	    }					/* If -option		*/ 	}					/* For all argc's	*/a5 	/*  infilename = NULL; */		/* Set "stdin"  signal	*/N5 	/* outfilename = NULL; */		/* Set "stdout" signal	*/ * 	switch (j) {				/* Any file arguments?	*/# 	case 3:					/* both files given	*/d8 	    if (!streq(argv[2], "-"))		/* But - means stdout	*/ 		outfilename = argv[2];# 	case 2:					/* Input file given	*/o 	    if (!streq(argv[1], "-")) 		infilename = argv[1];r 	    break;1   	case 0:					/* None!		*/ $ 	case 1:					/* No file arguments	*/ 	    break;)  	 	default:a2 	    fprintf(stderr, "Too many file arguments\n");* 	    FAIL("too many files", EXIT_FAILURE); 	} }  s
 static int getvalue(ap, ip, argv) register char		*ap;X
 int			*ip; char			*argv[];	 /*H  * Compile a "value".  We are currently scanning *ap, part of argv[*ip].  * The following are possible:7  *	-x123		return (123) and set *ap to EOS so the caller $  *	ap^		cycles to the next argument.  *6  *	-x 123		*ap == EOS and argv[*ip + 1][0] is a digit.3  *			return (123) and increment *i to skip over theL  *			next argument.M  *1  *	-xy or -x y	return(1), don't touch *ap or *ip.s  *D  * Note that the default for "flag option without value" is 1.  This@  * can only cause a problem for the -M option where the value is@  * mandatory.  However, the result of 1 is illegal as it is less  * than INIT_BITS.  */  {  	register int	result;  	register int	i;  
 	i = *ip + 1;U 	if (isdigit(*ap)) { 	    result = atoi(ap);i 	    *ap = EOS;c 	} 	else if (*ap == EOS 	      && argv[i] != NULL;  	      && isdigit(argv[i][0])) { 	    result = atoi(argv[i]);
 	    *ip = i;  	} 	else {  	    result = 1; 	} 	return (result);n }l m openinput()n {  #ifdef	decus 	if (infilename == NULL) { 	    infilename = malloc(257);! 	    fgetname(stdin, infilename);f> 	    infilename = realloc(infilename, strlen(infilename) + 1); 	}0 	if (freopen(infilename, "rn", stdin) == NULL) { 	    perror(infilename);5 	    FAIL("can't open compressed input", ERROR_EXIT);< 	} #else 
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) { 	    if (infilename == NULL) { 		infilename = malloc(256 + 1);( 		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);f 	    }: 	    if ((fdl_input = fdl_open(infilename, NULL)) == NULL)@ 		FAIL("can't open compressed input (vms private)", fdl_status); 	} 	elsem #endif 	{ 	    if (infilename == NULL) {
 #ifdef vms 		infilename = malloc(256 + 1);r 		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);e #elser 		infilename = "<stdin>";A #endif 	    } 	    else {) 		/*# 		 * "rb" means "read, binary mode"p 		 */g1 		if (freopen(infilename, "rb", stdin) == NULL) {r 		    perror(infilename);O? 		    FAIL("can't open compressed input (export)", ERROR_EXIT);( 		}r 	    } 	} #endif$ 	instream.bp = instream.bend = NULL; 	instream.bstart = inbuffer;" 	instream.bsize = sizeof inbuffer; 	instream.func = lz_fill;t }t   openoutput() { 
 #ifdef vms
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) {# 	    extern FDLSTUFF *fdl_create();    	    fclose(stdout); 	    stdout = NULL;bD 	    fdl_output = fdl_create(&fdl_descriptor, outfilename, xab_lrl); 	    if (fdl_output == NULL) {0 		fprintf(stderr, "Can't create output file\n");8 		FAIL("can't create output (vms private)", fdl_status); 	    } 	    if (outfilename == NULL) {(  		outfilename = malloc(256 + 1);' 		fdl_getname(fdl_output, outfilename);e> 		outfilename = realloc(outfilename, strlen(outfilename) + 1); 	    } 	} 	elseL #endif 	{ 	    /* * 	     * Not VMS Version 4, or export mode. 	     */ 	    if (outfilename == NULL) {e  		outfilename = malloc(256 + 1);  		fgetname(stdout, outfilename);> 		outfilename = realloc(outfilename, strlen(outfilename) + 1);/ 		if ((mode & (MODE_BINARY | MODE_FIXED)) == 0); 		    goto do_reopen;r 	    } 	    else { " 		if ((mode & MODE_BINARY) != 0) {, 		    if (freopen(outfilename, "wb", stdout,' 			    "alq=256", "fop=tef") == NULL) {t 			perror(outfilename);t4 			FAIL("can't create output (binary)", ERROR_EXIT); 		    }i 		}t& 		else if ((mode & MODE_FIXED) != 0) {, 		    if (freopen(outfilename, "wb", stdout, 			    "alq=256", "fop=tef",' 			    "rfm=fix", "bls=512") == NULL) {= 			perror(outfilename);e3 			FAIL("can't create output (fixed)", ERROR_EXIT);a 		    }[ 		}; 		else { 		    /*3 		     * Try to allocate the output file in chunks.)	 		     */b4 do_reopen:	    if (freopen(outfilename, "w", stdout, 			    "alq=256", "fop=tef",& 			    "rat=cr", "rfm=var") == NULL) { 			perror(outfilename);,2 			FAIL("can't create output (text)", ERROR_EXIT); 		    }  		}e 	    } 	} #else& #ifdef decus 	if (outfilename == NULL) {m# 	    outfilename = malloc(256 + 1);e# 	    fgetname(stdout, outfilename);MA 	    outfilename = realloc(outfilename, strlen(outfilename) + 1);; 	} 	if (freopen(outfilename,*9 		((mode & (MODE_BINARY | MODE_FIXED)) != 0) ?"wn" : "w",s 		stdout) == NULL) { 	    perror(outfilename);t& 	    FAIL("can't reopen", ERROR_EXIT); 	} #elsem 	if (outfilename == NULL)m 	    outfilename = "<stdout>"; 	else { 5 	    if (freopen(outfilename, "w", stdout) == NULL) {E 		perror(outfilename);# 		FAIL("can't create", ERROR_EXIT);f 	    } 	} #endif #endif- 	outstream.bp = outstream.bstart = outbuffer;r/ 	outstream.bend = outbuffer + sizeof outbuffer;	$ 	outstream.bsize = sizeof outbuffer; 	outstream.func = lz_flush;e }]Q -h- lzdcm2.c	Sat Mar 26 16:57:08 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZDCM2.C;17, /*  *			l z d c m 2 . c  *  * Actual decompression code  */V   #include "lz.h""   /*=  * These global parameters are read from the compressed file.t  * The decompressor needs them.i  */ 5 extern short	maxbits;		/* settable max # bits/code	*/)1 extern code_int	maxmaxcode;		/* 1 << maxbits			*/t   static flag	first_clear = TRUE;2   /*  * Big data storage stuff"  */-  ! static char_type	stack[MAXSTACK];i$ #define	STACK_TOP	(&stack[MAXSTACK])9 static U_short		tab_prefix[1 << BITS];	/* prefix code		*/sC static char_type  	tab_suffix[1 << BITS];	/* last char in string	*/g code_int		next_code;  	 #if DEBUGn #define	CHECK(what)						\ 	if (stp <= stack) {					\7 	    fprintf(stderr, "Stack overflow -- %s\n", what);	\i 	    abort();						\ 	} #elses #define CHECK(what)i #endif g int  decompress(out) 
 STREAM		*out;w /*>  * Decompress instream (global) to out.  Returns "end" signal:  *	-1	end of file]  *	LZ_EOR	end of recordE  *	LZ_ETX	end of segment  */j { . 	register char_type	*stp;		/* Stack pointer	*/) 	register code_int code, oldcode, incode;e/ 	register int		final;		/* End of a sequence?	*/ 3 	register char_type	*pstp;		/* Stack pointer and	*/i3 	register int		previous;	/* char for diff flavor	*/	 	extern code_int		getcode();   	stp = STACK_TOP;  	final = oldcode = getcode();t 	PUT((char) final, out); 	previous = final;" 	while ((code = getcode()) >= 0) {5 test:	    if (code >= LZ_CLEAR && code < firstcode) {e! 		if ((mode & MODE_DELTA) != 0) {s+ 		    for (pstp = stp; pstp < STACK_TOP;) {M	 #if UCHAR  			previous += *pstp;" #else  			previous += (*pstp & 0xFF); #endif 			*pstp++ = previous; 		    }  		}o' 		lz_putbuf(stp, STACK_TOP - stp, out);  		stp = STACK_TOP; 		switch (code) {g 		case LZ_ETX: 		case LZ_EOR: 		    goto finish;  " 		case LZ_SOH:			/* Unexpected		*/" 		case LZ_STX:			/* Unexpected		*/
 		default:; 		    fprintf(stderr, "\nUnexpected control 0x%X\n", code);	/ 		    FAIL("Unexpected control", EXIT_FAILURE);	   		case LZ_CLEAR:3 		    init_decompress();		/* Before getcode() !! */E  		    if ((code = getcode()) < 07 		      || ((export & (EXPORT_UNIX | EXPORT_ENDMARKER))r( 				 == (EXPORT_UNIX | EXPORT_ENDMARKER) 		       && code == LZ_CLEAR)) 			goto finish;l 		    else { 			/*,5 			 * init_decompress has set next_code to firstcode, 3 			 * however, for magical reasons, we want to toss\0 			 * the next substring, so we set next_code so4 			 * that the tab_... entry is effectively ignored.2 			 * Note below that tab_prefix[next_code] is set. 			 * to the character before the LZ_CLEAR and5 			 * tab_suffix to the character after the LZ_CLEAR./3 			 * But, these values have no relationship to oneL2 			 * another, so, by decrementing next_code, they" 			 * will be ignored.  (I think.) 			 */ 			next_code--; 
 			goto test;	 		    }  		}	 	    } 	    incode = code;  	    /*e& 	     * Special case for KwKwK string. 	     */ 	    if (code >= next_code) {	 		CHECK("KwKwK");n 		*--stp = final;e 		code = oldcode;	 	    } 	    /*[3 	     * Generate output characters in reverse orders 	     */ #ifdef interdataC 	    while (((unsigned long) code) >= ((unsigned long) NBR_CHAR)) {  #elset 	    while (code >= NBR_CHAR) {" #endif 		CHECK("generate output");i 		*--stp = tab_suffix[code]; 		code = tab_prefix[code]; 	    } 	    CHECK("final char");e' 	    *--stp = final = tab_suffix[code];p 	    /* ) 	     * And put them out in forward order  	     */$ 	    if ((mode & MODE_DELTA) != 0) {' 		for (pstp = stp; pstp < STACK_TOP;) {m	 #if UCHAR* 		    previous += *pstp; #else+! 		    previous += (*pstp & 0xFF);3 #endif 		    *pstp++ = previous;L 		}	 	    }* 	    lz_putbuf(stp, STACK_TOP - stp, out); 	    stp = STACK_TOP;* 	    /*  	     * Generate the new entry.  	     */+ 	    if ((code = next_code) < maxmaxcode) { ' 		tab_prefix[code] = (U_short) oldcode;m 		tab_suffix[code] = final;t 		next_code++; 	    }   	    /*t 	     * Remember previous code.e 	     */ 	    oldcode = incode; 	} finish:1 	return (code);* })   init_decompress()a /*8  * Called on cold start, or on LZ_SOH, LZ_STX, LZ_CLEAR.  */  {N 	register char_type	*cp; 	register U_short	*up; 	register int		code;   	if (first_clear) { E 	    for (cp = &tab_suffix[0], code = 0; cp < &tab_suffix[NBR_CHAR];)  		*cp++ = code++;i 	    first_clear = FALSE;i 	} 	else {a #if ((NBR_CHAR % 8) != 0)t* 	    << error, the following won't work >> #endif= 	    for (up = &tab_prefix[0]; up < &tab_prefix[NBR_CHAR];) {n 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 		*up++ = 0; 	    } 	} 	next_code = firstcode;_ })  	 #if DEBUGi dump_tab(dumpfd) FILE		*dumpfd; /*  * dump string table  */t {e. 	register char_type	*stp;	/* Stack pointer		*/ 	register int		i;i 	register int		ent;} 	extern char		*dumpchar();   	stp = STACK_TOP;)+ 	fprintf(dumpfd, "%d %s in string table\n",u8 	    next_code, (next_code == 1) ? "entry" : "entries");" 	for (i = 0; i < next_code; i++) {& 	    fprintf(dumpfd, "%5d: %5d/'%s' ",- 		i, tab_prefix[i], dumpchar(tab_suffix[i]));r 	    for (ent = i;;) { 		*--stp = tab_suffix[ent];  		if (ent < firstcode) 		    break; 		ent = tab_prefix[ent]; 	    }, 	    dumptext(stp, STACK_TOP - stp, dumpfd); 	    stp = STACK_TOP;  	} }= #endifQ -h- lzdcm3.c	Sat Mar 26 16:57:08 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZDCM3.C;22E /*  *			l z d c m 3 . c  *$  * Read codes from the input stream.  */L   #include "lz.h"t     #if !vax_asm && !vms_asm& static readonly char_type rmask[9] = {5 	0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF4 }; #endif	 #if DEBUG_ extern int	col;  static int	todump; unsigned long	code_count;( unsigned long	dump_first = -1; unsigned long	dump_last = -1;d #endif   /*  * getcode()  *=  * Read one code from the standard input.  If EOF, return -1.c
  * Inputs:  * 	stdin (via GET)a  * Outputs:t  * 	code or -1 is returned.s  */    extern code_int		next_code;U extern STREAM		instream; extern code_int		maxmaxcode; extern short		maxbits;! static short		n_bits = INIT_BITS;n. static code_int		maxcode = MAXCODE(INIT_BITS);   /*C  * buf[] contains 8-bit data read from the input stream.  getcode() J  * treats buf[] as a vector of bits, repacking it into variable-bit codes.  */e static char_type	buf[BITS];f9 static int		offset = 0;	/* Offset into buf    IN BITS 	*/	7 static int		size = 0;	/* Actual size of buf IN BITS 	*/o   code_int	 getcode()  {e 	/* > 	 * On the VAX (4.2 bsd), it is important to have the registerC 	 * declarations in exactly the order given, or the asm will break.o 	 */3 	register code_int 	code;		/* R11 extracted code	*/R( 	register int		r_off;		/* R10 offset		*/) 	register int		bits;		/* R09 bits/code	*/(2 	register char_type	*bp;		/* R08 buffer pointer	*/  
 	bp = buf; 	if (next_code > maxcode) {  	    n_bits++; 	    if (n_bits == maxbits)c 		maxcode = maxmaxcode;R 	    else {	 		maxcode = MAXCODE(n_bits); 	    } 	    size = 0;	 #if DEBUGt$ 	    if ((show & SHOW_DEBUG) != 0) {1 		fprintf(stderr, "\nChange to %d bits", n_bits);	 		col = 74;" 	    } #endif 	} 	if (offset >= size) {. 	    size = lz_getbuf(buf, n_bits, &instream);	 #if DEBUGu) 	    if ((show & SHOW_SERIOUS_DEBUG) != 0  	     || todump > 0iA 	     || (code_count >= dump_first && code_count <= dump_last)) {(2 		fprintf(stderr, "code_count %lu\n", code_count); 		dumphex(buf, size, stderr);e 		if (todump > 0)e 		    todump -= size;f 	    } #endif 	    if (size <= 0)E# 		return (-1);			/* end of file		*/" 	    offset = 0; 	    /* B 	     * Round size down to integral number of codes in the buffer.( 	     * (Expressed as a number of bits). 	     */' 	    size = (size << 3) - (n_bits - 1);e 	} 	r_off = offset; 	bits = n_bits;  #if vax_asmo  	asm("extzv   r10,r9,(r8),r11"); #elseR #if vms_asm ( 	code = lib$extzv(&offset, &n_bits, bp); #else. 	/*t 	 * Get to the first byte. 	 */ 	bp += (r_off >> 3); 	r_off &= 7; 	/*m# 	 * Get first part (low order bits)m 	 */	 #if UCHARe 	code = (*bp++ >> r_off);2 #else: 	/*85 	 * Don't touch the 0xFF; it prevents sign extension.	 	 */5 	code = ((*bp++ >> r_off) & rmask[8 - r_off]) & 0xFF;i #endif 	bits -= (8 - r_off);g5 	r_off = 8 - r_off;		/* now, offset into code word	*/* 	/*d> 	 * Get any 8 bit parts in the middle (<=1 for up to 16 bits). 	 */ 	if (bits >= 8) {x	 #if UCHARn 	    code |= *bp++ << r_off; #else % 	    code |= (*bp++ & 0xFF) << r_off;* #endif 	    r_off += 8; 	    bits -= 8;c 	} 	/* high order bits. */ 	 #if UCHARC& 	code |= (*bp & rmask[bits]) << r_off; #elser& 	code |= (*bp & rmask[bits]) << r_off; #endif 	/*e( 	 * End of non-vax (Unix) specific code. 	 */ #endif #endif 	offset += n_bits;, 	if (code >= LZ_CLEAR && code < firstcode) { 	    switch (code) { 	    case LZ_SOH:c 	    case LZ_STX:, 	    case LZ_CLEAR:t( 		size = 0;			/* Force read next time	*/ 		n_bits = INIT_BITS;e 		maxcode = MAXCODE(INIT_BITS);*	 #if DEBUGr! 		if ((show & SHOW_DEBUG) != 0) {r' 		    fprintf(stderr, "Read %s (%d)\n",L$ 			lz_names[code - LZ_CLEAR], code); 		    todump = 32; 		}s #endif 		break; 	    } 	}	 #if DEBUG % 	if ((show & SHOW_SERIOUS_DEBUG) != 0e= 	 || (code_count >= dump_first && code_count <= dump_last)) { ! 	    fprintf(stderr, "%c%5d %5d",a. 		((col += 12) >= 72) ? (col = 0, '\n') : ' ', 		code, next_code); 0 	    if (code >= LZ_CLEAR && code < firstcode) {6 		fprintf(stderr, " = %s", lz_names[code - LZ_CLEAR]); 	        col = 74; 	    } 	} 	++code_count; #endif 	return (code);  }C  L -h- lz.hlp	Sat Mar 26 16:57:08 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZ.HLP;6 ! 
 ! compress !C
 1 COMPRESSC   The COMPRESS command invokes a utility to copy a file, generatingxB   a file with (usually) fewer bytes.  Files compressed by COMPRESS   are recovered by DECOMPRESS.  -     COMPRESS Input-file-spec Output-file-spec:   2 Parameter:    Input-file-spec  ?   Specifies the name of the file to be compressed.  If you havet@   specified /EXPORT=VMS mode, the file must be stored on a disk.    Output-file-spec   5   Specifies the name of the file created by COMPRESS.L 2 Qualifiers  B   Indicate special actions to be performed by the COMPRESS utility<   or special properties of either the input or output files.)   Qualifiers apply to the entire process.E  @   The following list shows all the qualifiers available with the   COMPRESS command:c      o /BITS=value      o /EXPORT=(option,...)o      o /METHOD=optiono      o /MODE=(option,...)       o /SHOW=(option,...)e   2 /BITS   /BITS=value  =   This specifies the maximum number of bits to be used in the ?   compression. It implicitly controls both the "quality" of theZB   compression (more bits means more compression) and the amount ofA   memory needed for both compression and decompression (more bits,B   requires more memory). If the compressed file is to be read by aC   computer with limited memory (such as a PDP-11), choose /BITS=12,}?   else leave BITS at its default of 16.  The minimum value is 9s   and the maximum value is 16.  	 2 /EXPORT   /EXPORT=(option, [,...])-  @   Export controls the format of the output file.  You can select   the following:  A   VMS (D)               Write a file that can only be read by VMSn!                         COMPRESS.NC   UNIX                  Write a format that can be read by programsCB                         compatible with the Unix compress utility.@   [NO]ENDMARKER         Write a special file endmarker after the*                         data if specified.C   [NO]BLOCK             Monitor compression and reinitialize if theE7                         quality decreases if specified.i@   [NO]HEADER            Write a file header with information for0                         DECOMPRESS if specified.    C   In general, use /EXPORT=VMS for compression where the result willKC   be decompressed on a VMS system and /EXPORT=UNIX where the result C   will be decompressed on a Unix, RSX-11M, RSTS/E, or other non-VMSoD   system.  If /EXPORT=UNIX is specified, BLOCK, HEADER, or ENDMARKER;   may be negated to further qualify the output file format.e   3 VMS;  ?   Specifies output in VMS ("private") mode.  In addition to the*B   contents of the file itself, the "File definition block" is alsoB   compressed. The decompression utility can thus recreate the fileA   exactly (including ISAM indexes).  This is the default, and thec!   recommended mode for most uses.+   3 UNIX  @   Specifies an output format compatible with Unix compress v3.0.C   This allows transmitting sequential files to non-VMS systems thatp?   support a compress-compatible utility.  If you have specified B   /EXPORT=UNIX, the utility can be configured for variants of UnixA   compress by negating BLOCK, HEADER, and/or ENDMARKER as needed. @   Notice that file attributes are not preserved by /EXPORT=UNIX.   3 BLOCKe  A   Selects an algorithm whereby COMPRESS evaluates its performance @   and re-initializes the compression tables whenever performance@   degrades.  Older versions of Unix compress do not support this9   capability. If negated, ENDMARKER must also be negated.(   3 HEADER  ?   If negated, COMPRESS does not write a header record.  This isp?   for compatiblity with very old versions of Unix compress.  If-4   negated, BLOCK and ENDMARKER must also be negated.   3 ENDMARKER   C   If specified, a special "endmark" is written after the end of the;D   file.  This is necessary if the file is to be decompressed on RT11D   or other systems that require the last block of a file to fill the@   last block.  On the other hand, some versions of Unix compressA   cannot understand the "extra" endmarker.  If you guess wrong, apC   few bytes of garbage may be appended to the decompressed file.  A4?   version of Unix compress that handles endmarkers correctly isn   available.  	 2 /METHODn  /METHOD=(option)r  B   This specifies the particular compression algorithm.  Currently,    only /METHOD=LZW is supported.   3 LZWt  1   Use the Lempel-Ziv-Welch compression algorithm.T   2 /MODEu  /MODE=(option)   D   This allows specification of variations on the compression method.   3 BINARY  @   This opens the file in "binary" mode, rather than "text" mode.)   It is ignored if /EXPORT=VMS is chosen.e   3 DELTAIC   Compress the difference between successive bytes, rather than therA   bytes themselves.  For certain file formats, such as bit-mapped C   graphics, this may yield a 10-15% improvement in compressibility.iD   This is not compatible with some implementations of Unix compress.   2 /SHOWa  /SHOW=(option, [,...])o  B   Display information about the compression.  If omitted, COMPRESS0   operates silently (except for error messages).   3 ALLh/   Equivalent to /SHOW=(PROGRESS,STATISTICS,FDL)g  
 3 PROGRESSB   Print status messages at intervals, showing the operation of the?   program.  The report shows the current compression ratio (theh?   ratio of input to output bytes).  If this decreases, COMPRESSo@   decides that the characteristics of the file have changed, and=   resets its internal parameters.  The "gap" is the number ofs(   input codes used to compute the ratio.   3 STATISTICSG   Print a report at the end of the process.  Note that COMPRESS reports	G   the number of bytes it compresses, which includes the file as well astK   the information that COMPRESS records about the file (the File Definition)H   Language block and some internal codes), and will therefore be several>   hundred characters greater than the actual size of the file.   3 FDL;D   Dump the File Definition Language block that describes a VMS input   file.    3 DEBUGf'   Print internal debugging information./   3 DEBUG_SERIOUS ,   Print more internal debugging information.  
 3 DEBUG_IO   Dump the output file, too.   2 LZW_Overview2   LZW stands for a compression method described in  8     "A technique for High Performance Data Compression."<     Terry A. Welch. IEEE Computer, Vol 17, No. 6 (June 1984)
     pp. 8-19.   B   This section is abstracted from Terry Welch's article referencedC   below.  The algorithm builds a string translation table that mapse@   substrings in the input into fixed-length codes.  The compress(   algorithm may be described as follows:  :   1. Initialize table to contain single-character strings.C   2. Read the first character.  Set <w> (the prefix string) to thatg      character.o*   3. (step): Read next input character, K./   4. If at end of file, output code(<w>); exit.u$   5. If <w>K is in the string table:"      Set <w> to <w>K; goto step 3.*   6. Else <w>K is not in the string table.        Output code(<w>);&        Put <w>K into the string table;!        Set <w> to K; Goto step 3.c  A   "At each execution of the basic step an acceptable input stringi@   <w> has been parsed off.  The next character K is read and theB   extended string <w>K is tested to see if it exists in the string>   table.  If it is there, then the extended string becomes theD   parsed string <w> and the step is repeated.  If <w>K is not in theA   string table, then it is entered, the code for the successfullyBB   parsed string <w> is put out as compressed data, the character K;   becomes the beginning of the next string, and the step iso   repeated."  B   The decompression algorithm translates each received code into a?   prefix string and extension [suffix] character. The extensiono<   character is stored (in a push-down stack), and the prefixA   translated again, until the prefix is a single character, which)@   completes decompression of this code.  The entire code is then@   output by popping the stack.  I.e., the last code put into the0   stack was the first code in the original file.  ?   "An update to the string table is made for each code receivedO?   (except the first one).  When a code has been translated, itscC   final character is used as the extension character, combined withuB   the prior string, to add a new string to the string table.  This?   new string is assigned a unique code value, which is the same A   code that the compressor assigned to that string.  In this way,iC   the decompressor incrementally reconstructs the same string table B   that the decompressor used.... Unfortunately ... [the algorithm]%   does not work for an abnormal case.S  =   The abnormal case occurs whenever an input character string @   contains the sequence K<w>K<w>K, where K<w> already appears in   the compressor string table."p  ?   The decompression algorithm, augmented to handle the abnormala   case, is as follows:     1. Read first input code;o      Store in CODE and OLDcode;i1      With CODE = code(K), output(K); FINchar = K;i+   2. Read next code to CODE; INcode = CODE;T      If at end of file, exit;i4   3. If CODE not in string table (special case) then        Output(FINchar);y        CODE = OLDcode;'        INcode = code(OLDcode, FINchar);a   4. If CODE == code(<w>K) thenn        Push K onto the stack;c        CODE == code(<w>);n        Goto 4.     5. If CODE == code(K) then        Output K;        FINchar = K;p     6. While stack not empty        Output top of stack;2        Pop stack;T  )   7. Put OLDcode,K into the string table.         OLDcode = INcode;        Goto 2.  =   The algorithm as implemented here introduces two additionalt   complications.  :   The actual codes are transmitted using a variable-length=   encoding.  The lowest-level routines increase the number of A   bits in the code when the largest possible code is transmitted.e  >   Periodically, the algorithm checks that compression is still:   increasing.  If the ratio of input bytes to output bytesA   decreases, the entire process is reset.  This can happen if theeB   characteristics of the input file change. (This can be supressed   by /EXPORT=(UNIX, NOBLOCK)). 2 Unix  +   Is a trademark of AT&T Bell Laboratories.    !  ! decompress !h 1 DECOMPRESSA   The DECOMPRESS command invokes a utility to restore copy a filer'   that had been compressed by COMPRESS.   1     DECOMPRESS Input-file-spec [Output-file-spec]n   2 Command_Parameters    Input-file-spec  2   Specifies the name of the compressed input file.    Output-file-specE  B   Specifies the name of the file created by COMPRESS.  If the file?   was compressed by /EXPORT=VMS, the original file name will bef<   used if the Output file spec. is omitted.  If the file wasB   compressed by /EXPORT=UNIX and no Output file spec. is provided,)   the file will be written to SYS$OUTPUT:s   2 Command_Qualifiers  B   Indicate special actions to be performed by the COMPRESS utility<   or special properties of either the input or output files.)   Qualifiers apply to the entire process..  @   The following list shows all the qualifiers available with the   DECOMPRESS command:s      o /BITS=value      o /EXPORT=(option,...)E      o /METHOD=option       o /MODE=(option,...)n      o /SHOW=(option,...)e   2 /BITSK  /BITS=value  A   If a header was not provided, this specifies the maximum numberr?   of bits that were used in the compression.  This parameter isy3   ignored if the compressed file contains a header.l  	 2 /EXPORTr  /EXPORT=(option, [,...])o  @   Export describes the format of the input file.  You can select   the following:  =   VMS (D)               The file was created by VMS COMPRESS.f=   UNIX                  The file was created by Unix compress  			or a compatible program.dB                         compatible with the Unix compress utility.B   [NO]ENDMARKER         A special file endmarker follows the data.C   [NO]BLOCK             The compress program may have reinitialized  			compression. A   [NO]HEADER            The compress program wrote its parametersk 			into a file header.  A   In general, the program can determine the proper value of thesea>   flags by reading the first few bytes of the file.  If valid,;   the file header overrides the command line specification.lA   Generally, this option is needed only if you are trying to ready=   a file generated by a version of Unix compress that did nots?   write a header.  See the description of COMPRESS for details.y  	 2 /METHODi  /METHOD=(option)Z  B   This specifies the particular compression algorithm.  Currently,    only /METHOD=LZW is supported.   3 LZWt  1   Use the Lempel-Ziv-Welch compression algorithm.A   2 /MODEs  /MODE=(option)n  <   This allows specification of variations on the output file:   format.  These values will be taken from the source file'   description if /EXPORT=VMS is chosen.r   3 BINARY  B   This creates the file in "binary" mode, rather than "text" mode.A   It is ignored if COMPRESS created the file in /EXPORT=VMS mode. <   The output file will be created in RMS "Stream-LF" format.   3 DELTA/?   Compress used the difference between successive bytes, rathers?   than the bytes themselves.  For certain file formats, such as =   bit-mapped graphics, this may yield a 10-15% improvement inSC   compressibility. This is not compatible with some implementationsh>   of Unix compress.  This value is normally read from the file<   header, and generally need not be specified by DECOMPRESS.   3 FIXEDe  ;   Create the file in "fixed-block, 512-byte record" format.v;   This is probably the best format to use for decompressingi7   binary files (such as tar archives)  created on Unix..   3 TEXT  ?   Create the file in "variable-length carriage-control" format.R;   This is appropriate for decompressing readable text filesu   created by Unix compress.h   2 /SHOWo  /SHOW=(option, [,...])b  D   Display information about the compression.  If omitted, DECOMPRESS0   operates silently (except for error messages).   3 ALLg/   Equivalent to /SHOW=(PROGRESS,STATISTICS,FDL);  
 3 PROGRESSB   Print status messages at intervals, showing the operation of the
   program.   3 STATISTICS+   Print a report at the end of the process.    3 FDLoC   Dump the File Definition Language block that describes the outputi   file.    3 DEBUGr'   Print internal debugging information.o   3 DEBUG_SERIOUS ,   Print more internal debugging information.  
 3 DEBUG_IO   Dump the input file, too.,   2 Unix+   Is a trademark of AT&T Bell Laboratories.c