I -h- lz.h	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZ.H;95  /* #define DEBUG	TRUE	*/ /*=  * Header file for all lz compression/decompression routines.   *;  * Machine/Operating system/compiler selection: (#ifdef'ed)   * vax				Vax/Unix or Vax/VMS #  * pdp11			makes a small compressor    * M_XENIX			"large-model" Z8000*  * interdata			Signed long compare is slow'  * unix				Defined on true Unix systems   * decus			Decus C (no signal)3  * vms				Vax/VMS (VMS_V4 may be set automatically) B  * #define readonly		If the compiler doesn't support it correctly.  *  #  * Compiler configuration (#if'ed): K  * #define vax_asm   TRUE/FALSE	TRUE on Vax (4bsd) if the compiler supports 4  *				the asm() operator.  Check the generated code!K  * #define vms_asm   TRUE/FALSE	TRUE on Vax/VMS to use the run-time library   *				insv and extv routines. G  * #define UCHAR     TRUE/FALSE	TRUE if compiler supports unsigned char B  * #define DEBUG     TRUE/FALSE	TRUE to compile in debug printouts  *  * Algorithm Tuning parameters: 6  * #define USERMEM   <n>	Memory available to compress.2  *				If large enough, a faster algorithm is used.8  * #define SACREDMEM <n>	Don't use this part of USERMEM.5  * #define BITS      <n>	Maximum number of code bits. F  * #define MAXIO     <n>	Output buffer size (squeeze memory if needed)  */    #include <stdio.h> #include <ctype.h> #include <setjmp.h> 
 #ifndef decus  # include <signal.h> /*  * Arguments to signal():   */ 3 extern int	abort();		/* Debugging interrupt trap	*/ ; extern int	interrupt();		/* Non-debugging interrupt trap	*/ 6 extern int	address_error();	/* "Segment" violation		*/ #endif   #ifndef	TRUE # define FALSE		0  # define TRUE		1 #endif #ifndef	EOS  # define EOS		'\0' #endif+ #define	streq(a, b)	(strcmp((a), (b)) == 0) ) #define min(a,b)	((a) > (b)) ? (b) : (a))    /*F  * Set USERMEM to the maximum amount of physical user memory availableL  * in bytes.  USERMEM is used to determine the maximum BITS that can be used  * for compression.   *H  * SACREDMEM is the amount of physical memory saved for others; compress  * will hog the rest.   */    #ifndef SACREDMEM  # define SACREDMEM	0 #endif   /*"  * Set machine-specific parameters  */   
 #ifdef vax # ifdef unix7 #  define vax_asm	TRUE		/* If asm() supported on vax	*/  # endif  # ifdef vms  #  define vms_asm	TRUE # endif  #endif #ifndef	vax_asm  # define vax_asm	FALSE #endif #ifndef vms_asm  # define vms_asm	FALSE #endif   #ifdef pdp118 # define BITS	12	/* max bits/code for 16-bit machine		*/0 # define USERMEM 0	/* Force no user memory				*/B # define UCHAR	FALSE	/* TRUE if compiler supports unsigned char	*/< # define MAXIO 512	/* Buffer size for PDP-11 I/O buffers		*/ #endif   /**  * Set default values for some parameters.  */   
 #ifndef DEBUG  # define DEBUG	FALSE #endif   #ifdef interdata! # define SIGNED_COMPARE_SLOW TRUE  #endif #ifndef SIGNED_COMPARE_SLOW " # define SIGNED_COMPARE_SLOW FALSE #endif   #ifndef USERMEM 4 # define USERMEM 750000	/* default user memory				*/ #endif  
 #ifndef	UCHAR : # define UCHAR	TRUE	/* Compiler supports unsigned char		*/ #endif  
 #ifndef MAXIO , # define MAXIO	2048	/* I/O buffer size				*/ #endif   /*!  * Set derived tuning parameters.   */    #ifndef USERMEM  # define USERMEM	 0  #endif% #if USERMEM >=			(433484 + SACREDMEM)  # define PBITS		16 #else & # if USERMEM >=			(229600 + SACREDMEM) #  define PBITS		15  # else& #  if USERMEM >=		(127536 + SACREDMEM) #   define PBITS	14  #   else( #    if USERMEM >=		( 73464 + SACREDMEM) #     define PBITS	13 # #    else			/* Smaller systems			*/  #     define PBITS	12 
 #    endif	 #   endif  # endif  #endif   #ifndef BITS # define BITS PBITS  #endif   #ifdef M_XENIX # if BITS >= 16 = #  define XENIX_16		/* Enable special vector access macros	*/  # else #  if BITS > 13  #   undef BITS= #   define BITS 13		/* Code only handles BITS = 12, 13, 16	*/  #  endif # endif  #endif   /*<  * HSIZE is the size of the hash lookup table.  It is set to:  * 1 << BITS + fudge factor, rounded up to a prime number.;  * If it is too big, the "clear the hash" routine will take >  * too long.  The same numbers are replicated in the getsize()  * routine's data table.  */    #if BITS == 16+ # define HSIZE	69001		/* 95% occupancy			*/  #endif #if BITS == 15+ # define HSIZE	35023		/* 94% occupancy			*/  #endif #if BITS == 14+ # define HSIZE	18013		/* 91% occupancy			*/  #endif #if BITS == 13+ # define HSIZE	 9001		/* 91% occupancy			*/  #endif #if BITS <= 12+ # define HSIZE	 5003		/* 80% occupancy			*/  #endif   /**  * typedef's -- somewhat machine specific.  */    /*J  * a code_int must be able to hold 2**BITS values of type int, and also -1  */ 
 #if BITS > 15  typedef long int	code_int; #else  typedef int		code_int; #endif   /*=  * A count_int must hold ((2**BITS)-1) + (255<<BITS)) and -1.   *"  * count_int's also hold counters.  *8  * count_short's hold small counters (for the interdata)  *J  * Some implementations don't support unsigned char (Decus C, for example)A  * Decus C is also brain damaged with regards to unsigned shorts.   */  #if SIGNED_COMPARE_SLOW $ typedef unsigned long int count_int;' typedef unsigned short int count_short;  #else  typedef long int	count_int;  #endif  	 #if UCHAR   typedef	unsigned char	char_type; #else  typedef char		char_type; #endif   #ifdef decus typedef unsigned	U_short; 4 #define	readonly			/* Dummy out readonly modifier	*/ #else  typedef unsigned short	U_short;  #endif   #ifdef unix  #define	readonly #endif  5 typedef short		flag;		/* Boolean flag or parameter	*/    /*1  * The following define the "magic cookie" header   */  #define	HEAD1_MAGIC	0x1F #define HEAD2_MAGIC	0x9D= #define	VMS_HEAD2_MAGIC	0x9E		/* vms-private output format	*/    /*#  * Defines for third byte of header   */ 3 #define BIT_MASK	0x1F		/* Gets NBITS in the code	*/ 7 #define BLOCK_MASK	0x80		/* Gets block_compress flag	*/ : #define	DIFF_MASK	0x40		/* Gets differential cmprs flag	*/ /*<  * Mask0x20 is free.  I think 0x20 should mean that there is(  * a fourth header byte (for expansion).  */    /*K  * This is for backwards compatibilty with an old version of Unix compress.   */ 0 #ifdef COMPATIBLE			/* Compatible, but wrong!	*/, # define MAXCODE(n_bits)	(1 << (n_bits) - 1) #else . # define MAXCODE(n_bits)	((1 << (n_bits)) - 1) #endif  7 #define INIT_BITS 9			/* initial number of bits/code */    /*A  * One code could conceivably represent (1<<BITS) characters, but A  * to get a code of length N requires an input string of at least @  * N*(N-1)/2 characters.  With 5000 chars in the stack, an inputB  * file would have to contain a 25Mb string of a single character.  * This seems unlikely.   */ ; #define MAXSTACK    8000		/* size of lzdcmp output stack	*/    #ifndef CHECK_GAP 6 # define CHECK_GAP 	10000		/* ratio check interval		*/ #endif   #ifndef __LINE__ # define NO__LINE__  #endif #ifndef __FILE__ # define NO__LINE__  #endif	 #if DEBUG  # define VERBOSE_DEFAULT    1  # ifndef NO__LINE__   #  define FAIL(why, status)				\. 	fprintf(stderr, "\nfatal: %s (%s at %d)\n",	\# 	    why, __FILE__, __LINE__); 			\  	longjmp(failure, status); # else  #  define FAIL(why, status)				\+ 	fprintf(stderr, "\nfatal: %s\n", why); 		\  	longjmp(failure, status); # endif  #else  # define VERBOSE_DEFAULT    0 4 # define FAIL(why, status)	longjmp(failure, status); #endif   /*0  * Note -- for compatibility with Unix compress,(  * NBR_CHAR and LZ_CLEAR must equal 256.<  * Also, (1 << (MIN_BITS - 1) should equal or exceed NBR_CHR  */ 6 #define	NBR_CHAR      256		/* Number of input codes	*/1 #define MIN_BITS	9		/* Smallest code is 9 bits	*/ 1 #if ((1 << BITS) < NBR_CHAR) || (BITS < MIN_BITS) I     << Can't compile: not enough bits for the input character set size >>  #endif. #define	LZ_CLEAR	(NBR_CHAR)	/* Clear code			*/: #define	LZ_SOH		(LZ_CLEAR + 1)	/* Start of header block	*/9 #define	LZ_STX		(LZ_SOH   + 1)	/* Start of text block		*/ 8 #define	LZ_EOR		(LZ_STX   + 1)	/* End of text record		*/= #define	LZ_ETX		(LZ_EOR   + 1)	/* End of header/text block	*/M< #define	LZ_FIRST	(LZ_ETX   + 1)	/* First user (data) code	*/  
 #ifdef	vms #include		errno* #include		ssdefa #include		stsdef
 #include		rmso #include		descripc #ifndef	EXIT_SUCCESS3 #define	EXIT_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)o  #define	EXIT_FAILURE	(SS$_ABORT) #endif7 #define VMS_V4		L_cuserid >= 16		/* Enable new stuff	*/S #elseo+ #define VMS_V4		0			/* Disable new stuff	*/e extern int		errno; #ifdef decus #define	errno		$$ferr	 #endif #endif   /*  * Define exit() codes.#  */e   #ifndef	EXIT_SUCCESS #ifdef decus #define	EXIT_SUCCESS	IO_SUCCESSi #define	EXIT_FAILURE	IO_ERROR* #elsee+ #define	EXIT_SUCCESS	0			/* Normal exit		*/h* #define	EXIT_FAILURE	1			/* Error exit		*/ #endif #endif #if EXIT_FAILURE == 0i@   << error, EXIT_FAILURE must be non-zero for longjmp to work >> #endif
 #ifdef vms #define	ERROR_EXIT	(errno) #else  #define	ERROR_EXIT	EXIT_FAILUREo #endif   /*A  * Parameter values are converted to internal values (to simplifyt  * processing of VMS DCL)n  */a #define EXPORT_VMS		0x0001 #define EXPORT_UNIX		0x0002m #define EXPORT_BLOCK		0x0004 #define	EXPORT_HEADER		0x0008* #define EXPORT_ENDMARKER	0x0010t   #define	METHOD_LZ		0x0001i   #define MODE_TEXT		0x0001e #define	MODE_BINARY		0x0002M #define	MODE_FIXED		0x0004 #define	MODE_DELTA		0x0008   #define	SHOW_STATISTICS		0x0001c #define	SHOW_PROGRESS		0x0002p #define	SHOW_FDL		0x0004 #define	SHOW_DEBUG		0x0008! #define SHOW_SERIOUS_DEBUG	0x0010i #define SHOW_IO_DEBUG		0x0020r   r /*?  * All I/O is done by way of "streams".  To establish a stream, B  * set the parameters appropriately and off you go.  The following  * functions are provided:/  *	lz_fill(stream)		fills the buffer from stdini/  *	lz_flush(stream)	writes the buffer to stdout(5  *	lz_eof(stream)		returns EOF (for fill from memory)(2  *	lz_fail(stream)		abort (for writing to memory).0  *	lz_dummy(stream)	throw an output stream away.A  * Note: if VMS_V4 is enabled and the private (non-export) formatc?  * chosen, lz_fill and lz_flush access the files appropriately.a.  * Stream elements are initialized as follows:!  *	Input:	bp = NULL;	bend = NULL;i.  *	Output:	bp = bstart;	bend = bstart + bsize;  */    typedef struct STREAM {v4     char_type	*bp;		/* Next character to get/put		*/4     char_type	*bend;		/* -> end of stream buffer		*/4     char_type	*bstart;	/* Start of stream buffer		*/,     short	bsize;		/* Stream buffer size			*/7     int		(*func)();	/* Read/write a buffer function		*/e	 } STREAM;    /*I  * Note also that the compress routine uses putbuf(buf, count, outstream)	L  * and the decompress routine uses getbuf(buf, count, instream) to (quickly)  * transfer multiple bytes.   */D	 #if UCHARf #define	GET(s)		\ > 	(((s)->bp < (s)->bend) ? *(s)->bp++        : (*(s)->func)(s)) #else  #define	GET(s)		\E> 	(((s)->bp < (s)->bend) ? *(s)->bp++ & 0xFF : (*(s)->func)(s)) #endif #define	PUT(c, s)	\AC 	((((s)->bp >= (s)->bend) ? (*(s)->func)(s) : 0), *(s)->bp++ = (c))E   extern int lz_fill();0 extern int lz_flush(); extern int lz_eof(); extern int lz_fail();H extern int lz_dummy();  	 #if DEBUG 8 extern readonly char *lz_names[];		/* "LZ_CLEAR" etc.	*/ #endif   /*  * Options and globals.*  */d
 #if VMS_V4 #include devdef*  " #define	ATT_NAME	"vms$attributes ", #define	ATT_SIZE	15			/* strlen(ATT_NAME)	*/   typedef struct FDLSTUFF { - 	struct	RAB	rab;		/* Record access buffer		*/ + 	struct	FAB	fab;		/* File access buffer		*/=) 	struct	NAM	nam;		/* File name buffer		*/ : 	struct	XABFHC	xabfhc;		/* Attributes (file header blk)	*/7 	struct	XABSUM	xabsum;		/* Attributes (isam summary)	*/ 7 	char		starname[NAM$C_MAXRSS + 1]; /* Wild file name	*/e7 	char		filename[NAM$C_MAXRSS + 1]; /* Open file name	*/d } FDLSTUFF;   9 extern int	fdl_status;	/* Error code from fdl library		*/a #endif  . extern flag	export;		/* -x, /EXPORT=(...)			*/* extern flag	method;		/* LZ, of course			*/8 extern flag	show;		/* -v  /SHOW=(...) Verbose logging	*/- extern flag	mode;		/* Binary and friends			*/t+ extern short	maxbits;	/* -b /BITS=<n>				*/dJ extern readonly flag is_compress; /* TRUE if compress, FALSE if decomp.	*/4 extern char	*infilename;	/* For error printouts			*/9 extern char	*outfilename;	/* For more error printouts		*/ @ extern short	n_bits;		/* Current # of bits in compressed file	*/5 extern int	firstcode;	/* First value past signals		*/	4 extern jmp_buf	failure;	/* For longjmp() return			*/  U -h- lzcomp.cld	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZCOMP.CLD;35  !e+ ! Command language description for COMPRESS* !%   MODULE lz_dcl_tablef   DEFINE VERB		COMPRESS    PARAMETER P1,				! Input file  	LABEL=INPUT 	PROMPT="Input file",o 	VALUE (REQUIRED, TYPE=$FILE)a   PARAMETER P2,				! Output file
 	LABEL=OUTPUTt 	PROMPT="Output file", 	VALUE (REQUIRED, TYPE=$FILE)*  " QUALIFIER BITS,				! /BITS=<value> 	NONNEGATABLE, 	PLACEMENT=GLOBAL, 	VALUE(TYPE=$NUMBER)  8 QUALIFIER EXPORT,			! /EXPORT=(VMS UNIX BLOCK ENDMARKER) 	NONNEGATABLE, 	PLACEMENT=GLOBAL,# 	VALUE(TYPE=EXPORT_KEYWORDS, LIST),s 	DISALLOW (VMS AND UNIX)  	DISALLOW (BLOCK AND NEG HEADER)# 	DISALLOW (ENDMARKER AND NEG BLOCK)I  	DISALLOW (BLOCK AND NEG HEADER) 	DISALLOW (VMS AND NEG BLOCK)  	DISALLOW (VMS AND NEG HEADER)! 	DISALLOW (VMS AND NEG ENDMARKER)t    QUALIFIER METHOD,			! /METHOD=LZ 	NONNEGATABLE, 	PLACEMENT=GLOBAL, 	VALUE(TYPE=METHOD_KEYWORDS)  8 QUALIFIER SHOW,				! /SHOW=(PROGRESS, STATISTICS, DEBUG) 	NEGATABLE,u 	PLACEMENT=GLOBAL,  	VALUE(TYPE=SHOW_KEYWORDS, LIST)  " QUALIFIER MODE,				! /MODE=(DELTA) 	NONNEGATABLE, 	PLACEMENT=GLOBAL,! 	VALUE(TYPE=MODE_KEYWORDS, LIST),m   DEFINE TYPE EXPORT_KEYWORDSi 	KEYWORD VMS, DEFAULTo 	KEYWORD UNIX, 	KEYWORD BLOCK, NEGATABLEF 	KEYWORD HEADER, NEGATABLE 	KEYWORD ENDMARKER, NEGATABLE*   DEFINE TYPE METHOD_KEYWORDS  	KEYWORD	LZW, DEFAULTi   DEFINE TYPE MODE_KEYWORDSf 	KEYWORD BINARY	 	KEYWORD DELTA   DEFINE TYPE SHOW_KEYWORDS_ 	KEYWORD PROGRESS, NEGATABLE 	KEYWORD STATISTICS, NEGATABLE 	KEYWORD FDL, NEGATABLEl 	KEYWORD DEBUG, NEGATABLE0! 	KEYWORD DEBUG_SERIOUS, NEGATABLEe 	KEYWORD DEBUG_IO, NEGATABLE( 	KEYWORD ALL			! Actually, all but debugT -h- lzdcmp.cld	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZDCMP.CLD;6 !f- ! Command language description for DECOMPRESSe !e   MODULE lz_dcl_table(   DEFINE VERB		DECOMPRESSi   PARAMETER P1,				! Input file) 	LABEL=INPUT 	PROMPT="Input file",	 	VALUE (REQUIRED, TYPE=$FILE)e   PARAMETER P2,				! Output file
 	LABEL=OUTPUTn 	PROMPT="Output file", 	VALUE (TYPE=$FILE)e  " QUALIFIER BITS,				! /BITS=<value> 	NONNEGATABLE, 	PLACEMENT=GLOBAL, 	VALUE(TYPE=$NUMBER)  8 QUALIFIER EXPORT,			! /EXPORT=(VMS UNIX BLOCK ENDMARKER)0 	NONNEGATABLE,			! Only /EXPORT=(UNIX, NOHEADER)$ 	PLACEMENT=GLOBAL,		! is meaningful.# 	VALUE(TYPE=EXPORT_KEYWORDS, LIST),  	DISALLOW (VMS AND UNIX)  	DISALLOW (BLOCK AND NEG HEADER) 	DISALLOW (VMS AND NEG BLOCK)e 	DISALLOW (VMS AND NEG HEADER)! 	DISALLOW (VMS AND NEG ENDMARKER)e    QUALIFIER METHOD,			! /METHOD=LZ 	NONNEGATABLE, 	PLACEMENT=GLOBAL, 	VALUE(TYPE=METHOD_KEYWORDS)  8 QUALIFIER SHOW,				! /SHOW=(PROGRESS, STATISTICS, DEBUG) 	NEGATABLE,w 	PLACEMENT=GLOBAL,  	VALUE(TYPE=SHOW_KEYWORDS, LIST)  : QUALIFIER MODE,				! /MODE=(TEXT | BINARY | FIXED | DELTA) 	NONNEGATABLE, 	PLACEMENT=GLOBAL,! 	VALUE(TYPE=MODE_KEYWORDS, LIST),e# 	DISALLOW ANY2(TEXT, BINARY, FIXED)    DEFINE TYPE EXPORT_KEYWORDSj 	KEYWORD VMS, DEFAULTe 	KEYWORD UNIX, 	KEYWORD BLOCK, NEGATABLEt 	KEYWORD HEADER, NEGATABLE 	KEYWORD ENDMARKER, NEGATABLE    DEFINE TYPE METHOD_KEYWORDSh 	KEYWORD	LZ, DEFAULT   DEFINE TYPE MODE_KEYWORDSR 	KEYWORD	TEXT, DEFAULT 	KEYWORD BINARY, 	KEYWORD FIXED,	 	KEYWORD DELTA   DEFINE TYPE SHOW_KEYWORDST 	KEYWORD PROGRESS, NEGATABLE 	KEYWORD STATISTICS, NEGATABLE 	KEYWORD FDL, NEGATABLEu 	KEYWORD DEBUG, NEGATABLEe! 	KEYWORD DEBUG_SERIOUS, NEGATABLE* 	KEYWORD DEBUG_IO, NEGATABLE( 	KEYWORD ALL			! Actually, all but debugO -h- lzdcl.c	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZDCL.C;25	 /*1  * DCL parser for lz... stuff (swings both ways!)X  */_ #include "lz.h"  #include climsgdef  #define	DYNAMIC_STRING(name)			\'     struct dsc$descriptor_d name = {		\f( 	0, DSC$K_DTYPE_T, DSC$K_CLASS_D, NULL	\     }e   typedef struct {! 	char		*key;		/* Option name			*/X! 	flag		bit;		/* Sets this bit		*/S
 } KEYWORD;  7 static char		errname[257];	/* Error text stored here	*/ A static $DESCRIPTOR(err, errname);	/* descriptor for error text	*/d   extern char	*vms_etext();n  $ static DYNAMIC_STRING(command_line);# static DYNAMIC_STRING(cli_command);f" static DYNAMIC_STRING(cli_prompt);? static DYNAMIC_STRING(result);		/* cli_getvalue result datum	*/C2 static $DESCRIPTOR(prompt_compress, "Compress: ");6 static $DESCRIPTOR(prompt_decompress, "Decompress: ");  @ globalref int		*lz_dcl_table;	/* Different table for cmp/dcmp	*/ extern int		lib$get_input(); char			*cli_savevalue();   /*A  * Note: these tables are inclusive (for both lzcomp and lzdcmp).s6  * The code thus must accept "missing" element errors.  */t   KEYWORD	key_export[] = {  { "VMS",		EXPORT_VMS		},t  { "UNIX",		EXPORT_UNIX		},   { "BLOCK",		EXPORT_BLOCK		},1  { "HEADER",		EXPORT_HEADER		},d$  { "ENDMARKER",		EXPORT_ENDMARKER	},  { NULL,		0x0000			} };   KEYWORD key_method[] = {  { "LZW",		METHOD_LZ		},  { NULL,		0x0000			} };   KEYWORD key_mode[] = {  { "TEXT",		MODE_TEXT		},F  { "BINARY",		MODE_BINARY		},A  { "FIXED",		MODE_FIXED		},I  { "DELTA",		MODE_DELTA		},P  { NULL,		0x0000			} };   KEYWORD key_show[] = {9  { "ALL",		SHOW_PROGRESS | SHOW_STATISTICS	 | SHOW_FDL },f!  { "PROGRESS",		SHOW_PROGRESS		},*$  { "STATISTICS",	SHOW_STATISTICS		},  { "FDL",		SHOW_FDL		},m  { "DEBUG",		SHOW_DEBUG		},r)  { "DEBUG_SERIOUS",	SHOW_SERIOUS_DEBUG	},*!  { "DEBUG_IO",		SHOW_IO_DEBUG		},l  { NULL,		0x0000			} };   intt lzdcl(argc, argv)t
 int		argc; char		*argv[]; {u 	register int		i;m 	register int		status; 	struct dsc$descriptor_s	temp;  	extern int		ignore_dcl_error();   #if 0u 	for (i = 1; i < argc; i++) {e% 	    printf("%2d: %s\n", i, argv[i]);  	} #endif@ 	descriptor(&temp, (is_compress) ? "COMPRESS " : "DECOMPRESS "); 	if (argc <= 1) {e: 	    status = lib$get_foreign(	/* Read the command line	*/ 		&command_line,9 		(is_compress) ? &prompt_compress : &prompt_decompress);  	    if (status == RMS$_EOF) 		exit(status);	# 	    else if (status != SS$_NORMAL)/ 		lib$stop(status);;3 	    str$concat(&cli_prompt, &temp, &command_line);r 	} 	else {f! 	    for (i = 1; i < argc; i++) {;" 		str$append(&cli_command, &temp); 		descriptor(&temp, argv[i]);u" 		str$append(&cli_command, &temp); 		descriptor(&temp, " ");p 	    } 	} #if 0u 	printf("command: \"%.*s\"\n",: 	    cli_command.dsc$w_length, cli_command.dsc$a_pointer); #endif" 	VAXC$ESTABLISH(ignore_dcl_error);. 	status = cli$dcl_parse(		/* Parse the DCL		*/1 		&cli_command,		/* Input from lib$get_foreign	*/s& 		&lz_dcl_table,		/* Parsing table		*/6 		&lib$get_input,	    	/* Gets a required parameter	*/7 		&lib$get_input,	    	/* Gets a continuation prompt	*/  		&cli_prompt);  #if 0)9 	printf("cli$dcl_parse returns %s\n", vms_etext(status));s #endif% 	if ((status & STS$M_SUCCESS) != 0) {) 	    /*n 	     * Process all arguments  	     */) 	    infilename = cli_savevalue("INPUT");	/ 	    if (cli_present("OUTPUT") == CLI$_PRESENT) ( 		outfilename = cli_savevalue("OUTPUT");/ 	    if (cli_present("BITS") == CLI$_PRESENT) {* 		register int		i; 		register int		c;   		cli_getvalue("BITS");;: 		for (maxbits = 0, i = 0; i < result.dsc$w_length; i++) {" 		    c = result.dsc$a_pointer[i]; 		    if (!isdigit(c)) 			goto nogood_bits;+ 		    maxbits = (maxbits * 10) + (c - '0');c 		}S 		if (maxbits < MIN_BITS) {aA nogood_bits:	    fprintf(stderr, "Illegal bits value \"%.*s\"\n",e. 			result.dsc$w_length, result.dsc$a_pointer); 		    lib$signal(CLI$_IVVALU); 		}n 	    }- 	    cli_list("METHOD", &method, key_method);e- 	    cli_list("EXPORT", &export, key_export);.% 	    if ((export & EXPORT_UNIX) != 0)c 		export &= ~EXPORT_VMS;+ 	    cli_list("MODE",   &mode,   key_mode);x+ 	    cli_list("SHOW",   &show,   key_show);  	    status = SS$_NORMAL;  	} 	str$free1_dx(&command_line);l 	str$free1_dx(&cli_command); 	str$free1_dx(&cli_prompt);x 	str$free1_dx(&result);  	return (status);	 }/ x# cli_list(what, flag_word, keytable)r
 char			*what;* flag			*flag_word; KEYWORD			*keytable; {s 	register int		key_status; 	register int		status; 	register KEYWORD	*kp;   	switch(cli_present(what)) { 	case CLI$_NEGATED:	 #if 0h* 	    printf("found %s (negated)\n", what); #endif 	    *flag_word = 0; 	    break;e   	case CLI$_PRESENT:s1 	    for (kp = keytable; kp->key != NULL; kp++) { $ 		key_status = cli_present(kp->key); 		switch (key_status) {B 		case CLI$_PRESENT: 		    *flag_word |= kp->bit; #if 0I- 		    printf("found %s %s\n", what, kp->key);O #endif 		    break;   		case CLI$_NEGATED: 		    *flag_word &= ~kp->bit;I #if 0!7 		    printf("found %s %s (negated)\n", what, kp->key);E #endif 		    break; 		}  	    } 	    break;V  	 	default:  	    break;N 	} }A , intA cli_present(what)L char		*what; /*6  * TRUE if the argument is present in the command line  */D {G 	struct dsc$descriptor_s	parm;   	descriptor(&parm, what);O 	return(cli$present(&parm)); }S   descriptor(descr, what) ( register struct dsc$descriptor_s	*descr; char					*what;  /*.  * Turn a C string into a (static) descriptor.  */E {G$ 	descr->dsc$w_length = strlen(what);$ 	descr->dsc$b_class = DSC$K_CLASS_S;$ 	descr->dsc$b_dtype = DSC$K_DTYPE_T; 	descr->dsc$a_pointer = what;H }K   int, cli_getvalue(what) char		*what; /*<  * Get the value (storing it in result).  Return the status.,  * Note the following (successful) statuses:6  *	CLI$_COMMA		Another entry (in the list) may be read,  *	SS$_NORMAL		The last -- or only -- value.'  * A non-successful status is signaled.P  */H {K 	struct dsc$descriptor_s	parm; 	int			status;   	descriptor(&parm, what);RE 	if (((status = cli$get_value(&parm, &result)) & STS$M_SUCCESS) == 0)G 	    lib$signal(status); 	return (status);O }F     char * cli_savevalue(what)E char		*what; /*A  * Find the value and store it as a C string in malloc'ed memory.A3  * Return NULL on errors (which should not happen).r  */6 {: 	register char		*string;  / 	if ((cli_getvalue(what) & STS$M_SUCCESS) == 0)d 	    return (NULL);R 	else { . 	    string = malloc(result.dsc$w_length + 1);@ 	    strncpy(string, result.dsc$a_pointer, result.dsc$w_length); 	    return (string);R 	} }E I
 dumpoptions()E /*!  * Debug: dump all option values.   */P {O> 	fprintf(stderr, "(Debug) Option dump, bits = %d\n", maxbits);$ 	fprintf(stderr, "Input file: %s\n",: 	    (infilename == NULL) ? "<unspecified>" : infilename);) 	fprintf(stderr, "Output filename: %s\n",,< 	    (outfilename == NULL) ? "<unspecified>" : outfilename);+ 	option_dump("METHOD", method, key_method);)+ 	option_dump("EXPORT", export, key_export);K) 	option_dump("MODE",   mode,   key_mode);O) 	option_dump("SHOW",   show,   key_show);L }   & option_dump(what, flag_word, keytable)
 char			*what;= flag			flag_word;  KEYWORD			*keytable; {E 	register KEYWORD	*kp; 	register int		first;/  ; 	for (first = TRUE, kp = keytable; kp->key != NULL; kp++) {O, 	    if ((flag_word & kp->bit) == kp->bit) { 		if (first) {0 		    fprintf(stderr, " %s=(%s", what, kp->key); 		    first = FALSE; 		}V 		else {' 		    fprintf(stderr, ", %s", kp->key);X 		}N 	    } 	} 	if (first)P= 	    fprintf(stderr, " %s -- no options specified.\n", what);Y 	else {K 	    fprintf(stderr, ")\n"); 	} }B   #if 0O /*  * This is in lzvio.c, too.E  */  char * vms_etext(errorcode) int		errorcode;E {P 	char		*bp;D* 	short		errlen;		/* Actual text length		*/  0 	lib$sys_getmsg(&errorcode, &errlen, &err, &15); 	/*Y 	 * Trim trailing junk., 	 */0 	for (bp = &errname[errlen]; --bp >= errname;) {$ 	    if (isgraph(*bp) && *bp != ' ') 		break; 	}
 	bp[1] = EOS;E 	return(errname);D }G #endif  " #define	CODE(v)	((v) & STS$M_CODE)  & ignore_dcl_error(signal_arg, mech_arg) long int	signal_arg[]; long int	mech_arg[]; /*B  * VMS exception handler.  Needs extension to handle "all" errors.  */" {h 	switch (CODE(signal_arg[1])) {Y3 	case CODE(SS$_UNWIND):			/* Currently unwinding	*/a 	    return;  - 	case CODE(SS$_CONTROLC):		/* CTRL/C trap		*/  	case CODE(SS$_ACCVIO):* 	case CODE(SS$_ROPRAND): 	    lib$stop(signal_arg[1]);	 	    break;R  	 	default:c 	    sys$putmsg(signal_arg); 	    break;e 	} 	return; }CM -h- lzio.c	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZIO.C;26t /*  *			l z i o . c  *E  * I/O buffer management.  All input/output I/O is done through theseCA  * routines (and the macros in lz.h).  The rules of the game are:u  *   * input via GET() and getbuf().1  *	GET returns an 8-bit byte, or -1 on eof/error.RD  *	getbuf() returns the number of things gotten, or -1 on eof/error.2  *	No return on error: longjmp's to the main-line.  *$  * output via PUT() and lz_putbuf().2  *	No return on error: longjmp's to the main-line.J  * flush output by lz_flush() before closing files -- or you'll lose data.  */    /*LINTLIBRARY*/t   #include	"lz.h"E
 #if VMS_V4 #include	<rmsdef.h>T #ifndef FDLSTUFF #define FDLSTUFF char1 #endif extern FDLSTUFF *fdl_input;{ extern FDLSTUFF *fdl_output; extern int	fdl_status; #endif E int 
 lz_fill(s) register STREAM		*s; {Z 	register int	i; 	extern char	*infilename;_  
 #if VMS_V4" 	if ((export & EXPORT_VMS) == 0) {7 	    i = fread((char *) s->bstart, 1, s->bsize, stdin);E 	    if (ferror(stdin)) {N 		perror(infilename); 3 		FAIL("compress (export) read error", ERROR_EXIT);O 	    } 	}- 	else {			/* Decompress and export/private	*/	2 	    i = fdl_read(s->bstart, s->bsize, fdl_input); 	    if (i < 0  	     && fdl_status != RMS$_EOF)' 		fdl_message(fdl_input, "Read error");  	} #elseO #ifdef unixE7 	i = read(fileno(stdin), (char *) s->bstart, s->bsize);r
 	if (i < 0) {; 	    perror(infilename);$ 	    FAIL("read error", ERROR_EXIT); 	} #elses3 	i = fread((char *) s->bstart, 1, s->bsize, stdin);; 	if (ferror(stdin)) {; 	    perror(infilename);$ 	    FAIL("read error", ERROR_EXIT); 	} #endif #endif 	if (i <= 0) 	    return (EOF); 	else {P 	    s->bp = s->bstart;  	    s->bend = &s->bstart[i];g	 #if UCHARt 	    return (*s->bp++);m #elsen 	    return (*s->bp++ & 0xFF); #endif 	} }t c lz_flush(s)  register STREAM	*s;_ {) 	register int	count; 	extern char	*outfilename;   	count = s->bp - s->bstart; 	 #if DEBUGa 	if (!is_compressp# 	 && (show & SHOW_IO_DEBUG) != 0) { . 	    fprintf(stderr, "lz_flush %d:  ", count);( 	    dumptext(s->bstart, count, stderr); 	} #endif
 #if VMS_V4" 	if ((export & EXPORT_VMS) == 0) { 	    if (is_compress)}/ 		fwrite((char *) s->bstart, count, 1, stdout);i 	    else {w 		register char *bp, *bend;i  : 		for (bp = s->bstart, bend = bp + count; bp < bend; bp++) 		    putchar(*bp);r 	    } 	    if (ferror(stdout)) { 		perror(outfilename);" 		FAIL("write error", ERROR_EXIT); 	    } 	} 	else {tB 	    if (fdl_write((char *) s->bstart, count, fdl_output) == -1) {) 		fdl_message(fdl_output, "Write error");p( 		FAIL("write (fdl) error", ERROR_EXIT); 	    } 	} #elset #ifdef unixsA 	if (write(fileno(stdout), (char *) s->bstart, count) != count) {  	    perror(outfilename); % 	    FAIL("write error", ERROR_EXIT);I 	} #else . 	fwrite((char *) s->bstart, 1, count, stdout); 	if (ferror(stdout)) { 	    perror(outfilename);c% 	    FAIL("write error", ERROR_EXIT);  	} #endif #endif 	s->bp = s->bstart;  }l e inte lz_getbuf(buffer, count, s)0 char_type		*buffer;s int			count; register STREAM		*s; /*B  * Read a block of data -- be clever.  Return number gotten, or -1
  * on eof.  */s {1* 	register char_type	*bp;		/* -> buffer		*/- 	register char_type	*ip;		/* -> I/O buffer	*/e. 	register char_type	*ep;		/* End of segment	*// 	register int		remaining;	/* Size of segment	*/I
 	int			datum;n  * 	if (count == 0)				/* Shouldn't happen	*/ 	    return (0);
 	bp = buffer;" 	while (--count >= 0) { : 	    if ((datum = GET(s)) == EOF)	/* Maybe fill LZ buff	*/ 		break; 	    *bp++ = datum;m( 	    remaining = s->bend - (ip = s->bp); 	    if (remaining > count)s 		remaining = count; 	    ep = &ip[remaining];l 	    while (ip < ep) 		*bp++ = *ip++; 	    count -= remaining;( 	    s->bp = ip;				/* Refresh buffer	*/ 	}, 	return ((bp == buffer) ? -1 : bp - buffer); }h 	 intt lz_putbuf(bp, count, s)E register char_type	*bp;r int			count; register STREAM		*s; /*&  * Write a block of data -- be clever.  */l {r- 	register char_type	*op;		/* -> I/O buffer	*/ . 	register char_type	*ep;		/* End of segment	*// 	register int		remaining;	/* Size of segment	*/$   	while (--count >= 0) {k+ 	    PUT(*bp++, s);			/* Forces a buffer	*/t( 	    remaining = s->bend - (op = s->bp); 	    if (remaining > count)N 		remaining = count; 	    ep = &op[remaining];r 	    while (op < ep) 		*op++ = *bp++; 	    count -= remaining;( 	    s->bp = op;				/* Refresh buffer	*/ 	} }I i /*ARGUSED*/r int"	 lz_eof(s)  STREAM		*s;  /*5  * Dummy routine for read from memory -- returns EOF.b  */V {  #ifdef decus 	return (s, EOF);  #elseA 	return (EOF); #endif }	   int 
 lz_fail(s) STREAM		*s;n /*?  * Dummy routine for write to memory -- called if buffer fills.p  */  {d? 	fprintf(stderr, "Memory buffer [%d bytes] filled -- fatal.\n",c 		s->bsize);' 	FAIL("crash (lz_fail)", EXIT_FAILURE);* }c   intr lz_dummy(s)  STREAM		*s;  /*A  * Dummy routine for write to memory -- writes to the bit-bucket.s  */( {t 	s->bp = s->bstart;s }  $
 #ifndef decuss /*  * Signal error handlers.;  */s
 #ifdef vms #define unlink	deleten #endif   interrupt()  {r 	if (outfilename != NULL% 	 && !streq(outfilename, "<stdout>"))e 	    unlink(outfilename);w 	exit(EXIT_FAILURE); }:   address_error()o {r 	if (!is_compress)9 	    fprintf(stderr, "Decompress: corrupt input file\n");  	else {s. 	    fprintf(stderr, "fatal address error\n"); 	}
 #ifdef vms 	lib$signal(SS$_ACCVIO); #elser
 	interrupt();a #endif }( #endif l /*<  * getredirection() is intended to aid in porting C programs7  * to VMS (Vax-11 C) which does not support '>' and '<'e7  * I/O redirection.  With suitable modification, it mayr1  * useful for other portability problems as well.   */o  
 #ifdef	vms   intd getredirection(argc, argv)
 int		argc;
 char		**argv;i /*=  * Process vms redirection arg's.  Exit if any error is seen.R:  * If getredirection() processes an argument, it is erased?  * from the vector.  getredirection() returns a new argc value.   *>  * Warning: do not try to simplify the code for vms.  The codeA  * presupposes that getredirection() is called before any data isd(  * read from stdin or written to stdout.  *  * Normal usage is as follows:  *  *	main(argc, argv)c
  *	int		argc;e  *	char		*argv[];d  *	{&  *		argc = getredirection(argc, argv);  *	}  */) {"+ 	register char		*ap;	/* Argument pointer	*/" 	int			i;	/* argv[] index		*/  	int			j;	/* Output index		*/k# 	int			file;	/* File_descriptor 	*/m  : 	for (j = i = 1; i < argc; i++) {   /* Do all arguments	*/ 	    switch (*(ap = argv[i])) {r 	    case '<':			/* <file		*/l* 		if (freopen(++ap, "r", stdin) == NULL) {( 		    perror(ap);		/* Can't find file	*/. 		    exit(ERROR_EXIT);	/* Is a fatal error	*/ 		}  		break;  & 	    case '>':			/* >file or >>file	*/# 		if (*++ap == '>') {	/* >>file		*/t 		    /*3 		     * If the file exists, and is writable by us,V6 		     * call freopen to append to the file (using the7 		     * file's current attributes).  Otherwise, create-3 		     * a new file with "vanilla" attributes as ifr/ 		     * the argument was given as ">filename".i3 		     * access(name, 2) is TRUE if we can write onc 		     * the specified file.	 		     */ ! 		    if (access(++ap, 2) == 0) {g( 			if (freopen(ap, "a", stdout) != NULL)' 			    break;	/* Exit case statement	*/ ( 			perror(ap);	/* Error, can't append	*/, 			exit(ERROR_EXIT); /* After access test	*/" 		    }			/* If file accessable	*/ 		}E 		/*8 		 * On vms, we want to create the file using "standard"5 		 * record attributes.  create(...) creates the filei3 		 * using the caller's default protection mask andc/ 		 * "variable length, implied carriage return"e8 		 * attributes. dup2() associates the file with stdout. 		 */$6 		if ((file = creat(ap, 0, "rat=cr", "rfm=var")) == -1) 		 || dup2(file, fileno(stdout)) == -1) {** 		    perror(ap);		/* Can't create file	*/. 		    exit(ERROR_EXIT);	/* is a fatal error	*/ 		}			/* If '>' creation	*/s 		break;			/* Exit case test	*/k  
 	    default: ) 		argv[j++] = ap;		/* Not a redirector	*/R 		break;			/* Exit case test	*/C 	    } 	}				/* For all arguments	*/b) 	argv[j] = NULL;			/* Terminate argv[]	*/d$ 	return (j);			/* Return new argc	*/ }m #endif . #if 1 || DEBUG  	 int		col;e   readonly char *lz_names[] = {t=     "LZ_CLEAR", "LZ_SOH", "LZ_STX", "LZ_EOR", "LZ_ETX", "???"g };   dumphex(buffer, count, fd) register char_type	*buffer;. register int		count; FILE			*fd;t {h 	if (col > 0) {  	    putc('\n', fd);
 	    col = 0;  	} 	fprintf(fd, "%2d:", count); 	while (--count >= 0) {h4 	    fprintf(fd, " %02x", (int) (*buffer++ & 0xFF)); 	} 	fprintf(fd, "\n");I }I   dumptext(buffer, count, fd)i register char_type	*buffer;T int			count; FILE			*fd;  {S 	extern char	*dumpchar();F   	putc('"', fd);{ 	while (--count >= 0)o* 	    fputs(dumpchar((int) *buffer++), fd); 	fputs("\"\n", fd);i }r   char * dumpchar(c)s register int	c;r /*9  * Make a character printable.  Returns a static pointer.=  */{ {  	static char	dump_buffer[8];   	c &= 0xFF;   	if (isascii(c) && isprint(c)) { 	    dump_buffer[0] = c; 	    dump_buffer[1] = EOS; 	} 	else {E 	    switch (c) {}  	    case '\n':	return ("<LF>");! 	    case '\t':	return ("<TAB>");a  	    case '\b':	return ("<BS>");  	    case '\f':	return ("<FF>");  	    case '\r':	return ("<CR>"); 	    }( 	    sprintf(dump_buffer, "<x%02x>", c); 	} 	return (dump_buffer); }r #endif r /*F  * Cputime returns the elapsed process time (where available) in msec.E  * Note: Unix doesn't seem to have a good way to determine ticks/sec.i  */t   #ifdef	decus #include	<timeb.h>   long	 cputime(); {  	struct timeb		buf;  	static struct timeb	origin; 	long			result;  	int			msec;   	if (origin.time == 0) 	    ftime(&origin);
 	ftime(&buf);t* 	result = (buf.time - origin.time) * 1000;5 	msec = ((int) buf.millitm) - ((int) origin.millitm); ! 	return (result + ((long) msec));A }s #else 
 #ifdef vms #include	<types.h> struct tms { 	time_t	tms_utime; 	time_t	tms_stime;$ 	time_t	tms_uchild;	/* forgot the */' 	time_t	tms_uchildsys;	/* real names */s };* #define HERTZ	100.0				/* 10 msec units	*/ #elser #include	<sys/types.h> #include	<sys/times.h>
 #ifndef HERTZR- #define HERTZ	60.0				/* Change for Europe	*/e #endif #endif   long	 cputime()u {i 	struct tms	tms; 	double		temp; 	long		result;  
 	times(&tms);r( 	result = tms.tms_utime + tms.tms_stime;5 	temp = result * 1000.0 / HERTZ;		/* Time in msec.	*/  	result = temp;a 	return (result);  }o #endif  O -h- lzvio.c	Sat Mar 26 16:57:17 1988	USER1:[MINOW.PERSONAL.SOURCE.LZ]LZVIO.C;97u /*  *			l z v i o . c  * For VMS V4 only.i  */r   /*  * Problems:;  *	If you open a second input file (getting rms attributes)sD  *	it aborts with an internal "fatal" error (15820C LIB-F-FATERRLIB)  */p  o /*3  * Make TESTING_FDLIO non-zero to enable test code.   *  * Edit Historyc=  * 26-Dec-85	MM	Create files with "large" allocation quantity !  *			to improve processing speed.(A  * 18-Apr-86	Hein	Don't set xrb_lrl if the file isn't sequential.t3  *  2-Jun-87	MM	fdl$generate needs a dynamic stringt  */* #ifndef	TESTING_FDLIO  #define	TESTING_FDLIO	0  #endif   /*E  * RMS/FDL record level i/o routines for Vax-11 C V4 or greater only.   * Rather crude.  *  * The following are provided:  *  *	#define	FDLSTUFF	char  *	#include descrip   *
  *	FDLSTUFF *E%  *	fdl_open(filename, fdl_descriptor)i  *	char			*filename;)  *	struct	dsc$descriptor	*fdl_descriptor;	8  *		Initializes internal buffers and opens this existing<  *		file for input.  The filename may not contain wildcards.8  *		On (successful) return, fdl_descriptor will point to6  *		an initialized fdl specification.  The description<  *		string will be in malloc'ed memory.  The caller does not:  *		initialize the fdl_descriptor.  Returns NULL on error.6  *		(Note an error will be returned if the file is not  *		block-oriented.)  *6  *		When you don't need the fdl_descriptor information   *		any more, free it by calling!  *		    fdl_free(fdl_descriptor);*:  *		if fdl_descriptor is NULL on entry, the file is opened0  *		normally (fdl information is not collected).  *
  *	FDLSTUFF *o9  *	fdl_create(fdl_descriptor, override_filename, xab_lrl)*)  *	struct	dsc$descriptor	*fdl_descriptor;p  *	char			*override_filename;t  *	int			xab_lrl;s/  *		Creates a file using the fdl specification.t9  *		If override_filename is not NULL and not equal to "",w7  *		it will override the filename specified in the fdl.;2  *		fdl_write() is used to write data to the file.  *		Returns NULL on error.  *8  *		if fdl_descriptor is NULL, the file is created using:  *		the name in override_filename (which must be present).5  *		The file is created in "undefined" record format.(  *,  *		xab_lrl initializes the XAB$W_LRL field.  *  *	fdl_free(fdl_descriptor)s)  *	struct	dsc$descriptor	*fdl_descriptor;e&  *		Releases the fdl descriptor block.  *  *	int%  *	fdl_read(buffer, buffer_length, r)   *	char		*buffer;y  *	int		buffer_length;  *	FDLSTUFF	*r;f<  *		Read buffer_length bytes from the file (using SYS$READ).6  *		No expansion or interpretation.  buffer_length had9  *		better be even or you're asking for trouble.  Returnsn7  *		the actual number of bytes read.  The file has been   *		opened by fdl_open.s  *  *	int&  *	fdl_write(buffer, buffer_length, r)  *	char		*buffer;r  *	int		buffer_length;  *	FDLSTUFF	*r; <  *		Write buffer_length bytes to the file (using SYS$WRITE).6  *		No expansion or interpretation.  buffer_length had9  *		better be even or you're asking for trouble.  Returnsa<  *		the actual number of bytes written.  The file was opened  *		by fdl_create();  *  *	fdl_getname(r, buffer)i  *	FDLSTUFF	*r;r  *	char		*buffer;I9  *		Copies the currently open file's name to the caller'se  *		data buffer buffer.   *  *	longe  *	fdl_fsize(r)d1  *		Returns the size in bytes of the opened file.g  *  *	fdl_dump(fdl_descriptor, fd)s)  *	struct	dsc$descriptor	*fdl_descriptor;e  *	FILE			*fd;2  *		Writes the fdl info to the indicated file with&  *		line breaks in appropriate places.  *  *	fdl_message(r, why)  *	FDLSTUFF	*r;t  *	char		*why;=  *		All system-level routines set a global value, fdl_status.n=  *		fdl_message() prints the error message text corresponding <  *		to the current value of fdl_status.  The message printed  *		has the format:r)  *			why current_filename: error_message.g6  *		If why is NULL, only the error_message is printed.  */a / #include "lz.h"r
 #if VMS_V4 #ifndef	FDL$M_FDL_SIGNAL6 #define FDL$M_FDL_SIGNAL	1	/* Signal errors if set		*/ #endif #ifndef	FDL$M_FDL_STRING8 #define FDL$M_FDL_STRING	2	/* Use string for fdl text	*/ #endif #if TESTING_FDLIO ( #define	SIGNAL_ON_ERROR	FDL$M_FDL_SIGNAL #elsed #define	SIGNAL_ON_ERROR	0r #endif #define MSG(what, code)	\ @ 	fprintf(stderr, "Unexpected error at %s, code %X:\n\"%s\"\n", \ 	what, code, vms_etext(code));  3 int		fdl_status;		/* Set to last rms call status	*/   
 static char *i vms_etext(errorcode) int		errorcode;c {  	char		*bp;p* 	short		errlen;		/* Actual text length		*/7 	static char	errname[257];	/* Error text stored here	*/fB 	static $DESCRIPTOR(err, errname); /* descriptor for error text	*/    0 	lib$sys_getmsg(&errorcode, &errlen, &err, &15); 	/*c 	 * Trim trailing junk.e 	 */0 	for (bp = &errname[errlen]; --bp >= errname;) {$ 	    if (isgraph(*bp) && *bp != ' ') 		break; 	}
 	bp[1] = EOS;* 	return(errname);t }    static FDLSTUFF *r fail(r, why, name) FDLSTUFF	*r;			/* Buffer			*/ ( char		*why;			/* A little commentary		*/( char		*name;			/* Argument to perror		*/ /*  * Problem exit routinea  */" {	 	if (name == NULLs 	 && r != NULL)e 	    name = r->fab.fab$l_fna;c 	if (name == NULL)" 	    name = "<unknown file name>";' 	if ($VMS_STATUS_SUCCESS(fdl_status)) {i; 	    fprintf(stderr, "%s: restriction -- %s\n", name, why);(8 	    fdl_status = SS$_ABORT;	/* Force an error status	*/ 	} 	else {n 	    message(r, why, name);e 	} 	freefdlstuff(r);a 	return (NULL);  }t R
 FDLSTUFF *# fdl_open(filename,  fdl_descriptor) & char			*filename;		/* What to open		*/> struct	dsc$descriptor	*fdl_descriptor;	/* Result descriptor	*/ /*H  * Open the file.  Returns NULL on failure, else a pointer to RMS stuff.H  * Which is equivalently a pointer to the RAB. (Note that the RAB points  * in turn to the FAB.)   *H  * Return the file's fdl descriptor in the user-supplied (uninitialized)  * descriptor.  */  {_ 	register FDLSTUFF	*r; 	extern FDLSTUFF		*fdl_setup();   ' 	if ((r = fdl_setup(filename)) == NULL)	 	    return (NULL);  	/*i 	 * Now open the file. 	 */* 	r->fab.fab$b_fac = FAB$M_GET | FAB$M_BRO;7 	if ((fdl_status = sys$open(&r->fab)) != RMS$_NORMAL) {", 	    return (fail(r, "opening file", NULL)); 	}+ 	if ((r->fab.fab$l_dev & DEV$M_REC) != 0) {i9 	    fail(r, "can't read from record only device", NULL);  	    fdl_close(r); 	    return (NULL);" 	}% 	if (r->fab.fab$b_org == FAB$C_IDX) {s 	    /*(2 	     * (Much) more hacking for indexed-sequential1 	     * to get all the key and allocation blocks.  	     */ 	    int			i, nall, nkey;t. 	    char		**chain;	/* Links xab's together	*/ 	    struct myxabkey {' 		struct XABKEY	xabkey;		/* The xab		*/_, 		char		keyname[32];	/* Optional key name	*/ 	    }			*key; 	    struct XABALL	*all;  @ 	    nall = r->xabsum.xab$b_noa;	/* Allocation control blocks	*/2 	    nkey = r->xabsum.xab$b_nok;	/* Isam keys			*// 	    fdl_close(r);		/* Close it to try again	*/ + 	    if ((r = fdl_setup(filename)) == NULL)  		return (NULL);= 	    chain = &r->xabsum.xab$l_nxt;	/* Start xab block list	*/s! 	    for (i = 0; i < nkey; i++) {*) 		key = malloc(sizeof (struct myxabkey));  		key->xabkey = cc$rms_xabkey;5 		key->xabkey.xab$b_ref = i;	/* Set key ref number	*/ , 	 	key->xabkey.xab$l_knm = &key->keyname[0]; 		*chain = key;	! 		chain = &key->xabkey.xab$l_nxt;i 	    }! 	    for (i = 0; i < nall; i++) {&' 		all = malloc(sizeof (struct XABALL));) 		*all = cc$rms_xaball;b1 		all->xab$b_aid = i;		/* Allo area ref number	*/s 		*chain = all;c 		chain = &all->xab$l_nxt; 	    }. 	    r->fab.fab$b_fac = FAB$M_GET | FAB$M_BRO;; 	    if ((fdl_status = sys$open(&r->fab)) != RMS$_NORMAL) {m& 		MSG("fab status", r->fab.fab$l_sts);& 		MSG("fab stv   ", r->fab.fab$l_stv);0 		return (fail(r, "reopening ISAM file", NULL)); 	    } 	}4 	r->rab.rab$l_rop = RAB$M_BIO;		/* Block I/O only	*/8 	if ((fdl_status = sys$connect(&r->rab)) != RMS$_NORMAL)5 	    return (fail(r, "connecting after open", NULL));) 	if (fdl_descriptor != NULL) { 	    struct FAB		*fab_add; 	    struct RAB		*rab_add;> 	    static int		flags = (FDL$M_FDL_STRING | SIGNAL_ON_ERROR); 	    auto int		badblk; 	    auto int		retlen; 	    /*N$ 	     * Now, get the file attributes 	     */& 	    fdl_descriptor->dsc$w_length = 0;1 	    fdl_descriptor->dsc$b_dtype = DSC$K_DTYPE_T;n1 	    fdl_descriptor->dsc$b_class = DSC$K_CLASS_D;f* 	    fdl_descriptor->dsc$a_pointer = NULL; 	    fab_add = &r->fab;D 	    rab_add = &r->rab;s$ 	    if ((fdl_status = fdl$generate(
 		    &flags,e 		    &fab_add,e 		    &rab_add,t$ 		    0L,			/* file_dst (unused)		*/' 		    0L,			/* file_resnam (unused)		*/f 		    fdl_descriptor,i 		    &badblk,  		    &retlen)) != SS$_NORMAL) { 		fdl_free(fdl_descriptor);N 		sys$close(&r->fab);N, 		return(fail(r, "getting fdl info", NULL)); 	    } 	} 	return (r); }  o
 FDLSTUFF *6 fdl_create(fdl_descriptor, override_filename, xab_lrl)> struct	dsc$descriptor	*fdl_descriptor;	/* Result descriptor	*/. char			*override_filename;	/* What to open		*/( int			xab_lrl;		/* Longest record len	*/ /*I  * Create the file, Returns NULL on failure, else a pointer to RMS stuff.sH  * Which is equivalently a pointer to the RAB. (Note that the RAB pointsF  * in turn to the FAB.)  The file is open for writing using fdl_write.  *F  * Uses the filename in the descriptor block, or the override filename(  * if supplied (non-NULL and not == "");  *G  * If fdl_descriptor is NULL, the override_filename is opened normally.f  *C  * If xab_lrl is non-zero, it sets the file-header "longest record"d	  * field.r  */r {i 	register FDLSTUFF	*r; 	int			retlen; 	int			badblk;: 	static int		flags = (FDL$M_FDL_STRING | SIGNAL_ON_ERROR); 	struct	dsc$descriptor	newname;d$ 	struct	dsc$descriptor	*newname_ptr; 	int			fid_block[3]; 	auto int		rms_status, rms_stv;f' 	char			created_name[NAM$C_MAXRSS + 1];t+ 	struct	dsc$descriptor	created_name_des = {e 				    NAM$C_MAXRSS,l 				    DSC$K_DTYPE_T, i 				    DSC$K_CLASS_S, 				    &created_name[0] 				}; 	extern FDLSTUFF		*fdl_setup();	   	if (fdl_descriptor == NULL) { 	    /*t 	     * Normal file open.s 	     */4 	    if ((r = fdl_setup(override_filename)) == NULL) 		return (NULL);7 	    r->fab.fab$l_alq = 256;		/* Allocation quantity	*/ C 	    r->fab.fab$b_fac = FAB$M_PUT | FAB$M_BIO; /* Block I/O only	*/n 	    r->fab.fab$l_fop |=2 		(FAB$M_TEF | FAB$M_NAM | FAB$M_SQO | FAB$M_BIO);8 	    r->fab.fab$b_org = FAB$C_SEQ;	/* Sequential only	*/9 	    r->fab.fab$b_rfm = FAB$C_UDF;	/* Undefined format	*/.; 	    r->xabfhc.xab$w_lrl = xab_lrl;	/* Set record length	*/	& 	    fdl_status = sys$create(&r->fab);* 	    if (!$VMS_STATUS_SUCCESS(fdl_status))* 		return (fail(r, "creating file", NULL));% 	    goto exit;				/* Normal exit		*/h 	}? 	if (override_filename == NULL || override_filename[0] == '\0')h 	    newname_ptr = NULL; 	else {  	    newname_ptr = &newname;6 	    newname.dsc$w_length = strlen(override_filename);) 	    newname.dsc$b_dtype = DSC$K_DTYPE_T;l) 	    newname.dsc$b_class = DSC$K_CLASS_S;l/ 	    newname.dsc$a_pointer = override_filename;o 	} 	i( 	fdl_status = fdl$create(fdl_descriptor,+ 		newname_ptr,		/* New file name if any		*/l 		0,			/* Default filename		*/. 		&created_name_des,	/* Resultant filename		*/& 		&fid_block[0],		/* File ID block		*/  		&flags,			/* FDL flag bits		*/ 		0,			/* Statement number		*/& 		&retlen,		/* Created name length		*/% 		&rms_status,		/* FAB$L_STS code		*/e 		&rms_stv		/* FAB$L_STV			*/  	);i( 	if (!$VMS_STATUS_SUCCESS(fdl_status)) {" 	    MSG("FAB$L_STS", rms_status); 	    MSG("FAB$L_STV", rms_stv);r/ 	    return(fail(NULL, "creating file", NULL));e 	} 	created_name[retlen] = '\0';k+ 	if ((r = fdl_setup(created_name)) == NULL)r 	    return (NULL);r 	/**" 	 * Now, open the file for output. 	 */ 	r->fab.fab$b_fac = + 	    (xab_lrl == 0) ? FAB$M_PUT | FAB$M_BIOr 			   : FAB$M_PUT | FAB$M_BRO;7 	if ((fdl_status = sys$open(&r->fab)) != RMS$_NORMAL) {t4 	    return (fail(r, "opening created file", NULL)); 	}0 exit:	if ((r->fab.fab$l_dev & DEV$M_REC) != 0) {5 	    fail(r, "Can't write record only device", NULL);4 	    fdl_close(r); 	    return (NULL);_ 	} 	/*L: 	 * We do a bit of a hack to force "longest record length" 	 */ 	if (xab_lrl != 0T; 	 && r->fab.fab$b_org == FAB$C_SEQ) {	/* Seq. files only	*/I 	    char		*tempbuf;# 	    extern char		outbuffer[MAXIO];n   	    if (xab_lrl <= MAXIO) 		tempbuf = &outbuffer[0];2 	    else if ((tempbuf = malloc(xab_lrl)) == NULL)A 		return (fail(r, "allocating memory for longest record", NULL));*+ 	    r->rab.rab$l_rop = 0;		/* PUT I/O 		*/a< 	    if ((fdl_status = sys$connect(&r->rab)) != RMS$_NORMAL)? 		return (fail(r, "connect after create to set length", NULL));e  	    r->rab.rab$l_rbf = tempbuf;  	    r->rab.rab$w_rsz = xab_lrl;: 	    if ((fdl_status = sys$put(&r->rab)) != RMS$_NORMAL) { 		if (tempbuf != &outbuffer[0])/ 		    free(tempbuf);3 		return (fail(r, "putting longest record", NULL));r 	    }" 	    if (tempbuf != &outbuffer[0]) 		free(tempbuf);? 	    if ((fdl_status = sys$disconnect(&r->rab)) != RMS$_NORMAL)l? 		return (fail(r, "disconnecting after setting length", NULL));A 	}3 	r->rab.rab$l_rop = RAB$M_BIO;	/* Block I/O only	*/r8 	if ((fdl_status = sys$connect(&r->rab)) != RMS$_NORMAL)7 	    return (fail(r, "connecting after create", NULL));c 	return (r); }L   static FDLSTUFF *w fdl_setup(filename)$ char		*filename; /*<  * Initializes rms blocks and parses file name.  Returns the,  * FDL data block on success, NULL on error.  */  {e 	register FDLSTUFF	*r;  5 	if ((r = (char *)malloc(sizeof (FDLSTUFF))) == NULL)a 	    return (NULL);t* 	r->fab = cc$rms_fab;			/* Preset fab,		*/+ 	r->nam = cc$rms_nam;			/*   name block		*/n0 	r->rab = cc$rms_rab;			/*   and record block	*/6 	r->xabfhc = cc$rms_xabfhc;		/*   file header block	*/7 	r->xabsum = cc$rms_xabsum;		/*   isam summary block	*/i5 	r->fab.fab$l_nam = &r->nam;		/* fab -> name block	*/s9 	r->fab.fab$l_xab = &r->xabfhc;		/* fab -> file header	*/s6 	r->fab.fab$l_fna = filename;		/* Argument filename	*/5 	r->fab.fab$b_fns = strlen(filename);	/* ... size		*/F/ 	r->rab.rab$l_fab = &r->fab;		/* rab -> fab		*/)  						/* Stuff the name block	*/9 	r->nam.nam$l_esa = r->starname;		/* Expanded filename	*/$1 	r->nam.nam$b_ess = NAM$C_MAXRSS;	/* ... size		*/>5 	r->nam.nam$b_rss = NAM$C_MAXRSS;	/* ... max size		*/ < 	r->xabfhc.xab$l_nxt = &r->xabsum;	/* And build xab chain	*/8 	if ((fdl_status = sys$parse(&r->fab)) != RMS$_NORMAL) {+ 	    return (fail(r, "parsing", filename));" 	}4 	((char *)r->nam.nam$l_esa)[r->nam.nam$b_esl] = EOS;6 	r->fab.fab$l_fna = r->nam.nam$l_esa;	/* File name		*/3 	r->fab.fab$b_fns = r->nam.nam$b_esl;	/* Length		*//5 	r->fab.fab$l_fop |= FAB$M_NAM;		/* Use name block	*/n 	return (r); }	   fdl_free(fdl_descriptor)& struct	dsc$descriptor	*fdl_descriptor; /*  * Release the descriptorl  */n {	 	register int status;   = 	if ((status = str$free1_dx(fdl_descriptor)) != SS$_NORMAL) {aA 	    fprintf(stderr, "LZ fatal internal error \"%s\"\n", status);y 	    lib$signal(status); 	} }o   fdl_close(r) register FDLSTUFF	*r;d {e6 	if ((fdl_status = sys$close(&r->fab)) != RMS$_NORMAL)& 	    return(fail(r, "closing", NULL)); 	freefdlstuff(r);r }    static freefdlstuff(r)e register FDLSTUFF	*r;c /*%  * Free fdl block and all XAB blocks.e  */	 {- 	register struct XABSUM	*xthis;  	register struct XABSUM	*xnext;b   	if (r == NULL)a 	    return;4 	for (xnext = r->xabsum.xab$l_nxt; xnext != NULL;) { 	    xthis = xnext;< 	    xnext = xnext->xab$l_nxt; 	    free(xthis);L 	}	 	free(r);c }m a intb" fdl_read(buffer, buffer_length, r) char		*buffer;		/* Record			*/) int		buffer_length;		/* Record length		*/ , register FDLSTUFF *r;			/* Record info.			*/ /*G  * Read the next record from the file.  Returns number of bytes read or".  * -1 on any error. fdl_status has the status.  */l {v 	r->rab.rab$l_ubf = buffer;i" 	r->rab.rab$w_usz = buffer_length; 	r->rab.rab$l_bkt = 0;7 	if ((fdl_status = sys$read(&r->rab)) != RMS$_NORMAL) {e #if TESTING_FDLIO$" 	    if (fdl_status != RMS$_EOF) {/ 		fdl_message(r, "error return from sys$read");  		sleep(1);  	    } #endif 	    return (-1);c 	} 	return (r->rab.rab$w_rsz);	 }a = int$# fdl_write(buffer, buffer_length, r)  char		*buffer;		/* Record			*/) int		buffer_length;		/* Record length		*/f, register FDLSTUFF *r;			/* Record info.			*/ /*I  * Write the next record to the file.  Returns number of bytes written orl.  * -1 on any error. fdl_status has the status.  */d {r 	r->rab.rab$l_rbf = buffer; " 	r->rab.rab$w_rsz = buffer_length; 	r->rab.rab$l_bkt = 0;8 	if ((fdl_status = sys$write(&r->rab)) != RMS$_NORMAL) { #if 1 || TESTING_FDLIO3 	    fdl_message(r, "error return from sys$write");f: 	    fprintf(stderr, "writing %d bytes\n", buffer_length); 	    sleep(1); #endif 	    return (-1);d 	} 	return (r->rab.rab$w_rsz);l }( > fdl_getname(r, buffer)# FDLSTUFF	*r;			/* File pointer			*/ & char		*buffer;		/* Where to put it		*/ /*  * Return current file name_  */a { " 	strcpy(buffer, r->fab.fab$l_fna); 	return (buffer);u }d   long fdl_fsize(r)# FDLSTUFF	*r;			/* File pointer			*// /*  * Return current file sizer  */	 { C 	return (((long) r->xabfhc.xab$l_ebk * 512) + r->xabfhc.xab$w_ffb);S }u   fdl_message(r, why)a FDLSTUFF	*r; char		*why;. /*  * Print error message  */  {n 	extern char	*vms_etext();   	if (why == NULL) {d8 	    fprintf(stderr, "\n%s\n\n", vms_etext(fdl_status)); 	} 	else {r+ 	    fprintf(stderr, "\n%s%s%s:\n  %s\n\n",t 		why, 		(why[0] == EOS) ? "" : " ",U& 		(r == NULL) ? "" : r->fab.fab$l_fna, 		vms_etext(fdl_status));s 	} }r     static message(r, why, name)  FDLSTUFF	*r;			/* Buffer			*/ ( char		*why;			/* A little commentary		*/  char		*name;			/* File name			*/ /*  * Print error message  */R {;, 	fprintf(stderr, "\nRMS error when %s %s\n",& 	    why, (name == NULL) ? "" : name);4 	fprintf(stderr, "\"%s\"\n", vms_etext(fdl_status)); }e a fdl_dump(fdl_descriptor, fd)& struct	dsc$descriptor	*fdl_descriptor; FILE			*fd;_ /*  * Dump the descriptor to fd.   */  {S 	register char	*tp, *end;t  $ 	tp = fdl_descriptor->dsc$a_pointer;) 	end = tp + fdl_descriptor->dsc$w_length;) 	while (tp < end) {  	    if (*tp == '"') { 		do { 		    putc(*tp++, fd); 		} while (*tp != '"');) 	    } 	    putc(*tp, fd);a 	    if (*tp++ == ';') 		putc('\n', fd);* 	} }    a #if	TESTING_FDLIO_ /*  * Test program for rms io  */n #include <stdio.h>   char			line[133];| char			filename[133];| char			buffer[2048];   main(argc, argv)
 int		argc; char		*argv[]; {  	FDLSTUFF	*old;f 	FDLSTUFF	*new;  	int		size, total, nrecords;8 	struct	dsc$descriptor	fdl_info;	/* Result descriptor	*/   	for (;;) {y( 	    fprintf(stderr, "Old file name: "); 	    fflush(stdout); 	    if (gets(line) == NULL) 		break; 	    if (line[0] == EOS) 		continue;*5 	    if ((old = fdl_open(line, &fdl_info)) == NULL) {n# 		fprintf(stderr, "open failed\n");N 		continue;  	    }( 	    fprintf(stderr, "New file name: "); 	    if (gets(line) == NULL) 		break;: 	    if ((new = fdl_create(&fdl_info, line, 0)) == NULL) {% 		fprintf(stderr, "create failed\n");d 		fdl_free(&fdl_info); 		continue;} 	    } 	    fdl_getname(old, buffer);2 	    fprintf(stderr, "Fdl for \"%s\", size %ld\n", 		buffer, fdl_fsize(old));! 	    fdl_dump(&fdl_info, stderr);t 	    total = nrecords = 0;@ 	    while ((size = fdl_read(buffer, sizeof buffer, old)) > 0) { 		fdl_write(buffer, size, new);r
 		nrecords++;t 		total += size; 	    } 	    fdl_close(old); 	    fdl_close(new);; 	    fprintf(stderr, "copied %d records, %d bytes total\n",t 		nrecords, total);$ 	    fdl_free(&fdl_info);M 	} }$   #endif #endif  