 /*  *			l z i o . c  *E  * I/O buffer management.  All input/output I/O is done through these A  * routines (and the macros in lz.h).  The rules of the game are:   *   * input via GET() and getbuf().1  *	GET returns an 8-bit byte, or -1 on eof/error. D  *	getbuf() returns the number of things gotten, or -1 on eof/error.2  *	No return on error: longjmp's to the main-line.  *$  * output via PUT() and lz_putbuf().2  *	No return on error: longjmp's to the main-line.J  * flush output by lz_flush() before closing files -- or you'll lose data.  */    #include	"lz.h" 
 #if VMS_V4 #include	<rmsdef.h>  #ifndef FDLSTUFF #define FDLSTUFF char  #endif extern FDLSTUFF *fdl_input;  extern FDLSTUFF *fdl_output; extern int	fdl_status; #endif   int 
 lz_fill(s) register STREAM		*s; {  	register int	i; 	extern char	*infilename;   
 #if VMS_V4 	if (export && is_compress) { 7 	    i = fread((char *) s->bstart, 1, s->bsize, stdin);  	    if (ferror(stdin)) {  		perror(infilename); , 		FAIL("export && is_compress fread error"); 	    } 	}- 	else {			/* Decompress and export/private	*/ 2 	    i = fdl_read(s->bstart, s->bsize, fdl_input);) 	    if (i < 0 && fdl_status != RMS$_EOF) ' 		fdl_message(fdl_input, "Read error");  	} #else  #ifdef unix 7 	i = read(fileno(stdin), (char *) s->bstart, s->bsize); 
 	if (i < 0) {  	    perror(infilename); 	    FAIL("unix read error");  	} #else 3 	i = fread((char *) s->bstart, 1, s->bsize, stdin);  	if (ferror(stdin)) {  	    perror(infilename); 	    exit(IO_ERROR); 	} #endif #endif 	if (i <= 0) 	    return (EOF); 	else {m 	    s->bp = s->bstart;  	    s->bend = &s->bstart[i];L	 #if UCHARf 	    return (*s->bp++);x #elsef 	    return (*s->bp++ & 0xFF); #endif 	} }T N lz_flush(s)o register STREAM	*s; {  	register int	count; 	extern char	*outfilename;   	count = s->bp - s->bstart; 	 #if DEBUG # 	if (!is_compress && verbose > 4) { . 	    fprintf(stderr, "lz_flush %d:  ", count);( 	    dumptext(s->bstart, count, stderr); 	} #endif
 #if VMS_V4 	if (export) { 	    if (is_compress) / 		fwrite((char *) s->bstart, count, 1, stdout);  	    else {  		register char *bp, *bend;   : 		for (bp = s->bstart, bend = bp + count; bp < bend; bp++) 		    putchar(*bp);  	    } 	    if (ferror(stdout)) { 		perror(outfilename);& 		FAIL("VMS V4 fwrite/putchar error"); 	    } 	} 	else {cB 	    if (fdl_write((char *) s->bstart, count, fdl_output) == -1) {) 		fdl_message(fdl_output, "Write error"); ! 		FAIL("VMS V4 fdl_write error");  	    } 	} #elsel #ifdef unixA 	if (write(fileno(stdout), (char *) s->bstart, count) != count) {  	    perror(outfilename);o= 	    fprintf(stderr, "Can't write to \"%s\"\n", outfilename);  	    FAIL("Unix write error"); 	} #elsee. 	fwrite((char *) s->bstart, 1, count, stdout); 	if (ferror(stdout)) { 	    perror(outfilename); ( 	    FAIL("Other (decus) fwrite error"); 	} #endif #endif 	s->bp = s->bstart;e }y l intt lz_getbuf(buffer, count, s)_ char_type		*buffer;I int			count; register STREAM		*s; /*B  * Read a block of data -- be clever.  Return number gotten, or -1
  * on eof.  */i {d* 	register char_type	*bp;		/* -> buffer		*/- 	register char_type	*ip;		/* -> I/O buffer	*/g. 	register char_type	*ep;		/* End of segment	*// 	register int		remaining;	/* Size of segment	*/o
 	int			datum;d  * 	if (count == 0)				/* Shouldn't happen	*/ 	    return (0);
 	bp = buffer;  	while (--count >= 0) {p: 	    if ((datum = GET(s)) == EOF)	/* Maybe fill LZ buff	*/ 		break; 	    *bp++ = datum;T( 	    remaining = s->bend - (ip = s->bp); 	    if (remaining > count)  		remaining = count; 	    ep = &ip[remaining];	 	    while (ip < ep) 		*bp++ = *ip++; 	    count -= remaining;( 	    s->bp = ip;				/* Refresh buffer	*/ 	}, 	return ((bp == buffer) ? -1 : bp - buffer); }  P int  lz_putbuf(bp, count, s)n register char_type	*bp;  int			count; register STREAM		*s; /*&  * Write a block of data -- be clever.  */k {c- 	register char_type	*op;		/* -> I/O buffer	*/y. 	register char_type	*ep;		/* End of segment	*// 	register int		remaining;	/* Size of segment	*/e   	while (--count >= 0) {E+ 	    PUT(*bp++, s);			/* Forces a buffer	*/l( 	    remaining = s->bend - (op = s->bp); 	    if (remaining > count)T 		remaining = count; 	    ep = &op[remaining];  	    while (op < ep) 		*op++ = *bp++; 	    count -= remaining;( 	    s->bp = op;				/* Refresh buffer	*/ 	} }s c int 	 lz_eof(s)c STREAM		*s;C /*5  * Dummy routine for read from memory -- returns EOF.F  */E {" 	return (s, EOF);k }g   inta
 lz_fail(s) STREAM		*s;r /*?  * Dummy routine for write to memory -- called if buffer fills.:  */  {l? 	fprintf(stderr, "Memory buffer [%d bytes] filled -- fatal.\n",k 		s->bsize); 	FAIL("lz_fail crash");P }E   int  lz_dummy(s)g STREAM		*s;  /*A  * Dummy routine for write to memory -- writes to the bit-bucket.A  */' {l 	s->bp = s->bstart;  }i k
 #ifndef decusa /*  * Signal error handlers.s  */v
 #ifdef vms #define unlink	deleteo #endif   interrupt()E {	< 	if (outfilename != NULL && !streq(outfilename, "<stdout>")) 	    unlink(outfilename);  	exit(IO_ERROR); }t   address_error()2 {! 	if (!is_compress)9 	    fprintf(stderr, "Decompress: corrupt input file\n"); 
 	interrupt();e }y #endif Z /*<  * getredirection() is intended to aid in porting C programs7  * to VMS (Vax-11 C) which does not support '>' and '<'/7  * I/O redirection.  With suitable modification, it maya1  * useful for other portability problems as well.X  */'  
 #ifdef	vms   int! getredirection(argc, argv)
 int		argc;
 char		**argv;C /*=  * Process vms redirection arg's.  Exit if any error is seen..:  * If getredirection() processes an argument, it is erased?  * from the vector.  getredirection() returns a new argc value.o  *>  * Warning: do not try to simplify the code for vms.  The codeA  * presupposes that getredirection() is called before any data isy(  * read from stdin or written to stdout.  *  * Normal usage is as follows:  *  *	main(argc, argv) 
  *	int		argc;i  *	char		*argv[];X  *	{&  *		argc = getredirection(argc, argv);  *	}  */  {T+ 	register char		*ap;	/* Argument pointer	*/m 	int			i;	/* argv[] index		*/r 	int			j;	/* Output index		*/a# 	int			file;	/* File_descriptor 	*/L  : 	for (j = i = 1; i < argc; i++) {   /* Do all arguments	*/ 	    switch (*(ap = argv[i])) {  	    case '<':			/* <file		*/ * 		if (freopen(++ap, "r", stdin) == NULL) {( 		    perror(ap);		/* Can't find file	*/, 		    exit(IO_ERROR);	/* Is a fatal error	*/ 		}  		break;  & 	    case '>':			/* >file or >>file	*/# 		if (*++ap == '>') {	/* >>file		*/, 		    /*3 		     * If the file exists, and is writable by us,L6 		     * call freopen to append to the file (using the7 		     * file's current attributes).  Otherwise, createF3 		     * a new file with "vanilla" attributes as ifC/ 		     * the argument was given as ">filename".N3 		     * access(name, 2) is TRUE if we can write onN 		     * the specified file.	 		     */E! 		    if (access(++ap, 2) == 0) { ( 			if (freopen(ap, "a", stdout) != NULL)' 			    break;	/* Exit case statement	*/ ( 			perror(ap);	/* Error, can't append	*/* 			exit(IO_ERROR);	/* After access test	*/" 		    }			/* If file accessable	*/ 		}  		/*8 		 * On vms, we want to create the file using "standard"5 		 * record attributes.  create(...) creates the file 3 		 * using the caller's default protection mask and / 		 * "variable length, implied carriage return" 8 		 * attributes. dup2() associates the file with stdout. 		 */ 6 		if ((file = creat(ap, 0, "rat=cr", "rfm=var")) == -1) 		 || dup2(file, fileno(stdout)) == -1) { * 		    perror(ap);		/* Can't create file	*/, 		    exit(IO_ERROR);	/* is a fatal error	*/ 		}			/* If '>' creation	*/  		break;			/* Exit case test	*/   
 	    default: ) 		argv[j++] = ap;		/* Not a redirector	*/  		break;			/* Exit case test	*/  	    } 	}				/* For all arguments	*/ ) 	argv[j] = NULL;			/* Terminate argv[]	*/ $ 	return (j);			/* Return new argc	*/ }  #endif   #if 1 || DEBUG  	 int		col;    readonly char *lz_names[] = { =     "LZ_CLEAR", "LZ_SOH", "LZ_STX", "LZ_EOR", "LZ_ETX", "???"  };   dumphex(buffer, count, fd) register char_type	*buffer;  register int		count; FILE			*fd;  {  	if (col > 0) {  	    putc('\n', fd);
 	    col = 0;  	} 	fprintf(fd, "%2d:", count); 	while (--count >= 0) { , 	    fprintf(fd, " %02x", *buffer++ & 0xFF); 	} 	fprintf(fd, "\n");  }    dumptext(buffer, count, fd)  register char_type	*buffer;  int			count; FILE			*fd;  {  	extern char	*dumpchar();    	putc('"', fd);  	while (--count >= 0) * 	    fputs(dumpchar((int) *buffer++), fd); 	fputs("\"\n", fd);  }    char * dumpchar(c)  register int	c;  /*9  * Make a character printable.  Returns a static pointer.   */  {  	static char	dump_buffer[8];   	c &= 0xFF;   	if (isascii(c) && isprint(c)) { 	    dump_buffer[0] = c; 	    dump_buffer[1] = EOS; 	} 	else {  	    switch (c) {  	    case '\n':	return ("\\n");  	    case '\t':	return ("\\t");  	    case '\b':	return ("\\b");  	    case '\f':	return ("\\f");  	    case '\r':	return ("\\r");  	    }( 	    sprintf(dump_buffer, "<x%02X>", c); 	} 	return (dump_buffer); }  #endif   /*F  * Cputime returns the elapsed process time (where available) in msec.E  * Note: Unix doesn't seem to have a good way to determine ticks/sec.   */    #ifdef	decus #include	<timeb.h>   long	 cputime()  {  	struct timeb		buf;  	static struct timeb	origin; 	long			result;  	int			msec;   	if (origin.time == 0) 	    ftime(&origin);
 	ftime(&buf); * 	result = (buf.time - origin.time) * 1000;/ 	msec = ((int) buf.msec) - ((int) origin.msec);l! 	return (result + ((long) msec));e }t #elsei
 #ifdef vms #include	<types.h> struct tms { 	time_t	tms_utime; 	time_t	tms_stime;$ 	time_t	tms_uchild;	/* forgot the */' 	time_t	tms_uchildsys;	/* real names */- };* #define HERTZ	100.0				/* 10 msec units	*/ #else  #include	<sys/types.h> #include	<sys/times.h>
 #ifndef HERTZr- #define HERTZ	60.0				/* Change for Europe	*/  #endif #endif   long	 cputime()e {n 	struct tms	tms; 	double		temp; 	long		result;  
 	times(&tms);(( 	result = tms.tms_utime + tms.tms_stime;5 	temp = result * 1000.0 / HERTZ;		/* Time in msec.	*/m 	result = temp;  	return (result);D }U #endif  