 /*  *			l z v i o . c  * For VMS V4 only.   */    /*  * Problems:;  *	If you open a second input file (getting rms attributes) D  *	it aborts with an internal "fatal" error (15820C LIB-F-FATERRLIB)  */     /*3  * Make TESTING_FDLIO non-zero to enable test code.   *  * Edit History   */  #ifndef	TESTING_FDLIO  #define	TESTING_FDLIO	0  #endif   /*E  * RMS/FDL record level i/o routines for Vax-11 C V4 or greater only.   * Rather crude.  *  * The following are provided:  *  *	#define	FDLSTUFF	char  *	#include descrip   *
  *	FDLSTUFF * %  *	fdl_open(filename, fdl_descriptor)   *	char			*filename;)  *	struct	dsc$descriptor	*fdl_descriptor; 8  *		Initializes internal buffers and opens this existing<  *		file for input.  The filename may not contain wildcards.8  *		On (successful) return, fdl_descriptor will point to6  *		an initialized fdl specification.  The description<  *		string will be in malloc'ed memory.  The caller does not:  *		initialize the fdl_descriptor.  Returns NULL on error.6  *		(Note an error will be returned if the file is not  *		block-oriented.)  *6  *		When you don't need the fdl_descriptor information   *		any more, free it by calling!  *		    fdl_free(fdl_descriptor); :  *		if fdl_descriptor is NULL on entry, the file is opened0  *		normally (fdl information is not collected).  *
  *	FDLSTUFF * 0  *	fdl_create(fdl_descriptor, override_filename))  *	struct	dsc$descriptor	*fdl_descriptor;   *	char			*override_filename; /  *		Creates a file using the fdl specification. 9  *		If override_filename is not NULL and not equal to "", 7  *		it will override the filename specified in the fdl. 2  *		fdl_write() is used to write data to the file.  *		Returns NULL on error.  *8  *		if fdl_descriptor is NULL, the file is created using:  *		the name in override_filename (which must be present).5  *		The file is created in "undefined" record format.   *  *	fdl_free(fdl_descriptor) )  *	struct	dsc$descriptor	*fdl_descriptor; &  *		Releases the fdl descriptor block.  *  *	int%  *	fdl_read(buffer, buffer_length, r)   *	char		*buffer;   *	int		buffer_length;  *	FDLSTUFF	*r; <  *		Read buffer_length bytes from the file (using SYS$READ).6  *		No expansion or interpretation.  buffer_length had9  *		better be even or you're asking for trouble.  Returns 7  *		the actual number of bytes read.  The file has been   *		opened by fdl_open.   *  *	int&  *	fdl_write(buffer, buffer_length, r)  *	char		*buffer;   *	int		buffer_length;  *	FDLSTUFF	*r; <  *		Write buffer_length bytes to the file (using SYS$WRITE).6  *		No expansion or interpretation.  buffer_length had9  *		better be even or you're asking for trouble.  Returns <  *		the actual number of bytes written.  The file was opened  *		by fdl_create();  *  *	fdl_getname(r, buffer)   *	FDLSTUFF	*r;   *	char		*buffer; 9  *		Copies the currently open file's name to the caller's   *		data buffer buffer.   *  *	long   *	fdl_fsize(r) 1  *		Returns the size in bytes of the opened file.   *  *	fdl_dump(fdl_descriptor, fd) )  *	struct	dsc$descriptor	*fdl_descriptor;   *	FILE			*fd;2  *		Writes the fdl info to the indicated file with&  *		line breaks in appropriate places.  *  *	fdl_message(r, why)  *	FDLSTUFF	*r;   *	char		*why;=  *		All system-level routines set a global value, fdl_status. =  *		fdl_message() prints the error message text corresponding <  *		to the current value of fdl_status.  The message printed  *		has the format: )  *			why current_filename: error_message. 6  *		If why is NULL, only the error_message is printed.  */    #include "lz.h" 
 #if VMS_V4 #include rms #include ssdef #include descrip #include devdef  #ifndef	FDL$M_FDL_SIGNAL6 #define FDL$M_FDL_SIGNAL	1	/* Signal errors if set		*/ #endif #ifndef	FDL$M_FDL_STRING8 #define FDL$M_FDL_STRING	2	/* Use string for fdl text	*/ #endif #if TESTING_FDLIO ( #define	SIGNAL_ON_ERROR	FDL$M_FDL_SIGNAL #else  #define	SIGNAL_ON_ERROR	0  #endif   #define	TRUE	1 #define	FALSE	0 
 #define	EOS	0    typedef struct FDLSTUFF { - 	struct	RAB	rab;		/* Record access buffer		*/ + 	struct	FAB	fab;		/* File access buffer		*/ ) 	struct	NAM	nam;		/* File name buffer		*/ 4 	struct	XABFHC	xab;		/* Extended attributes block	*/7 	char		starname[NAM$C_MAXRSS + 1]; /* Wild file name	*/ 7 	char		filename[NAM$C_MAXRSS + 1]; /* Open file name	*/  } FDLSTUFF;   3 int		fdl_status;		/* Set to last rms call status	*/    static FDLSTUFF *  fail(r, why, name) FDLSTUFF	*r;			/* Buffer			*/ ( char		*why;			/* A little commentary		*/( char		*name;			/* Argument to perror		*/ /*  * Problem exit routine   */  {  #if TESTING_FDLIO  	if (name == NULL && r != NULL)  	    name = r->fab.fab$l_fna;  	message(r, why, name);  #endif 	if (r != NULL) 
 	    free(r);  	return (NULL);  }   
 FDLSTUFF *# fdl_open(filename,  fdl_descriptor) & char			*filename;		/* What to open		*/> struct	dsc$descriptor	*fdl_descriptor;	/* Result descriptor	*/ /*H  * Open the file.  Returns NULL on failure, else a pointer to RMS stuff.H  * Which is equivalently a pointer to the RAB. (Note that the RAB points  * in turn to the FAB.)   *H  * Return the file's fdl descriptor in the user-supplied (uninitialized)  * descriptor.  */  {  	register FDLSTUFF	*r; 	int			retlen; 	int			badblk; 	struct FAB		*fab_add; 	struct RAB		*rab_add;: 	static int		flags = (FDL$M_FDL_STRING | SIGNAL_ON_ERROR); 	extern FDLSTUFF		*fdl_setup();   ' 	if ((r = fdl_setup(filename)) == NULL)  	    return (NULL);  	/*  	 * Now open the file. 	 */? 	r->fab.fab$b_fac = FAB$M_GET | FAB$M_BIO; /* Block I/O only	*/ 7 	if ((fdl_status = sys$open(&r->fab)) != RMS$_NORMAL) { , 	    return (fail(r, "opening file", NULL)); 	}+ 	if ((r->fab.fab$l_dev & DEV$M_REC) != 0) { # 	    fail(r, "Record only device");  	    fdl_close(r); 	    return (NULL);  	}4 	r->rab.rab$l_rop = RAB$M_BIO;		/* Block I/O only	*/8 	if ((fdl_status = sys$connect(&r->rab)) != RMS$_NORMAL)5 	    return (fail(r, "connecting after open", NULL));  	if (fdl_descriptor != NULL) { 	    /* $ 	     * Now, get the file attributes 	     */) 	    fdl_descriptor->dsc$w_length = 4096; 2 	    fdl_descriptor->dsc$b_dtype = DSC$K_DTYPE_VT;1 	    fdl_descriptor->dsc$b_class = DSC$K_CLASS_D; 2 	    fdl_descriptor->dsc$a_pointer = malloc(4096); 	    fab_add = &r->fab;  	    rab_add = &r->rab; $ 	    if ((fdl_status = fdl$generate(
 		    &flags,  		    &fab_add,  		    &rab_add,  		    0, 0,  		    fdl_descriptor,  		    &badblk,  		    &retlen)) != SS$_NORMAL) { 		fdl_free(fdl_descriptor);  		sys$close(&r->fab); , 		return(fail(r, "getting fdl info", NULL)); 	    } 	    /* ? 	     * Success, null-terminate fdl info and squeeze the block.  	     */1 	    fdl_descriptor->dsc$a_pointer[retlen] = EOS; " 	    fdl_descriptor->dsc$a_pointer7 		= realloc(fdl_descriptor->dsc$a_pointer, retlen + 1); + 	    fdl_descriptor->dsc$w_length = retlen;  	} 	return (r); }   
 FDLSTUFF *- fdl_create(fdl_descriptor, override_filename) > struct	dsc$descriptor	*fdl_descriptor;	/* Result descriptor	*/. char			*override_filename;	/* What to open		*/ /*I  * Create the file, Returns NULL on failure, else a pointer to RMS stuff. H  * Which is equivalently a pointer to the RAB. (Note that the RAB pointsF  * in turn to the FAB.)  The file is open for writing using fdl_write.  *F  * Uses the filename in the descriptor block, or the override filename(  * if supplied (non-NULL and not == "");  *G  * If fdl_descriptor is NULL, the override_filename is opened normally.   */  {  	register FDLSTUFF	*r; 	int			retlen; 	int			badblk;: 	static int		flags = (FDL$M_FDL_STRING | SIGNAL_ON_ERROR); 	struct	dsc$descriptor	newname; $ 	struct	dsc$descriptor	*newname_ptr; 	int			fid_block[3];' 	char			created_name[NAM$C_MAXRSS + 1]; + 	struct	dsc$descriptor	created_name_des = {  				    NAM$C_MAXRSS,  				    DSC$K_DTYPE_T,   				    DSC$K_CLASS_S, 				    &created_name[0] 				}; 	extern FDLSTUFF		*fdl_setup();    	if (fdl_descriptor == NULL) {4 	    if ((r = fdl_setup(override_filename)) == NULL) 		return (NULL);C 	    r->fab.fab$b_fac = FAB$M_PUT | FAB$M_BIO; /* Block I/O only	*/ = 	    r->fab.fab$l_fop |= (FAB$M_NAM | FAB$M_SQO | FAB$M_BIO); 8 	    r->fab.fab$b_org = FAB$C_SEQ;	/* Sequential only	*/9 	    r->fab.fab$b_rfm = FAB$C_UDF;	/* Undefined format	*/t6 	    if ((fdl_status = sys$create(&r->fab)) & 01 == 0), 		return (fail(r, "creating (sys$create)")); 	    goto exit;t 	}? 	if (override_filename == NULL || override_filename[0] == '\0')  	    newname_ptr = NULL; 	else {o 	    newname_ptr = &newname;6 	    newname.dsc$w_length = strlen(override_filename);) 	    newname.dsc$b_dtype = DSC$K_DTYPE_T;#) 	    newname.dsc$b_class = DSC$K_CLASS_S;l/ 	    newname.dsc$a_pointer = override_filename;n 	}- 	if ((fdl_status = fdl$create(fdl_descriptor,*+ 		newname_ptr,		/* New file name if any		*/  		0,			/* Default filename		*/. 		&created_name_des,	/* Resultant filename		*/& 		&fid_block[0],		/* File ID block		*/  		&flags,			/* FDL flag bits		*/ 		0,			/* Statement number		*/& 		&retlen,		/* Created name length		*/# 		0, 0)			/* Create status, stv		*/t 		) & 01 == 0) {7 	    return(fail(NULL, "creating (fdl$create)", NULL));r 	} 	created_name[retlen] = '\0';r+ 	if ((r = fdl_setup(created_name)) == NULL)_ 	    return (NULL);n 	/*	" 	 * Now, open the file for output. 	 */? 	r->fab.fab$b_fac = FAB$M_PUT | FAB$M_BIO; /* Block I/O only	*/h7 	if ((fdl_status = sys$open(&r->fab)) != RMS$_NORMAL) {l4 	    return (fail(r, "opening created file", NULL)); 	}0 exit:	if ((r->fab.fab$l_dev & DEV$M_REC) != 0) {# 	    fail(r, "Record only device");i 	    fdl_close(r); 	    return (NULL);l 	}4 	r->rab.rab$l_rop = RAB$M_BIO;		/* Block I/O only	*/8 	if ((fdl_status = sys$connect(&r->rab)) != RMS$_NORMAL)7 	    return (fail(r, "connecting after create", NULL));  	return (r); }	 u static FDLSTUFF *  fdl_setup(filename)p char		*filename; /*<  * Initializes rms blocks and parses file name.  Returns the,  * FDL data block on success, NULL on error.  */e {r 	register FDLSTUFF	*r;  5 	if ((r = (char *)malloc(sizeof (FDLSTUFF))) == NULL)e 	    return (NULL);s* 	r->fab = cc$rms_fab;			/* Preset fab,		*/+ 	r->nam = cc$rms_nam;			/*   name block		*/	0 	r->rab = cc$rms_rab;			/*   and record block	*/4 	r->xab = cc$rms_xabfhc;			/*   file header block	*/5 	r->fab.fab$l_nam = &r->nam;		/* fab -> name block	*/_6 	r->fab.fab$l_xab = &r->xab;		/* fab -> file header	*/6 	r->fab.fab$l_fna = filename;		/* Argument filename	*/5 	r->fab.fab$b_fns = strlen(filename);	/* ... size		*/ / 	r->rab.rab$l_fab = &r->fab;		/* rab -> fab		*/*  						/* Stuff the name block	*/9 	r->nam.nam$l_esa = r->starname;		/* Expanded filename	*/ 2 	r->nam.nam$b_ess = NAM$C_MAXRSS ;	/* ... size		*/6 	r->nam.nam$b_rss = NAM$C_MAXRSS ;	/* ... max size		*/8 	if ((fdl_status = sys$parse(&r->fab)) != RMS$_NORMAL) {+ 	    return (fail(r, "parsing", filename));e 	}4 	((char *)r->nam.nam$l_esa)[r->nam.nam$b_esl] = EOS;6 	r->fab.fab$l_fna = r->nam.nam$l_esa;	/* File name		*/3 	r->fab.fab$b_fns = r->nam.nam$b_esl;	/* Length		*/ 5 	r->fab.fab$l_fop |= FAB$M_NAM;		/* Use name block	*/e 	return (r); }i   fdl_free(fdl_descriptor)& struct	dsc$descriptor	*fdl_descriptor; /*  * Release the descriptor;  */	 {t- 	if (fdl_descriptor->dsc$a_pointer != NULL) {	) 	    free(fdl_descriptor->dsc$a_pointer);f* 	    fdl_descriptor->dsc$a_pointer = NULL; 	} };   fdl_close(r) register FDLSTUFF	*r;l {l6 	if ((fdl_status = sys$close(&r->fab)) != RMS$_NORMAL)$ 	    return(fail(r, "close", NULL));	 	free(r);v }e   intt" fdl_read(buffer, buffer_length, r) char		*buffer;		/* Record			*/) int		buffer_length;		/* Record length		*/L, register FDLSTUFF *r;			/* Record info.			*/ /*G  * Read the next record from the file.  Returns number of bytes read orp.  * -1 on any error. fdl_status has the status.  */  {$ 	r->rab.rab$l_ubf = buffer;r" 	r->rab.rab$w_usz = buffer_length; 	r->rab.rab$l_bkt = 0;7 	if ((fdl_status = sys$read(&r->rab)) != RMS$_NORMAL) {  #if TESTING_FDLIOf" 	    if (fdl_status != RMS$_EOF) {/ 		fdl_message(r, "error return from sys$read");d 		sleep(1);  	    } #endif 	    return (-1);  	} 	return (r->rab.rab$w_rsz);c }A a int*# fdl_write(buffer, buffer_length, r)A char		*buffer;		/* Record			*/) int		buffer_length;		/* Record length		*/*, register FDLSTUFF *r;			/* Record info.			*/ /*I  * Write the next record to the file.  Returns number of bytes written orl.  * -1 on any error. fdl_status has the status.  */S {F 	r->rab.rab$l_rbf = buffer;t" 	r->rab.rab$w_rsz = buffer_length; 	r->rab.rab$l_bkt = 0;8 	if ((fdl_status = sys$write(&r->rab)) != RMS$_NORMAL) { #if TESTING_FDLIOa3 	    fdl_message(r, "error return from sys$write");  	    sleep(1); #endif 	    return (-1);T 	} 	return (r->rab.rab$w_rsz);r }  L fdl_getname(r, buffer)# FDLSTUFF	*r;			/* File pointer			*/ & char		*buffer;		/* Where to put it		*/ /*  * Return current file nameU  */  {_" 	strcpy(buffer, r->fab.fab$l_fna); 	return (buffer);  }t   long fdl_fsize(r)# FDLSTUFF	*r;			/* File pointer			*/u /*  * Return current file size   */  {t= 	return (((long) r->xab.xab$l_ebk * 512) + r->xab.xab$w_ffb);  }i   fdl_message(r, why)h FDLSTUFF	*r; char		*why;o /*  * Print error message  */* {* 	extern char	*vms_etext();   	if (why == NULL) {i8 	    fprintf(stderr, "\n%s\n\n", vms_etext(fdl_status)); 	} 	else {i( 	    fprintf(stderr, "\n%s%s%s: %s\n\n", 		why, 		(why[0] == EOS) ? "" : " ",a& 		(r == NULL) ? "" : r->fab.fab$l_fna, 		vms_etext(fdl_status));S 	} }f  7 static char		errname[257];	/* Error text stored here	*/ A static $DESCRIPTOR(err, errname);	/* descriptor for error text	*/$  
 static char *  vms_etext(errorcode) int		errorcode;  {d 	char		*bp;s* 	short		errlen;		/* Actual text length		*/  0 	lib$sys_getmsg(&errorcode, &errlen, &err, &15); 	/*b 	 * Trim trailing junk.  	 */0 	for (bp = &errname[errlen]; --bp >= errname;) {$ 	    if (isgraph(*bp) && *bp != ' ') 		break; 	}
 	bp[1] = EOS;B 	return(errname);i }(   static message(r, why, name)) FDLSTUFF	*r;			/* Buffer			*/f( char		*why;			/* A little commentary		*/  char		*name;			/* File name			*/ /*  * Print error message  */  {r/ 	fprintf(stderr, "\nRMS error %x when %s %s\n",t2 	    fdl_status, why, (name == NULL) ? "" : name);4 	fprintf(stderr, "\"%s\"\n", vms_etext(fdl_status)); }S   fdl_dump(fdl_descriptor, fd)& struct	dsc$descriptor	*fdl_descriptor; FILE			*fd;  /*  * Dump the descriptor to fd._  */s {f 	register char	*tp, *end;   $ 	tp = fdl_descriptor->dsc$a_pointer;) 	end = tp + fdl_descriptor->dsc$w_length;b 	while (tp < end) {) 	    if (*tp == '"') { 		do { 		    putc(*tp++, fd); 		} while (*tp != '"');n 	    } 	    putc(*tp, fd);N 	    if (*tp++ == ';') 		putc('\n', fd);n 	} }m     #if	TESTING_FDLIOe /*  * Test program for rms io  */r #include <stdio.h>   char			line[133];  char			filename[133];p char			buffer[2048];   main(argc, argv)
 int		argc; char		*argv[]; {l 	FDLSTUFF	*old;w 	FDLSTUFF	*new;  	int		size, total, nrecords;8 	struct	dsc$descriptor	fdl_info;	/* Result descriptor	*/   	for (;;) {r( 	    fprintf(stderr, "Old file name: "); 	    fflush(stdout); 	    if (gets(line) == NULL) 		break; 	    if (line[0] == EOS) 		continue;,5 	    if ((old = fdl_open(line, &fdl_info)) == NULL) {y# 		fprintf(stderr, "open failed\n");  		continue;* 	    }( 	    fprintf(stderr, "New file name: "); 	    if (gets(line) == NULL) 		break;7 	    if ((new = fdl_create(&fdl_info, line)) == NULL) {*% 		fprintf(stderr, "create failed\n");  		fdl_free(&fdl_info); 		continue;  	    } 	    fdl_getname(old, buffer);2 	    fprintf(stderr, "Fdl for \"%s\", size %ld\n", 		buffer, fdl_fsize(old));! 	    fdl_dump(&fdl_info, stderr);N 	    total = nrecords = 0;@ 	    while ((size = fdl_read(buffer, sizeof buffer, old)) > 0) { 		fdl_write(buffer, size, new);M
 		nrecords++;  		total += size; 	    } 	    fdl_close(old); 	    fdl_close(new);; 	    fprintf(stderr, "copied %d records, %d bytes total\n",c 		nrecords, total);; 	    fdl_free(&fdl_info);t 	} }    #endif #endif  