 /* #define DEBUG	TRUE	*/ /*=  * Header file for all lz compression/decompression routines.   *;  * Machine/Operating system/compiler selection: (#ifdef'ed)   * vax				Vax/Unix or Vax/VMS #  * pdp11			makes a small compressor    * M_XENIX			"large-model" Z8000*  * interdata			Signed long compare is slow'  * unix				Defined on true Unix systems   * decus			Decus C (no signal)3  * vms				Vax/VMS (VMS_V4 may be set automatically) B  * #define readonly		If the compiler doesn't support it correctly.  *  #  * Compiler configuration (#if'ed): K  * #define vax_asm   TRUE/FALSE	TRUE on Vax (4bsd) if the compiler supports 4  *				the asm() operator.  Check the generated code!K  * #define vms_asm   TRUE/FALSE	TRUE on Vax/VMS to use the run-time library   *				insv and extv routines. G  * #define UCHAR     TRUE/FALSE	TRUE if compiler supports unsigned char B  * #define DEBUG     TRUE/FALSE	TRUE to compile in debug printouts  *  * Algorithm Tuning parameters: 6  * #define USERMEM   <n>	Memory available to compress.2  *				If large enough, a faster algorithm is used.8  * #define SACREDMEM <n>	Don't use this part of USERMEM.5  * #define BITS      <n>	Maximum number of code bits. F  * #define MAXIO     <n>	Output buffer size (squeeze memory if needed)  */    #include <stdio.h> #include <ctype.h> #include <setjmp.h> 
 #ifndef decus  # include <signal.h> /*  * Arguments to signal():   */ 3 extern int	abort();		/* Debugging interrupt trap	*/ ; extern int	interrupt();		/* Non-debugging interrupt trap	*/ 6 extern int	address_error();	/* "Segment" violation		*/ #endif   #ifndef	TRUE # define FALSE		0  # define TRUE		1 #endif #ifndef	EOS  # define EOS		'\0' #endif+ #define	streq(a, b)	(strcmp((a), (b)) == 0) ) #define min(a,b)	((a) > (b)) ? (b) : (a))    /*F  * Set USERMEM to the maximum amount of physical user memory availableL  * in bytes.  USERMEM is used to determine the maximum BITS that can be used  * for compression.   *H  * SACREDMEM is the amount of physical memory saved for others; compress  * will hog the rest.   */    #ifndef SACREDMEM  # define SACREDMEM	0 #endif   /*"  * Set machine-specific parameters  */   
 #ifdef vax # ifdef unix7 #  define vax_asm	TRUE		/* If asm() supported on vax	*/  # endif  # ifdef vms  #  define vms_asm	TRUE # endif  #endif #ifndef	vax_asm  # define vax_asm	FALSE #endif #ifndef vms_asm  # define vms_asm	FALSE #endif   #ifdef pdp118 # define BITS	12	/* max bits/code for 16-bit machine		*/0 # define USERMEM 0	/* Force no user memory				*/B # define UCHAR	FALSE	/* TRUE if compiler supports unsigned char	*/< # define MAXIO 512	/* Buffer size for PDP-11 I/O buffers		*/ #endif   /**  * Set default values for some parameters.  */   
 #ifndef DEBUG  # define DEBUG	FALSE #endif   #ifdef interdata! # define SIGNED_COMPARE_SLOW TRUE  #endif #ifndef SIGNED_COMPARE_SLOW " # define SIGNED_COMPARE_SLOW FALSE #endif   #ifndef USERMEM 4 # define USERMEM 750000	/* default user memory				*/ #endif  
 #ifndef	UCHAR : # define UCHAR	TRUE	/* Compiler supports unsigned char		*/ #endif  
 #ifndef MAXIO , # define MAXIO	2048	/* I/O buffer size				*/ #endif   /*!  * Set derived tuning parameters.   */    #ifndef USERMEM  # define USERMEM	 0  #endif% #if USERMEM >=			(433484 + SACREDMEM)  # define PBITS		16 #else & # if USERMEM >=			(229600 + SACREDMEM) #  define PBITS		15  # else& #  if USERMEM >=		(127536 + SACREDMEM) #   define PBITS	14  #   else( #    if USERMEM >=		( 73464 + SACREDMEM) #     define PBITS	13 # #    else			/* Smaller systems			*/  #     define PBITS	12 
 #    endif	 #   endif  # endif  #endif   #ifndef BITS # define BITS PBITS  #endif   #ifdef M_XENIX # if BITS >= 16 = #  define XENIX_16		/* Enable special vector access macros	*/  # else #  if BITS > 13  #   undef BITS= #   define BITS 13		/* Code only handles BITS = 12, 13, 16	*/  #  endif # endif  #endif   /*<  * HSIZE is the size of the hash lookup table.  It is set to:  * 1 << BITS + fudge factor, rounded up to a prime number.;  * If it is too big, the "clear the hash" routine will take >  * too long.  The same numbers are replicated in the getsize()  * routine's data table.  */    #if BITS == 16+ # define HSIZE	69001		/* 95% occupancy			*/  #endif #if BITS == 15+ # define HSIZE	35023		/* 94% occupancy			*/  #endif #if BITS == 14+ # define HSIZE	18013		/* 91% occupancy			*/  #endif #if BITS == 13+ # define HSIZE	 9001		/* 91% occupancy			*/  #endif #if BITS <= 12+ # define HSIZE	 5003		/* 80% occupancy			*/  #endif   /**  * typedef's -- somewhat machine specific.  */    /*J  * a code_int must be able to hold 2**BITS values of type int, and also -1  */ 
 #if BITS > 15  typedef long int	code_int; #else  typedef int		code_int; #endif   /*=  * A count_int must hold ((2**BITS)-1) + (255<<BITS)) and -1.   *"  * count_int's also hold counters.  *8  * count_short's hold small counters (for the interdata)  *J  * Some implementations don't support unsigned char (Decus C, for example)A  * Decus C is also brain damaged with regards to unsigned shorts.   */  #if SIGNED_COMPARE_SLOW $ typedef unsigned long int count_int;' typedef unsigned short int count_short;  #else  typedef long int	count_int;  #endif  	 #if UCHAR   typedef	unsigned char	char_type; #else  typedef char		char_type; #endif   #ifdef decus typedef unsigned	U_short; 4 #define	readonly			/* Dummy out readonly modifier	*/ #else  typedef unsigned short	U_short;  #endif   #ifdef unix  #define	readonly #endif  5 typedef short		flag;		/* Boolean flag or parameter	*/    /*1  * The following define the "magic cookie" header   */  #define	HEAD1_MAGIC	0x1F #define HEAD2_MAGIC	0x9D= #define	VMS_HEAD2_MAGIC	0x9E		/* vms-private output format	*/    /*#  * Defines for third byte of header   */ 3 #define BIT_MASK	0x1F		/* Gets NBITS in the code	*/ 7 #define BLOCK_MASK	0x80		/* Gets block_compress flag	*/ : #define	DIFF_MASK	0x40		/* Gets differential cmprs flag	*/ /*<  * Mask0x20 is free.  I think 0x20 should mean that there is(  * a fourth header byte (for expansion).  */    /*K  * This is for backwards compatibilty with an old version of Unix compress.   */ 0 #ifdef COMPATIBLE			/* Compatible, but wrong!	*/, # define MAXCODE(n_bits)	(1 << (n_bits) - 1) #else . # define MAXCODE(n_bits)	((1 << (n_bits)) - 1) #endif  7 #define INIT_BITS 9			/* initial number of bits/code */    /*A  * One code could conceivably represent (1<<BITS) characters, but A  * to get a code of length N requires an input string of at least @  * N*(N-1)/2 characters.  With 5000 chars in the stack, an inputB  * file would have to contain a 25Mb string of a single character.  * This seems unlikely.   */ ; #define MAXSTACK    8000		/* size of lzdcmp output stack	*/    #ifndef CHECK_GAP 6 # define CHECK_GAP 	10000		/* ratio check interval		*/ #endif   #ifndef __LINE__ # define NO__LINE__  #endif #ifndef __FILE__ # define NO__LINE__  #endif	 #if DEBUG  # define VERBOSE_DEFAULT    1  # ifndef NO__LINE__   #  define FAIL(why, status)				\. 	fprintf(stderr, "\nfatal: %s (%s at %d)\n",	\# 	    why, __FILE__, __LINE__); 			\  	longjmp(failure, status); # else  #  define FAIL(why, status)				\+ 	fprintf(stderr, "\nfatal: %s\n", why); 		\  	longjmp(failure, status); # endif  #else  # define VERBOSE_DEFAULT    0 4 # define FAIL(why, status)	longjmp(failure, status); #endif   /*0  * Note -- for compatibility with Unix compress,(  * NBR_CHAR and LZ_CLEAR must equal 256.<  * Also, (1 << (MIN_BITS - 1) should equal or exceed NBR_CHR  */ 6 #define	NBR_CHAR      256		/* Number of input codes	*/1 #define MIN_BITS	9		/* Smallest code is 9 bits	*/ 1 #if ((1 << BITS) < NBR_CHAR) || (BITS < MIN_BITS) I     << Can't compile: not enough bits for the input character set size >>  #endif. #define	LZ_CLEAR	(NBR_CHAR)	/* Clear code			*/: #define	LZ_SOH		(LZ_CLEAR + 1)	/* Start of header block	*/9 #define	LZ_STX		(LZ_SOH   + 1)	/* Start of text block		*/ 8 #define	LZ_EOR		(LZ_STX   + 1)	/* End of text record		*/= #define	LZ_ETX		(LZ_EOR   + 1)	/* End of header/text block	*/ < #define	LZ_FIRST	(LZ_ETX   + 1)	/* First user (data) code	*/  
 #ifdef	vms #include		errno  #include		ssdef  #include		stsdef
 #include		rms  #include		descrip  #ifndef	EXIT_SUCCESS3 #define	EXIT_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)   #define	EXIT_FAILURE	(SS$_ABORT) #endif7 #define VMS_V4		L_cuserid >= 16		/* Enable new stuff	*/  #else + #define VMS_V4		0			/* Disable new stuff	*/  extern int		errno; #ifdef decus #define	errno		$$ferr  #endif #endif   /*  * Define exit() codes.   */    #ifndef	EXIT_SUCCESS #ifdef decus #define	EXIT_SUCCESS	IO_SUCCESS  #define	EXIT_FAILURE	IO_ERROR  #else + #define	EXIT_SUCCESS	0			/* Normal exit		*/ * #define	EXIT_FAILURE	1			/* Error exit		*/ #endif #endif #if EXIT_FAILURE == 0 @   << error, EXIT_FAILURE must be non-zero for longjmp to work >> #endif
 #ifdef vms #define	ERROR_EXIT	(errno) #else  #define	ERROR_EXIT	EXIT_FAILURE  #endif   /*A  * Parameter values are converted to internal values (to simplify   * processing of VMS DCL)   */  #define EXPORT_VMS		0x0001 #define EXPORT_UNIX		0x0002  #define EXPORT_BLOCK		0x0004 #define	EXPORT_HEADER		0x0008  #define EXPORT_ENDMARKER	0x0010    #define	METHOD_LZ		0x0001    #define MODE_TEXT		0x0001  #define	MODE_BINARY		0x0002  #define	MODE_FIXED		0x0004 #define	MODE_DELTA		0x0008   #define	SHOW_STATISTICS		0x0001  #define	SHOW_PROGRESS		0x0002  #define	SHOW_FDL		0x0004 #define	SHOW_DEBUG		0x0008! #define SHOW_SERIOUS_DEBUG	0x0010  #define SHOW_IO_DEBUG		0x0020      /*?  * All I/O is done by way of "streams".  To establish a stream, B  * set the parameters appropriately and off you go.  The following  * functions are provided:/  *	lz_fill(stream)		fills the buffer from stdin /  *	lz_flush(stream)	writes the buffer to stdout 5  *	lz_eof(stream)		returns EOF (for fill from memory) 2  *	lz_fail(stream)		abort (for writing to memory).0  *	lz_dummy(stream)	throw an output stream away.A  * Note: if VMS_V4 is enabled and the private (non-export) format ?  * chosen, lz_fill and lz_flush access the files appropriately. .  * Stream elements are initialized as follows:!  *	Input:	bp = NULL;	bend = NULL; .  *	Output:	bp = bstart;	bend = bstart + bsize;  */    typedef struct STREAM { 4     char_type	*bp;		/* Next character to get/put		*/4     char_type	*bend;		/* -> end of stream buffer		*/4     char_type	*bstart;	/* Start of stream buffer		*/,     short	bsize;		/* Stream buffer size			*/7     int		(*func)();	/* Read/write a buffer function		*/ 	 } STREAM;    /*I  * Note also that the compress routine uses putbuf(buf, count, outstream) L  * and the decompress routine uses getbuf(buf, count, instream) to (quickly)  * transfer multiple bytes.   */ 	 #if UCHAR  #define	GET(s)		\ > 	(((s)->bp < (s)->bend) ? *(s)->bp++        : (*(s)->func)(s)) #else  #define	GET(s)		\ > 	(((s)->bp < (s)->bend) ? *(s)->bp++ & 0xFF : (*(s)->func)(s)) #endif #define	PUT(c, s)	\ C 	((((s)->bp >= (s)->bend) ? (*(s)->func)(s) : 0), *(s)->bp++ = (c))    extern int lz_fill();  extern int lz_flush(); extern int lz_eof(); extern int lz_fail();  extern int lz_dummy();  	 #if DEBUG 8 extern readonly char *lz_names[];		/* "LZ_CLEAR" etc.	*/ #endif   /*  * Options and globals.   */ 
 #if VMS_V4 #include devdef   " #define	ATT_NAME	"vms$attributes ", #define	ATT_SIZE	15			/* strlen(ATT_NAME)	*/   typedef struct FDLSTUFF { - 	struct	RAB	rab;		/* Record access buffer		*/ + 	struct	FAB	fab;		/* File access buffer		*/ ) 	struct	NAM	nam;		/* File name buffer		*/ : 	struct	XABFHC	xabfhc;		/* Attributes (file header blk)	*/7 	struct	XABSUM	xabsum;		/* Attributes (isam summary)	*/ 7 	char		starname[NAM$C_MAXRSS + 1]; /* Wild file name	*/ 7 	char		filename[NAM$C_MAXRSS + 1]; /* Open file name	*/  } FDLSTUFF;   9 extern int	fdl_status;	/* Error code from fdl library		*/  #endif  . extern flag	export;		/* -x, /EXPORT=(...)			*/* extern flag	method;		/* LZ, of course			*/8 extern flag	show;		/* -v  /SHOW=(...) Verbose logging	*/- extern flag	mode;		/* Binary and friends			*/ + extern short	maxbits;	/* -b /BITS=<n>				*/ J extern readonly flag is_compress; /* TRUE if compress, FALSE if decomp.	*/4 extern char	*infilename;	/* For error printouts			*/9 extern char	*outfilename;	/* For more error printouts		*/ @ extern short	n_bits;		/* Current # of bits in compressed file	*/5 extern int	firstcode;	/* First value past signals		*/ 4 extern jmp_buf	failure;	/* For longjmp() return			*/  