 /*(  *		lzdcmp [-options] [infile [outfile]]  */  #ifdef	DOCUMENTATION   title	lzdcmp	File Decompression  index		File decompression    synopsis 	.s.nf% 	lzdcmp [-options] [infile [outfile]]  	.s.f  description   5 	lzdcmp decompresses files compressed by lzcomp.  The 2 	documentation for lzcomp describes the process in 	greater detail.  % 	Options may be given in either case.  	.lm +8  	.p -80 	-B	Output file is "binary", not text.  (Ignored7 	in VMS private mode.)  On VMS, this generates a stream 6 	file without carriage-control attributes.  On Decus C7 	systems, it generates a "fixed block, 512 byte record"  	file.  It is unneeded on Unix.  	.p -85 	-F	Output file is "fixed block, 512 bytes."  This is < 	used only by VMS for reading files created by Unix compress< 	or by "export" mode.  It is identical to binary on Decus C. 	.p -85 	-X 3	To read files compressed by an old Unix version & 	that doesn't generate header records. 	.p -84 	-V val	Verbose (print status messages and debugging: 	information).  The value selects the amount of verbosity.* 	See the lzcomp documentation for details.   VMS Command Language Interface  3 	In addition to the above (Unix-style) command line 9 	interface, lzcomp supports a VMS command line interface. % 	The following options are available:  	.lm +8  	.p -8 	/EXPORT=(VMS, UNIX, HEADER) 	.p -8 	/MODE=(TEXT, BINARY, FIXED) 	.p -8' 	/SHOW=(ALL, PROGRESS, STATISTICS, FDL, ! 		DEBUG, DEBUG_SERIOUS, DEBUG_IO)  	.lm -8    VMS private mode  @ 	If the file was compressed in VMS private mode, all information; 	needed to reconstruct the file is stored in the compressed ? 	file, using the VMS run-time library FDL routines.  This means = 	that the expanded file will have the same name and directory = 	location it had originally.  If the directory structure does > 	not exist (for example, because you have moved the compressed? 	file to another machine), you must specify the second argument $ 	to lzdcmp to specify the file name.   Author  3 	This version by Martin Minow.  See lzcomp for more 	 	details.    #endif   /*,  * Compatible with compress.c, v3.0 84/11/27  */    /*)BUILD 		$(PROGRAM) = lzdcmp  		$(INCLUDE) = lz.h  		$(CPP) = 1 		$(RMS) = 1: 		$(FILES) = { lzdcm1.c lzdcm2.c lzdcm3.c lzio.c lzvio.c } */   #include	"lz.h"    /*=  * These global parameters are read from the compressed file.   * The decompressor needs them.   */ 6 short		maxbits = BITS;		/* settable max # bits/code	*/  code_int	maxmaxcode = 1 << BITS;   /*B  * Note, if export is zero or 1, the "true" value will be set from8  * the file header.  If it is 2, no header will be read.  */ 
 #if VMS_V43 flag		export = EXPORT_VMS	/* Assume VMS private		*/  			| EXPORT_HEADER 			| EXPORT_BLOCK  			| EXPORT_ENDMARKER; #else 6 flag		export = EXPORT_UNIX	/* Assume standard Unix		*/ 			| EXPORT_HEADER 			| EXPORT_BLOCK  			| EXPORT_ENDMARKER; #endif+ flag		method = METHOD_LZ;	/* Of course			*/  flag		mode = MODE_TEXT; % flag		show = 0;		/* No statistics		*/ 7 flag		background = FALSE;	/* TRUE (Unix) if detached	*/ 7 flag		is_compress = FALSE;	/* For lzio.c and lzdcl.c	*/ 4 char		*infilename = NULL;	/* For error printouts		*/: char		*outfilename = NULL;	/* For openoutput and errors	*/1 int		firstcode;		/* First code after internals	*/ 8 static long	start_time;		/* Time we started (in msec)	*/: extern long	cputime();		/* Returns process time in msec	*/ jmp_buf		failure;  STREAM		instream;  STREAM		outstream; char_type	inbuffer[MAXIO]; char_type	outbuffer[MAXIO]; 
 #if VMS_V4 FDLSTUFF	*fdl_input; FDLSTUFF	*fdl_output; , static struct dsc$descriptor fdl_descriptor; int		xab_lrl = 0;  static STREAM	mem_stream;     typedef struct more_attributes {     char	*name;      int		type;8     char	*result;	/* Actually a union (int *, char *)	*/ } MORE_ATTRIBUTES;   #define	STRING	0 #define INTEGER	1    /*A  * Additional attributes (put into the compressed file by lzcomp) -  * are extracted using this extensible table.   */   , static MORE_ATTRIBUTES more_attributes[] = {*     { "xabfhc$w_lrl", INTEGER, &xab_lrl },     NULL };   #endif   main(argc, argv)
 int		argc; char		*argv[]; /*  * Decompress mainline  */  { 
 	int		result; 
 	int		status;  	extern code_int	getcode();   
 #ifndef	decus  	/* E 	 * background is TRUE if running detached from the command terminal.  	 */B 	background = (signal(SIGINT, SIG_IGN) == SIG_IGN) ? TRUE : FALSE; 	if (!background) * 	    background = !isatty(fileno(stderr)); 	if (!background) { I 	    if ((show & (SHOW_DEBUG | SHOW_SERIOUS_DEBUG | SHOW_IO_DEBUG)) != 0)  		signal(SIGINT, abort); 	    else {  		signal(SIGINT, interrupt);! 		signal(SIGSEGV, address_error);  	    } 	} #endif' 	if ((status = setjmp(failure)) == 0) {  	    setup(argc, argv); 	 #if DEBUG  	    if (show & SHOW_DEBUG)  		dumpoptions(); #endif	 	    do {  	        openinput(); : 	    } while (get_magic_header());	/* Sets export, etc.	*/ 	    openoutput();' 	    if ((show & SHOW_STATISTICS) != 0)  		start_time = cputime();  	    init_decompress(); % 	    result = decompress(&outstream); ) 	    if ((export & EXPORT_ENDMARKER) != 0  	     && result != LZ_ETX * 	     && getcode() != (code_int) LZ_ETX) {; 		fprintf(stderr, "Decompress didn't finish correctly.\n");  		goto fail; 	    } 	    lz_flush(&outstream);
 #if VMS_V4$ 	    if ((export & EXPORT_VMS) != 0) 		fdl_close(fdl_output); 	    else {  		fclose(stdout);  	    } #else  	    fclose(stdout); #endif	 #if DEBUG * 	    if ((show & SHOW_SERIOUS_DEBUG) != 0) 		dump_tab(stderr);  #endif) 	    if ((show & SHOW_STATISTICS) != 0) { & 		start_time = cputime() - start_time; 		fprintf(stderr, > 		    "%ld.%02ld seconds (process time) for decompression.\n",6 		    start_time / 1000L, (start_time % 1000L) / 10L); 	    } 	    exit(EXIT_SUCCESS); 	} 	else { H fail:	    fprintf(stderr, "Error when decompressing \"%s\" to \"%s\"\n", 		(infilename  == NULL) ? * 		    "<input file unknown>" : infilename, 		(outfilename == NULL) ? ( 		    "<no output file>" : outfilename); 	    exit(status); 	} }   
 static int get_magic_header() /*<  * Read the compressed file header.  Note: if we switch from;  * Unix to VMS (or vice-versa), we must re-open the file in   * the new mode.  */  {  	int		head1; 	int		head2; 	int		head3;
 #if VMS_V47 	int		old_export = export & (EXPORT_VMS | EXPORT_UNIX);  #endif   	head2 = 0; % 	if ((export & EXPORT_HEADER) != 0) { 3 	    if ((head1 = GET(&instream)) != HEAD1_MAGIC) { 7 		fprintf(stderr, "Incorrect first header byte 0x%x\n", 
 		    head1); ) 		FAIL("can't get header", EXIT_FAILURE);  	    } 	    head2 = GET(&instream); 	    head3 = GET(&instream); 	    switch (head2) {  	    case HEAD2_MAGIC:) 		export &= ~(EXPORT_VMS | EXPORT_BLOCK);  		export |= EXPORT_UNIX; 		mode &= ~MODE_DELTA; 		break;   	    case VMS_HEAD2_MAGIC:* 		export &= ~(EXPORT_UNIX | EXPORT_BLOCK); 		export |= EXPORT_VMS;  		mode &= ~MODE_DELTA; 		break;  
 	    default: 8 		fprintf(stderr, "Incorrect second header byte 0x%x\n",
 		    head2); ) 		FAIL("can't get header", EXIT_FAILURE);  	    }
 #if VMS_V4 	    /* A 	     * If export status changes, we must re-open the input file.  	     */= 	    if ((export & (EXPORT_VMS | EXPORT_UNIX)) != old_export)  		return (TRUE); #endif  	    maxbits = head3 & BIT_MASK;# 	    if ((head3 & BLOCK_MASK) != 0)  		export |= EXPORT_BLOCK; " 	    if ((head3 & DIFF_MASK) != 0) 		mode |= MODE_DELTA; 	 #if DEBUG $ 	    if ((show & SHOW_DEBUG) != 0) {1 		fprintf(stderr, "%s: compressed with %d bits,",  		   infilename, maxbits);- 		fprintf(stderr, " block compression %s.\n", 8 		    (export & EXPORT_BLOCK) ? "enabled" : "disabled");4 		fprintf(stderr, " differential compression %s.\n",4 		    (mode & MODE_DELTA) ? "enabled" : "disabled"); 	    } #endif 	} 	if (maxbits > BITS) {4 	    fprintf(stderr, "%s: compressed with %d bits,", 		infilename, maxbits); @ 	    fprintf(stderr, " lzdcmp can only handle %d bits\n", BITS);) 	    FAIL("too many bits", EXIT_FAILURE);  	} 	maxmaxcode = 1 << maxbits;   	if ((export & EXPORT_VMS) != 0)C 	    firstcode = GET(&instream) + 0x100;	/* From compressed file	*/ ' 	else if ((export & EXPORT_BLOCK) != 0) . 	    firstcode = LZ_CLEAR + 1;		/* Default		*/ 	else 2 	    firstcode = 256;			/* Backwards compatible	*/
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) { 	    register code_int	code; 	    char		text[256];  	    extern code_int	getcode();  	    auto int		termin; 	    /* ! 	     * Get the attribute record.  	     */( 	    if ((code = getcode()) != LZ_SOH) {8 		fprintf(stderr, "Expected header, read 0x%x\n", code);3 		FAIL("can't get header (private)", EXIT_FAILURE);  	    } 	    init_decompress(); 7 	    code = mem_decompress(text, sizeof text, &termin);  	    text[code] = EOS;2 	    if (strncmp(text, ATT_NAME, ATT_SIZE) != 0) {5 		fprintf(stderr, "Expected \"%s\", read \"%.*s\"\n",  		    ATT_NAME, code, text);9 		FAIL("can't get attribute block header", EXIT_FAILURE);  	    }" 	    code = atoi(text + ATT_SIZE);0 	    fdl_descriptor.dsc$b_class = DSC$K_CLASS_S;0 	    fdl_descriptor.dsc$b_dtype = DSC$K_DTYPE_T; 	    /* 1 	     * Note: malloc should probably be lib$getvm  	     */1 	    fdl_descriptor.dsc$a_pointer = malloc(code); ( 	    fdl_descriptor.dsc$w_length = code;H 	    code = mem_decompress(fdl_descriptor.dsc$a_pointer, code, &termin);/ 	    if (code != fdl_descriptor.dsc$w_length) { ; 		fprintf(stderr, "\nError reading fdl attributes block,"); 8 		fprintf(stderr, " expected %d bytes, read %d bytes\n",) 		    fdl_descriptor.dsc$w_length, code); 7 		FAIL("can't get attribute block data", EXIT_FAILURE);  	    }" 	    if ((show & SHOW_FDL) != 0) {9 		fprintf(stderr, "\nFDL information read from \"%s\"\n",  		    infilename);$ 		fdl_dump(&fdl_descriptor, stderr); 	    } 	    while (termin == LZ_EOR) {  		MORE_ATTRIBUTES		*p; 		int			len;  8 		code = mem_decompress(text, sizeof text - 1, &termin); 		text[code] = EOS;  		if ((show & SHOW_FDL) != 0) ; 		    fprintf(stderr, "Additional header: \"%s\"\n", text); # 		for (p = more_attributes;; p++) {  		    if (p->name == NULL) { 		        fprintf(stderr, 7 			    "\nIgnoring unknown descriptor \"%s\"\n", text); 	 			break;  		    }  		    len = strlen(p->name);- 		    if (strncmp(p->name, text, len) == 0) {  			switch (p->type) {  			case INTEGER:. 			    *((int *)p->result) = atoi(&text[len]);
 			    break;    			case STRING: % 			    strcpy(p->result, &text[len]); 
 			    break;  			}	 			break;  		    }  		}  	    }( 	    if ((code = getcode()) != LZ_STX) {A 		fprintf(stderr, "\nExpecting start of text, got 0x%x\n", code); ) 		FAIL("no start of text", EXIT_FAILURE);  	    } 	} #else   	if ((export & EXPORT_VMS) != 0): 	    FAIL("VMS private mode not supported", EXIT_FAILURE); #endif 	return (FALSE); }   
 #if VMS_V4 int $ mem_decompress(buffer, size, termin) char_type	*buffer;
 int		size;
 int		*termin;  /*>  * Decompress up to size bytes to buffer.  Return actual size.  */  { , 	mem_stream.bp = mem_stream.bstart = buffer;! 	mem_stream.bend = buffer + size;  	mem_stream.bsize = size;  	mem_stream.func = lz_fail; 2 	if ((*termin = decompress(&mem_stream)) == LZ_EOR 	 || *termin == LZ_ETX) % 	    return (mem_stream.bp - buffer);  	else { 7 	    fprintf(stderr, "Decompress to memory failed.\n"); 6 	    FAIL("can't decompress to memory", EXIT_FAILURE); 	}$ 	return (-1);				/* Can't happen		*/ }  #endif  $ static readonly char *helptext[] = {$ 	"The following options are valid:",; 	"-B\tBinary file (important on VMS/RSX, ignored on Unix)", < 	"-F\tOutput fixed-block 512 byte records (VMS export only",G 	"-M val\tSet the maximum number of code bits (unless header present)", 7 	"-V val\tPrint status information or debugging data.", , 	"-X val\tSet export (compatibility) mode:", 	"-X 0\tVMS private mode",* 	"-X 1\tCompatibility with Unix compress",? 	"-X 2\tDo not read a header, disable \"block-compress\" mode", E 	"\t(If a header is present, lzdcmp will properly configure itself,", / 	"\toverriding the -X, -B and -M flag values.",  	NULL, };   static setup(argc, argv) 
 int		argc; char		*argv[]; /*:  * Get parameters and open files.  Exit fatally on errors.  */  {  	register char	*ap;  	register int	c; 	char		**hp; 	auto int	i; 	int		j; 	int		temp;   
 #ifdef	vms# 	argc = getredirection(argc, argv);  	/* 2 	 * Prescan to see whether we must do a DCL parse. 	 */( 	for (j = FALSE, i = 1; i < argc; i++) { 	    if (argv[i][0] == '-') {  		j = TRUE;  		break; 	    } 	} 	if (j == FALSE) {/ 	    if ((i = lzdcl(argc, argv)) != SS$_NORMAL) 
 		exit(i); 	    return; 	} #endif! 	for (i = j = 1; i < argc; i++) {  	    ap = argv[i];5 	    if (*ap++ != '-' || *ap == EOS)	/* Filename?		*/ + 		argv[j++] = argv[i];		/* Just copy it		*/  	    else {  		while ((c = *ap++) != EOS) { 		    if (islower(c))  			c = toupper(c); 		    switch (c) { 		    case 'B':  			mode |= MODE_BINARY; 	 			break;    		    case 'F':  			mode |= MODE_FIXED;	 			break;    		    case 'M': $ 			maxbits = getvalue(ap, &i, argv); 			if (maxbits < MIN_BITS) {- 			    fprintf(stderr, "Illegal -M value\n");  			    goto usage; 			}	 			break;    		    case 'V': ! 			show = getvalue(ap, &i, argv); 	 			break;    		    case 'X': - 			switch ((temp = getvalue(ap, &i, argv))) {  			case 0:	export = EXPORT_VMS 					| EXPORT_BLOCK  					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break; 			case 1:	export = EXPORT_UNIX  					| EXPORT_BLOCK  					| EXPORT_HEADER 					| EXPORT_ENDMARKER;
 				break;   			case 2: export = EXPORT_UNIX  					| EXPORT_BLOCK  					| EXPORT_HEADER; 
 				break; 			case 3:	export = EXPORT_UNIX  					| EXPORT_HEADER; 
 				break;  			case 4:	export = EXPORT_UNIX;
 				break; 			default: 7 			    fprintf(stderr, "Illegal -X value: %d\n", temp);  			    goto usage; 			}	 			break;    		    default:5 			fprintf(stderr, "Unknown option '%c' in \"%s\"\n",  				*ap, argv[i]);/ usage:			for (hp = helptext; *hp != NULL; hp++) $ 			    fprintf(stderr, "%s\n", *hp);( 			FAIL("unknown option", EXIT_FAILURE);" 		    }				/* Switch on options	*/  		}				/* Everything for -xxx	*/ 	    }					/* If -option		*/ 	}					/* For all argc's	*/ 5 	/*  infilename = NULL; */		/* Set "stdin"  signal	*/ 5 	/* outfilename = NULL; */		/* Set "stdout" signal	*/ * 	switch (j) {				/* Any file arguments?	*/# 	case 3:					/* both files given	*/ 8 	    if (!streq(argv[2], "-"))		/* But - means stdout	*/ 		outfilename = argv[2];# 	case 2:					/* Input file given	*/  	    if (!streq(argv[1], "-")) 		infilename = argv[1];  	    break;    	case 0:					/* None!		*/ $ 	case 1:					/* No file arguments	*/ 	    break;   	 	default: 2 	    fprintf(stderr, "Too many file arguments\n");* 	    FAIL("too many files", EXIT_FAILURE); 	} }   
 static int getvalue(ap, ip, argv) register char		*ap; 
 int			*ip; char			*argv[];  /*H  * Compile a "value".  We are currently scanning *ap, part of argv[*ip].  * The following are possible:7  *	-x123		return (123) and set *ap to EOS so the caller $  *	ap^		cycles to the next argument.  *6  *	-x 123		*ap == EOS and argv[*ip + 1][0] is a digit.3  *			return (123) and increment *i to skip over the   *			next argument.   *1  *	-xy or -x y	return(1), don't touch *ap or *ip.   *D  * Note that the default for "flag option without value" is 1.  This@  * can only cause a problem for the -M option where the value is@  * mandatory.  However, the result of 1 is illegal as it is less  * than INIT_BITS.  */  {  	register int	result;  	register int	i;  
 	i = *ip + 1;  	if (isdigit(*ap)) { 	    result = atoi(ap);  	    *ap = EOS;  	} 	else if (*ap == EOS 	      && argv[i] != NULL   	      && isdigit(argv[i][0])) { 	    result = atoi(argv[i]);
 	    *ip = i;  	} 	else {  	    result = 1; 	} 	return (result);  }    openinput()  {  #ifdef	decus 	if (infilename == NULL) { 	    infilename = malloc(257);! 	    fgetname(stdin, infilename); > 	    infilename = realloc(infilename, strlen(infilename) + 1); 	}0 	if (freopen(infilename, "rn", stdin) == NULL) { 	    perror(infilename);5 	    FAIL("can't open compressed input", ERROR_EXIT);  	} #else 
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) { 	    if (infilename == NULL) { 		infilename = malloc(256 + 1);] 		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);  	    }: 	    if ((fdl_input = fdl_open(infilename, NULL)) == NULL)@ 		FAIL("can't open compressed input (vms private)", fdl_status); 	} 	elsem #endif 	{ 	    if (infilename == NULL) {
 #ifdef vms 		infilename = malloc(256 + 1);n 		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);r #elseo 		infilename = "<stdin>";s #endif 	    } 	    else {r 		/*# 		 * "rb" means "read, binary mode"e 		 */g1 		if (freopen(infilename, "rb", stdin) == NULL) {  		    perror(infilename);.? 		    FAIL("can't open compressed input (export)", ERROR_EXIT);e 		}y 	    } 	} #endif$ 	instream.bp = instream.bend = NULL; 	instream.bstart = inbuffer;" 	instream.bsize = sizeof inbuffer; 	instream.func = lz_fill;d }  o openoutput() { 
 #ifdef vms
 #if VMS_V4" 	if ((export & EXPORT_VMS) != 0) {# 	    extern FDLSTUFF *fdl_create();i   	    fclose(stdout); 	    stdout = NULL;uD 	    fdl_output = fdl_create(&fdl_descriptor, outfilename, xab_lrl); 	    if (fdl_output == NULL) {0 		fprintf(stderr, "Can't create output file\n");8 		FAIL("can't create output (vms private)", fdl_status); 	    } 	    if (outfilename == NULL) {   		outfilename = malloc(256 + 1);' 		fdl_getname(fdl_output, outfilename);Y> 		outfilename = realloc(outfilename, strlen(outfilename) + 1); 	    } 	} 	else  #endif 	{ 	    /* * 	     * Not VMS Version 4, or export mode. 	     */ 	    if (outfilename == NULL) {   		outfilename = malloc(256 + 1);  		fgetname(stdout, outfilename);> 		outfilename = realloc(outfilename, strlen(outfilename) + 1);/ 		if ((mode & (MODE_BINARY | MODE_FIXED)) == 0)i 		    goto do_reopen;h 	    } 	    else {e" 		if ((mode & MODE_BINARY) != 0) {, 		    if (freopen(outfilename, "wb", stdout,' 			    "alq=256", "fop=tef") == NULL) {m 			perror(outfilename);g4 			FAIL("can't create output (binary)", ERROR_EXIT); 		    }  		}o& 		else if ((mode & MODE_FIXED) != 0) {, 		    if (freopen(outfilename, "wb", stdout, 			    "alq=256", "fop=tef",' 			    "rfm=fix", "bls=512") == NULL) {  			perror(outfilename);(3 			FAIL("can't create output (fixed)", ERROR_EXIT);2 		    }. 		}o 		else { 		    /*3 		     * Try to allocate the output file in chunks.e	 		     */t4 do_reopen:	    if (freopen(outfilename, "w", stdout, 			    "alq=256", "fop=tef",& 			    "rat=cr", "rfm=var") == NULL) { 			perror(outfilename);;2 			FAIL("can't create output (text)", ERROR_EXIT); 		    }l 		}e 	    } 	} #else  #ifdef decus 	if (outfilename == NULL) {.# 	    outfilename = malloc(256 + 1);P# 	    fgetname(stdout, outfilename);	A 	    outfilename = realloc(outfilename, strlen(outfilename) + 1);  	} 	if (freopen(outfilename, 9 		((mode & (MODE_BINARY | MODE_FIXED)) != 0) ?"wn" : "w",L 		stdout) == NULL) { 	    perror(outfilename);d& 	    FAIL("can't reopen", ERROR_EXIT); 	} #else_ 	if (outfilename == NULL)  	    outfilename = "<stdout>"; 	else {L5 	    if (freopen(outfilename, "w", stdout) == NULL) {  		perror(outfilename);# 		FAIL("can't create", ERROR_EXIT);L 	    } 	} #endif #endif- 	outstream.bp = outstream.bstart = outbuffer;a/ 	outstream.bend = outbuffer + sizeof outbuffer;r$ 	outstream.bsize = sizeof outbuffer; 	outstream.func = lz_flush;c }/