H /**************************** CUT HERE ****************************** */F /* Read a TAR format tape or file , move files into VMS directories */  /* Copyright 1986, Sid Penstone,( *  Department of Electrical Engineering, *  Queen's University,# *  Kingston, Ontario, Canada K7L3N6  * (613)-545-59251 * BITNET:          PENSTONE@QUCDNEE1  (Preferred)  *       or  PENSTONE@QUCDN *  * Version 2.2, Oct.21,1986F * mods: - corrected header size (thanks to Eric Gisin, U .of Waterloo)2 *       - No more of the dreaded QIO's ( "  "  " ), *       - tried to sort out link flag format( *       - uses a tape or a file as inputI *       - NOTE: default is NO conversion to vms standard text format (cr) 8 * 2.1   - trapped commas in file names, converted to '_'( * 2.2   - reported translations of names6 *       - continued after error in opening output file2 *       - exit correctly on cannot open input file */    I /* The input data is in record format, length 512, blocks of 10240 bytes;   */      #include stdio
 #include time  #include ssdef #include iodef #include descrip #include ctype   #define ERROR1 -1  #define BUFFSIZE 512 #define ISDIRE 1 #define ISFILE 0 #define NAMSIZE 100 0 #define SIZE 10240              /* Block size */5 #define DSIZE 512               /* Data block size */   * struct                  /* A Tar header */     {      char title[NAMSIZE];     char protection[8]; 9     char field1[8];             /* this is the user id */ ;     char field2[8];             /*  this is the group id */ 6     char count[12];             /*  was 11 in error */7     char time[12];              /* UNIX format date  */ ?     char chksum[8];             /* Header Checksum (ignored) */ 8     char linkcount;             /* hope this is right */@     char linkname[NAMSIZE]; /* Space for the name of the link */*     char dummy[255];    /* and the rest */
     } header;   9 static char buffer[DSIZE];      /* BUFFER for a record */    /* Function flags, options:*/ 0 int extract,            /* x option (default) */C     list,                       /* t option : list tape contents */ 6     verbose,            /* v option, report actions */	     wait;   ! /* Miscellaneous globals, etc. */   . char *tarfile = "tape", /* Input file name  */?     pathname[NAMSIZE],  /* File name as found on tape (UNIX) */ /     directory[NAMSIZE], /* Current directory */ ?     new_directory[NAMSIZE],     /* Directory of current file */ 7     top[NAMSIZE],               /* Top level or root */ 5     newfile[NAMSIZE],   /* VMS format of file name */ @     outfile[NAMSIZE],   /* Complete output file specification */%     temp[256],          /* Scratch */ A     creation[NAMSIZE],  /* Date as extracted from the TAR file */ -     *ctime(),           /* System function */ /     linkname[NAMSIZE];  /* Linked file name  */   A int bytecount,  mode, uic1, uic2, linktype;/* Data from header */ ? int tarfd;                      /* The input file descriptor */    main(argc,argv) 	 int argc; 
 char *argv[];  { & int isterm,status,file_type,j,c, flag; char *make_directory(), *cp;  ( /* Decode the options and parameters: */       if(argc ==1)	         { 5         extract = 1;            /* Default for now */          verbose = 1;;         wait = 0;               /* Don't wait for prompt */ 	         }      while(--argc > 0) 	         {          cp = argv[1];          while(c = *cp++)
             {              switch(c) 
             {              case 't':                  list=1;                  break;             case 'x':                  extract=1;                 break;             case 'v':                  verbose=1;                 break;             case 'w':                  wait=1;                  break;             default::                 printf("Option '%c' not recognized.\n",c);
             }         }    }      /* Find if this is a terminal */     isterm = isatty(0);    /* Set up directory names */     strcpy(top,getenv("PATH"));   ' /* Start with the default as the top */      strcpy(directory,top);   /* open the file for reading */       if((tarfd = opentar()) <= 0)	         { /         printf("Error opening the Tar tape\n");          exit(2);	         } I /* Now keep reading headers from this file, and decode the names, etc. */   F     while((status=hdr_read(&header))==DSIZE)    /* 0 on end of file */	         { :         if(strlen(header.title)!=0)     /* Valid header */
             {              decode_header();             if(extract)                  { E                 file_type=scan_title(pathname,new_directory,newfile); /                 if( make_new(new_directory)!=0) @                     printf("Error creating %s\n",new_directory);'                 if(file_type == ISDIRE)                      {}'                 if(file_type == ISFILE) - /*  Now move the data into the output file */ #                     if(bytecount>0)                          { 6                         strcpy(outfile,new_directory);0                         strcat(outfile,newfile);=                         if((j=copyfile(outfile,bytecount))<0) F                             printf("Error writing file %s\n",outfile);                         }                  } :             else                        /* listing only */                 { (                 printf("%o %6d %s %s\n",8                     mode,bytecount,creation+4,pathname);!                 if(linktype == 0) '                     tarskip(bytecount);                  elseI                     printf("     *****( Linked to file: %s)\n",linkname);                  } 
             } C         else                    /* Empty header means the end!!! */ 
             {              status = 1; /             printf("End of Tar file found.\n");              break;
             }             }       /* end while  */:     if(status == 1)                     /* Empty header */	         { @         printf("Do you wish to move past the EOF mark ? y/n\n");         gets(temp); #         if(tolower(temp[0]) == 'y') 1             while((status=hdr_read(&header)) >0);          else             exit(SS$_NORMAL); 	         } >     if(status==0)                       /* End of tar file  */	         { ,         printf("End of file encountered\n");         exit(SS$_NORMAL); 	         } 7     if(status<0)                        /* An error  */ 	         { )         printf("Error reading input.\n");          exit(2);	         }  }     G /* This function simply copies the file to the output, no conversion */    int copyfile(outfile,nbytes), char outfile[]; /* name of output version */ int nbytes;    {  int inbytes, fil;  /*  Open the output file */ (     if((fil=creat(outfile,0)) == ERROR1)	         { ;         printf(" Creation error in opening %s \n",outfile);          tarskip(bytecount);          return(-2); 	         }      if(linktype !=0)	         { ?         sprintf(buffer,"This file is linked to %s\n",linkname); '         write(fil,buffer,strlen(temp)); 	         }      else	         {          while(nbytes>0) 
             { 6             if((inbytes=read(tarfd,buffer,DSIZE)) > 0)                 { A                 write(fil,buffer,(nbytes > DSIZE)? DSIZE:nbytes); "                 nbytes -= inbytes;                 }              else                 { 7                 printf("End of input file detected\n");                  close(fil);                  return(-1);                  } 
             } 	         }  /* Close the file */     close(fil);      if(verbose) 	         { (         printf("CREATED: %s\n",outfile);         if(linktype!=0) :             printf(" *** REAL DATA IS IN: %s\n",linkname);	         }      return(0); }   > /* Decode a file name into the directory, and the name, returnB * a value to indicate if this is a directory name, or another file= * We return the extracted directory string in "dire", and the A * filename (if it exists) in "fname". The full title is in "line"  * at input.  */   int scan_title(line,dire,fname)  char line[],dire[],fname[];  {  char temp[NAMSIZE],*end1;  int len,len2,i,ind; ? /* The format will be UNIX at input, so we have to scan for the* * UNIX directory separator '/'A * If the name ends with '/' then it is actually a directory name.eF * If the directory consists only of '.', then don't add a subdirectoryI * The output directory will be a complete file spec, based on the default6 * directory. */F     strcpy(dire,top);                   /* Start with the top level */     if(strncmp(line,"./",2)==0)69         strcpy(line,line+2);            /* ignore "./" */.C     strcpy(temp,line);                  /* Start in local buffer */ K     ind=vms_cleanup(temp);              /* Remove illegal vms characters */iD     if((end1=strrchr(temp,'/'))==0)     /* No directory at all  ? */>         strcpy(fname,temp);             /* Only a file name */     elseJ         {                               /* End of directory name is '/' */F         *end1 = 0;                      /* Terminate directory name */I         strcpy(fname,end1+1);           /* File name without directory */tL         for (i=0;temp[i];i++)           /* Change '/' to '.' in directory */             if(temp[i]=='/')                 temp[i]='.';5         dire[strlen(dire)-1] = (temp[0]=='.')?0:'.' ; L                  /* "." to indicate a subdirectory (unless already there )*/?         strcat(dire,temp);      /* Add on the new directory  */ @         strcat(dire,"]") ;              /* And close with ']' */	         }eA     if(strlen(fname)==0)        /* Could this cause problems ? */*	         {r         return(ISDIRE);*	         }h     elseA         for(i=0,end1=fname;*end1;end1++) /* Replace multiple . */h             if(*end1 == '.')9                 if(i++)*end1 = '_'; /* After the first */a@         if((i>1||ind)&& verbose )       /* Any translations ? */E             printf("****RENAMED: %s \n         TO: %s\n",line,fname);f     return(ISFILE);r }m  L /* Create a new directory, finding out any higher levels that are missing */  K /* We will parse the directory name into the next higher directory, and the % * desired directory as "desired.dir".iH * Thus: "DEV:[top.sub1.sub2]" is made into "DEV:[top.sub1]sub2.dir" . IfJ * the directory does not exist , then create the original directory. ThereH * may be higher levels missing, so we can recurse until we reach the topG * level directory, then work our way back, creating directories at eachr * successive level.t */   int make_new(want) char want[]; { 
 int i,len;3 char a[NAMSIZE],parent[NAMSIZE],*end,name[NAMSIZE];      strcpy(parent,want);     len = strlen(parent); 8     parent[len-1] =0 ;          /* Get rid of the "]" */7     end = strrchr(parent,'.');  /* Find the last '.' */      if(end != NULL) 	         {n9         strcpy(a,end+1);        /* Get the last parent */ 7         strcat(a,".dir");       /* Add the extension */NA         *end++ = ']' ;          /* Reduce the directory parent */i=         *end = 0;               /* Terminate the directory */          strcpy(name,parent);         strcat(name,a);v /*      } */  @     if(access(name,0) <0)       /* Does the directory exist ? */	         {oB             if(strcmp(parent,top)!=0) /* No, are we at the top? */<                 if(make_new(parent))   /*  No, look again */-                     return(-1); /* recurse */t4             if(mkdir(want,0755,0,0,0)) /* make it */<                 return(-1);             /* Leave on error */             else                 if(verbose) 1                     printf("CREATED: %s\n",want);              return(0);	         } 	         }      return(0); }   @  /* Function to open and get data from the blocked input file */
 int opentar()a {' int fd; 3     fd = open(tarfile, 0, "rfm = fix","mrs = 512");      if(fd < 0)	         { +         printf("Can't open input file \n");          return(0);	         }      return(fd);c }o  F /* Get the next file header from the input file buffer. We will always% * move to the next 512 byte boundary.) */ int hdr_read(buffer)
 char *buffer;t {y	 int stat;(=     stat = read(tarfd,buffer,DSIZE);    /* read the header */cL     return(stat);                               /* Catch them next read ? */ })    G /* This is supposed to skip over data to get to the desired position */ G /* Position is the number of bytes to skip. We should never have to useo6 * this during data transfers; just during listings. */ int tarskip(bytes)
 int bytes; {l int i=0;     while(bytes > 0)	         {t-         if((i=read(tarfd,buffer,DSIZE)) == 0) 
             {e@             printf("End of file encountered while skipping.\n");             return(-1);n
             },         bytes -= i;)	         }      return(0); }w  % /* Decode the fields of the header */    int decode_header()% {" int idate, *bintim;  char ll; bintim = &idate;$     linktype=0; strcpy(linkname,"");"     strcpy(pathname,header.title);$     sscanf(header.time,"%o",bintim);;     strcpy(creation,ctime(bintim));     /* Work on this! */      creation[24]=0; )     sscanf(header.count,"%o",&bytecount);o)     sscanf(header.protection,"%o",&mode);e%     sscanf(header.field1,"%o",&uic1);(%     sscanf(header.field2,"%o",&uic2); B     /* We may have the link written as binary or as character:  */)     linktype = isdigit(header.linkcount)? 6             (header.linkcount - '0'):header.linkcount;     if(linktype != 0) .         sscanf(header.linkname,"%s",linkname);     return(0); }o    C /* remove illegal characters from directory and file names; replace D * hyphens and commas with underscores.Returns number of translations * that were made." */ vms_cleanup(string)e char string[]; { 
 int i,flag=0;  char c;      for(i=0;c=string[i];i++)	         {          switch (c)
             {*>             case '-':           /* No hyphens in file names */>             case ',':           /* No commas in file names  */ 	    case '+': 	    case '!': 	    case '@': 	    case '#': 	    case '%': 	    case '^': 	    case '<':< 	    case '>':		/* un*x can have lots of other weird ones */ 	    case '?': 	    case '=': 	    case '`': 	    case '~':                 string[i]= '_';dE                 flag++;         /* Record if any changes were made */                  break;             default:                 break;
             } 	         }n     return(flag);e }"