E /* Write a TAR format tape or file , from files in VMS directories */ 0 /* May compile as a version  with "./" prefix */ /* Copyright 1986,Sid Penstone, ( *  Department of Electrical Engineering, *  Queen's University,# *  Kingston, Ontario, Canada K7L3N6  * (613)-545-2925 * BITNET:   PENSTONE@QUCDNEE1  * Version 1.10, Feb.21,1987  *  * Modifications:8 *       - used the C call stat() to get file informationA *       - now propagates directory specs to subsequent file-specs 7 * 1.4   - starts pathnames at current default directory D * 1.5   - corrected error in scan_name for  directories outside treeD *       - did immediate close of file-descriptor version in out_file7 *         to get around overflow of file operations ??? I * 1.6   - added cleanup_dire() to correctly handle rooted directory specs ? * 1.6b  - corrected typing error in scan_name "-" should be "=" F *       - looked past nodename in getting rid of device in scan_name()G *       - reject access to other nodes by trapping "::" in initsearch() I * 1.7   - set resultant string size to 0 in search(), because of problems ! *         with rooted directories D * 1.8   - added "d" option, with default to suppress trailing "." in *         output file names 4 * 1.9   - don't output file with negative bytecounts- * 1.10  - simplified some code in scan_name() ; *       - report creation time instead of modification time K *       - added conditionals for prefix (for some strange UNIX systems e.g.  *               Metheus)D * 1.11  - Allowed write-out of files with record attributes of 0 butI *         not of fixed format. (Best attempt at random VMS record formats - *	  where sequential access can be done.) GCE  */              7 /* The input data is in VMS format,. The output will be A *  blocks of 10240 bytes, with 512 byte internal blocks of header < * and data. Unfilled 512 blocks will be packed with garbage.B * The output will be padded out to a full block of size BLKSIZE at * the end of the Tar file.  */                #include stdio
 #include time  #include ssdef #include descrip #include ctype #include rms #include stsdef 
 #include file 
 #include stat  #include types       -         /* Define this only if necessary:  */  /* #define useprefix  */ #define ISDIRE 1 #define ISFILE 0! #define FIXED           FAB$C_FIX  #define NAMSIZE 100 7 #define BLKSIZE 20480           /* Block size on tape*/ 0 #define DSIZE 512               /* data block */       : static struct tarhdr                    /* A Tar header */     {      char title[NAMSIZE];     char protection[8];      char uid[8];     char gid[8];     char count[12];      char time[12];     char chksum[8]; 2     char linkmode;      /* hope this is right!! */D     char linkname[NAMSIZE];     /* Space for the name of the link */*     char dummy[255];    /* and the rest */
     } header;        > struct tarhdr *empty;                   /* buffer of nulls  */H char *dbuffer;                          /* for buffering output data  */       P static int bufferpointer;               /* Position of next byte in the block */B static struct FAB fblock,fblock2;       /* File attribute block */J static struct NAM nblock,nblock2;       /* Name attribute block for rms */? struct stat *sblock;                    /*  for stat() call  */         /* Function flags, options:*/ ; int create,                     /* c operation (default) */ 1     list,                       /* t operation */ 6     verbose,            /* v option, report actions */	     wait, 4     dot;                /* Include trailing dots  */ #ifdef useprefix int prefix;  #endif       ! /* Miscellaneous globals, etc. */        & char temp[NAMSIZE];     /* scratch  */       4 char *strindex();       /* String search function */       1 char *tarfile = "tape" ,        /* Output file */ 4     operation = ' ',    /* Current operation c,t  */A     pathname[NAMSIZE],  /* File name as written on tape (UNIX) */ 8     directory[NAMSIZE], /* The current root directory */?     new_directory[NAMSIZE],     /* Directory of current file */ 5     newfile[NAMSIZE],   /* VMS format of file name */ :     outfile[NAMSIZE],   /* stripped format of file name */C     filetime[32],               /* Modification date as from vms */ 8     searchname[NAMSIZE];        /* for the NAM block  */       ! /* Global file characteristics */  FILE *vmsfile; int vmsfd, outfd, temfd;A unsigned vmsmrs, vmstime;               /* maximum record size */ : int vmsrat,vmsorg,vmsrfm; /* Other format (as integers) */              @ int bytecount,  mode, uid , gid , links;/* Data in the header */> default_name = "*.*";   /* Only get the most recent version */ int i;              A /* ******************** start here *************************** */  main(argc,argv) 	 int argc; 
 char *argv[];  {  int status,file_type,j,c,len; : char  *cp, *indx, names[NAMSIZE]= "", string[NAMSIZE]= "",         ans[10]; FILE *temfile;            initialize();        ( /* Decode the options and parameters: */     if(argc ==1)	         { 5         create = 1;             /* Default for now */          operation = 'c';         list = 0;          verbose = 1;;         wait = 0;               /* Don't wait for prompt */          dot = 0; #ifdef useprefix         prefix=0;  #endif	         }      if(--argc > 0)	         {          cp = argv[1];          while(c = *cp++)
             {              switch(c)                  { A                 case 'c':               /*  c and t exclusive  */                      create = 1; $                     operation = 'c';                     list = 0;                      break;                 case 't':                      create = 0;                      list = 1; $                     operation = 't';=                     verbose = 1;        /* t means report  */                      break;                 case 'v':                      verbose=1;                     break; #ifdef useprefix                 case 'p':                      prefix=1;                      break; #endif                 case 'w':                      wait=1;                      break;                 case 'd':                      dot=1;                     break;                 case '-':                      break;                 default:>                     printf("Option '%c' not recognized.\n",c);                 } 
             } 	         }                      A /* Use the parse operation to fill in missing specifications, and C * set up for repeated searching. The multiple file search described F * in the RMS manual does not seem to work, so we will have to sort out  * the items separated by commas.  */      if(--argc > 0)F         strcpy(names,argv[2]);          /* Assume file name is next */     else	         { !         strcpy(names,"[...]*.*"); @ /******** COMMENTED OUT.. otherwise asks the user for file names     printf(" File name(s)?");      gets(names); ************ */ 	         } 8     if(create)  /* Open the output and scratch files  */	         { 8         outfd = creat(tarfile,0600,"rfm=fix","mrs=512");         temfile = tmpfile();          temfd = fileno(temfile);#         if(outfd < 0 || temfd < 0 ) 
             {              printf( D             "Couldn't open output tar or scratch file. Bye,bye.\n");             exit(2);
             } 	         } G     /* Now we will extract search strings from the names string. Assume #     * they are separated by commas.      */@     while(strlen(names)!=0)     /* Get the file name argument */	         { "         if(indx=strchr(names,','))>                 *indx = 0;      /* Replace , by terminator  */E         if(strchr(names,']'))   /* Always include a directory spec */ ?             strcpy(string,names);       /* Get the new part  */ O         else                            /* If no directory, keep the old one */ )             if((cp = strchr(string,']'))) #                 strcpy(cp+1,names);              else%                 strcpy(string,names); #         if(initsearch(string) <= 0) K             printf("***** No files found while searching for:%s\n",string);a         else%         while(search(newfile,100)!=0)y
             {e<             chgcase(newfile);   /* all lower case, please */"             cleanup_dire(newfile);A             file_type = scan_name(newfile,new_directory,outfile); +             strcpy(pathname,new_directory);E%             strcat(pathname,outfile); $             get_attributes(newfile);             if(wait)                 { -                 strcpy(temp,ctime(&vmstime));t1                 if((cp=strchr(temp,'\n'))!= NULL) <                      *cp = 0;           /* Avoid newline  */1                 printf("%c: %-40s %-18s [y/n] ?", 1                        operation,newfile,temp+4);                   scanf("%s",ans);'                     if ( ans[0] != 'y')_!                         continue;i                 }.             if(create)                 {-'                 if(file_type == ISDIRE)o                     {f#                     bytecount =  0;e                      mode = 0755;*                     fill_header(pathname);(                     write_header(outfd);                     } '                 if(file_type == ISFILE)e                     {u                      mode = 0644;6                     if(addfile(newfile, pathname) < 0)A                         printf("ERROR: %s NOT COPIED\n",newfile);m                     }c                 }d             if(verbose || list)                  {f7                 if(bytecount >0 || file_type == ISDIRE) 1                     printf("%c: %-40s %6d  %26s",sE                        operation,pathname,bytecount,ctime(&vmstime));a                 else5                    printf("IGNORED:  %s\n",pathname);.                 } 
             }iF         if(indx)                        /* any more in the string ? */>             strcpy(names,indx+1);       /* Yes, work on it  */         else             break;	         }      if(create)	         {u         write_trailer(outfd);Z         close(outfd);T	         }*     exit(SS$_NORMAL);c }e       ( /* Copy the vms file to the output file. *r */      e int addfile(vmsname,unixname)s char vmsname[],unixname[]; {e int ind;A     if(bytecount <= 0)          /* We don't output null files  */          return(0);3     if((ind=out_file(vmsname,bytecount,outfd)) < 0)          return(ind);*     bufferpointer = bufferpointer%BLKSIZE;     return(1); }B      z      p /* Write out the file.- * move nbytes of data from "fdin" to "fdout";s' * Always pad the output to a full DSIZEh> * If it a vms text file, it may be various formats, so we will< * write into a temporary file first, then copy to the output( * so that we get the correct byte count./ * We set the bytecount=0 if this is funny file.  */# int out_file(filename,nbytes,fdout)a char filename[]; int fdout, nbytes; {d int i, n, pos, fdin;
 FILE *filein;      if(vmsrfm == FIXED)t	         {p'         if((fdin=open(filename,0)) <=0)                  { A                 printf("Error opening input file %s\n",filename);t                 return(-1);                  } L         fill_header(pathname);          /* We have all of the information */D         write_header(outfd);            /* So write to the output */         while(nbytes > 0)t
             {c>             n = read(fdin,dbuffer,nbytes>DSIZE? DSIZE:nbytes);             if(n<0)                  {                  close(fdin);5                 printf("Read error on input file\n");a                 return(-1);                  }p             nbytes -= n;'             write(fdout,dbuffer,DSIZE);lH             bufferpointer += DSIZE;             /* Count the position */
             }t         close(fdin);         return(0);	         }/F /*    else if(vmsrat != 0)  */              /* must be a text file  */3       else  /* allow general sequential file out */ J         {                               /* Write out to standard stream */2         if((filein = fopen(filename,"r")) == NULL)                 {T6                 printf("ERROR OPENING %s\n",filename);                 return(-1);                  }l         nbytes = 0;fD         lseek(temfd,0,0);               /* Back to the beginning  */9         while((i = fgets(dbuffer,DSIZE,filein)) !=  NULL)o
             {v              n = strlen(dbuffer);             nbytes += n;#             write(temfd,dbuffer,n);r
             }EE         fclose(filein);                 /* All done with the input */ D         lseek(temfd,0,0);               /* Back to the beginning  */A         bytecount = nbytes;             /* Use the real count  */ @         fill_header(pathname);          /* Compute the header */7         write_header(outfd);            /* Write it  */ D         while(nbytes > 0)               /* Now copy to the output */
             { ?             n = read(temfd,dbuffer,nbytes>DSIZE? DSIZE:nbytes);              nbytes -= n;'             write(fdout,dbuffer,DSIZE); H             bufferpointer += DSIZE;             /* Count the position */
             }a         return(0);	         } C                         /* Other formats e.g. .OBJ are not done  */          bytecount = 0;         return(0); }       b) /* Copy the header to the output file  */* int write_header(fd) int fd;  {  int n;*     if((n=write(fd,&header,DSIZE))!=DSIZE)	         { 9         printf("Error writing header in output file.\n");          exit(1);	         }      bufferpointer += DSIZE;h     return(n); }        * /*  get the file attributes via stat()  */      x int get_attributes(fname) 
 char fname[];1 {      if(stat(fname,sblock))     {;7         printf("Error getting file status:%s\n",fname);aG         vmstime = 0;                    /* Prevent garbage printoout */ D         bytecount = 0;                  /* of inaccessible files  */         return(-1);      } 8 /* now get the file attributes, we don't use them all */      bytecount = sblock->st_size;      vmsrat = sblock->st_fab_rat;      vmsmrs = sblock->st_fab_mrs;      vmsrfm = sblock->st_fab_rfm;7     vmstime = sblock->st_ctime;         /* was mtime */d }               D /* Write the two blank blocks on the output file, and pad the output# * to a full blocksize if needed. */  write_trailer(fdout)
 int fdout; {  int rem;     header = *empty;     write_header(fdout);     write_header(fdout);*     bufferpointer = bufferpointer%BLKSIZE;#     while (bufferpointer < BLKSIZE)          write_header(fdout);     return(1); }        C /* Decode a file name into the directory, and the name, and convert B * to a valid UNIX pathname. Return  a value to indicate if this is$ * a directory name, or another file.= * We return the extracted directory string in "dire", and themA * filename (if it exists) in "fname". The full title is in "line"  * at input.  */      s int scan_name(line,dire,fname) char line[],dire[],fname[];* {  char temp[NAMSIZE],*end1,*end2;w int len,len2,i; > /* The format will be VMS at input, so we have to scan for theA * VMS device separator ':', and also the VMS directory separatorsa *  '[' and ']'. F * If the name ends with '.dir;1' then it is actually a directory name.P * The outputs dire and  fname will be a complete file spec, based on the default * directory.I * It may be a rooted directory, in which case there will be a "][" stringt
 * remove it..tP * Strip out colons from the right, in case there is a node name (should not be!)M * If the filename ends in a trailing '.', suppress it , unless the "d" optione * is setG * If the prefix bit is set ("p" option), then put the prefix "./" aheade * of all pathnames on the tape */      t      mO     strcpy(temp,strrchr(line,':')+1);           /* Start with the whole name */ <     strcpy(dire, "");           /* And an empty directory */ #ifdef useprefix     if(prefix)         strcpy(dire,"./"); #endifH                     /* Get rid of default directory part of the name  */J     for(end1=temp,end2=strrchr(directory,':')+1;*end2 && (*end1 == *end2);          end1++,end2++);     if(*end2 == 0)G         *end1 = 0;              /* Perfect match, no directory spec  */      else	         {sG         if(*end2 != ']' || *end1 != '.') /* Is this a subdirectory?  */eE             end1 = strchr(temp,'['); /* no root, use the full name */ J         end1++;                         /* Get past the starting . or [ */	         }      strcat(dire,end1);6     if(strlen(dire) && (end2=strchr(dire,']'))!= NULL)E         strcpy(end2,"/");       /* get rid of the directory marks  */r@     strcpy(temp,strchr(line,']')+1); /* Now get the file name */J     if((end1=strindex(temp,".dir;1"))!=0)       /* Is this a directory? */	         {UF         strcpy(end1,"/");               /* Terminate directory name */D         strcat(dire,temp);              /* Add it to the pathname */:         strcpy(fname,"");               /* No file name */	         }      else	         {0         strcpy(fname,temp); H         strcpy(strchr(fname,';'),"");           /* no version numbers */	         } M     /* Now rewrite the directory name, starting after the first character  */      if(strlen(dire) != 0) 8         for (i=1;dire[i];i++)   /* Change '.' to '/'  */             if(dire[i]=='.')                 dire[i]='/';     if((len=strlen(fname))==0)	         {y         return(ISDIRE); 	         }u     else         if(fname[--len] == '.')             if (dot == 0)7                 fname[len] = 0; /* No trailing dots  */O         return(ISFILE);l }m       B /* To start looking for file names to satisfy the requested input,B * use the sys$parse routine to create a wild-card name block. WhenA * it returns, we can then use the resultant FAB and NAM blocks on @ * successive calls to sys$search() until there are no more files * that match */        int initsearch(string) char string[]; {p int status;        #     if(strindex(string,"::")!=NULL)i	         { @         printf("***** Access across nodes is not supported.\n");         return(-1); 	         }k     fblock = cc$rms_fab;     nblock = cc$rms_nam;$     fblock.fab$l_dna = default_name;,     fblock.fab$b_dns = strlen(default_name);     fblock.fab$l_fna = string;&     fblock.fab$b_fns = strlen(string);     fblock.fab$l_nam = &nblock; "     nblock.nam$l_esa = searchname;*     nblock.nam$b_ess = sizeof(searchname); #ifdef debug(     printf("searching on: %s\n",string); #endif      status = sys$parse(&fblock);     if(status != RMS$_NORMAL)t	         {          if(status == RMS$_DNF):             printf("Directory not found:%s\n",searchname);         else-             printf("Error in sys$parse()\n");"         return (-1);	         }tC     searchname[nblock.nam$b_esl] = 0;   /* Terminate the string  */sD     /* Now reset for searching, pointing to the parsed name block */     fblock = cc$rms_fab;     fblock.fab$l_nam = &nblock;eD     return(nblock.nam$b_esl); /* return the length of the string  */ }b      o@ /* Get the next file name that matches the namblock that was set" * up by the sys$search() function. */ int search(buff,maxlen)  char buff[]; int maxlen;< {  int status;             nblock.nam$l_rsa = buff;     nblock.nam$b_rss = maxlen;;     nblock.nam$b_rsl = 0;       /* For next time around  */ 6     while( (status = sys$search(&fblock)) != RMS$_NMF)     {t#         buff[nblock.nam$b_rsl] = 0; !         if(status == RMS$_NORMAL) 
             {l%             return(nblock.nam$b_rsl); 
             }i         else
             {:#             if( status == RMS$_PRV) ?                 printf("%s : No privilege for access.\n",buff);f(             else if (status == RMS$_FNF)6                 printf("%s : File not found.\n",buff);             else                 {b=                 printf(" Error in f$search for :%s\n", buff);                  return (0);                  } 
             }      }e     return (0);  } : /* Fill the fields of the header; enter with the file nameB * if the file name is empty, then this is a trailer, and we should * fill it with zeroes. */         int fill_header(name)a char name[]; { 
 int i,chksum;= char *ptr,tem[15];7     header = *empty;            /* Clear the header  */RB     if(strlen(name)!=0)         /* only fill if there is a file */	         { E         sprintf(header.title,"%s",name);        /* write file name */oF         sprintf(header.protection,"%6o ",mode); /* all written with */F         sprintf(header.uid,"%6o ",uid);         /* a trailing space */'         sprintf(header.gid,"%6o ",gid);eF         sprintf(tem,"%11o ",bytecount);         /* except the count */I         strncpy(header.count,tem,12);           /* and the time, which */tF         sprintf(tem,"%11o ",vmstime);           /* except the count */B         strncpy(header.time,tem,12);            /* have no null */G         strncpy(header.chksum,"        ",8);    /* all blanks for sum*/ < /* I know that the next two are already zero, but do them */A         header.linkmode = 0;                    /* always zero */?B         sprintf(header.linkname,"%s","");       /* always blank */A         for(chksum=0, ptr = &header;ptr < &header.linkmode;ptr++)*G                  chksum += *ptr;                /* make the checksum */ J         sprintf(header.chksum,"%6o",chksum);    /* This is how it looks */F         }                                       /* on UNIX tapes... */     return(0); }       t9 /* Initialize various fields, get some standard values */d      E initialize() {  int i;     dbuffer = malloc(DSIZE+1);)     sblock = malloc(sizeof(struct stat));      empty = malloc(DSIZE);     for (i=0;i < DSIZE;i++) J         empty->title[i] = 0;    /* all zeroes, even if malloc() did it  */     header = *empty;     bufferpointer = 0;9     gid = getgid();     /* for now, use the user's uic */e'     uid = getuid(); /* and group uic */ H     mode = 0644;                /* This get changed elsewhere, anyhow */?     strcpy(directory,getenv("PATH"));   /* Default directory */n     return;  }*      t      l< /* Search for string2 in string1; return address pointer. */ char *strindex(string1,string2)s char *string1,*string2;s {c char *c1, *c2, *cp;m$     for(c1 = string1; *c1 !=0; c1++)	         {>4         cp = c1;        /* save the start address */:         for(c2=string2; *c2 !=0 && *c1 == *c2; c1++,c2++);            if(*c2 == 0)l                 return(cp);_	         }u     return(NULL);  }        / /* function to change a string to lower case */  int chgcase(string)  char string[]; {  int i;2         for(i=0;string[i]=tolower(string[i]);i++);:         return (--i);           /* return string length */ }D       3 /* Routine to get rid of rooted directory problems,r * and any others that turn up  */      a int cleanup_dire(string) char string[]; {e char *ptr, temp[NAMSIZE];t/         if((ptr=strindex(string,"][")) == NULL)                  return(0);5                 /* Just collapse around the string */t         strcpy(ptr,ptr+2);         return(1); }r