D /********************************* CUT HERE ***********************/E /* Write a TAR format tape or file , from files in VMS directories */  /* Copyright 1986,Sid Penstone, ( *  Department of Electrical Engineering, *  Queen's University,# *  Kingston, Ontario, Canada K7L3N6  * (613)-545-2925 * BITNET:   PENSTONE@QUCDNEE1  * Version 1.8, Dec.23,1986 *  * Modifications:8 *       - used the C call stat() to get file informationA *       - now propagates directory specs to subsequent file-specs 7 * 1.4   - starts pathnames at current default directory D * 1.5   - corrected error in scan_name for  directories outside treeD *       - did immediate close of file-descriptor version in out_file7 *         to get around overflow of file operations ??? I * 1.6   - added cleanup_dire() to correctly handle rooted directory specs ? * 1.6b  - corrected typing error in scan_name "-" should be "=" F *       - looked past nodename in getting rid of device in scan_name()G *       - reject access to other nodes by trapping "::" in initsearch() I * 1.7   - set resultant string size to 0 in search(), because of problems ! *         with rooted directories D * 1.8   - added "d" option, with default to suppress trailing "." in *         output file names  */    7 /* The input data is in VMS format,. The output will be A *  blocks of 10240 bytes, with 512 byte internal blocks of header < * and data. Unfilled 512 blocks will be packed with garbage.B * The output will be padded out to a full block of size BLKSIZE at * the end of the Tar file.  */      #include stdio
 #include time  #include ssdef #include descrip #include ctype #include rms #include stsdef 
 #include file 
 #include stat  #include types     #define ISDIRE 1 #define ISFILE 0! #define FIXED           FAB$C_FIX  #define NAMSIZE 100 7 #define BLKSIZE 10240           /* Block size on tape*/ 0 #define DSIZE 512               /* data block */  : static struct tarhdr                    /* A Tar header */     {      char title[NAMSIZE];     char protection[8];      char uid[8];     char gid[8];     char count[12];      char time[12];     char chksum[8]; 2     char linkmode;      /* hope this is right!! */D     char linkname[NAMSIZE];     /* Space for the name of the link */*     char dummy[255];    /* and the rest */
     } header;   > struct tarhdr *empty;                   /* buffer of nulls  */H char *dbuffer;                          /* for buffering output data  */  P static int bufferpointer;               /* Position of next byte in the block */B static struct FAB fblock,fblock2;       /* File attribute block */J static struct NAM nblock,nblock2;       /* Name attribute block for rms */? struct stat *sblock;                    /*  for stat() call  */    /* Function flags, options:*/ ; int create,                     /* c operation (default) */ 1     list,                       /* t operation */ 6     verbose,            /* v option, report actions */	     wait, 4     dot;                /* Include trailing dots  */  ! /* Miscellaneous globals, etc. */   & char temp[NAMSIZE];     /* scratch  */  4 char *strindex();       /* String search function */  1 char *tarfile = "tape" ,        /* Output file */ 4     operation = ' ',    /* Current operation c,t  */A     pathname[NAMSIZE],  /* File name as written on tape (UNIX) */ 8     directory[NAMSIZE], /* The current root directory */?     new_directory[NAMSIZE],     /* Directory of current file */ 5     newfile[NAMSIZE],   /* VMS format of file name */ :     outfile[NAMSIZE],   /* stripped format of file name */C     filetime[32],               /* Modification date as from vms */ 8     searchname[NAMSIZE];        /* for the NAM block  */  ! /* Global file characteristics */  FILE *vmsfile; int vmsfd, outfd, temfd;A unsigned vmsmrs, vmstime;               /* maximum record size */ : int vmsrat,vmsorg,vmsrfm; /* Other format (as integers) */    @ int bytecount,  mode, uid , gid , links;/* Data in the header */> default_name = "*.*";   /* Only get the most recent version */ int i;    A /* ******************** start here *************************** */  main(argc,argv) 	 int argc; 
 char *argv[];  {  int status,file_type,j,c,len; : char  *cp, *indx, names[NAMSIZE]= "", string[NAMSIZE]= "",         ans[10]; FILE *temfile;       initialize();   ( /* Decode the options and parameters: */     if(argc ==1)	         { 5         create = 1;             /* Default for now */          operation = 'c';         list = 0;          verbose = 1;;         wait = 0;               /* Don't wait for prompt */          dot = 0;	         }      if(--argc > 0)	         {          cp = argv[1];          while(c = *cp++)
             {              switch(c)                  { A                 case 'c':               /*  c and t exclusive  */                      create = 1; $                     operation = 'c';                     list = 0;                      break;                 case 't':                      create = 0;                      list = 1; $                     operation = 't';=                     verbose = 1;        /* t means report  */                      break;                 case 'v':                      verbose=1;                     break;                 case 'w':                      wait=1;                      break;                 case 'd':                      dot=1;                     break;                 case '-':                      break;                 default:>                     printf("Option '%c' not recognized.\n",c);                 } 
             } 	         }       A /* Use the parse operation to fill in missing specifications, and C * set up for repeated searching. The multiple file search described F * in the RMS manual does not seem to work, so we will have to sort out  * the items separated by commas.  */      if(--argc > 0)F         strcpy(names,argv[2]);          /* Assume file name is next */     else	         { !         strcpy(names,"[...]*.*"); @ /******** COMMENTED OUT.. otherwise asks the user for file names     printf(" File name(s)?");      gets(names); ************ */ 	         } 8     if(create)  /* Open the output and scratch files  */	         { 8         outfd = creat(tarfile,0600,"rfm=fix","mrs=512");         temfile = tmpfile();          temfd = fileno(temfile);#         if(outfd < 0 || temfd < 0 ) 
             {              printf( D             "Couldn't open output tar or scratch file. Bye,bye.\n");             exit(2);
             } 	         } G     /* Now we will extract search strings from the names string. Assume #     * they are separated by commas.      */@     while(strlen(names)!=0)     /* Get the file name argument */	         { "         if(indx=strchr(names,','))>                 *indx = 0;      /* Replace , by terminator  */E         if(strchr(names,']'))   /* Always include a directory spec */ ?             strcpy(string,names);       /* Get the new part  */ O         else                            /* If no directory, keep the old one */ )             if((cp = strchr(string,']'))) #                 strcpy(cp+1,names);              else%                 strcpy(string,names); #         if(initsearch(string) <= 0) K             printf("***** No files found while searching for:%s\n",string);          else%         while(search(newfile,100)!=0) 
             { <             chgcase(newfile);   /* all lower case, please */"             cleanup_dire(newfile);A             file_type = scan_name(newfile,new_directory,outfile); +             strcpy(pathname,new_directory); %             strcat(pathname,outfile); $             get_attributes(newfile);             if(wait)                 { -                 strcpy(temp,ctime(&vmstime)); 1                 if((cp=strchr(temp,'\n'))!= NULL) <                      *cp = 0;           /* Avoid newline  */1                 printf("%c: %-40s %-18s [y/n] ?", 1                        operation,newfile,temp+4);                   scanf("%s",ans);'                     if ( ans[0] != 'y') !                         continue;                  }              if(create)                 {*'                 if(file_type == ISDIRE)*                     {e#                     bytecount =  0;e                      mode = 0755;*                     fill_header(pathname);(                     write_header(outfd);                     }r'                 if(file_type == ISFILE)I                     {E                      mode = 0644;6                     if(addfile(newfile, pathname) < 0)A                         printf("ERROR: %s NOT COPIED\n",newfile);u                     }                  }n             if(verbose || list)                  {e4                 if(bytecount || file_type == ISDIRE)1                     printf("%c: %-40s %6d  %26s",iE                        operation,pathname,bytecount,ctime(&vmstime));                  else5                    printf("IGNORED:  %s\n",pathname);                  } 
             } F         if(indx)                        /* any more in the string ? */>             strcpy(names,indx+1);       /* Yes, work on it  */         else             break;	         }      if(create)	         {z         write_trailer(outfd);p         close(outfd);h	         }e     exit(SS$_NORMAL);e }d  ( /* Copy the vms file to the output file. *  */   int addfile(vmsname,unixname)  char vmsname[],unixname[]; {  int ind;A     if(bytecount == 0)          /* We don't output null files  */l         return(0);3     if((ind=out_file(vmsname,bytecount,outfd)) < 0)a         return(ind);*     bufferpointer = bufferpointer%BLKSIZE;     return(1); }      /* Write out the file.- * move nbytes of data from "fdin" to "fdout"; ' * Always pad the output to a full DSIZEe> * If it a vms text file, it may be various formats, so we will< * write into a temporary file first, then copy to the output( * so that we get the correct byte count./ * We set the bytecount=0 if this is funny file.n */# int out_file(filename,nbytes,fdout)  char filename[]; int fdout, nbytes; {  int i, n, pos, fdin;
 FILE *filein;      if(vmsrfm == FIXED)M	         { '         if((fdin=open(filename,0)) <=0)                  { A                 printf("Error opening input file %s\n",filename);r                 return(-1);i                 }hL         fill_header(pathname);          /* We have all of the information */D         write_header(outfd);            /* So write to the output */         while(nbytes > 0) 
             {h>             n = read(fdin,dbuffer,nbytes>DSIZE? DSIZE:nbytes);             if(n<0)b                 {                  close(fdin);5                 printf("Read error on input file\n");                  return(-1);/                 }              nbytes -= n;'             write(fdout,dbuffer,DSIZE);aH             bufferpointer += DSIZE;             /* Count the position */
             }          close(fdin);         return(0);	         }lB     else if(vmsrat != 0)                /* must be a text file  */J         {                               /* Write out to standard stream */2         if((filein = fopen(filename,"r")) == NULL)                 {*6                 printf("ERROR OPENING %s\n",filename);                 return(-1);r                 }h         nbytes = 0;,D         lseek(temfd,0,0);               /* Back to the beginning  */9         while((i = fgets(dbuffer,DSIZE,filein)) !=  NULL) 
             {*              n = strlen(dbuffer);             nbytes += n;#             write(temfd,dbuffer,n);D
             }rE         fclose(filein);                 /* All done with the input */ D         lseek(temfd,0,0);               /* Back to the beginning  */A         bytecount = nbytes;             /* Use the real count  */h@         fill_header(pathname);          /* Compute the header */7         write_header(outfd);            /* Write it  */fD         while(nbytes > 0)               /* Now copy to the output */
             {s?             n = read(temfd,dbuffer,nbytes>DSIZE? DSIZE:nbytes);              nbytes -= n;'             write(fdout,dbuffer,DSIZE);.H             bufferpointer += DSIZE;             /* Count the position */
             }e         return(0);	         }*C                         /* Other formats e.g. .OBJ are not done  */_         bytecount = 0;         return(0); }]  ) /* Copy the header to the output file  */  int write_header(fd) int fd;e {  int n;*     if((n=write(fd,&header,DSIZE))!=DSIZE)	         { 9         printf("Error writing header in output file.\n");n         exit(1);	         }c     bufferpointer += DSIZE;      return(n); }   * /*  get the file attributes via stat()  */   int get_attributes(fname) 
 char fname[];  {-     if(stat(fname,sblock))     {=7         printf("Error getting file status:%s\n",fname); G         vmstime = 0;                    /* Prevent garbage printoout */ D         bytecount = 0;                  /* of inaccessible files  */         return(-1);r     } 8 /* now get the file attributes, we don't use them all */      bytecount = sblock->st_size;      vmsrat = sblock->st_fab_rat;      vmsmrs = sblock->st_fab_mrs;      vmsrfm = sblock->st_fab_rfm;     vmstime = sblock->st_mtime;  }     D /* Write the two blank blocks on the output file, and pad the output# * to a full blocksize if needed. */s write_trailer(fdout)
 int fdout; {  int rem;     header = *empty;     write_header(fdout);     write_header(fdout);*     bufferpointer = bufferpointer%BLKSIZE;#     while (bufferpointer < BLKSIZE)          write_header(fdout);     return(1); }r  C /* Decode a file name into the directory, and the name, and convert B * to a valid UNIX pathname. Return  a value to indicate if this is$ * a directory name, or another file.= * We return the extracted directory string in "dire", and theeA * filename (if it exists) in "fname". The full title is in "line"o * at input.o */   int scan_name(line,dire,fname) char line[],dire[],fname[];. {* char temp[NAMSIZE],*end1,*end2;t int len,len2,i;]> /* The format will be VMS at input, so we have to scan for theA * VMS device separator ':', and also the VMS directory separatorse *  '[' and ']'.eF * If the name ends with '.dir;1' then it is actually a directory name.P * The outputs dire and  fname will be a complete file spec, based on the default * directory.I * It may be a rooted directory, in which case there will be a "][" string 
 * remove it.. P * Strip out colons from the right, in case there is a node name (should not be!)K * If the filename ends in a triling '.', suppressit , unless the "d" option. * is set */    O     strcpy(temp,strrchr(line,':')+1);           /* Start with the whole name */ 4 /* Get rid of default directory part of the name  */J     for(end1=temp,end2=strrchr(directory,':')+1;*end2 && (*end1 == *end2);          end1++,end2++);     if(*end2 == 0)G         *end1 = 0;              /* Perfect match, no directory spec  */e     else	         {          switch(*end1) 	         {n         case '.':p?         case '[':               /* Legal beginnings or ends  */r             break;M         case ']':               /* We are above the default, use full name */ B             end1 = strchr(temp,'[');    /* Fixed this from 1.5  */             break;A         default:                /* Something strange, back up  */i?             while(*end1 != '.' && *end1 != '[' && end1 >= temp)i                 end1--;              break;	         }hB         end1++;                 /* Get past the starting . or [ */     }l     strcpy(dire,end1);     if(strlen(dire))M         strcpy(strchr(dire,']'),"/");   /* get rid of the directory marks  */ @     strcpy(temp,strchr(line,']')+1); /* Now get the file name */)     if((end1=strindex(temp,".dir;1"))!=0)t	         {;N         strcpy(end1,"/");                       /* Terminate directory name */         strcat(dire,temp);         strcpy(fname,""); 	         }      else	         {=         strcpy(fname,temp);eH         strcpy(strchr(fname,';'),"");           /* no version numbers */	         }a)     /* Now rewrite the directory name  */n8     for (i=1;dire[i];i++)       /* Change '.' to '/'  */         if(dire[i]=='.')             dire[i]='/';     if((len=strlen(fname))==0)	         {*         return(ISDIRE);_	         }I     else         if(fname[--len] == '.')             if (dot == 0)7                 fname[len] = 0; /* No trailing dots  */h         return(ISFILE);  }   B /* To start looking for file names to satisfy the requested input,B * use the sys$parse routine to create a wild-card name block. WhenA * it returns, we can then use the resultant FAB and NAM blocks on @ * successive calls to sys$search() until there are no more files * that match */   int initsearch(string) char string[]; {f int status;i  #     if(strindex(string,"::")!=NULL) 	         {u@         printf("***** Access across nodes is not supported.\n");         return(-1); 	         }      fblock = cc$rms_fab;     nblock = cc$rms_nam;$     fblock.fab$l_dna = default_name;,     fblock.fab$b_dns = strlen(default_name);     fblock.fab$l_fna = string;&     fblock.fab$b_fns = strlen(string);     fblock.fab$l_nam = &nblock; "     nblock.nam$l_esa = searchname;*     nblock.nam$b_ess = sizeof(searchname); #ifdef debug(     printf("searching on: %s\n",string); #endif      status = sys$parse(&fblock);     if(status != RMS$_NORMAL)t	         {)         if(status == RMS$_DNF):             printf("Directory not found:%s\n",searchname);         else-             printf("Error in sys$parse()\n");=         return (-1);	         }nC     searchname[nblock.nam$b_esl] = 0;   /* Terminate the string  */cD     /* Now reset for searching, pointing to the parsed name block */     fblock = cc$rms_fab;     fblock.fab$l_nam = &nblock;lD     return(nblock.nam$b_esl); /* return the length of the string  */ }u  @ /* Get the next file name that matches the namblock that was set" * up by the sys$search() function. */ int search(buff,maxlen)  char buff[]; int maxlen;t {e int status;        nblock.nam$l_rsa = buff;     nblock.nam$b_rss = maxlen;;     nblock.nam$b_rsl = 0;       /* For next time around  */u6     while( (status = sys$search(&fblock)) != RMS$_NMF)     {s#         buff[nblock.nam$b_rsl] = 0;f!         if(status == RMS$_NORMAL) 
             { %             return(nblock.nam$b_rsl);n
             }f         else
             {e#             if( status == RMS$_PRV) ?                 printf("%s : No privilege for access.\n",buff);o(             else if (status == RMS$_FNF)6                 printf("%s : File not found.\n",buff);             else                 { =                 printf(" Error in f$search for :%s\n", buff);n                 return (0);                  }d
             }      }r     return (0);o }n: /* Fill the fields of the header; enter with the file nameB * if the file name is empty, then this is a trailer, and we should * fill it with zeroes. */n   int fill_header(name)  char name[]; {t
 int i,chksum;  char *ptr,tem[15];7     header = *empty;            /* Clear the header  */rB     if(strlen(name)!=0)         /* only fill if there is a file */	         { E         sprintf(header.title,"%s",name);        /* write file name */pF         sprintf(header.protection,"%6o ",mode); /* all written with */F         sprintf(header.uid,"%6o ",uid);         /* a trailing space */'         sprintf(header.gid,"%6o ",gid);sF         sprintf(tem,"%11o ",bytecount);         /* except the count */I         strncpy(header.count,tem,12);           /* and the time, which */ F         sprintf(tem,"%11o ",vmstime);           /* except the count */B         strncpy(header.time,tem,12);            /* have no null */G         strncpy(header.chksum,"        ",8);    /* all blanks for sum*/ < /* I know that the next two are already zero, but do them */A         header.linkmode = 0;                    /* always zero */ B         sprintf(header.linkname,"%s","");       /* always blank */A         for(chksum=0, ptr = &header;ptr < &header.linkmode;ptr++)NG                  chksum += *ptr;                /* make the checksum */fJ         sprintf(header.chksum,"%6o",chksum);    /* This is how it looks */F         }                                       /* on UNIX tapes... */     return(0); }t  9 /* Initialize various fields, get some standard values */    initialize() {* int i;     dbuffer = malloc(DSIZE+1);)     sblock = malloc(sizeof(struct stat));0     empty = malloc(DSIZE);     for (i=0;i < DSIZE;i++) J         empty->title[i] = 0;    /* all zeroes, even if malloc() did it  */     header = *empty;     bufferpointer = 0;9     gid = getgid();     /* for now, use the user's uic */ '     uid = getuid(); /* and group uic */uH     mode = 0644;                /* This get changed elsewhere, anyhow */?     strcpy(directory,getenv("PATH"));   /* Default directory */      return;r }f    < /* Search for string2 in string1; return address pointer. */ char *strindex(string1,string2)a char *string1,*string2;  {e char *c1, *c2, *cp; $     for(c1 = string1; *c1 !=0; c1++)	         {n4         cp = c1;        /* save the start address */:         for(c2=string2; *c2 !=0 && *c1 == *c2; c1++,c2++);            if(*c2 == 0);                 return(cp);_	         }m     return(NULL);a }f  / /* function to change a string to lower case */i int chgcase(string)k char string[]; {e int i;2         for(i=0;string[i]=tolower(string[i]);i++);:         return (--i);           /* return string length */ }m  3 /* Routine to get rid of rooted directory problems,; * and any others that turn upn */   int cleanup_dire(string) char string[]; {  char *ptr, temp[NAMSIZE];;/         if((ptr=strindex(string,"][")) == NULL)o                 return(0);5                 /* Just collapse around the string */a         strcpy(ptr,ptr+2);         return(1); }a