/*
 * Decompiled with CFR 0.152.
 */
package org.doit.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArray {
    public byte[] bytes;
    public int offset = 0;

    public void append(byte by) {
        if (this.offset == this.bytes.length) {
            byte[] byArray = this.bytes;
            this.bytes = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, this.bytes, 0, this.offset);
        }
        this.bytes[this.offset++] = by;
    }

    public void append(ByteArray byteArray) {
        if (this.bytes.length - this.offset < byteArray.length()) {
            byte[] byArray = this.bytes;
            this.bytes = new byte[byArray.length + byteArray.length()];
            System.arraycopy(byArray, 0, this.bytes, 0, this.offset);
        }
        System.arraycopy(byteArray.bytes, 0, this.bytes, this.offset, byteArray.length());
        this.offset += byteArray.length();
    }

    public void append(byte[] byArray) {
        if (this.bytes.length - this.offset < byArray.length) {
            byte[] byArray2 = this.bytes;
            this.bytes = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, this.bytes, 0, this.offset);
        }
        System.arraycopy(byArray, 0, this.bytes, this.offset, byArray.length);
        this.offset += byArray.length;
    }

    public void append(String string) {
        this.append(string.getBytes());
    }

    public String toString() {
        return new String(this.bytes, 0, this.offset);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes, 0, this.offset);
    }

    public byte get(int n) {
        return this.bytes[n];
    }

    public int length() {
        return this.offset;
    }

    public void erase() {
        this.offset = 0;
    }

    public void chop() {
        this.chop(1);
    }

    public void chop(int n) {
        this.offset -= n;
        if (this.offset < 0) {
            this.offset = 0;
        }
    }

    public static void main(String[] stringArray) {
        ByteArray byteArray = new ByteArray(3);
        byteArray.append("foo");
        byteArray.append("bar");
        byteArray.append("joe");
        System.out.println(byteArray.toString());
        ByteArray byteArray2 = new ByteArray(1);
        byteArray2.append("test");
        byteArray.append(byteArray2);
        System.out.println(byteArray.toString());
    }

    public ByteArray() {
        this(512);
    }

    public ByteArray(int n) {
        this.bytes = new byte[n];
    }

    public ByteArray(String string) {
        this(string.length());
        this.append(string);
    }

    public ByteArray(byte[] byArray) {
        this(byArray.length);
        this.append(byArray);
    }
}

