/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.doit.muffin.Configuration;
import org.doit.muffin.ConfigurationListener;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManagerFrame;
import org.doit.muffin.Options;
import org.doit.muffin.Prefs;
import org.doit.muffin.UserPrefs;

public class FilterManager
implements ConfigurationListener {
    final String[] defaultKnownList = new String[]{"AnimationKiller", "CookieMonster", "Decaf", "DocumentInfo", "EmptyFont", "ForwardedFor", "Glossary", "History", "ImageKill", "HostnameExpander", "NoCode", "Painter", "Preview", "Rewrite", "NoThanks", "Referer", "Secretary", "SecretAgent", "SecretServer", "Snoop", "Stats", "Translate"};
    Options options = null;
    Configuration configs = null;
    FilterManagerFrame frame = null;
    UserPrefs userPrefs = null;
    Vector knownFilters = null;
    Vector enabledFilters = null;
    Hashtable knownFiltersCache = null;
    Hashtable enabledFiltersCache = null;

    public void configurationChanged(String string) {
        this.userPrefs = this.configs.getUserPrefs();
        this.knownFilters = this.getKnownFilters(string);
        this.enabledFilters = this.getEnabledFilters(string);
    }

    Vector getKnownFilters(String string) {
        if (!this.knownFiltersCache.containsKey(string)) {
            Vector<String> vector = new Vector<String>(32);
            this.knownFiltersCache.put(string, vector);
            UserPrefs userPrefs = this.configs.getUserPrefs(string);
            String[] stringArray = userPrefs.getStringList("FilterManager.knownFilters");
            if (stringArray.length == 0) {
                stringArray = this.defaultKnownList;
            }
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return (Vector)this.knownFiltersCache.get(string);
    }

    Vector getEnabledFilters(String string) {
        if (!this.enabledFiltersCache.containsKey(string)) {
            Vector vector = new Vector(32);
            this.enabledFiltersCache.put(string, vector);
            UserPrefs userPrefs = this.configs.getUserPrefs(string);
            String[] stringArray = userPrefs.getStringList("FilterManager.enabledFilters");
            int n = 0;
            while (n < stringArray.length) {
                this.enable(string, stringArray[n]);
                ++n;
            }
        }
        return (Vector)this.enabledFiltersCache.get(string);
    }

    synchronized Filter[] createFilters(String string) {
        String string2 = this.configs.autoConfig(string);
        if (!string2.equals(this.configs.getCurrent())) {
            System.out.println("Automatic change to " + string2);
            this.configs.setCurrent(string2);
        }
        Filter[] filterArray = new Filter[this.enabledFilters.size()];
        int n = 0;
        while (n < filterArray.length) {
            FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
            filterArray[n] = filterFactory.createFilter();
            ++n;
        }
        return filterArray;
    }

    void createFrame() {
        if (this.frame == null) {
            this.frame = new FilterManagerFrame(this);
        }
        this.frame.hideshow();
    }

    String shortName(String string) {
        if (string.startsWith("muffin.filter.") || string.startsWith("org.doit.muffin.filter.")) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    void append(String string) {
        this.knownFilters.addElement(string);
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    void remove(String string) {
        int n = 0;
        while (n < this.knownFilters.size()) {
            String string2 = (String)this.knownFilters.elementAt(n);
            if (string2.equals(string)) {
                this.knownFilters.removeElementAt(n);
            }
            ++n;
        }
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    void enable(String string, String string2) {
        if ((string2 = this.shortName(string2)).indexOf(46) == -1) {
            string2 = "org.doit.muffin.filter." + string2;
        }
        try {
            FilterFactory filterFactory = (FilterFactory)Class.forName(string2).newInstance();
            UserPrefs userPrefs = this.configs.getUserPrefs(string);
            Vector vector = this.getEnabledFilters(string);
            Prefs prefs = userPrefs.extract(string2.substring(string2.lastIndexOf(46) + 1));
            filterFactory.setPrefs(prefs);
            filterFactory.setManager(this);
            vector.addElement(filterFactory);
            if (this.frame != null) {
                this.frame.updateEnabledFiltersList();
            }
        }
        catch (Exception exception) {
            System.out.println("");
            System.out.println("WARNING: Can't load " + string2 + ": ");
            System.out.println("");
            System.out.println("         " + exception);
            System.out.println("");
            System.out.println("         You may need to restart muffin with a different CLASSPATH.");
            System.out.println("");
        }
    }

    void enable(String string) {
        this.enable(this.configs.getCurrent(), string);
    }

    void disable(Vector vector, int n) {
        FilterFactory filterFactory = (FilterFactory)vector.elementAt(n);
        filterFactory.shutdown();
        vector.removeElementAt(n);
        if (this.frame != null) {
            this.frame.updateEnabledFiltersList();
        }
    }

    void disable(int n) {
        this.disable(this.configs.getCurrent(), n);
    }

    void disable(String string, int n) {
        Vector vector = this.getEnabledFilters(string);
        this.disable(vector, n);
    }

    void disableAll() {
        Enumeration enumeration = this.configs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = this.getEnabledFilters(string);
            int n = vector.size() - 1;
            while (n >= 0) {
                this.disable(vector, n);
                --n;
            }
        }
    }

    void save(String string) {
        Vector vector = this.getEnabledFilters(string);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            FilterFactory filterFactory = (FilterFactory)vector.elementAt(n);
            stringArray[n] = this.shortName(filterFactory.getClass().getName());
            ++n;
        }
        UserPrefs userPrefs = this.configs.getUserPrefs(string);
        userPrefs.putStringList("FilterManager.enabledFilters", stringArray);
        userPrefs.save();
    }

    void save() {
        this.save(this.configs.getCurrent());
    }

    void saveAll() {
        Enumeration enumeration = this.configs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.save(string);
        }
    }

    public void save(FilterFactory filterFactory) {
        this.userPrefs.merge(filterFactory.getPrefs());
        this.userPrefs.save();
    }

    FilterManager(Options options, Configuration configuration) {
        this.options = options;
        this.configs = configuration;
        this.knownFiltersCache = new Hashtable();
        this.enabledFiltersCache = new Hashtable();
        configuration.addConfigurationListener(this);
    }
}

