/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.awt.Color;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.MuffinResolver;
import org.doit.muffin.OptionsFrame;
import org.doit.muffin.UserPrefs;

public class Options
extends UserPrefs {
    OptionsFrame frame;
    Vector hostsAllow;
    Vector hostsDeny;
    Vector adminAllow;
    Vector adminDeny;

    void createFrame() {
        if (this.frame == null) {
            this.frame = new OptionsFrame(this);
        }
        this.frame.hideshow();
    }

    void updateHostsAllow() {
        this.hostsAllow = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.hostsAllow"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.hostsAllow.addElement(stringTokenizer.nextToken());
        }
    }

    void updateHostsDeny() {
        this.hostsDeny = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.hostsDeny"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.hostsDeny.addElement(stringTokenizer.nextToken());
        }
    }

    void updateAdminAllow() {
        this.adminAllow = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.adminAllow"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.adminAllow.addElement(stringTokenizer.nextToken());
        }
    }

    void updateAdminDeny() {
        this.adminDeny = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.adminDeny"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.adminDeny.addElement(stringTokenizer.nextToken());
        }
    }

    void sync() {
        this.updateHostsAllow();
        this.updateHostsDeny();
        this.updateAdminAllow();
        this.updateAdminDeny();
        MuffinResolver.init(this.getStringList("muffin.nameservers"));
    }

    boolean hostAccess(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostAddress();
        Enumeration enumeration = this.hostsAllow.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return true;
        }
        enumeration = this.hostsDeny.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    boolean adminInetAccess(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostAddress();
        Enumeration enumeration = this.adminAllow.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return true;
        }
        enumeration = this.adminDeny.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    boolean useHttpProxy() {
        return this.getString("muffin.httpProxyHost").length() > 0 && this.getInteger("muffin.httpProxyPort") > 0;
    }

    boolean useHttpsProxy() {
        return this.getString("muffin.httpsProxyHost").length() > 0 && this.getInteger("muffin.httpsProxyPort") > 0;
    }

    Options(String string) {
        super(string);
        this.putInteger("muffin.port", 51966);
        this.putString("muffin.httpProxyHost", "");
        this.putString("muffin.httpProxyPort", "");
        this.putString("muffin.httpsProxyHost", "");
        this.putString("muffin.httpsProxyPort", "");
        this.putString("muffin.geometry", "");
        this.putBoolean("muffin.noWindow", false);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.putString("muffin.hostsAllow", "127.0.0.1," + inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.putString("muffin.hostsAllow", "ALL");
        }
        this.putString("muffin.hostsDeny", "ALL");
        this.putString("muffin.adminAllow", this.getString("muffin.hostsAllow"));
        this.putString("muffin.adminDeny", this.getString("muffin.hostsDeny"));
        this.putString("muffin.adminUser", "");
        this.putString("muffin.adminPassword", "");
        this.putColor("muffin.bg", Color.lightGray);
        this.putColor("muffin.fg", Color.black);
        this.putString("muffin.font", "helvetica-bold-12");
        this.putString("muffin.smallfont", "helvetica-plain-10");
        this.putString("muffin.bigfont", "helvetica-bold-16");
        this.putString("muffin.logfile", "muffin.log");
        this.putBoolean("muffin.proxyKeepAlive", false);
        this.putInteger("muffin.readTimeout", 90000);
        this.putString("muffin.nameservers", "");
        this.load();
    }
}

