/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.doit.muffin.Prefs;
import org.doit.util.SortedProperties;

class UserPrefs
extends Prefs {
    String rcfile = "unknown";
    boolean loaded = false;

    void setPrefsFile(String string) {
        this.rcfile = string;
    }

    String getPrefsFile() {
        return this.rcfile;
    }

    void unload() {
        this.clear();
        this.loaded = false;
    }

    void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(this.getUserFile(this.rcfile));
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.put(string, properties.get(string));
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.loaded = true;
    }

    void save() {
        Object object;
        SortedProperties sortedProperties = new SortedProperties();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            sortedProperties.put(object, this.get(object));
        }
        this.checkUserDirectory();
        object = new File(this.getUserFile(this.rcfile));
        System.out.println("Saving " + ((File)object).getAbsolutePath());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            sortedProperties.save(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(enumeration);
        }
        catch (IOException iOException) {
            System.out.println(enumeration);
        }
    }

    UserPrefs() {
    }

    UserPrefs(String string) {
        this.setPrefsFile(string);
    }
}

