/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.IOException;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.FilterException;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.filter.NoThanks;

public class NoThanksFilter
implements ContentFilter,
RequestFilter,
ReplyFilter {
    NoThanks factory;
    Prefs prefs;
    InputObjectStream in = null;
    OutputObjectStream out = null;
    Request request = null;

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        String string = request.getURL();
        String string2 = this.factory.redirect(string);
        if (string2 != null) {
            this.factory.report(request, "redirect to " + string2);
            request.setURL(string2);
            return;
        }
        if (this.factory.isKilled(string)) {
            this.factory.report(request, "rejected " + string);
            throw new FilterException("NoThanks URL " + string + " rejected");
        }
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getContentType();
        if (string != null && this.factory.killContent(string)) {
            this.factory.report(this.request, "rejected " + string);
            throw new FilterException("NoThanks content-type " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block22: {
            Object object;
            Thread.currentThread().setName("NoThanks");
            Object object22222 = null;
            boolean bl = false;
            block12: while ((object = this.in.read()) != null) {
                Token token = (Token)object;
                if (bl && token.getType() != 4) continue;
                switch (token.getType()) {
                    case 4: {
                        String string = token.toString();
                        bl = this.factory.killComment(string);
                        if (bl) {
                            this.factory.report(this.request, "removed comment " + string);
                            break;
                        }
                        if (object22222 != null) continue block12;
                        this.out.write(token);
                        break;
                    }
                    case 2: {
                        Object object3;
                        boolean bl2 = true;
                        Object object4 = token.createTag();
                        if (object22222 != null) {
                            if (!((Tag)object4).is((String)object22222)) continue block12;
                            object22222 = null;
                            break;
                        }
                        if (this.factory.stripTag(((Tag)object4).name())) {
                            this.factory.report(this.request, "stripped " + ((Tag)object4).name());
                            object22222 = this.factory.stripUntil(((Tag)object4).name());
                            bl2 = false;
                        }
                        if (bl2 && this.factory.replaceTag(((Tag)object4).name())) {
                            object3 = this.factory.replaceTagWith(((Tag)object4).name());
                            this.factory.report(this.request, "replaced " + ((Tag)object4).name() + " with " + ((Tag)object3).name());
                            object4 = object3;
                        }
                        if (bl2 && this.factory.checkTagAttributes((Tag)object4) && this.factory.processTagAttributes(this.request, (Tag)object4)) {
                            bl2 = false;
                            if (this.factory.hasEnd(((Tag)object4).name())) {
                                object22222 = "/" + ((Tag)object4).name();
                            }
                        }
                        if (bl2 && this.factory.checkTag(((Tag)object4).name()) && ((Tag)object4).attributeCount() > 0) {
                            object3 = ((Tag)object4).enumerate();
                            while (object3.hasMoreElements()) {
                                String string;
                                String string2 = (String)object3.nextElement();
                                if (!this.factory.checkAttr(string2) || (string = ((Tag)object4).get(string2)) == null || !this.factory.isKilled(string)) continue;
                                if (this.factory.isRequired(((Tag)object4).name())) {
                                    this.factory.report(this.request, "removed " + string2 + "=" + string);
                                    ((Tag)object4).remove(string2);
                                    continue;
                                }
                                this.factory.report(this.request, "killed " + ((Tag)object4).name() + " with " + string2 + "=" + string);
                                bl2 = false;
                                if (!this.factory.hasEnd(((Tag)object4).name())) break;
                                object22222 = "/" + ((Tag)object4).name();
                                break;
                            }
                        }
                        if (!bl2) continue block12;
                        token.importTag((Tag)object4);
                        this.out.write(token);
                        break;
                    }
                    default: {
                        if (object22222 != null) continue block12;
                        this.out.write(token);
                        break;
                    }
                }
            }
            Object var2_14 = null;
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException object22222) {}
            break block22;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var2_15 = null;
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var2_16 = null;
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public NoThanksFilter(NoThanks noThanks) {
        this.factory = noThanks;
    }
}

