/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Request;
import org.doit.muffin.filter.RewriteFilter;
import org.doit.muffin.filter.RewriteFrame;

public class Rewrite
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    RewriteFrame frame = null;
    MessageArea messages = null;
    Vector rules = null;
    Vector rewrite = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("rewrite");
        prefs.putString("Rewrite.rules", string);
        prefs.setOverride(bl);
        this.messages = new MessageArea();
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new RewriteFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        RewriteFilter rewriteFilter = new RewriteFilter(this);
        rewriteFilter.setPrefs(this.prefs);
        return rewriteFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    String rewrite(Request request, String string) {
        RE rE = null;
        REMatch rEMatch = null;
        Enumeration enumeration = this.rules.elements();
        int n = 0;
        while (rEMatch == null && enumeration.hasMoreElements()) {
            rE = (RE)enumeration.nextElement();
            rEMatch = rE.getMatch(string);
            ++n;
        }
        if (rEMatch != null) {
            String string2 = (String)this.rewrite.elementAt(n - 1);
            String string3 = rEMatch.substituteInto(string2);
            this.report(request, "RULE #" + n + ": " + string + " -> " + string3);
            string = string3;
        }
        return string;
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("Rewrite.rules"));
        try {
            this.load(new FileReader(new File(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void load(Reader reader) {
        this.rules = new Vector();
        this.rewrite = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            RE rE = new RE("^[# \t\n]");
            while ((string = bufferedReader.readLine()) != null) {
                if (rE.getMatch(string) != null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                try {
                    this.rules.addElement(new RE(stringTokenizer.nextToken()));
                    this.rewrite.addElement(stringTokenizer.nextToken());
                }
                catch (REException rEException) {
                    System.out.println("REException: " + rEException);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void report(Request request, String string) {
        request.addLogEntry("Rewrite", string);
        this.messages.append(string + "\n");
    }
}

