/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.Task.WorkerThread;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 30;
    private static final byte retries = 3;
    private static int uniqueID = 0;
    private Vector resolvers;

    private void init() {
        this.resolvers = new Vector();
    }

    private void sendTo(Message message, Receiver receiver, Hashtable hashtable, int n) {
        Resolver resolver = (Resolver)this.resolvers.elementAt(n);
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Object object = resolver.sendAsync(message, receiver);
            hashtable.put(object, new Integer(n));
        }
    }

    public void setPort(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n2)).setPort(n);
            ++n2;
        }
    }

    public void setTCP(boolean bl) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n)).setTCP(bl);
            ++n;
        }
    }

    public void setIgnoreTruncation(boolean bl) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n)).setIgnoreTruncation(bl);
            ++n;
        }
    }

    public void setEDNS(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n2)).setEDNS(n);
            ++n2;
        }
    }

    public void setTSIGKey(String string, String string2) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n)).setTSIGKey(string, string2);
            ++n;
        }
    }

    public void setTSIGKey(String string) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n)).setTSIGKey(string);
            ++n;
        }
    }

    public void setTimeout(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(n2)).setTimeout(n);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message send(Message message) throws IOException {
        Message message2 = null;
        Serializable serializable = null;
        boolean[] blArray = new boolean[this.resolvers.size()];
        byte[] byArray = new byte[this.resolvers.size()];
        byte[] byArray2 = new byte[this.resolvers.size()];
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        ExtendedResolver extendedResolver = this;
        if (extendedResolver == null) {
            throw null;
        }
        Receiver receiver = extendedResolver.new Receiver(vector, hashtable);
        while (true) {
            Message message3;
            QElement qElement;
            Serializable serializable2;
            block21: {
                boolean bl = false;
                serializable2 = vector;
                synchronized (serializable2) {
                    block20: {
                        block19: {
                            int n = 0;
                            while (n < this.resolvers.size()) {
                                if (byArray[n] == byArray2[n] && byArray[n] < 3) {
                                    this.sendTo(message, receiver, hashtable, n);
                                    int n2 = n;
                                    byArray[n2] = (byte)(byArray[n2] + 1);
                                    bl = true;
                                    break;
                                }
                                if (byArray2[n] < byArray[n]) {
                                    bl = true;
                                }
                                ++n;
                            }
                            if (!bl) {
                                Object var16_17 = null;
                                break block19;
                            }
                            try {
                                vector.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (vector.size() == 0) {
                                break block20;
                            }
                            qElement = (QElement)vector.firstElement();
                            vector.removeElement(qElement);
                            message3 = qElement.obj instanceof Message ? (Message)qElement.obj : null;
                            int n3 = n = qElement.res;
                            byArray2[n3] = (byte)(byArray2[n3] + 1);
                            break block21;
                        }
                        break;
                    }
                    Object var16_18 = null;
                    continue;
                }
            }
            if (message3 == null) {
                serializable2 = (IOException)qElement.obj;
                if (!(serializable2 instanceof InterruptedIOException)) {
                    blArray[n] = true;
                }
                if (serializable != null) continue;
                serializable = serializable2;
                continue;
            }
            byte by = message3.getHeader().getRcode();
            if (by == 0) {
                return message3;
            }
            if (message2 == null) {
                message2 = message3;
            } else {
                byte by2 = message2.getHeader().getRcode();
                if (by == 3 && by2 != 3) {
                    message2 = message3;
                }
            }
            blArray[n] = true;
        }
        if (message2 != null) {
            return message2;
        }
        throw serializable;
    }

    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Integer n;
        Object object = this;
        synchronized (object) {
            n = new Integer(uniqueID++);
        }
        object = this.getClass() + ": " + message.getQuestion().getName();
        WorkerThread.assignThread(new ResolveThread(this, message, n, resolverListener), (String)object);
        return n;
    }

    public Message sendAXFR(Message message) throws IOException {
        return ((Resolver)this.resolvers.elementAt(0)).sendAXFR(message);
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.elementAt(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        Resolver[] resolverArray = new Resolver[this.resolvers.size()];
        int n = 0;
        while (n < this.resolvers.size()) {
            resolverArray[n] = (Resolver)this.resolvers.elementAt(n);
            ++n;
        }
        return resolverArray;
    }

    public void addResolver(Resolver resolver) {
        this.resolvers.addElement(resolver);
    }

    public void deleteResolver(Resolver resolver) {
        this.resolvers.removeElement(resolver);
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] stringArray = FindServer.servers();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                SimpleResolver simpleResolver = new SimpleResolver(stringArray[n]);
                simpleResolver.setTimeout(30);
                this.resolvers.addElement(simpleResolver);
                ++n;
            }
        } else {
            this.resolvers.addElement(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] stringArray) throws UnknownHostException {
        this.init();
        int n = 0;
        while (n < stringArray.length) {
            SimpleResolver simpleResolver = new SimpleResolver(stringArray[n]);
            simpleResolver.setTimeout(30);
            this.resolvers.addElement(simpleResolver);
            ++n;
        }
    }

    public ExtendedResolver(Resolver[] resolverArray) throws UnknownHostException {
        this.init();
        int n = 0;
        while (n < resolverArray.length) {
            this.resolvers.addElement(resolverArray[n]);
            ++n;
        }
    }

    class QElement {
        Object obj;
        int res;

        public QElement(Object object, int n) {
            this.obj = object;
            this.res = n;
        }
    }

    class Receiver
    implements ResolverListener {
        Vector queue;
        Hashtable idMap;

        public void enqueueInfo(Object object, Object object2) {
            int n;
            Cloneable cloneable = this.idMap;
            synchronized (cloneable) {
                Integer n2 = (Integer)this.idMap.get(object);
                if (n2 == null) {
                    Object var6_5 = null;
                    return;
                }
                n = n2;
                this.idMap.remove(object);
            }
            cloneable = this.queue;
            synchronized (cloneable) {
                ExtendedResolver extendedResolver = ExtendedResolver.this;
                if (extendedResolver == null) {
                    throw null;
                }
                QElement qElement = extendedResolver.new QElement(object2, n);
                this.queue.addElement(qElement);
                this.queue.notify();
            }
        }

        public void receiveMessage(Object object, Message message) {
            this.enqueueInfo(object, message);
        }

        public void handleException(Object object, Exception exception) {
            System.out.println("got an exception: " + exception);
            this.enqueueInfo(object, exception);
        }

        public Receiver(Vector vector, Hashtable hashtable) {
            this.queue = vector;
            this.idMap = hashtable;
        }
    }
}

