/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class Name {
    public static Name root = new Name("");
    static final int MAXLABELS = 64;
    private String[] name;
    private byte labels;
    private boolean qualified;

    public Name wild() {
        Name name = new Name(this, 0);
        name.name[0] = "*";
        return name;
    }

    public boolean isWild() {
        return this.name[0].equals("*");
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public void append(Name name) {
        System.arraycopy(name.name, 0, this.name, this.labels, name.labels);
        this.labels = (byte)(this.labels + name.labels);
    }

    public short length() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.labels) {
            n = (short)(n + (this.name[n2].length() + 1));
            ++n2;
        }
        short s = (short)(n + 1);
        n = s;
        return s;
    }

    public byte labels() {
        return this.labels;
    }

    public boolean subdomain(Name name) {
        if (name == null || name.labels > this.labels) {
            return false;
        }
        int n = this.labels;
        int n2 = name.labels;
        while (n2 > 0) {
            if (this.name[--n].equals(name.name[--n2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.labels == 0) {
            stringBuffer.append(".");
        }
        int n = 0;
        while (n < this.labels) {
            stringBuffer.append(this.name[n]);
            if (this.qualified || n < this.labels - 1) {
                stringBuffer.append(".");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void toWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        int n = 0;
        while (n < this.labels) {
            Name name = new Name(this, n);
            int n2 = compression != null ? compression.get(name) : -1;
            if (n2 >= 0) {
                dataByteOutputStream.writeShort(n2 |= 0xC000);
                return;
            }
            if (compression != null) {
                compression.add(dataByteOutputStream.getPos(), name);
            }
            dataByteOutputStream.writeString(this.name[n]);
            ++n;
        }
        dataByteOutputStream.writeByte(0);
    }

    public void toWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        int n = 0;
        while (n < this.labels) {
            dataByteOutputStream.writeByte(this.name[n].length());
            int n2 = 0;
            while (n2 < this.name[n].length()) {
                dataByteOutputStream.writeByte(Character.toLowerCase(this.name[n].charAt(n2)));
                ++n2;
            }
            ++n;
        }
        dataByteOutputStream.writeByte(0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (name.labels != this.labels) {
            return false;
        }
        int n = 0;
        while (n < this.labels) {
            if (!name.name[n].equalsIgnoreCase(this.name[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.labels;
        int n2 = 0;
        while (n2 < this.labels) {
            int n3 = 0;
            while (n3 < this.name[n2].length()) {
                n += Character.toLowerCase(this.name[n2].charAt(n3));
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public Name(String string, Name name) {
        this.labels = 0;
        this.name = new String[64];
        if (string.equals("@") && name != null) {
            this.append(name);
            this.qualified = true;
            return;
        }
        try {
            MyStringTokenizer myStringTokenizer = new MyStringTokenizer(string, ".");
            while (myStringTokenizer.hasMoreTokens()) {
                byte by = this.labels;
                this.labels = (byte)(by + 1);
                this.name[by] = myStringTokenizer.nextToken();
            }
            if (myStringTokenizer.hasMoreDelimiters()) {
                this.qualified = true;
            } else if (name != null) {
                this.append(name);
                this.qualified = true;
            } else {
                this.qualified = this.labels > 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("String ");
            stringBuffer.append(string);
            if (name != null) {
                stringBuffer.append(".");
                stringBuffer.append(name);
            }
            stringBuffer.append(" has too many labels");
            System.out.println(stringBuffer.toString());
            this.name = null;
            this.labels = 0;
        }
    }

    public Name(String string) {
        this(string, null);
    }

    Name(DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        int n;
        int n2 = 0;
        this.labels = 0;
        this.name = new String[64];
        int n3 = dataByteInputStream.getPos();
        while ((n = dataByteInputStream.readUnsignedByte()) != 0) {
            if ((n & 0xC0) != 0) {
                Name name;
                int n4 = dataByteInputStream.readUnsignedByte();
                Name name2 = name = compression == null ? null : compression.get(n4 += (n & 0xFFFFFF3F) << 8);
                if (name == null) {
                    byte by = this.labels;
                    this.labels = (byte)(by + 1);
                    this.name[by] = new String("<compressed>");
                    break;
                }
                System.arraycopy(name.name, 0, this.name, this.labels, name.labels);
                this.labels = (byte)(this.labels + name.labels);
                break;
            }
            byte[] byArray = new byte[n];
            dataByteInputStream.read(byArray);
            byte by = this.labels;
            this.labels = (byte)(by + 1);
            this.name[by] = new String(byArray);
            ++n2;
        }
        if (compression != null) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n2) {
                Name name = new Name(this, n5);
                compression.add(n6, name);
                n6 += this.name[n5].length() + 1;
                ++n5;
            }
        }
        this.qualified = true;
    }

    public Name(Name name, int n) {
        this.name = new String[64];
        this.labels = (byte)(name.labels - n);
        System.arraycopy(name.name, n, this.name, 0, this.labels);
        this.qualified = name.qualified;
    }
}

