/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class RRset {
    private Vector rrs = new Vector();
    private Vector sigs = new Vector();
    private int start = 0;

    public void addRR(Record record) {
        if (record.getType() != 24) {
            Vector vector = this.rrs;
            synchronized (vector) {
                if (!this.rrs.contains(record)) {
                    this.rrs.addElement(record);
                }
            }
        } else if (!this.sigs.contains(record)) {
            this.sigs.addElement(record);
        }
    }

    public void deleteRR(Record record) {
        if (record.getType() != 24) {
            Vector vector = this.rrs;
            synchronized (vector) {
                this.rrs.removeElement(record);
            }
        } else {
            this.sigs.removeElement(record);
        }
    }

    public void clear() {
        Vector vector = this.rrs;
        synchronized (vector) {
            this.rrs.setSize(0);
        }
        this.sigs.setSize(0);
        this.start = 0;
    }

    public Enumeration rrs() {
        RRset rRset = this;
        if (rRset == null) {
            throw null;
        }
        return rRset.new Enumerator();
    }

    public Enumeration sigs() {
        return this.sigs.elements();
    }

    public int size() {
        return this.rrs.size();
    }

    public Name getName() {
        if (this.rrs.size() == 0) {
            return null;
        }
        Record record = (Record)this.rrs.elementAt(0);
        return record.getName();
    }

    public short getType() {
        if (this.rrs.size() == 0) {
            return 0;
        }
        Record record = (Record)this.rrs.elementAt(0);
        return record.getType();
    }

    public short getDClass() {
        if (this.rrs.size() == 0) {
            return 0;
        }
        Record record = (Record)this.rrs.elementAt(0);
        return record.getDClass();
    }

    public int getTTL() {
        if (this.rrs.size() == 0) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        Enumeration enumeration = this.rrs();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            if (record.getTTL() >= n) continue;
            n = record.getTTL();
        }
        return n;
    }

    public Record first() {
        if (this.rrs.size() == 0) {
            return null;
        }
        return (Record)this.rrs.elementAt(0);
    }

    public String toString() {
        Record record;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ [");
        RRset rRset = this;
        if (rRset == null) {
            throw null;
        }
        Enumeration enumeration = rRset.new Enumerator();
        while (enumeration.hasMoreElements()) {
            record = (Record)enumeration.nextElement();
            stringBuffer.append(record);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("<>");
        }
        stringBuffer.append("] [");
        enumeration = this.sigs();
        while (enumeration.hasMoreElements()) {
            record = (Record)enumeration.nextElement();
            stringBuffer.append(record);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("<>");
        }
        stringBuffer.append("] }");
        return stringBuffer.toString();
    }

    class Enumerator
    implements Enumeration {
        int first;
        int count;
        int size;
        Record[] records;
        boolean cycled;

        public boolean hasMoreElements() {
            return !this.cycled || this.count < this.first;
        }

        public Object nextElement() {
            if (this.count == this.first && this.cycled) {
                throw new NoSuchElementException();
            }
            Record record = this.records[this.count++];
            if (this.count == this.size) {
                this.count = 0;
                this.cycled = true;
            }
            return record;
        }

        Enumerator() {
            Vector vector = RRset.this.rrs;
            synchronized (vector) {
                this.size = RRset.this.rrs.size();
                this.records = new Record[this.size];
                int n = 0;
                while (n < this.size) {
                    this.records[n] = (Record)RRset.this.rrs.elementAt(n);
                    ++n;
                }
            }
            RRset rRset2 = RRset.this;
            int n = rRset2.start + 1;
            rRset2.start = n;
            if (n >= this.size) {
                RRset rRset3 = RRset.this;
                rRset3.start = rRset3.start - this.size;
            }
            this.first = this.count = RRset.this.start;
        }
    }
}

