/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class SOARecord
extends Record {
    private Name host;
    private Name admin;
    private int serial;
    private int refresh;
    private int retry;
    private int expire;
    private int minimum;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.host != null) {
            stringBuffer.append(this.host);
            stringBuffer.append(" ");
            stringBuffer.append(this.admin);
            stringBuffer.append(" (\n\t\t\t\t\t");
            stringBuffer.append(this.serial);
            stringBuffer.append("\t; serial\n\t\t\t\t\t");
            stringBuffer.append(this.refresh);
            stringBuffer.append("\t; refresh\n\t\t\t\t\t");
            stringBuffer.append(this.retry);
            stringBuffer.append("\t; retry\n\t\t\t\t\t");
            stringBuffer.append(this.expire);
            stringBuffer.append("\t; expire\n\t\t\t\t\t");
            stringBuffer.append(this.minimum);
            stringBuffer.append(")\t; minimum");
        }
        return stringBuffer.toString();
    }

    public Name getHost() {
        return this.host;
    }

    public Name getAdmin() {
        return this.admin;
    }

    public int getSerial() {
        return this.serial;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getExpire() {
        return this.expire;
    }

    public int getMinimum() {
        return this.minimum;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.host == null) {
            return;
        }
        this.host.toWire(dataByteOutputStream, compression);
        this.admin.toWire(dataByteOutputStream, compression);
        dataByteOutputStream.writeInt(this.serial);
        dataByteOutputStream.writeInt(this.refresh);
        dataByteOutputStream.writeInt(this.retry);
        dataByteOutputStream.writeInt(this.expire);
        dataByteOutputStream.writeInt(this.minimum);
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        if (this.host == null) {
            return;
        }
        this.host.toWireCanonical(dataByteOutputStream);
        this.admin.toWireCanonical(dataByteOutputStream);
        dataByteOutputStream.writeInt(this.serial);
        dataByteOutputStream.writeInt(this.refresh);
        dataByteOutputStream.writeInt(this.retry);
        dataByteOutputStream.writeInt(this.expire);
        dataByteOutputStream.writeInt(this.minimum);
    }

    private SOARecord() {
    }

    public SOARecord(Name name, short s, int n, Name name2, Name name3, int n2, int n3, int n4, int n5, int n6) throws IOException {
        super(name, (short)6, s, n);
        this.host = name2;
        this.admin = name3;
        this.serial = n2;
        this.refresh = n3;
        this.retry = n4;
        this.expire = n5;
        this.minimum = n6;
    }

    SOARecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)6, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.host = new Name(dataByteInputStream, compression);
        this.admin = new Name(dataByteInputStream, compression);
        this.serial = dataByteInputStream.readInt();
        this.refresh = dataByteInputStream.readInt();
        this.retry = dataByteInputStream.readInt();
        this.expire = dataByteInputStream.readInt();
        this.minimum = dataByteInputStream.readInt();
    }

    SOARecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)6, s, n);
        this.host = new Name(myStringTokenizer.nextToken(), name2);
        this.admin = new Name(myStringTokenizer.nextToken(), name2);
        this.serial = Integer.parseInt(myStringTokenizer.nextToken());
        this.refresh = TTL.parseTTL(myStringTokenizer.nextToken());
        this.retry = TTL.parseTTL(myStringTokenizer.nextToken());
        this.expire = TTL.parseTTL(myStringTokenizer.nextToken());
        this.minimum = TTL.parseTTL(myStringTokenizer.nextToken());
    }
}

