/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;

public class Zone
extends NameSet {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private int type = 1;
    private Name origin;
    private short dclass = 1;

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return (RRset)this.findExactSet(this.origin, (short)2, this.dclass);
    }

    public SOARecord getSOA() {
        RRset rRset = (RRset)this.findExactSet(this.origin, (short)6, this.dclass);
        if (rRset == null) {
            return null;
        }
        Enumeration enumeration = rRset.rrs();
        return (SOARecord)enumeration.nextElement();
    }

    public short getDClass() {
        return this.dclass;
    }

    public SetResponse findRecords(Name name, short s) {
        SetResponse setResponse = null;
        if (this.findName(name) == null) {
            return new SetResponse(2);
        }
        Object[] objectArray = this.findSets(name, s, this.dclass);
        if (objectArray == null) {
            return new SetResponse(3);
        }
        RRset[] rRsetArray = new RRset[objectArray.length];
        System.arraycopy(objectArray, 0, rRsetArray, 0, objectArray.length);
        int n = 0;
        while (n < rRsetArray.length) {
            RRset rRset = rRsetArray[n];
            if (s != 5 && s != 255 && rRset.getType() == 5) {
                CNAMERecord cNAMERecord = (CNAMERecord)rRset.first();
                setResponse = this.findRecords(cNAMERecord.getTarget(), s);
                if (setResponse.isNODATA()) {
                    setResponse.set((byte)4, cNAMERecord);
                } else if (setResponse.isNXDOMAIN() && !cNAMERecord.getTarget().subdomain(this.origin)) {
                    setResponse.set((byte)4, cNAMERecord);
                }
                setResponse.addCNAME(cNAMERecord);
                return setResponse;
            }
            if (setResponse == null) {
                setResponse = new SetResponse(5);
            }
            setResponse.addRRset(rRset);
            ++n;
        }
        return setResponse;
    }

    public RRset findExactMatch(Name name, short s) {
        return (RRset)this.findExactSet(name, s, this.dclass);
    }

    public void addRecord(Record record) {
        short s;
        Name name = record.getName();
        RRset rRset = (RRset)this.findExactSet(name, s = record.getType(), this.dclass);
        if (rRset == null) {
            rRset = new RRset();
            this.addSet(name, s, this.dclass, rRset);
        }
        rRset.addRR(record);
    }

    public Zone(String string, Cache cache) throws IOException {
        Record record;
        Master master = new Master(string);
        while ((record = master.nextRecord()) != null) {
            if (this.origin == null || record.getName().subdomain(this.origin)) {
                this.addRecord(record);
                if (this.origin != null || record.getType() != 6) continue;
                this.origin = record.getName();
                continue;
            }
            cache.addRecord(record, (byte)3, master);
        }
    }
}

