//======================================================================
//
// Memtrack.c
//
// By Mark Russinovich
// http://www.sysinternals.com
//
// Functions for tracking pool usage in a driver and detection 
// some kinds of buffer over- and under-runs.
//
//======================================================================

//
// Only use our debugging functions if doing a checked build or
// memory debugging is explicitly turned on
//
#if DBG || MEMDBG

PVOID MemAllocatePoolWithTag( IN POOL_TYPE PoolType, IN ULONG NumberOfBytes,
							 IN ULONG Tag );

PVOID MemAllocatePool( IN POOL_TYPE PoolType, IN ULONG NumberOfBytes );

VOID MemFreePool( PVOID Buffer );

PVOID MemAllocateFromNPagedLookasideList( PNPAGED_LOOKASIDE_LIST  Lookaside );

VOID MemFreeToNPagedLookasideList( PNPAGED_LOOKASIDE_LIST  Lookaside, PVOID Buffer );

VOID
MemInitializeNPagedLookasideList(
    IN PNPAGED_LOOKASIDE_LIST Lookaside,
    IN PALLOCATE_FUNCTION Allocate,
    IN PFREE_FUNCTION Free,
    IN ULONG Flags,
    IN ULONG Size,
    IN ULONG Tag,
    IN USHORT Depth
    );

VOID
MemDeleteNPagedLookasideList( PNPAGED_LOOKASIDE_LIST Lookaside );

PVOID MemAllocateFromPagedLookasideList( PNPAGED_LOOKASIDE_LIST  Lookaside );

VOID MemFreeToPagedLookasideList( PNPAGED_LOOKASIDE_LIST  Lookaside, PVOID Buffer );

VOID
MemInitializePagedLookasideList(
    IN PNPAGED_LOOKASIDE_LIST Lookaside,
    IN PALLOCATE_FUNCTION Allocate,
    IN PFREE_FUNCTION Free,
    IN ULONG Flags,
    IN ULONG Size,
    IN ULONG Tag,
    IN USHORT Depth
    );

VOID
MemDeletePagedLookasideList( PNPAGED_LOOKASIDE_LIST Lookaside );

#else // DBG || MEMDBG

//
// Redefine the Mem allocation functions to point at the
// Executives functions in builds that have memory debugging 
// turned off.
//
#define MemAllocatePool           ExAllocatePool
#define MemAllocatePoolWithTag    ExAllocatePoolWithTag
#define MemFreePool               ExFreePool
#define MemInitializeNPagedLookasideList   ExInitializeNPagedLookasideList
#define MemDeleteNPagedLookasideList       ExDeleteNPagedLookasideList
#define MemAllocateFromNPagedLookasideList ExAllocateFromNPagedLookasideList
#define MemFreeToNPagedLookasideList       ExFreeToNPagedLookasideList
#define MemInitializePagedLookasideList    ExInitializePagedLookasideList
#define MemDeletePagedLookasideList        ExDeletePagedLookasideList
#define MemAllocateFromPagedLookasideList  ExAllocateFromPagedLookasideList
#define MemFreeToPagedLookasideList        ExFreeToPagedLookasideList


#endif // DBG || MEMDBG

VOID MemTrackPrintStats( PCHAR Text );
VOID MemTrackInit();
