//======================================================================
// 
//  Filemon.h
//
//  Copyright (C) 1996-1997 Mark Russinovich and Bryce Cogswell
//
//======================================================================

// 
// NT Final Build number
//
#define NT4FINAL        1381

//
// Maximum amount of memory grabbed 
//
#define MAXMEMORY       1000000

//
// Maximum path length of pathname. This is larger than Win32 maxpath
// because network drives have leading paths
//
#define MAXPATHLEN      1024

//
// Length of process name (rounded up to next DWORD)
//
#define PROCNAMELEN     20

//
// Maximum length of NT process name
//
#define NT_PROCNAMELEN  16

//
// Maximum seperate filter components 
//
#define MAXFILTERS      64

//
// Length of buffer for error string
//
#define ERRORLEN        64

//
// Structure for device specific data that keeps track of what
// drive and what filesystem device are hooked 
//
typedef struct {
   PDEVICE_OBJECT   FileSystem;
   unsigned         LogicalDrive;
} HOOK_EXTENSION, *PHOOK_EXTENSION;         


//
// Structure for the fileobject/name hash table
//
typedef struct _nameentry {
   PFILE_OBJECT		FileObject;
   PCHAR		FullPathName;
   struct _nameentry 	*Next;
} HASH_ENTRY, *PHASH_ENTRY;


//
// Number of hash buckets in the hash table
//
#define NUMHASH		0x100

//
// Hash function. Basically chops the low few bits of the file object
//
#define HASHOBJECT(_fileobject)		(((ULONG)_fileobject)>>5)%NUMHASH


//
// Structure for keeping linked lists of output buffers
//
typedef struct _store {
    ULONG           Len;
    struct _store * Next;
    CHAR            Data[ MAX_STORE ];
} STORE_BUF, *PSTORE_BUF;


//
// A check to see if a fastio table extends to a specific entry
//
#define FASTIOPRESENT( _hookExt, _call )                                                      \
    ((((ULONG)&_hookExt->FileSystem->DriverObject->FastIoDispatch->_call -                    \
       (ULONG) &_hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch <    \
       (ULONG) _hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch )) && \
      hookExt->FileSystem->DriverObject->FastIoDispatch->_call )


//
// Undocumented ntoskrnl variable
//
extern PSHORT           NtBuildNumber;

//
// For the definitions in Winioctl.h
//
#undef DEVICE_TYPE
typedef UCHAR  BYTE;
typedef USHORT WORD;
typedef ULONG  DWORD;
typedef LONGLONG  DWORDLONG;
typedef PVOID SID;

//
// So that we can pick up NT 5.0 IOCTLs in WINIOCTL.h
//
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0500








