//======================================================================
// 
// Ioctlcmd.h
//
// Copyright (C) 1996 Mark Russinovich and Bryce Cogswell
//
// Common header file for device driver and GUI. Contains common
// data structure definitions and IOCTL command codes.
//
//======================================================================

//
// Define the various device type values.  Note that values used by Microsoft
// Corporation are in the range 0-32767, and 32768-65535 are reserved for use
// by customers.
//
#define FILE_DEVICE_FILEMON	0x00008300

//
// Version #
//
#define FILEMONVERSION    360

//
// commands that the GUI can send the device driver
//
#define FILEMON_setdrives   (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x00, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_zerostats   (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x01, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_getstats    (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x02, METHOD_NEITHER, FILE_ANY_ACCESS )
#define FILEMON_unloadquery (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x03, METHOD_NEITHER, FILE_ANY_ACCESS )
#define FILEMON_stopfilter  (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x04, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_startfilter (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x05, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_setfilter   (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x06, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_timetype    (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x07, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_version     (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x08, METHOD_BUFFERED, FILE_ANY_ACCESS )

//
// format of a data entry
//
typedef struct {
	ULONG	          seq;
    LARGE_INTEGER     time;
	char	          text[0];
} ENTRY, *PENTRY;

//
// Length of a filter definition string
//
#define MAXFILTERLEN 256

//
// Filter definition
//
typedef struct {
    char     processfilter[MAXFILTERLEN];
	char     excludeprocess[MAXFILTERLEN];
    char     pathfilter[MAXFILTERLEN];
    char     excludefilter[MAXFILTERLEN];
    BOOLEAN  logreads;
    BOOLEAN  logwrites;
} FILTER, *PFILTER;

//
// Define page size for use by GUI
//

#ifndef PAGE_SIZE
#if defined(_ALPHA_)
#define PAGE_SIZE 0x2000  // 8K
#else
#define PAGE_SIZE 0x1000  // 4K
#endif
#endif

//
// This determines the size of an output buffer
//
#define MAX_STORE	(PAGE_SIZE*16 - 8)

