+ C	TITLE	Houghton Mifflin Utility (HMFUNCTN)  C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C A C	Houghton Mifflin lower level routine to determine the code and  F C	index value for a word to be stored in the in-memory tables (cache,  C 	user and master). C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C 6 C AUTHOR: EX Houghton Mifflin	CREATION DATE: 24-JUN-83 C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C 3 C X01.02	Cathy Baker	 9-FEB-84	Split into own file.  C  C--   1 	SUBROUTINE lngspl$functn(codefn,indxfn,letter,n)  C++  C    FUNCTIONAL DESCRIPTION: C J C This subroutine is a basic tool to encode a word array 'letter', of 'n'  C characters, producing :  C 7 C  o  a longword 'codefn' to represent the word itself. J C  o  a 24-bit number 'indxfn' to represent the position of the word in a ; C     table, (top 8 bits of the supplied longword being 0).  C L C These codes are used to place the word in the in-memory dictionary tables ? C (master, cache and user). They are used directly in routines  D C LNGSPL$ADD_WORD_USER, LNGSPL$_DELETE_WORD_USER and LNGSPL$RAMVER. B C Furthermore, LNGSPL$RAMVER passes them on as output parameters. L C But all other callers just call this routine to then supply them as input   C parameters for LNGSPL$USERVER. C  C    CALLING SEQUENCE: C % C LNGSPL$FUNCTN              Callers: 0 C (codefn.wlu.r,    	LNGSPL$ADD_WORD_USER       - C  indxfn.wlu.r,	LNGSPL$DELETE_WORD_USER       C  letter.rlu.ra, ( C  n.rwu.r)		LNGSPL$RAMVER               C # C    			LNGSPL$VERIFY_WORD_MASTER   # C    			LNGSPL$VERIFY_WORD_USER     # C    			LNGSPL$GET_CORRECTION       # C    			LNGSPL$DELETE               # C    			LNGSPL$INSERT               # C    			LNGSPL$TRANSP               # C    			LNGSPL$REPLACE               C  C    FORMAL PARAMETERS: 5 C	codefn:		Coded word for storage in in-memory table. 6 C	indxfn:		Index value of where to put the coded word.. C	letter:		Array of letters of word to insert.$ C	n:		Number of letters in the word. C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS: C  C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER(a-z) 	INTEGER*2	k,n 	CHARACTER*1	letter(32)  C + c function used to calculate code and index 	 	codefn=0 	 	indxfn=0  	if(n.eq.0) return 	k=12 	codefn=ishft(ichar(letter(1)),8)+ichar(letter(n)) 	indxfn=codefn 10	k=k+1 	if(k.gt.n) return* 	alpha=ishft(iand(codefn,'77600000'o),-16)8 	beta=ior(ichar(letter(k)),ishft(iand(codefn,'177777'o),
 	1        8))  	codefn=alpha+alpha+alpha+beta. 	if(codefn.gt.16777212) codefn=codefn-16777213* 	alpha=ishft(iand(codefn,'77600000'o),-16)1 	beta=ior(ichar(letter(n+1-k)),ishft(iand(codefn,  	1        '177777'o),8)) 	codefn=alpha+alpha+alpha+beta. 	if(codefn.gt.16777212) codefn=codefn-16777213 	indxfn=indxfn+codefn 	 	go to 10    	END		!of lngspl$functn 