5 C	TITLE	Houghton Mifflin Corrector Utility (HMINSERT)  C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C A C	    Houghton Mifflin lower level routine used by the corrector:  C $ C	                     LNGSPL$INSERT C	 C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ( C X01.01	Nick Tatham	24-JUN-83	Original	 C 2 C X01.02	Martin Cook  	12-AUG-83	32 char. wrd fix	 C 8 C X01.03	Cathy Baker	13-JAN-84	Return if word >17chars,  C						speeding it up. C 3 C X01.04	Cathy Baker	 8-FEB-84	Split into own file. ! C						Changed INCLUDE statements  C						to logicals.  C--   8 	INTEGER*4 FUNCTION lngspl$insert(nword,usertab,ucorflg)   C++  C    FUNCTIONAL DESCRIPTION: C N C Operates on a word array 'letter'. 'letter' contains a misspelt word and is L C passed in via the common block LNGSPL$DATA_CORRECTOR (in the include file H C CORECTCOM.FOR). Changes 'letter' to form a new word in 'modlet', then G C tests 'modlet' against the master dictionary, and, if 'ucorflg' set,  C C against the user dictionary defined by 'usertab'. If 'modlet' is  J C verified as a proper word, it becomes one of the correction suggestions. C D C The word 'letter' is changed and tested repeatedly throughout its H C length, by INSERT-ing each other lower case letter from a-z, and '-', 5 C ''', and '.', between each pair of letters in turn.  C D C 'nword'  is passed back to LNGSPL$GET_CORRECTION, noting how many G C correction suggestions the routine has found and has placed into the  M C common array 'setlist'. If the misspelt word has a capcode of >2, (i.e. is  N C a mixed case or hyphenated word) no action is taken, 'nword' returned being  C 0. C I C Each 'modlet' formed is tested against the in-memory master dictionary, D C by calling LNGSPL$RAMVER. If the word is found, its hyphen map is M C retrieved. However, if 'modlet' is >4 letters, then the word is now tested  O C against the master dictionary on disk, calling LNGSPL$LOCATE with a 'locflg'  H C of 2 (to counteract error rate of LNGSPL$$RAMVER). If the word is not P C found in either master dictionary, and 'ucorflg' is set, it is tested against   C the user dictionary 'usertab'. C M C If 'modlet' is verified as a valid word, it added to the list of suggested  J C corrections 'setlist', together with its hyphen map in 'sethyp' and its I C capitalization code in 'setcap'. (These data structures are all part of * C the common block LNGSPL$DATA_CORRECTOR.) C  C    CALLING SEQUENCE: C P C  status.wlc.v = LNGSPL$INSERT            (Caller: LNGSPL$GET_CORRECTION)       C    			(nword.wlu.r,  C    		 	 usertab.rlu.ra,  C    		 	 ucorflg.rbu.r) C  C  C    FORMAL PARAMETERS:  C & C	nword:			Number of corrections found C % C	usertab:		User memory table address  C 1 C	ucorflg:		Flag set if correction possibilities  + C				derived are to be checked against the   C				user memory.  C  C    IMPLICIT INPUTS:  C ( C	Word to be corrected in array 'letter' C  C    IMPLICIT OUTPUTS: C > C	Correction found, with their hyphen maps and capitalization A C	codes in arrays 'setlist', 'sethyp', and 'setcap' respectively.  C  C    ROUTINE VALUE:  C H C    LNGSPL$_COMPLETED  or that obtained from the call to LNGSPL$LOCATE 5 C    			('iostat') which indicates why the disk read   C    			access failed. C  C    SIDE EFFECTS: C  C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .'   	IMPLICIT INTEGER*2 (a-z) # 	CHARACTER*1	charspc(3),modskel(14)  	INTEGER*2	lngspl$locate; 	INTEGER	hyp4,lngspl$ramver,check,indxfn,codefn,usertab(*),  	1       lngspl$userver  	INTEGER*4	iostat  	LOGICAL*1	ucorflg 	BYTE		locflg,ondisk 	DATA		charspc/'-','''','.'/ 	INCLUDE		'corectcom/list' 	INCLUDE		'globalsym/list' C ( 	lngspl$insert = %loc(lngspl$_completed) 	nword=0!         if (lengthw.gt.17) return ' 	if(lengthw.le.3.or.capcode.gt.2)return 8 c insert all possible letters into each location of word 	do 50 kp1=lengthw+1,1,-1    	do 40 j=94,122 % 	if(ichar(modlet(kp1)).eq.j) go to 40  	modlet(kp1)=char(j)& 	if(j.lt.97) modlet(kp1)=charspc(j-93)9 	check=lngspl$ramver(modlet,lengthw+1,hyp4,indxfn,codefn,  	1                ondisk) 	 	capdic=0 5 	if(check.ne.%loc(lngspl$_correct_spelling)) go to 10 : c if candidate is longer than 4 chars,generate skelton and: c check against disk to ensure error rate does not produce c misspellings 	if(lengthw+1.le.4) go to 20 	lengthm=lengthw+1* 	call lngspl$rules(modlet,modskel,lengthm)	 	locflg=2 6 	check=lngspl$locate(modskel,lengthm,modlet,lengthw+1,9 	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(check.lt.0) go to 1000 	if(check.gt.0) go to 208 c if flag is on, check candidate against user dictionary 10	if(.not.ucorflg) go to 408 	if(modlet(lengthw+1).eq.'s') call lngspl$functn(codefn,# 	1         indxfn,modlet,lengthw+1) 9 	check=lngspl$userver(indxfn,codefn,capcode,usertab,hyp4, $ 	1                 capdic,lengthw+1)5 	if(check .eq. %loc(lngspl$_word_not_found)) go to 40  20	nword=nword+15 c supply word and hyphen map as alternative spellings  	do 30 i=1,lengthw+1  30	setlist(nword)(i:i)=modlet(i) 	sethyp(nword)=hyp4  	setcap(nword)=capdic  40	continue ' 	if(kp1.gt.1) modlet(kp1)=letter(kp1-1)  50	continue  	do 60 m=1,lengthw+1 60	modlet(m)=letter(m) 	return 
 1000	continue  	lngspl$insert = iostat  	return    	END			! of lngspl$insert 