6 C	TITLE	Houghton Mifflin Corrector Utility (HMRESCASE) C++  C			COPYRIGHT (c) 1984, 1985 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C A C	    Houghton Mifflin lower level routine used by the corrector:  C % C	                     LNGSPL$RESCASE  C	 C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ( C X01.01	Nick Tatham	24-JUN-83	Original	 C 2 C X01.02	Martin Cook  	12-AUG-83	32 char. wrd fix	 C 3 C X01.03	Cathy Baker	 8-FEB-84	Split into own file.  C > C X01.04	Ian Kirkham	14-Jan-85	Add tests for capitalization of  C						letters, not just done on C						All-Upper-Case words  C  C--   : 	SUBROUTINE LNGSPL$RESCASE(setlist,setcap,capcode,caseflg,  	1                      		nword) C++  C    FUNCTIONAL DESCRIPTION: C I C This routine is called when LNGSPL$GET_CORRECTION has formed a list of  O C correction suggestions in 'setlist'. 'setlist' stores all words in lowercase  O C unless they are mixed-case words (capcode=5), when they are stored correctly.  C F C Supplied with a list of 'nword' corrections in 'setlist', and their D C dictionary-defined capitalization codes in 'setcap', this routine L C updates 'setlist' to show either their dictionary-defined capitalization, 3 C or that of the misspelt word given in 'capcode'.   C B C The routine looks at the boolean 'caseflg'; if this flag is set J C then 'capcode' must be taken into consideration, and the capitalization 8 C of the correction then depends on the following rules: C @ C o  if the misspelt word is all u.c., make all corrections u.c. C I C o  if the misspelt word is init. cap, and the correction's code is NOT  - C    all u.c., make the correction init. cap.  C C C o  if the misspelt word is init. cap or cap-after-the-hyphen, and H C    the correction's code is cap-after-the-hyphen or init.-cap-and-cap F C    -after-the-hyphen, then make the correction cap-after-the-hyphen. C  C    CALLING SEQUENCE: C H C       LNGSPL$RESCASE             (Caller : LNGSPL$GET_CORRECTION)      C 	(setlist.mlu.ra,  C  	 setcap.rlu.ra,  C  	 capcode.rlu.r,  C  	 caseflg.rbu.r,  C  	 nword.rwu.r)  C  C    FORMAL PARAMETERS: ! C	setlist:		Array of Corrections  5 C	setcap:			Array of dictionary capitalization codes   C				for the corrections. 6 C	capcode:		Capitalization code for the misspelt word.3 C	caseflg:		Flag set if 'capcode' to be taken into   C				consideration. ! C	nword:			Number of corrections.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS: C  C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*32	setlist(25)  	BYTE		setcap(25)  	LOGICAL*1	caseflg C 9 c based on caseflg,modify case of all words in setlist to 5 c reflect either dictionary cap or form of input word  	do 200 j=1,nword  	ind=setcap(j) 	if(.not.caseflg) go to 10 	if(capcode.eq.2) ind=capcode 2 	if(capcode.eq.1 .and. setcap(j).ne.2) ind=capcode* 	if((capcode.eq.1 .or. capcode.eq.3) .and./ 	1  (setcap(j).eq.3 .or. setcap(j).eq.4)) ind=3 % 10	go to (200,20,30,50,60,200), ind+1  c initial cap only 20	let=ichar(setlist(j)(1:1)) , 	if((let.ge.'141'o .and. let.le.'172'o) .or., 	1  (let.ge.'340'o .and. let.le.'357'o) .or.( 	2  (let.ge.'361'o .and. let.le.'375'o))$ 	3      setlist(j)(1:1)=char(let-32)
 	go to 200
 c all caps! 30	length=index(setlist(j),' ')-1  	if(length.eq.-1) length=32    	do 40 i=1,length  	let=ichar(setlist(j)(i:i)) , 	if((let.ge.'141'o .and. let.le.'172'o) .or., 	1  (let.ge.'340'o .and. let.le.'357'o) .or.( 	2  (let.ge.'361'o .and. let.le.'375'o))$ 	3      setlist(j)(i:i)=char(let-32) 40	continue 
 	go to 200" c initial cap and cap after hyphen 50	let=ichar(setlist(j)(1:1)) , 	if((let.ge.'141'o .and. let.le.'172'o) .or., 	1  (let.ge.'340'o .and. let.le.'357'o) .or.( 	2  (let.ge.'361'o .and. let.le.'375'o))$ 	3      setlist(j)(1:1)=char(let-32)! 60	length=index(setlist(j),' ')-1  	if(length.eq.-1) length=32    	do 70 i=1,length $ 	if(setlist(j)(i:i).eq.'-') go to 80 70	continue ! 80	let=ichar(setlist(j)(i+1:i+1)) , 	if((let.ge.'141'o .and. let.le.'172'o) .or., 	1  (let.ge.'340'o .and. let.le.'357'o) .or.( 	2  (let.ge.'361'o .and. let.le.'375'o))( 	3      setlist(j)(i+1:i+1)=char(let-32) 200	continue 	return    	END		! of lngspl$rescase 