, C	TITLE	Houghton Mifflin Utility (LHMDELUSR) C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C H C	Houghton Mifflin entry point routine to delete a word from a specific  C	user memory dictionary:  C  C			LNGSPL$DELETE_WORD_USER  C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C : C X01.02	Cathy Baker 	13-JAN-84      Added code to improve) C					       hyphenation storage in user   C					       memory. C 3 C X01.03	Cathy Baker	 9-FEB-84	Split into own file.   C						Changed INCLUDE statement C						to use a logical. C--   7 	INTEGER FUNCTION lngspl$delete_word_user(word,usertab)  C++  C    FUNCTIONAL DESCRIPTION: C G C Does the reverse of LNGSPL$ADD_WORD_USER, deleting the entry for the   C parameter 'word'.  C I C When the word's 'codefn' is found in 'usertab', extracts the dictionary K C entry for the capitalization code. If just one of the dictionary capcode  L C or the word's capcode is 3, returns 'lngspl$_word_not_found' because it is7 C indeterminate whether the capcode is actually 4 or 5.  C  C    CALLING SEQUENCE: C 2 C	status.wlc.v = LNGSPL$DELETE_WORD_USER		Calling:) C    			(word.rt.dx,     		LNGSPL$LOWCASE , C	          	 usertab.mlu.ra)		LNGSPL$FUNCTN C  C    FORMAL PARAMETERS:  C	word:			Word to delete. - C	usertab:		User memory from which to delete.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C  C LNGSPL$_COMPLETED  C LNGSPL$_WORD_NOT_FOUNDA C LNGSPL$_ILLEGAL_STRING:	' 0 < word_length < 32 ' does not apply  C ? C LNGSPL$_NOT_INITIALIZED:	'usertab(2)' should contain the info . C    				planted by LNGSPL$INITIALIZE_VERIFIER C    				and does not. C    SIDE EFFECTS: C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER(a-z) 	CHARACTER*(*)	word  	DIMENSION	usertab(*)  	INTEGER*2	length,capcode  	CHARACTER*1	letter(32)  	INCLUDE		'globalsym/list' C  c check for not initialized 6 	lngspl$delete_word_user=%loc(lngspl$_not_initialized)@ 	if(usertab(2).ne.ishft(usertab(1),-4).and.(usertab(2).ne.255))       &  return c initialize 	length=index(word,' ')-1 " 	if(length.eq.-1) length=len(word)5 	lngspl$delete_word_user=%loc(lngspl$_illegal_string)  	if(length.gt.32)return  	do 10 i=1,length  10	letter(i)=word(i:i) 	do 20 i=length+1,32 20	letter(i)=' ' 	size=usertab(1) 	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)  c reduce word to lower case + 	call lngspl$lowcase(letter,length,capcode) 
 	cap4=capcode  	if(cap4.gt.3) cap4=3 : c calculate code and position in table(i.e. ind ) for word0 	call lngspl$functn(codefn,indxfn,letter,length) 	code=iand(codefn,'17777777'o)$ 	if(code.ge.'17777776'o) code=code-2 	ind=iand(indxfn,size)# 	if(ind.gt.maxindx) ind=ind-maxindx 	 	rehash=0  	q=iand(code,'177'o) 	a=3-q8 c if location 'i' of usertab is unused,word is not found
 30	i=ind+5;   	if(iand(usertab(i),'17777777'o).eq.'17777777'o) go to 60 7 c if code and capitalization match ,word can be deleted 2 	if(iand(usertab(i),'17777777'o).ne.code) go to 352 	capdic=ishft(iand(usertab(i),'00060000000'o),-22), c compare case of input word with dictionary 	if(capdic.eq.cap4) go to 70( 	if(capdic.eq.3 .or. cap4.eq.3) go to 60 	if(capdic.lt.cap4) go to 70	 	go to 60 ' c try next location if rehash < maxrhsh ! 35	if(rehash.gt.maxrhsh) go to 60  	rehash=rehash+1 	a=a+q+q
 	ind=ind+a c watch for table wrap around  40	if(ind.lt.maxindx) go to 30 	ind=ind-maxindx	 	go to 40  c word not found9 60	lngspl$delete_word_user = %loc(lngspl$_word_not_found)  	return  c delete code from location 'i'  70	usertab(i)='17777776'o 2 	lngspl$delete_word_user = %loc(lngspl$_completed) c ( c***************************************) c delete word from user word list on disk ( c*************************************** c  	return ! 	END		!of lngspl$delete_word_user 