; C	TITLE	CUSINIVO - Custom verifier - Initialize verifier VO  C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C 9 C	Houghton Mifflin entry point routine to initialize the  4 C	master dictionary and a specified user dictionary: C + C			LNGSPL$INITIALIZE_VERIFIER_CUSTOMISABLE  C < C	Used in Verifier Only kit for the customisable dictionary,% C		returning LNGSPL$_CORRECTOR_ABSENT  C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Ian Kirkham		CREATION DATE: 20-Sep-84  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C 8 C X01.01	Ian Kirkham	20-Sep-84	Created from LHMINIVO.FOR C  C--   6 	INTEGER FUNCTION lngspl$initialize_verifier*4(master,  	1    ramfile,corr,size,usertab) C++  C    FUNCTIONAL DESCRIPTION: C Q C The boolean parameter 'corr' is ignored as this is only to support the verifier E C only version.  The return status will be 'LNGSPL$_CORRECTOR_ABSENT'  C 	 C Opens : F C	o   the shareable library image dictionary 'ramfile', defaulting to J C	    SYS$LIBRARY and .EXE. Calls CUSMAP_OPEN for this purpose and to map  C	    it into memory.  C  C Initializes : > C		o  the user dictionary table 'usertab' of 'size' longwords 	 C			with: 7 C		     i) 7 longwords of control info based on 'size':  C			Array pos (1): 'size' - 1 ' C				  (2): size of hyphen map section. ' C				  (3): index for position of last   C					dictionary word stored. * C				  (4): capacity for dictionary words.+ C				  (5): 0, i.e. no of dictionary words   C					currently stored. , C				  (6)/(7): 1, i.e. reserved for future.5 C		    ii)	1 s for the area that can be covered with  , C			dictionary words when the table is used.; C		   iii) 0 s for the remaining unused word area, and the   C			hyphen map area. C ( C Sets a control variable VERINIT to 25. C  C	Calling sequence:  C 8 C  status.wlc.v = LNGSPL$INITIALIZE_VERIFIER	Calling..		' C		(master.rt.dx,			CUSMAP_OPEN (Bliss)  C		 ramfile.rt.dx, C		 corr.rbu.r,  C		 size.rlu.r,  C		 usertab.wlu.ra)  C  C    FORMAL PARAMETERS: 5 C	master:			Name of master dictionary file (not used) 5 C	ramfile:		Name of master dic EXE file to be mapped   C				into memory. (not used)8 C	corr:			Flag set if corrector is available. (not used)1 C	size:			Size in longwords of user memory array. 0 C				Must be a power of 2 between powers 11 and 1 C				15 inclusive, i.e. 2048, 4096, 8192, 16384,   C				or 32678., C	usertab:		User memory array start address. C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C  C	LNGSPL$_COMPLETED ' C			or if a file cannot be opened, the   C			status from that failure.  C  C    SIDE EFFECTS: C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z) $ 	INTEGER*4	status,cusmap_open,iostat 	CHARACTER*(*)	master,ramfile  	LOGICAL*1	corr  	INTEGER*4	usertab(*),size,i 	INCLUDE		'cusmascom/list' 	INCLUDE		'globalsym/list' C % C open table ram file shareable image  	status = cusmap_open()  	if(status) goto 400 C problems with table file$ 	lngspl$initialize_verifier = status 	return  400	continueI C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ + C initialize user specific dictionary table    	usertab(1)=size-1  	usertab(2)=ishft(usertab(1),-4)& 	if (usertab(2).gt.255) usertab(2)=255# 	usertab(3)=usertab(1)-usertab(2)-7 + 	usertab(4)=ishft(size,-1) + ishft(size,-2) 
 	usertab(5)=0    	do 50 i=6,usertab(3)  	usertab(i)='17777777'o  50	continue  	do 60 i=usertab(3)+1,size
 	usertab(i)=0  60	continue K C The main dictionary has been initalized into the same format as 'usertab' I C thus the initialization need not be done again at runtime.  Set No-Corr < 	lngspl$initialize_verifier = %loc(lngspl$_corrector_absent) 	verinit=25  	return  500	continue 	call errsns(,,,,iostat)$ 	lngspl$initialize_verifier = iostat 	return ! 	END		! of lngspl$initialize_user 