+ C	TITLE	Houghton Mifflin Utility (HMBISRCH)  C++ ! C			  COPYRIGHT (c) 1984, 1985 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C E C	Houghton Mifflin lower level routine to determine the block number  ( C	on disk that contains a specific word: C  C				LNGSPL$BISRCH C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C 6 C AUTHOR: EX Houghton Mifflin	CREATION DATE: 24-JUN-83 C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C 7 C X01.02	Cathy Baker	 9-FEB-84	Separated into own file. ! C						Changed include statement   C						to a logical. C > C X01.03	Catherine B.	 25-APR-84	New 385Kb dictionary support. C : C X01.04	Catherine B.	 23-MAY-84	Changed dimensions of UB  C						for 435Kb dictionary. C						Moved this value as   C						'pointer_size' into# C						mastercom.for to reduce no.  $ C						of files needing modification% C						when updating dictionary size.  C = C X01.05	Ian Kirkham	14-Jan-85	Add in fix in search algorithm % C						to allow the use of the larger  C						lexicons. C--   / 	INTEGER FUNCTION lngspl$bisrch *2 (key,nxtblk)  C++  C    FUNCTIONAL DESCRIPTION: C M C Function returns the number of the block on disk (in the master dictionary  N C file) from 1-780, that contains the words whose skeltons begin as specified F C in 'key'. 'key' indicates which block contains the 'skelton' of the  C word you wish to locate. C I C 'nxtblk' is a boolean, set if the caller should search both the return  8 C value block and the following block of the dictionary. C H C The master dictionary is searched using a binary-split search method. L C Each block of the dictionary is associated with a 5-bit code in the array H C 'pointer'. ('pointer' is part of the common block LNGSPL$DATA_MASTER.)H C This number is compared with the value of 'key'. If there is a direct M C match, 'nxtblk' is set. Otherwise, the block number to return is the lower  % C number (lb) from the binary search.  C  C    CALLING SEQUENCE: C 4 C	block.wwu.v = LNGSPL$BISRCH              ( Caller:5 C    	      		(key.rlu.r,		   LNGSPL$LOCATE  )         C    	       		 nxtblk.wbu.r)  C  C    FORMAL PARAMETERS:  C   C	key:					Index into 'pointer'.* C	nxtblk:					Flag set if both the return * C    						value block and the next block  C						should be searched. C    IMPLICIT INPUTS: * C	Pointer					Index table into dictionary. C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE: $ C	Number of block to search on disk. C  C    SIDE EFFECTS: C  C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z)      	INTEGER*4	key 	BYTE 		nxtblk 	INCLUDE 	'mastercom/list' 	INCLUDE		'verifycom/list' C ? c binary search pointer table for first block with pointer less  c than 'key'	 	nxtblk=0  	lb=0          ub=pointer_size  10	if(ub-lb.ge.2) go to 20> c no exact match in pointer table.first block with record less c than key must be block lb  	lngspl$bisrch=lb  	if(lb.eq.0) lngspl$bisrch=1" 	if(lb.eq.pointer_size-1) nxtblk=1 	return   20	lngspl$bisrch=ishft(ub+lb,-1)+ 	if(key.lt.pointer(lngspl$bisrch)) go to 40 + 	if(key.gt.pointer(lngspl$bisrch)) go to 50  c exact match in pointer table 	lngspl$bisrch=lngspl$bisrch-1	 	nxtblk=1  	return  c bisect range of search 40	ub=lngspl$bisrch 	 	go to 10  50	lb=lngspl$bisrch 	 	go to 10    	END		!of lngspl$bisrch 