+ C	TITLE	Houghton Mifflin Utility (HMRAMVER)  C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C @ C	Houghton Mifflin lower level routine to verify whether a word 0 C	is present in the in-memory master dictionary: C  C				LNGSPL$RAMVER C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C 3 C X01.02	Cathy Baker	 9-FEB-84	Split into own file. " C						Changed INCLUDE statements  C						to use logicals.  C A C X01.03	Catherine Baker	 26-APR-84	New 385Kb dictionary support.  C ? C X01.04	Catherine Baker	 11-JUN-84	Added D_lines for code that   C						is to be included in the & C						performance build. This avoids ' C						the need for a separate copy of  ' C						this module (RAMVERMOD). D-line  % C						code prevents search in cache.  C  C--   9 	INTEGER FUNCTION lngspl$ramver*4(letter,lengthw,hyphens, ' 	1                indxfn,codefn,ondisk)  C++  C    FUNCTIONAL DESCRIPTION: C J C  For word 'letter' of length 'lengthw', generates 'indxfn' and 'codefn' F C  by calling LNGSPL$FUNCTN; uses these codes to search the in-memory N C  dictionary table 'vertab' and the 'cache' table. (If 'letter' ends in 's', 7 C  this is stripped off before calling LNGSPL$FUNCTN.)   C H C If word is found in 'vertab', its hyphen map is returned in 'hyphens'.F C If the word is found in 'cache' and its hyphen map is 1-byte of '1'sI C followed by 3 bytes of '0's, then the word is a misspelling discovered  P C previously, so the boolean 'ondisk' is set to 0, and 'lngspl$_word_not_found'  C returned.  C  C    CALLING SEQUENCE: C 1 C status.wlc.v  = LNGSPL$RAMVER          Callers: 1 C    		(letter.rlu.ra,		LNGSPL$VERIFY_WORD_MASTER 3 C    		 lengthw.rwu.r,		LNGSPL$DELETE               3 C    		 hyphens.wlu.r,		LNGSPL$INSERT               2 C    		 indxfn.wlu.r,		LNGSPL$REPLACE             2 C    		 codefn.wlu.r,		LNGSPL$TRANSP               C    		 ondisk.wbu.r)  C  C  C    FORMAL PARAMETERS: C C	letter,lengthw:		Word to be verified and its length in characters < C	hyphens:		Hyphen map of word if it is found in dictionary.9 C	indxfn,codefn:		Codes derived and used to locate word,  # C				returned as output parameters. 7 C	ondisk:			Flag cleared if this word was one verified  3 C				before, not found then, and placed into cache.  C  C    IMPLICIT INPUTS: ( C	Vertab:			Master dictionary in memory. C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C  C	LNGSPL$_WORD_NOT_FOUND C	LNGSPL$_CORRECT_SPELLING C  C    SIDE EFFECTS: C  C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*1	letter(32) 7 	INTEGER smap,indxfn,codefn,hyphens,offset,i,j,indcach,  	1       code,ind 
 	BYTE		ondisk  	INCLUDE 	'mastercom/list' 	INCLUDE 	'verifycom/list' 	INCLUDE 	'globalsym/list' C : c strip off word-final 's' ,set smap and decrement lengthw
 c accordingly  	smap=0 
 	n=lengthw 	if(letter(n).ne.'s') go to 10 	smap='20000000'o  	n=lengthw-1 c calculate code and ind- 10	call lngspl$functn(codefn,indxfn,letter,n) + 	lngspl$ramver=%loc(lngspl$_word_not_found)  	if(lengthw.gt.21) return  	code=iand(codefn,'17777777'o) 	ind=iand(indxfn,'3777'o) 7 c initialize in preparation for search of in-ram tables 	 	ondisk=1 	 	offset=1 ) c look for code in position 'i' of vertab  20	i=ind+offset 3   	if(iand(vertab(i),'17777777'o).ne.code) go to 30 0   	if(iand(vertab(i),'40000000'o).ne.0) go to 501 	if(iand(vertab(i),'20000000'o).eq.smap) go to 50 * c rehash within vertab,look for code again- 30	j=ind+3+ishft(iand(indxfn,'3770000'o),-12)  	if(j.ge.2047) j=j-2047  	i=j+offset 1 	if(iand(vertab(i),'17777777'o).ne.code) go to 40 0   	if(iand(vertab(i),'40000000'o).ne.0) go to 501 	if(iand(vertab(i),'20000000'o).eq.smap) go to 50  40	offset=offset+2048  	if(offset.le.6144) go to 20> C If this is a performance build, compiled /D-lines, the cache C table is not searched. D       return    0 c calculate new ind,look for code in cache table  60	indcach=iand(indxfn,'377'o)+14 	if(iand(cache(indcach),'17777777'o).ne.code) return c code matches. check 's' map 3 	if(iand(cache(indcach),'40000000'o).ne.0) go to 70 4 	if(iand(cache(indcach),'20000000'o).ne.smap) return9 c match in cache table.check hyphen map for a misspelling . 70	hyphens=iand(cache(indcach),'37700000000'o)' 	if(hyphens.ne.'37700000000'o) go to 80 	 	ondisk=0  	return $ c correct spelling.return hyphen map/ 80	lngspl$ramver=%loc(lngspl$_correct_spelling)  	return " c word was found.supply hyphen map1 50	lngspl$ramver = %loc(lngspl$_correct_spelling) ' 	hyphens=iand(vertab(i),'37700000000'o)  	return    	END		!of lngspl$ramver 