, C	TITLE	Houghton Mifflin Utility (LHMADDUSR) C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C C C	Houghton Mifflin entry point routine to add a word to a specific   C	user memory dictionary:  C  C			LNGSPL$ADD_WORD_USER C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C : C X01.02	Cathy Baker 	13-JAN-84      Added code to improve) C					       hyphenation storage in user   C					       memory. C 3 C X01.03	Cathy Baker	 9-FEB-84	Split into own file.   C						Changed INCLUDE statement C						to use a logical. C--   4 	INTEGER FUNCTION lngspl$add_word_user(word,hyphens, 	1       usertab)  C++  C    FUNCTIONAL DESCRIPTION: C O C Makes a word entry for 'word' with hyphen map 'hyphens' into user dictionary   C table 'usertab'.   C L C Calls LNGSPL$LOWCASE to generate the word's capitalization code 'capcode' I C and to reduce the word to lowercase if its capcode is <=2. If 'capcode' C C returned is >3 makes it = 3, since will be stored as 2 bits only.  C P C Then calls LNGSPL$FUNCTN to generate two longword codes 'codefn' and 'indxfn' N C from the characters in the word, representing the word, and where to put it . C in the user dictionary table, respectively.  C L C An appropriate empty longword is found in the dictionary table using 'ind'N C generated initially from AND-ing 'indxfn' with the size of 'usertab'. 'ind' C C is altered using a hashing technique, and 'usertab' probed until:  C > C    o   an empty slot is found (bottom 22 bits are all 1 's) A C    o   'code' is found : returns 'lngspl$_word_already_exists'  J C    o   the maximum no. of hashes is reached : 'lngspl$_user_memory_full' C I C Into 'usertab' enters one longword that contains a set of bit patterns,  C from low to high order bits: C A C       o  its code, 22 bits:	bottom 22 bits of longword 'codefn' * C       o  its captilization code, 2 bits: C    							00 lowcase C    							01 init cap  C    							10 uppercase C    							11 mixed case  C H C       o  an index to the location of its hyphen map 'hyphens', 8 bits: C J C    	  If the word is > 9 chars, enters the full longword 'hyphens' into D C    	  the hyphen map section of 'usertab' and an index entry here.G C    	  If the word is <=9 chars, then 'hyphens' will fit in 8 bits so  0 C    	  the top 8 bits of 'hyphens' is entered.  C I C If the word already exists, this routine may change the capitalization  I C code entry in the dictionary, depending on that of the input word. The  E C dictionary always stores the lowest-number-of-capitals version from  C a capcode of 0 to 2. C  C    CALLING SEQUENCE: C / C	status.wlc.v = LNGSPL$ADD_WORD_USER		Calling: ) C    			(word.rt.dx,     		LNGSPL$LOWCASE ( C 	 	 	 hyphens.rlu.r,   		LNGSPL$FUNCTN C    	 	 	 usertab.mlu.ra) C  C    FORMAL PARAMETERS:  C	word:			Word to add.& C	hyphens:		Hyphen map of word to add.( C	usertab:		User memory to which to add. C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C  C LNGSPL$_COMPLETED  C LNGSPL$_WORD_ALREADY_EXISTS F C LNGSPL$_USER_MEMORY_FULL:      'usertab(5)' i.e. no of word entries + C    				 > 'usertab(4)' i.e. word capacity  C A C LNGSPL$_ILLEGAL_STRING:	' 0 < word_length < 32 ' does not apply  C ? C LNGSPL$_NOT_INITIALIZED:	'usertab(2)' should contain the info . C    				planted by LNGSPL$INITIALIZE_VERIFIER C    				and does not. C    SIDE EFFECTS: C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER(a-z) 	CHARACTER*(*)	word  	DIMENSION	usertab(*)  	INTEGER*2	capcode,length  	CHARACTER*1	letter(32)  	INCLUDE		'globalsym/list' C  c check for not initialized 3 	lngspl$add_word_user=%loc(lngspl$_not_initialized) @ 	if(usertab(2).ne.ishft(usertab(1),-4).and.(usertab(2).ne.255))       &  return c check for user table full ' 	if(usertab(5).gt.usertab(4)) go to 110  c initialize 	length=index(word,' ')-1 " 	if(length.eq.-1) length=len(word)2 	lngspl$add_word_user=%loc(lngspl$_illegal_string) 	if(length.gt.32) return 	do 10 i=1,length  10	letter(i)=word(i:i) 	do 20 i=length+1,32 20	letter(i)=' ' 	size=usertab(1) 	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)  c reduce word to all lower case + 	call lngspl$lowcase(letter,length,capcode) 
 	cap4=capcode  	if(cap4.gt.3) cap4=3 : c calculate code and position in table(i.e. ind ) for word0 	call lngspl$functn(codefn,indxfn,letter,length) 	code=iand(codefn,'17777777'o)$ 	if(code.ge.'17777776'o) code=code-2 	ind=iand(indxfn,size)# 	if(ind.gt.maxindx) ind=ind-maxindx 	 	rehash=0  	q=iand(code,'177'o) 	a=3-q8 c if location 'i' of usertab is unused,word can be added
 30	i=ind+5;   	if(iand(usertab(i),'17777777'o).eq.'17777777'o) go to 70 7 c if code is found in location 'i' ,word already exists 2 	if(iand(usertab(i),'17777777'o).eq.code) go to 60' c try next location if rehash < maxrhsh   	if(rehash.gt.maxrhsh) go to 110 	rehash=rehash+1 	a=a+q+q
 	ind=ind+a c watch for table wrap around  40	if(ind.lt.maxindx) go to 30 	ind=ind-maxindx	 	go to 40  c word already exists 3 60	lngspl$add_word_user = %loc(lngspl$_word_exists) 8 c compare case of input word with dictionary case.change c dictionary case if necessary2 	capdic=ishft(iand(usertab(i),'00060000000'o),-22) 	if(capdic.eq.cap4) return& 	if(capdic.eq.3 .or. cap4.eq.3) return 	if(capdic.lt.cap4) return* c change case in dictionary to match input/ 	lngspl$add_word_user = %loc(lngspl$_completed) 5 	usertab(i)=ior(iand(usertab(i),'37717777777'o),ishft  	1          (cap4,22)) 	return 2 c insert code and capitalization into location 'i'& 70	usertab(i)=ior(code,ishft(cap4,22)) 	usertab(5)=usertab(5)+1/ 	lngspl$add_word_user = %loc(lngspl$_completed)  c ( c***************************************$ c add word to user word list on disk( c*************************************** c & c insert hyphenation into location 'i', 	if(length.lt.10 .or. hyphens.eq.0) go to 80) 	mi=ior(hyphens,ishft(hyphens,length-33)) 1 	mi=ishft(iand(mi,'37777760000'o),-13) + iand(mi,  	1        '17777'o)  	if(mi.gt.8190) mi=mi-8191 	mi=iand(mi,usertab(2)) # 	if(usertab(size-mi).eq.0) go to 90 * 	if(usertab(size-mi).eq.hyphens) go to 100 	mi=mi+1# 	if(usertab(size-mi).eq.0) go to 90 * 	if(usertab(size-mi).eq.hyphens) go to 100 	mi=mi+1# 	if(usertab(size-mi).eq.0) go to 90 * 	if(usertab(size-mi).eq.hyphens) go to 100
 	hyphens=0: 80	usertab(i)=ior(usertab(i),iand(hyphens,'37700000000'o)) 	return  90	usertab(size-mi)=hyphens + 100	usertab(i)=ior(usertab(i),ishft(mi,24))  	return  c user memory space full9 110	lngspl$add_word_user = %loc(lngspl$_user_memory_full)  	return  	END		!of lngspl$add_word_user