+ C	TITLE	Houghton Mifflin Utility (LHMCORVC)  C++  C			  COPYRIGHT (c) 1984 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C : C	Houghton Mifflin entry point routine to find corrections C	for a misspelt word: C  C			LNGSPL$GET_CORRECTION  C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C 9 C X01.02	Cathy Baker	 9-FEB-84	Changed INCLUDE statements  C						to use logicals.  C : C X01.03	Cathy Baker	 4-JUN-84	Made some simplifications,  C						approved by Houghton. C--   7 	INTEGER FUNCTION lngspl$get_correction *4(word,caserr, - 	1  caseflg,ucorflg,usertab,try,list,hyphens)  C++  C    FUNCTIONAL DESCRIPTION: C K C Suggests a list of up to 30 words as suitable corrections for a misspelt  M C 'word'. Returns a correction list in 'list', plus an array of hyphen maps,  
 C 'hyphens'.   C L C Parameters 'try' and 'list' are updated by this routine, until the return P C status is 'lngspl$_limit_exceeded', meaning no more suggestions are available.N C The entry point into the routine is determined by the value of 'try'. (Also,K C the order of tries 3-7 is changed if the word is exactly 4 letters long.)  C  C'try' 1 :  = C    	initializes -  	this call's corrections list, 'setlist'  C    			hyphen array, 'sethyp'< C    			related data from common block LNGSPL$DATA_CORRECTOR C I C    	converts the word to lowercase, copying it into scratchpad 'modlet'  C B C    	generates word's skeleton, in 'skelton' calling LNGSPL$RULES C D C    	If 'caserr' flag NOT set, immediately continues with 'try' 2. = C    	If 'caserr' flag set, means that the verifier returned  L C    	'lngspl$_case_incorrect' for this word. Searches for case corrections 	 C    	in:  C  C    		user dictionary  C    		master dictionary on disk
 C'try' 2 : C D C    	calls LNGSPL$TRANSP to transpose each pair of letters in turn F C    	and test against the dictionaries. If the transposed version is C C    	verified by a dictionary, it is added to 'setlist', i.e. the  8 C    	list of new suggestions from this particular call. C 'try' 3 :  C B C    	calls LNGSPL$REPLACE to replaced each letter with all other E C    	possible letters in turn. If the replaced version is verified,   C    	added to 'setlist'.  C 'try' 4 :  C @ C    	calls LNGSPL$DELETE to delete each letter in turn. If the 7 C    	deleted version is verified, added to 'setlist'.   C 'try' 5 :  C F C    	calls LNGSPL$INSERT to insert each possible letter between each J C    	pair of letters in turn. If the inserted version is verified, added  C    	to 'setlist'.  C 'try' 6 :  C F C    	calls LNGSPL$LOCATE to search the master dictionary on disk for F C    	each word having the same skeleton as the misspelt word.  Those # C    	found are added to 'setlist'.  C 'try' 7 :  C D C    	calls LNGSPL$TARGET to apply a set of upto 72 rules to change I C    	the misspelt word's skeleton and generate another. After doing so,  ? C    	the actions of 'try' 6 are done on the modified skeleton.  C I C The routine is not exited until a new set of corrections is generated,  H C which may be after one or more increments of 'try'. When at least one  C new correction is available: C J C    i)	the case of corrections is changed according to value of 'caseflg' C    	calling LNGSPL$RESCASEI C   ii) duplicate suggestions are removed, and new ones are added to the  A C    	parameter 'list', from 'setlist', by calling LNGSPL$DUPWORD  C  C    CALLING SEQUENCE: C 1 C status.wlc.v = LNGSPL$GET_CORRECTION		Calling.. % C    	 	(word.rt.dx,			LNGSPL$LOWCASE ) C    	    	 caserr.rbu.r,			LNGSPL$FUNCTN ' C    		 caseflg.rbu.r,			LNGSPL$USERVER % C    		 ucorflg.rbu.r,			LNGSPL$RULES & C    		 usertab.rlu.ra,		LNGSPL$LOCATE. C    		 try.mlu.r,			corrector only routines..# C    		 list.mt.ds,			LNGSPL$TRANSP ' C    		 hyphens.wlu.ra)		LNGSPL$REPLACE  C    						LNGSPL$DELETE C    						LNGSPL$INSERT C    						LNGSPL$DUPWORD  C     						LNGSPL$TARGET  C    						LNGSPL$RESCASE  C  C    FORMAL PARAMETERS:  C P C 'try' -  storing the number of times that this routine has been called with a  C          particular word. K C 'list' -  the list of corrections that the routine has so far suggested,  5 C     	    from all calls using this particular word.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: C	None.  C  C    ROUTINE VALUE:  C  C lngspl$_completed H C lngspl$_limit_exceeded :	no more corrections, or maximum of 30 reachedD C lngspl$_illegal_string :  	'0 < word_length < 32 ' does not apply.? C lngspl$_not_initialized :  	control variable 'verinit' <> 25.  C 8 C The status can also be that from a failed disk access. C  C    SIDE EFFECTS: C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*(*)	word,list( 	INTEGER*4	lngspl$transp,lngspl$replace,& 	2		lngspl$delete,lngspl$insert,iostat 	BYTE		locflg,skeldone6 	INTEGER		indxfn,codefn,lngspl$userver,try,usertab(*), 	2       	hyp4,hyphens(30) 	CHARACTER*1	modskel(14)! 	LOGICAL*1	caseflg,caserr,ucorflg  	INCLUDE		'verifycom/list' 	INCLUDE		'corectcom/list' 	INCLUDE		'globalsym/list' C  c initialize 	lengthw=index(word,' ')-1$ 	if(lengthw.eq.-1) lengthw=len(word)> c step thru the various stages of correction based on value of c try 5 	lngspl$get_correction = %loc(lngspl$_limit_exceeded)  50	try=try+1
 	do 60 i=1,25  	sethyp(i)=0 	setcap(i)=0 	setsuf(i)=0 60	setlist(i)=' ' 8 	if(lengthw.eq.4) go to(100,190,500,600,200,300,400,700) 	1                ,try+ 	go to(100,190,200,300,400,500,600,700),try  	return  c initialize8 100	lngspl$get_correction = %loc(lngspl$_illegal_string)+ 	if(lengthw.eq.0 .or. lengthw.gt.32) return 6 	lngspl$get_correction = %loc(lngspl$_not_initialized) 	if(verinit.ne.25) return 5 	lngspl$get_correction = %loc(lngspl$_limit_exceeded) ; c list will contain cumulative list of candidates,separated # c by blanks with duplicates removed     	list=' '         skeldone=0 	do 110 i=1,30 110	hyphens(i)=0 	do 120 i=1,lengthw  120	letter(i)=word(i:i)  	do 130 i=lengthw+1,32 130	letter(i)=' '  c reduce word to lower case , 	call lngspl$lowcase(letter,lengthw,capcode) 	if(capcode.le.2) go to 140  	do 135 i=1,lengthw  	let=ichar(letter(i)) , 	if((let.ge.'101'o .and. let.le.'132'o) .or., 	1  (let.ge.'300'o .and. let.le.'317'o) .or.( 	2  (let.ge.'321'o .and. let.le.'335'o)) 	3   letter(i)=char(let+32)  135	continue 140	do 145 i=1,32  145	modlet(i)=letter(i) 8 c omit case error correction if this is not a case error 	if(.not.caserr) go to 50 * c case error correction in user dictionary1 	call lngspl$functn(codefn,indxfn,letter,lengthw) "         if(.not.ucorflg) go to 155< 	lngspl$get_correction=lngspl$userver(indxfn,codefn,capcode,0 	1                  usertab,hyp4,capdic,lengthw): 	if(lngspl$get_correction.eq.%loc(lngspl$_word_not_found)) 	1	go to 155 	do 150 i=1,32 150	setlist(1)(i:i)=letter(i)  	setcap(1)=capdic  	sethyp(1)=hyp4  	nword=1
 	go to 510E c case error correction in master dictionary; first generate skeleton  155   	lengths=lengthw* 	call lngspl$rules(letter,skelton,lengths)         skeldone=1	 	locflg=1 4 	nword=lngspl$locate(skelton,lengths,letter,lengthw,9 	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(nword.lt.0) go to 1000 	if(nword.gt.0) go to 510 	 	go to 50 / c try transposing all pairs of adjacent letters 1 190	iostat = lngspl$transp(nword,usertab,ucorflg) 1 	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50
 	go to 510* c replace each letter by all other letters2 200	iostat = lngspl$replace(nword,usertab,ucorflg)1 	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50
 	go to 510" c delete each letter one at a time1 300	iostat = lngspl$delete(nword,usertab,ucorflg) 1 	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50
 	go to 510. c insert all possible letters in each position1 400	iostat = lngspl$insert(nword,usertab,ucorflg) 1 	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50
 	go to 5107 c if this is a case error, we already have the skeleton  500     if (skeldone) go to 502  	lengths=lengthw* 	call lngspl$rules(letter,skelton,lengths)         skeldone=18 c look for a match with skelton in the master dictionary7 502     if(lengthw.le.21 .and. lengths.le.14) go to 505      	try = 8     	return  505	locflg=04 	nword=lngspl$locate(skelton,lengths,letter,lengthw,9 	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(nword)1000,50,510 ; c list of candidates is in setlist.based on caseflg,restore > c according to either the dictionary or form of the input word= 510	call lngspl$rescase(setlist,setcap,capcode,caseflg,nword) = c scan setlist for duplicates.add only new candidates to list  c for output7 	call lngspl$dupword(setlist,sethyp,list,hyphens,nword)C 	if(nword.eq.0) go to 50$ 	if(nword.lt.0 .or. try.eq.7) return0 	lngspl$get_correction = %loc(lngspl$_completed) 	returnf( c try targetted substitution on skeleton 600   	totwrd=0y	 	locflg=0d
 	rulepos=1
 	rulenum=1= 610	if(lngspl$target(modskel,lengthm,rulenum,rulepos).ne. 0) g 	1        go to 620w 	if(totwrd.eq.0) go to 50s< 	if(try.lt.7)lngspl$get_correction = %loc(lngspl$_completed) 	returne: c rule rulenum of targetted sub has produced new skeleton & c modskel.see if it matches in lexicon7 620	nword=lngspl$locate(modskel,lengthm,letter,lengthw,i9 	1            setlist,sethyp,setcap,setsuf,locflg,iostat)D 	if(nword)1000,610,6400 c modskel was matched.add non-duplicates to list= 640	call lngspl$rescase(setlist,setcap,capcode,caseflg,nword)f7 	call lngspl$dupword(setlist,sethyp,list,hyphens,nword)I 	totwrd=totwrd+nword 	if(nword.ge.0) go to 610l 	return  c all tries exhausted	
 700	return
 1000	continuet 	lngspl$get_correction =iostat 	returns! 	END			! of lngspl$get_correctionE