+ C	TITLE	Houghton Mifflin Utility (LHMINIVO)  C++ ! C			  COPYRIGHT (c) 1984. 1985 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION. C  C FACILITY:	 C		lngspl$   C  C ABSTRACT:  C 9 C	Houghton Mifflin entry point routine to initialize the  4 C	master dictionary and a specified user dictionary: C  C			LNGSPL$INITIALIZE_VERIFIER C C C	Used in Verifier Only kit, returning LNGSPL$_CORRECTOR_ABSENT if   C	the corr flag is set.  C  C ENVIRONMENT: C 7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable. ; C	Built as part of the verifier corrector shareable library  C / C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C ) C X01.01	Nick Tatham 	24-JUN-83	Original	  C : C X01.02	Cathy Baker	12-JAN-84	Set value of usertab(2) to # C						255 (if greater), to improve  C						storage of hyphen maps.   C 3 C X01.03	Cathy Baker	 9-FEB-84	Split into own file. ! C						Changed INCLUDE statement   C						to use a logical. C 9 C X01.04	Ian Kirkham	15-Mar-85	Set POINTER_SIZE up at run ! C						time to reflect which type  C						of lexicons are in use  C : C X01.05	Ian Kirkham	 4-Jun-85	Remove refs to LNGSPLBS and% C						LNGSPLBZ to make them the same  C						(LNGSPLBE)  C--   6 	INTEGER FUNCTION lngspl$initialize_verifier*4(master,# 	2       ramfile,corr,size,usertab)  C++  C    FUNCTIONAL DESCRIPTION: C K C The caller sets boolean parameter 'corr' if it has the corrector routines E C available. (Needed purely for this version of this routine for the  O C verifier-only kit, where the return status will be 'LNGSPL$_CORRECTOR_ABSENT'  C if this boolean is set.) C H C Opens :  o  the master dictionary file on disk 'master', defaulting to C    	    SYS$LIBRARY and .LGS.  C M C         o  the shareable library image dictionary 'ramfile', defaulting to  K C    	    SYS$LIBRARY and .EXE. Calls MAP_OPEN for this purpose and to map  L C    	    it into memory in 'vertab'. Data is also mapped into common block K C    	    data 'pointer', 'rstring', 'lstring', 'rlen', 'llen' and 'table'  ( C    	    as part of the same operation. C A C Initializes :  o  the cache dictionary table 'cache' (with 0s)   C H C    	       o  the user dictionary table 'usertab' of 'size' longwords  C    		  with:? C    	          i) 7 longwords of control info based on 'size': " C    			Array pos (1): 'size' - 1 + C    				  (2): size of hyphen map section. + C    				  (3): index for position of last  ' C    				       dictionary word stored. . C    				  (4): capacity for dictionary words./ C    				  (5): 0, i.e. no of dictionary words   C    					  currently stored. 0 C    				  (6)/(7): 1, i.e. reserved for future.B C                   ii) 1 s for the area that can be covered with 0 C    			dictionary words when the table is used.? C    		   iii) 0 s for the remaining unused word area, and the   C    			hyphen map area. C ( C Sets a control variable VERINIT to 25. C  C    CALLING SEQUENCE: C 8 C  status.wlc.v = LNGSPL$INITIALIZE_VERIFIER	Calling..		5 C    		(master.rt.dx,        		MAP_OPEN (Bliss)	       C    		 ramfile.rt.dx, C    		 corr.rbu.r,  C    		 size.rlu.r,  C    		 usertab.wlu.ra)  C  C    FORMAL PARAMETERS: * C	master:			Name of master dictionary file5 C	ramfile:		Name of master dic EXE file to be mapped   C				into memory.	- C	corr:			Flag set if corrector is available. 1 C	size:			Size in longwords of user memory array. 4 C    				Must be a power of 2 between powers 11 and ; C    		      		15 inclusive, i.e. 2048, 4096, 8192, 16384,   C				or 32678., C	usertab:		User memory array start address. C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:9 C	POINTER_SIZE		set up to reflect the size of the current . C				lexicons in VERIFYCOM COMMON block and in+ C				fact should only be accessed by BISRCH  C  C    ROUTINE VALUE:  C  C	LNGSPL$_COMPLETED ' C			or if a file cannot be opened, the   C			status from that failure.  C	LNGSPL$_ILLEGAL_STRING4 C			if an input file was used that is not recognised. C			as a lexicon (ie. of form LNGSPL(AE/BS/BZ) C  C    SIDE EFFECTS: C	None.  C--   ? C  'Houghton Mifflin Spelling Verification-Correction Copyright < C  (c) Houghton Mifflin 1983 . All rights strictly reserved.@ C  Unpublished .Restricted and confidential proprietary programs; C  of Houghton Mifflin . Licenced for use solely in DIGITAL ; C  software . Reproduction , disclosure , or re-creation of < C  embodied computer programs or algorithms is prohibited .' C  	IMPLICIT INTEGER*2 (a-z) ! 	INTEGER*4	status,map_open,iostat  	CHARACTER*128	rslbuf  	CHARACTER*(*)	master,ramfile  	LOGICAL*1	corr " 	INTEGER		usertab(*),size,i,rsllen 	INCLUDE		'mastercom/list' 	INCLUDE		'verifycom/list' 	INCLUDE		'globalsym/list' C 4 c if no master file spec assume user dictionary only$       	if(len(master).eq.0) go to 40  c get actual file name of master0 	status = SYS$TRNLOG (master, rsllen, rslbuf,,,) C ' C if status is SS$_NORMAL then continue  C  	IF(IAND(status,1).ne.1)THEN( 	    lngspl$initialize_verifier = status 	    RETURN  	END IF   1 	IF(INDEX(rslbuf(1:rsllen), 'LNGSPLAE').ne.0)THEN # 	    pointer_size =	ae_pointer_size 6 	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLBE').ne.0)THEN# 	    pointer_size =	be_pointer_size  	ELSE ! 	    lngspl$initialize_verifier =  	1	%LOC(lngspl$_illegal_string)  	    RETURN  	END IF  c open master lexicon file6 	open(unit=2,file=master,access='direct',status='old',6 	1  defaultfile='SYS$LIBRARY:.LGS',form='unformatted',* 	2  shared,readonly,err=500,iostat=iostat)& c open master ram file shareable image< 	status = map_open(ramfile, %LOC(vertab), master_block_size) 	if(status) goto 400 c problems with master ram file  	close (unit=2) $ 	lngspl$initialize_verifier = status 	return  400	continueI c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  c zero cache table 40	do 45 i=1,256
 45	cache(i)=0 + c initialize user specific dictionary table    	usertab(1)=size-1  	usertab(2)=ishft(usertab(1),-4)-         if (usertab(2).gt.255) usertab(2)=255 # 	usertab(3)=usertab(1)-usertab(2)-7 + 	usertab(4)=ishft(size,-1) + ishft(size,-2) 
 	usertab(5)=0    	do 50 i=6,usertab(3)  50	usertab(i)='17777777'o  	do 60 i=usertab(3)+1,size 60	usertab(i)=0 7   	lngspl$initialize_verifier = %loc(lngspl$_completed) H   	if (corr) lngspl$initialize_verifier = %loc(lngspl$_corrector_absent) 	verinit=25  	return  500	continue 	call errsns(,,,,iostat)$ 	lngspl$initialize_verifier = iostat 	return ! 	END		! of lngspl$initialize_user 