= C***	TITLE	TapeLoad - Houghton Mifflin Dictionary Tape Loader  C ! C			  COPYRIGHT (c) 1984, 1985 BY 5 C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  C H C This software is furnished under a license and may be used and  copiedH C only  in  accordance  with  the  terms  of  such  license and with theH C inclusion of the above copyright notice.  This software or  any  otherH C copies  thereof may not be provided or otherwise made available to anyH C other person.  No title to and ownership of  the  software  is  hereby C transferred. C H C The information in this software is subject to change  without  noticeH C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT C CORPORATION. C J C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or  I C reliability of its software on  equipment  which is  not  supplied  by    C DIGITAL EQUIPMENT CORPORATION.   C++  C FACILITY:	$ C		DECspell Dictionary Build Process C  C ABSTRACT:  C 8 C		Take a standard Houghton Mifflin dictionary tape and 8 C		strips it into a MASTER dictionary and a RAMFIL file. C	 C ENVIRONMENT:7 C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.  C 3 C AUTHOR: Houghton Mifflin		CREATION DATE: 6-Feb-84  C  C MODIFIED BY: C  C Edit		Modifier	Date		Reason  C = C X01.01	Nick Tatham	16-APR-84	Type in from Houghton Listings  C > C X01.02	Catherine B.	26-APR-84	Modify to create a block data & C						source for in-memory dictionary$ C						as output (as in CRBLKDATA), & C						instead of a binary output for  C						the same. C @ C X01.03	Catherine B.	22-MAY-84	Modify dimensions to unpack the  C						DECspell V1.1 435Kb   C						dictionaries. C < C X01.04	Ian Kirkham	11-Dec-84	Alter output file so that the$ C						file refers to MASTERCOM/LIST C						and not MASTERCOM.FOR C = C X01.05	Ian Kirkham	 4-Feb-85	Alter to take the 1985 lexicon  C ; C X01.06	Ian Kirkham	15-Mar-85	Read in all sizes of lexicon  C						determined by sizes in  C						MASTERCOM.FOR C--      	PROGRAM	TapeLoad    C++  C    FUNCTIONAL DESCRIPTION: C C C       Main Program. Takes an input 'TAPE' file that contains the  : C	a raw binary form of both the in-memory and disk master @ C	dictionaries. Creates two output files: 'MASTER' and 'RAMFIL'.; C	'RAMFIL' is the source code for the in-memory dictionary   C	.EXE file. C  C    CALLING SEQUENCE: C 0 C	Main Program. Fixed file names (logical names) C  C    FORMAL PARAMETERS:  C  C	None C  C    IMPLICIT INPUTS:  C  C	Fixed file names C  C    IMPLICIT OUTPUTS: C  C	Fixed file names C  C    ROUTINE VALUE:  C 	 C	Success  C  C    SIDE EFFECTS: C  C	None C--    C***	Declarations    	IMPLICIT	INTEGER*2 (a-z)    	CHARACTER*14	log_filename 	CHARACTER*128	rslbuf  	INTEGER*4	rsllen 0 	INTEGER*4	vertab_size, pointer_size, table_size        	INTEGER*2	sector(256)  	INTEGER*2	block_number,line_no ! 	INTEGER*2	line_no_minus,quotient    	INCLUDE		'mastercom/list' C+ C	Open input raw tape file C-  	log_filename = 'LNGSPL$RAMLOAD'  / 	OPEN	(UNIT=1, FILE=log_filename, STATUS='OLD', 0      &	 	 ACCESS='SEQUENTIAL', FORM='FORMATTED',      &	 	 SHARED, READONLY)   6 	status = SYS$TRNLOG (log_filename, rsllen, rslbuf,,,) C ! C check for SS$_NORMAL ret status  C  	IF(status.ne.1)2 	1    STOP 'Failure translating logical file name'  1 	IF(INDEX(rslbuf(1:rsllen), 'LNGSPLAE').ne.0)THEN ! 	    vertab_size =	ae_vertab_size # 	    pointer_size =	ae_pointer_size  	    table_size =	ae_table_size 6 	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLBS').ne.0)THEN! 	    vertab_size =	bs_vertab_size # 	    pointer_size =	bs_pointer_size  	    table_size =	bs_table_size 6 	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLBZ').ne.0)THEN! 	    vertab_size =	bz_vertab_size # 	    pointer_size =	bz_pointer_size  	    table_size =	bz_table_size  	ELSE * 	    STOP 'Unrecognised lexicon file name' 	END IF  C+> C 	Read the in-memory master dictionary and associated tables  C    	into memory. C- 	DO i=1,max_vertab_size  	    vertab(i) = 0 	END DO    	DO i=1,max_pointer_size 	    pointer(i) = 0  	END DO    	DO i=1,max_table_size 	    table(i) = 0  	END DO    	DO 20 i=1,table_size,64# 	    READ(1,10) (table(j),j=i,i+63)  10	    FORMAT(64Z8)  20	CONTINUE    	DO 30 i=1,pointer_size,64% 	    READ(1,10) (pointer(j),j=i,i+63)  30	CONTINUE    	DO 40 i=1,vertab_size,64 $ 	    READ(1,10) (vertab(k),k=i,i+63) 40	CONTINUE      C+; C	Read the master disk dictionary and write immediately to   C	output 'MASTER' file.  C-. 	OPEN	(UNIT=2, FILE='MASTER', ACCESS='DIRECT',;      &	         STATUS='NEW', FORM='UNFORMATTED', RECL=128)  C 4 C	RECL = 512 in bytes; RECL = 128 in four byte words C  	DO 60 i=1,2000 * 	    READ(1,50,END=70) (sector(k),k=1,128), 	    READ(1,50,END=70) (sector(k),k=129,256) 50	    FORMAT(128Z4) 	    WRITE(2,REC=i) sector 60	CONTINUE  70	CONTINUE    	CLOSE(UNIT=2,STATUS='KEEP') 	CLOSE(UNIT=1,STATUS='KEEP')     C+4 C	Open the in-memory dictionary output 'RAMFIL' file C-1 	OPEN	(UNIT=2, FILE='RAMFIL', DEFAULTFILE='.FOR', E      &	         ACCESS='SEQUENTIAL', RECL=80, CARRIAGECONTROL='LIST', /      &	         STATUS='NEW', FORM='FORMATTED')    C+= C Write out FORTRAN statements for initializing in-ram tables  C- 	WRITE (2,110)= 110	FORMAT(6x,'block data',/,6x,'include ''mastercom/list''')    C  C Verification table first C  	block_number  = 24  	line_no       = 4 	line_no_minus = 3% 	quotient      = block_number/line_no   + 	DO 160 i= 1, max_vertab_size, block_number   # 	WRITE(2,120) i, i+(block_number-1) 2 120	FORMAT(6x,'data (vertab(i),i=',i5,',',i5,')/')   	DO 140 j=1, quotient " 	    ifrst = ((j-1) * line_no) + i" 	    ilast = ifrst + line_no_minus? 	    IF (j.lt.quotient) WRITE (2,130) (vertab(k),k=ifrst,ilast) . 130	FORMAT(5x,'+',<line_no>('''',z8.8,'''x,'))  ? 	    IF (j.eq.quotient) WRITE (2,135) (vertab(k),k=ifrst,ilast) E 135	FORMAT(5x,'+',<line_no_minus>('''',z8.8,'''x,'),'''',z8.8,'''x/')  140	CONTINUE   160	CONTINUE   C  C Compression table next C  	  	block_number  = 20 % 	quotient      = block_number/line_no   ) 	DO 190 i=1, max_table_size, block_number   # 	WRITE(2,170) i, i+(block_number-1) 1 170	FORMAT(6x,'data (table(i),i=',i5,',',i5,')/')    	DO 180 j=1,quotient" 	    ifrst = ((j-1) * line_no) + i" 	    ilast = ifrst + line_no_minus> 	    IF (j.lt.quotient) WRITE (2,130) (table(k),k=ifrst,ilast)> 	    IF (j.eq.quotient) WRITE (2,135) (table(k),k=ifrst,ilast) 180	CONTINUE   190	CONTINUE   C  C Pointer table next C    	block_number  = 32 % 	quotient      = block_number/line_no   + 	DO 230 i=1, max_pointer_size, block_number   # 	WRITE(2,210) i, i+(block_number-1) 3 210	FORMAT(6x,'data (pointer(i),i=',i5,',',i5,')/')    	DO 220 j=1,quotient" 	    ifrst = ((j-1) * line_no) + i" 	    ilast = ifrst + line_no_minus@ 	    IF (j.lt.quotient) WRITE (2,130) (pointer(k),k=ifrst,ilast)@ 	    IF (j.eq.quotient) WRITE (2,135) (pointer(k),k=ifrst,ilast) 220	CONTINUE   230	CONTINUE       	WRITE (2,240) 240	FORMAT (6x,'end')  	CLOSE	(UNIT=2,STATUS='KEEP')            STOP     	END 	! of TapeLoad 