9  C	TITLE	CUSVERMST - Custom verifier - verify word master   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  C@  C	Houghton Mifflin entry point routine to verify a word against>  C	the table dictionary and an optional specified user memory   C	dictionary:  C  C			LNGSPL$VERIFY_WORD_TABLE   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.7  C	Built as part of the verifier only shareable library 9  C	to use a set of ram table dictionaries to increase the 7  C	size of the word list, thus allowing other languages   C	to be supported.   C0  C AUTHOR: Ian Kirkham		CREATION DATE: 20-Sep-84  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C>  C X01.01	Ian Kirkham	20-Sep-84	Created from LHMVERMST.FOR for'  C						the expansion of the dictionary   C						to a set of tables.   C  C--  <  	INTEGER FUNCTION lngspl$verify_word_master*4(word,usertab,  	1	uverflg,hyphens)  C++  C    FUNCTIONAL DESCRIPTION:   CL  C Verifies that a word in 'word' is mispelt, calling routines that search,   C in turn:   CJ  C  o  A set of 'n_tables' tables in the same format as 'usertab', the nth?  C	table starting at 'table+(n-1)*131072' these being mapped in B  C	at runtime. This value 131072 must be the same as TABLE_SIZE in  C	CUSSPLREQ.R32N  C  o  user dictionary table 'usertab', only if 'uverflg' set (LNGSPL$USERVER)  CK  C If 'word' is found, then not misspelt and its hyphen map is returned in  
  C 'hyphens'.   CH  C Word is considered found if it is a case variant of a word in one of E  C the dictionaries. In this case, an appropriate status is returned  !  C detailing the case difference.   C  C    CALLING SEQUENCE:   C6  C status.wlc.v = LNGSPL$VERIFY_WORD_MASTER	 Calling..!  C		(word.rt.dx,			LNGSPL$LOWCASE #  C		 usertab.rlu.ra,		LNGSPL$FUNCTN $  C		 uverflg.rbu.r,			LNGSPL$USERVER  C		 hyphens.wlu.r)   C  C    FORMAL PARAMETERS:  C	word:			Word to be verified. +  C	usertab:		User memory to verify against. 2  C	uverflg:		Flag set if the user memory is to be   C				verified against. )  C	hyphens:		Hyphen map of word if found.   C  C    IMPLICIT INPUTS:1  C	table:			Base address of the dictionary tables %  C	n_tables:		Number of tables loaded   C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C  C LNGSPL$_CORRECT_SPELLING K  C LNGSPL$_CASE_INCORRECT :	  a mixed case word not found in user dic, but  .  C				found somewhere in a lower case version.  C LNGSPL$_WORD_NOT_FOUND D  C LNGSPL$_ILLEGAL_STRING : 	'0 < word_length < 32 ' does not apply.B  C LNGSPL$_NOT_INITIALIZED:	If control variable VERINIT is not 25.  C9  C The status can also be that from a failed disk access.   C  C    SIDE EFFECTS:   C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*(*)	word-  	INTEGER*4	hyphens,usertab(*),indxfn,codefn,   	1			lngspl$userver,iostat,tab   	CHARACTER*1	letter(32)  	BYTE		setcap(25),setsuf(25)   	LOGICAL*1	uverflg   	CHARACTER*32	setlist(25)  	INCLUDE		'cusmascom/list'   	INCLUDE 	'globalsym/list'   C
  C initialize 8  	lngspl$verify_word_master=%loc(lngspl$_illegal_string)  	hyphens=0   	lengthw=index(word,' ')-1 %  	if(lengthw.eq.-1) lengthw=len(word) *  	if(lengthw.eq.0.or.lengthw.gt.32) return9  	lngspl$verify_word_master=%loc(lngspl$_not_initialized)   	if(verinit.ne.25) return  	do 10 i=1,lengthw   	letter(i)=word(i:i)   10	continue  	do 15 i=lengthw+1,32  	letter(i)=' '   15	continue  C-  	call lngspl$lowcase(letter,lengthw,capcode)   CC  C We check the word with the various tables in the following order 
  C		userver 1 	  C		  ... 
  C		userver n   C		real user dict!  C		real user dict for case error   C		userver 1 for case error	  C		  ...   C		userver n for case error  C.  C First look for word in the tables, in order  C2  	call lngspl$functn(codefn,indxfn,letter,lengthw)  	do 25 tab=0,n_tables-19  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn, :  	1	capcode,%VAL(table+tab*131072),hyphens,capdic,lengthw)F  	if(lngspl$verify_word_master.ne.%loc(lngspl$_word_not_found)) return  25	continue@  C Next look for word in user specific dictionary if we have one  	if(.not.uverflg) go to 30 9  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn, +  	1	capcode,usertab,hyphens,capdic,lengthw) F  	if(lngspl$verify_word_master.ne.%loc(lngspl$_word_not_found)) return  30	if(capcode.le.2) return "  C try non-standard capitalization  	do 35 i=1,lengthw   	let=ichar(letter(i))*  	if((let.ge.'101'o.and.let.le.'132'o).or.*  	1  (let.ge.'300'o.and.let.le.'317'o).or.'  	2  (let.ge.'321'o.and.let.le.'335'o))   	3	letter(i)=char(let+32)  35	continue9  C look in user table for match again but with case error   	if(.not.uverflg) go to 40 9  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn, +  	1	capcode,usertab,hyphens,capdic,lengthw) I  	if (lngspl$verify_word_master.ne.%loc(lngspl$_word_not_found)) go to 50   40	do 45 tab=0,n_tables-1A  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn,capcode, 2  	1	%VAL(table+tab*131072),hyphens,capdic,lengthw)I  	if (lngspl$verify_word_master.ne.%loc(lngspl$_word_not_found)) go to 50   45	continue4  C Not found in any of the tables so return status -  	return  C Found with case error:  50	lngspl$verify_word_master=%loc(lngspl$_case_incorrect)  	return&  	END			! of lngspl$verify_word_master