-  C	TITLE	Houghton Mifflin Utility (MODDECODE)   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CA  C	Houghton Mifflin lower level routine to read a block from the  D  C	dictionary into memory and decode it, passing back various info, !  C	depending upon its parameters:   C  C				LNGSPL$DECODE   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C7  C AUTHOR: EX Houghton Mifflin	CREATION DATE: 24-JUN-83   C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C<  C X01.02	Nick Tatham	4-JUL-83	Add support for error status   C						return from file read.  C8  C X01.03	Cathy Baker	 9-FEB-84	Separated into own file;!  C						changed INCLUDE statement   C						to a logical.   C?  C X01.04	Catherine B.	 25-APR-84	New 385Kb dictionary support.   C*  C*********** MODULE RENAMED FROM HMDECODE  C8  C X01.05	Cathy Baker 	 21-MAY-1984	Modified to include   C						common data for block   C						number analysis.  C  C--     A  	INTEGER*4 FUNCTION lngspl$decode(wordskl,locflg,nxtblk,suftest, @  	1          block,nword,setlist,sethyp,setcap,setsuf,len1,len2)  C++  C    FUNCTIONAL DESCRIPTION:   C  D  C Searches the 'block' number on disk that should contain the word ;  C whose characters and skeleton are encoded in 'wordskl'.    CG  C The code parameters 'wordskl', 'locflg' and 'suftest' are set by the P  C caller LNGSPL$LOCATE but 'block' and 'nxtblk' are outputs from LNGSPL$BIRCH, M  C 'block' being the number of the block in the master dictionary to search.  A  C If 'nxtblk' is set, both this and the next block are searched.   CH  C If locflg = 0, then 'setlist', 'sethyp', 'setcap', and 'setsuf' will P  C contain the data for the words that match the skeleton encoded in 'wordskl'. E  C 'nword' will indicate how many words have been found and returned.   CK  C If locflg = 1, the same data structures will contain one element only -  J  C the data for the first word that matched 'wordskl' completely. 'nword' 4  C will be 1 or 0, i.e. word was found or not found.  CI  C If locflg = 2, the same data structures will not contain any relevant  J  C information; 'nword' will simply specify 1 or 0, i.e. word was found or
  C not found.   CI  C First, reads the 'block' from disk into memory in 'sector'. Next takes M  C each longword from this block in turn, and decodes it in one of two ways,  G  C one way involving using a decompression 'table' that is part of the  C  C common block data LNGSPL$DATA_MASTER. Once a complete dictionary I  C word's record has been decoded, the word and its skelton lie in 5-bit  C  C codes in 'foundwo', and its hyphen map, capitalization code and  J  C suffix code in 'curhyp', 'curcap' and 'cursuf' respectively. These are >  C translated back to 7-bit codes before the routine finishes.  CH  C Note: Refer to section 3.3.4.1 of the Houghton Mifflin documentation.  C  C    CALLING SEQUENCE: 5  C	status.wlc.v = LNGSPL$DECODE              (Caller: /  C    		(wordskl.rlu.ra,    			LNGSPL$LOCATE )    C    	 	 locflg.rbu.r,   C    	 	 nxtblk.rbu.r,   C    	 	 suftest.rwu.r,  C    	 	 block.rwu.r,  C    	 	 nword.wwu.r,  C    	 	 setlist.wlu.ra,   C    	 	 sethyp.wlu.ra,  C    	 	 setcap.wlu.ra,  C    	 	 setsuf.wlu.ra,  C		 len1.rwu.r,  C		 len2.rwu.r)  C  C    FORMAL PARAMETERS:6  C	wordskl:		Array for misspelt word and its skeleton.5  C	locflg:			Flag indicating quantity of output data    C				required by caller. 7  C	nxtblk:			Flag set if 2 contiguous blocks are to be    C				searched. 7  C	suftest:		Code indicating if word's suffix has been    C				stripped off. &  C	block:			Number of block to search.  CF  C	setlist,sethyp,setcap,	Output arrays for the words which have same 9  C	setsuf:			skeleton, their hyphen maps, capitalization    C				codes and suffix maps.  C*  C	len1:			Length of skeleton in bytes.			#  C	len2:			Length of word in bytes.   C  C    IMPLICIT INPUTS:.  C	Table			Used to decode the dictionary data.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  CA  C	LNGSPL$COMPLETED   	or if the block cannot be read, the error  &  C 				status from the READ statement.  C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*32	setlist(25)#  	INTEGER*2	foundwo(35),predskl(35) 0          INTEGER*2      	curdskl(35),wordskl(35)%  	INTEGER*4 	status,sethyp(25),curhyp &      	INTEGER*4	entry,masq,preh,hyping,  	BYTE 		locflg,nxtblk,setcap(25),setsuf(25)3  	INTEGER*2	sector(256),nword,block,hyp2(2),ent2(2) *          INTEGER*2	entry1,entry2,len1,len2*  	BYTE		comlsk,comlwo,diflsk,diflwo,difins   	BYTE		sumdif,let,prevsl,prevwl  C *****  C X01.05 Modification...   C          INTEGER*4	blockpos           LOGICAL*1	nextdone ,      	COMMON /decodedata/ blockpos, nextdone  C ****   	INCLUDE 	'mastercom/list'   	INCLUDE 	'globalsym/list'   C+ F  C 'entry' is a longword, with the high order 2 bytes also referenced D  C as 'entry2' and the low order 2 bytes as 'entry1'. 'curhyp' is a H  C longword with the high order 2 bytes referenced as 'hyp2(2)' and the "  C low order 2 bytes as 'hyp2(1)'.  C- 9  	EQUIVALENCE	(curhyp,hyp2),(entry,ent2),(entry1,ent2(1))        &			,(entry2,ent2(2))   C)  	lngspl$decode = %loc(lngspl$_completed)   c read block from disk $  5	read(2,rec=block,err=1000) sector  	do 10 j=1,35  10	predskl(j)=0  	preh=0  	pres=0  	prec=0  	prevsl=14   	prevwl=35   	hyp2(1)=0   	k=0 
  	recwon=1  	curwrd=sector(recwon) ,  15	hyp2(2)=ishft(iand(curwrd,'70000'o),-12)*  	if(iand(curwrd,'100000'o).eq.0) go to 20-  	entry=table(ishft(iand(curwrd,'7776'o),-1)) *  	curcap=ishft(iand(entry2,'160000'o),-13))  	comlsk=ishft(iand(entry2,'017000'o),-9) )  	comlwo=ishft(iand(entry2,'000760'o),-4)   	diflsk=iand(entry2,'000017'o) *  	cursuf=ishft(iand(entry1,'176000'o),-10))  	diflwo=ishft(iand(entry1,'001740'o),-5) 
  	difins=1,  	if(diflsk.eq.0 .and. diflwo.eq.0) difins=0/  	if(difins.eq.1) curdskl(1)=iand(entry1,'37'o) 
  	go to 30  c)  20	curcap=ishft(iand(curwrd,'7000'o),-9) '  	comlsk=ishft(iand(curwrd,'0740'o),-5)   	comlwo=iand(curwrd,'37'o)   	recwon=recwon+1   	curwrd=sector(recwon) *  	cursuf=ishft(iand(curwrd,'176000'o),-10))  	diflsk=ishft(iand(curwrd,'001700'o),-6) )  	diflwo=ishft(iand(curwrd,'000076'o),-1) 
  	difins=0  c  30	sumdif=diflsk+diflwo  	bits=0  	if(difins.eq.sumdif) go to 50   	recwon=recwon+1   	curwrd=sector(recwon) 	  	bits=15   40	difins=difins+1 
  	bits=bits-5 5  	curdskl(difins)=iand(ishft(curwrd,-(bits+1)),'37'o)   	if(difins.eq.sumdif) go to 50   	if(bits.gt.0) go to 40  	recwon=recwon+1   	curwrd=sector(recwon) 	  	bits=15 
  	go to 40  c  50	if(bits.eq.0) go to 60  	if(k.eq.15) go to 70
  	bits=bits-5 >  55	hyp2(1)=ior(ishft(hyp2(1),5),iand(ishft(curwrd,-(bits+1)),       &				'37'o))  	k=k+5 
  	go to 50  c'  60	if(iand(curwrd,'1'o).ne.0) go to 70   	recwon=recwon+1   	curwrd=sector(recwon) 	  	bits=10 
  	go to 55  c  70	hyp2(1)=ishft(hyp2(1),16-k)   	curhyp=ishft(curhyp,13)   	lensk=comlsk+diflsk   	lenwo=comlwo+diflwo %  	masq=ishft('37777777777'o,32-lenwo) %  	curhyp=iand(ieor(curhyp,preh),masq) 
  	preh=curhyp   	cursuf=ieor(cursuf,pres)
  	pres=cursuf   	curcap=ieor(curcap,prec)
  	prec=curcap   c  	k=0   	if(diflsk.eq.0) go to 100   	do 90 i=1,lensk   	if(i.le.comlsk) go to 80  	k=k+1 (  	foundwo(i)=ieor(predskl(i),curdskl(k))'  	if(prevsl.lt.i) foundwo(i)=curdskl(k)   	predskl(i)=foundwo(i)   	if(k.eq.diflsk) go to 100 
  	go to 90  c  80	foundwo(i)=predskl(i)   90	continue  c  100	if(diflwo.eq.0) go to 130  	lastad=lenwo+14   	do 120 i=15,lastad  	if(i.le.comlwo+14) go to 110  	k=k+1 (  	foundwo(i)=ieor(predskl(i),curdskl(k))'  	if(prevwl.lt.i) foundwo(i)=curdskl(k)   	predskl(i)=foundwo(i)   	if(k.eq.sumdif) go to 130   	go to 120   c  110	foundwo(i)=predskl(i)
  120	continue   c  130	prevsl=lensk   	prevwl=lenwo+14   c	   c match skeleton !  170	if (lensk.ne.len1) go to 200   	do 180 i=1,lensk(  	if(foundwo(i).eq.wordskl(i)) go to 180(  	if(foundwo(i).lt.wordskl(i)) go to 200  	return
  180	continue   	totlen=lenwo+14 #  c match suffix as well as skeleton 9  	if(suftest.eq.0 .and. (iand(cursuf,21).ne.0)) go to 200   	if(suftest.eq.0) go to 185)  	if(iand(cursuf,suftest).eq.0) go to 200   185	if(locflg.eq.0) go to 195
  c match word   	if (lenwo.ne.len2) go to 200  	do 190 i=15,totlen(  	if(foundwo(i).ne.wordskl(i)) go to 200
  190	continue   c match on all properties  195	nword=nword+1  	if(locflg.eq.2) then  	    blockpos=recwon   	    return          endif>  c load dictionary word from foundwo into setlist, translating  c from 5 bits to 7   	do 500 i=15,totlen  	let=foundwo(i)+96   	if(foundwo(i).eq.27) let=39 2  	if(foundwo(i).ge.28 .and. foundwo(i).le.30) let=  	1      foundwo(i)+17%  	setlist(nword)(i-14:i-14)=char(let) 
  500	continueu  	i=lenwo+1   	setlist(nword)(i:32)=' '(  c load hyphens,cap code, and suffix map  	sethyp(nword)=curhyp  	setcap(nword)=curcap  	setsuf(nword)=cursuf$  c append suffix to word if required-     	if(suftest.eq.3) setlist(nword)(i:i)='s'e/  	if(suftest.eq.12) setlist(nword)(i:i+1)='''s'u  	if(suftest.ne.48) go to 520i  	setlist(nword)(i:i+2)='ing'e#  c adjust hyphen map for ing suffixv)  	if((iand(cursuf,'40'o)).eq.0) go to 520C
  	hyping='1'o 5  	sethyp(nword)=ior(sethyp(nword),ishft(hyping,33-i))   520	if(locflg.eq.1) thenT  	    blockpos=recwons  	    return  	endifh  c  200	recwon=recwon+1  	curwrd=sector(recwon)n  	hyp2(1)=0   	k=0e"  	if(curwrd.ne.'177777'o) go to 15  	if(nxtblk.eq.0) then U             blockpos=recwon              return      	endif 
  	nxtblk=0          nextdone = 1e  	block=block+1s	  	go to 5l  1000	continue  	call errsns(,,,,status)   	lngspl$decode = status  	return  	END			!of lngspl$decodeu