,  C	TITLE	Houghton Mifflin Utility (HMFUNCTN)  C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CB  C	Houghton Mifflin lower level routine to determine the code and G  C	index value for a word to be stored in the in-memory tables (cache,    C 	user and master).   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C7  C AUTHOR: EX Houghton Mifflin	CREATION DATE: 24-JUN-83   C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C4  C X01.02	Cathy Baker	 9-FEB-84	Split into own file.  C  C--  2  	SUBROUTINE lngspl$functn(codefn,indxfn,letter,n)  C++  C    FUNCTIONAL DESCRIPTION:   CK  C This subroutine is a basic tool to encode a word array 'letter', of 'n'    C characters, producing :    C8  C  o  a longword 'codefn' to represent the word itself.K  C  o  a 24-bit number 'indxfn' to represent the position of the word in a  <  C     table, (top 8 bits of the supplied longword being 0).  CM  C These codes are used to place the word in the in-memory dictionary tables  @  C (master, cache and user). They are used directly in routines E  C LNGSPL$ADD_WORD_USER, LNGSPL$_DELETE_WORD_USER and LNGSPL$RAMVER.  C  C Furthermore, LNGSPL$RAMVER passes them on as output parameters.  M  C But all other callers just call this routine to then supply them as input  !  C parameters for LNGSPL$USERVER.   C  C    CALLING SEQUENCE:   C&  C LNGSPL$FUNCTN              Callers:1  C (codefn.wlu.r,    	LNGSPL$ADD_WORD_USER        .  C  indxfn.wlu.r,	LNGSPL$DELETE_WORD_USER       C  letter.rlu.ra,)  C  n.rwu.r)		LNGSPL$RAMVER                 C$  C    			LNGSPL$VERIFY_WORD_MASTER  $  C    			LNGSPL$VERIFY_WORD_USER    $  C    			LNGSPL$GET_CORRECTION      $  C    			LNGSPL$DELETE              $  C    			LNGSPL$INSERT              $  C    			LNGSPL$TRANSP              $  C    			LNGSPL$REPLACE               C  C    FORMAL PARAMETERS:6  C	codefn:		Coded word for storage in in-memory table.7  C	indxfn:		Index value of where to put the coded word. /  C	letter:		Array of letters of word to insert. %  C	n:		Number of letters in the word.   C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER(a-z)   	INTEGER*2	k,n   	CHARACTER*1	letter(32)  C,  c function used to calculate code and index
  	codefn=0
  	indxfn=0  	if(n.eq.0) return   	k=1 3  	codefn=ishft(ichar(letter(1)),8)+ichar(letter(n))   	indxfn=codefn 	  10	k=k+1   	if(k.gt.n) return +  	alpha=ishft(iand(codefn,'77600000'o),-16) 9  	beta=ior(ichar(letter(k)),ishft(iand(codefn,'177777'o),   	1        8))  	codefn=alpha+alpha+alpha+beta /  	if(codefn.gt.16777212) codefn=codefn-16777213 +  	alpha=ishft(iand(codefn,'77600000'o),-16) 2  	beta=ior(ichar(letter(n+1-k)),ishft(iand(codefn,  	1        '177777'o),8))   	codefn=alpha+alpha+alpha+beta /  	if(codefn.gt.16777212) codefn=codefn-16777213   	indxfn=indxfn+codefn
  	go to 10     	END		!of lngspl$functn