,  C	TITLE	Houghton Mifflin Utility (HMLOCATE)  C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  C?  C	Houghton Mifflin lower level routine to locate a word in the A  C	disk master dictionary and return ones with the same skeleton:   C  C				LNGSPL$LOCATE   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C<  C X01.02	Nick Tatham	4-JUL-83	Add support for error status   C						return from file read.  CE  C X01.03        Cathy Baker	12-JAN-84       Fixed 'SCI' bug, i.e for L  C                                               words with skeltons of 's'.  C<  C X01.04	Cathy Baker	 9-FEB-84	Split into own file. Changed!  C						INCLUDE statement to use    C						logicals.   C?  C X01.05	Catherine B.	 25-APR-84	New 385Kb dictionary support.   C--  4  	INTEGER FUNCTION lngspl$locate*2 (skelton,lengths,6  	1       letter,lengthw,setlist,sethyp,setcap,setsuf,  	1       locflg,iostat)  C++  C    FUNCTIONAL DESCRIPTION:   CN  C This function takes a word 'letter' of length 'lengthw', whose skeleton is L  C 'skelton' of length 'lengths', and calls LNGSPL$BISRCH and LNGSPL$DECODE 3  C to search the master dictionary on disk for it.    CJ  C According to the parameter code 'locflg', it returns different results:  C  C Corrector mode:M  C  o locflg = 0,as value of this function, returns the number of words with  @  C    		the same skeleton as 'letter'; the details of the words A  C    		are in arrays 'setlist', 'sethyp', 'setcap' and 'setsuf'.   C Verifier mode: L  C  o locflg = 1,as value of function, returns 0/1 for word found/not_found.;  C    		If the input word is found, returns its hyphen map, C  C    		capitalization code and suffix in 'sethyp(1)', 'setcap(1)'  &  C    		and 'setsuf(1)' respectively.   C Check mode:M  C  o locflg = 2,  as value of function, returns 0/1 as word found/not_found.   CL  C First, examines 'skelton' and 'letter' to see if word ends in any of the J  C suffixes - s, - 's, - ing, and if so strips them off, re-adjusting the K  C word lengths 'lengths' and 'lengthw'. Forms a code 'suftest' as follows:   C  C Sufest = 2  C  0   		word does not end in 's' , ''s' or 'ing'  C  3   		word ends in 's'  C 12  		word ends in ''s'  C 48  		word ends in 'ing'   C  CC  C Second, forms two codes with which to search master dictionary :   CI  C o  'wordskl' - an array of 35 5-bit codes; the first 14 members are a  O  C     number-coded version of 'skelton' using the translation table 'char7t5'. I  C     The next 21 members are a number-coded version of 'letter', where  H  C     each of chars a-z becomes numbers 1-26, then ''' = 27, '-' = 28,   C     and '.' = 29.  CI  C    NOTE: see Page 3-20 of Houghton Mifflin documentation for 'skelton'   C    	  number encoding.   C4  C  o   'key' - the first 6 characters of 'skelton'.  CH  C Third, calls LNGSPL$BISRCH to determine the block number (of the 850 <  C blocks of the master dictionary) that should be searched.  CK  C Fourth, calls LNGSPL$DECODE to find matching skeleton(s) in that block.  8  C LNGSPL$DECODE returns a parameter 'nword' specifying:  C  C nword,  C  0 			(nothing found, all locflg values) 6  C  n			( n = the number of matching skeletons found,   C     			locflg = 0) 3  C  1			(the actual word was matched, locflg = 1,2)   CH  C 'nword' then becomes the return value of this function LNGSPL$LOCATE.  CL  C If LNGSPL$DECODE fails because the disk block cannot be read, its return D  C status appears in 'iostat', and the value of this function is -1.  C  L  C Fifth, if locflg is 0, and suffix - s was removed, this function adds it 1  C back on again, and re-searches the dictionary.   C  C  C    CALLING SEQUENCE:   C9  C	nword.wwu.v = LNGSPL$LOCATE              		(locflg = ) 2  C		(skelton.rlu.ra,	LNGSPL$VERIFY_WORD_MASTER (1)5  C 		 lengths.rwu.r,		LNGSPL$GET_CORRECTION     (0,1) 5  C 		 letter.rlu.ra,   	LNGSPL$DELETE             (2) 3  C 		 lengthw.rwu.r,		LNGSPL$INSERT             (2) 4  C 		 setlist.wlu.ra,	LNGSPL$REPLACE            (2) 3  C 		 sethyp.wlu.ra,		LNGSPL$TRANSP             (2)   C 		 setcap.wlu.ra,    C 		 setsuf.wlu.ra,  C 		 locflg.rbu.r,   C 		 iostat.wlu.r)   C  C    FORMAL PARAMETERS:  C		See description!  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:0  C	Number of words found ( but see description).  C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*32	setlist(25)$  	CHARACTER*1	skelton(14),letter(32)$  	INTEGER*4	key,lngspl$decode,iostat)          INTEGER*4	sethyp(25),itemp,shift   	INTEGER*2	wordskl(35),suftest $  	BYTE		char7t5(127),nxtblk,sufstrp	$  	BYTE		locflg,setcap(25),setsuf(25)  	INCLUDE		'mastercom/list'   	INCLUDE		'globalsym/list' 8  	DATA char7t5/38*0,27,5*0,28,29,30,21*0,5,3*0,9,5*0,15,5  	1            7*0,21,0,1,5*0,31,0,0,2,0,4,0,6,7,8,0, 4  	2            10,11,12,13,14,0,16,17,18,19,20,0,22,  	3            23,24,25,26,5*0/   C  	lngspl$locate=0 -  	if(lengthw.gt.21 .or. lengths.gt.14) return   	sufstrp=0   	len1=lengths  	len2=lengthw  c do suffix stripping  	suftest=0 %  	if(letter(lengthw).ne.'s') go to 50 -  	if(lengthw.lt.2 .or. lengths.lt.2) go to 60 (  	if(letter(lengthw-1).ne.'''') go to 404  	if(skelton(lengths).ne.'s' .or. skelton(lengths-1)  	1          .ne.'''') go to 60   c suffix 's  	suftest=12  	len1=lengths-2
  	len2=len2-2 
  	go to 60  c suffix s (  40	if(skelton(lengths).ne.'s') go to 60  	suftest=3   	len1=lengths-1
  	len2=len2-1 
  	go to 60
  c suffix ing 1  50	if(lengthw.le.3 .or. lengths .le. 2) go to 60 9  	if(letter(lengthw).ne.'g' .or. letter(lengthw-1).ne.'n' ,  	1  .or. letter(lengthw-2).ne.'i') go to 604  	if(skelton(lengths).ne.'g' .or. skelton(lengths-1)  	1 .ne.'n') go to 60   	suftest=48  	len1=lengths-2
  	len2=len2-3 =  c convert characters in word and skeleton to 5 bit code and    c move to array wordskl  60	continue  	do 80 i=1,len1  	let=ichar(skelton(i))   	if(let.gt.127) return   80	wordskl(i)=char7t5(let)   	do 90 i=1,len2  	let=ichar(letter(i))-96   	if(letter(i).eq.'''') let=27 *2I   	if(letter(i).eq.'~') return  *2E 7  	if(letter(i).ge.'-' .and. letter(i).le.'/')let=let+79 $  	if(let.le.0 .or. let.gt.30) return  90	wordskl(14+i)=let 	  	nword=0 ,  c use first 6 characters of skeleton as key	  95	key=0 
  	lenkey=6  	if(len1.lt.6) lenkey=len1       	shift=25  	do 100 i=1,lenkey   	itemp=wordskl(i)!  	key=ior(key,ishft(itemp,shift))   100	shift=shift-5(  c find first disk sector to be searched!  	block=lngspl$bisrch(key,nxtblk) .  c decode sector and look for matching records=  	iostat = lngspl$decode(wordskl,locflg,nxtblk,suftest,block, ;  	1           nword,setlist,sethyp,setcap,setsuf,len1,len2) 2  	if (iostat.ne.%loc(lngspl$_completed)) goto 1000  	lngspl$locate=nword 9  c for correction try adjusting s suffix and search again   	if(locflg.ne.0) return  	if(sufstrp.ne.0) return   	sufstrp=1   	if(suftest.ne.3) go to 110  	suftest=0   	wordskl(lengths)=19 
  	len1=len1+1 
  	go to 95<  110	if(skelton(lengths).ne.'s' .or. letter(lengthw).eq.'s')  	1          return C          if ((skelton(lengths).eq.'s') .and. (lengths.eq.1)) return   	suftest=3   	wordskl(lengths)=0
  	len1=len1-1 
  	go to 95  1000	continue  	lngspl$locate = -1  	return     	END		!of lngspl$locate