-  C	TITLE	Houghton Mifflin Utility (HMLOWCASE)   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CA  C	Houghton Mifflin lower level routine to determine translate a  :  C	word into lowercase and derive its capitalization code:  C  C				LNGSPL$LOWCASE  C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C4  C X01.06	Cathy Baker	 9-FEB-84	Split into own file.  C  C--     2  	SUBROUTINE lngspl$lowcase(letter,length,capcode)  C++  C    FUNCTIONAL DESCRIPTION:   CA  C For word in array 'letter' of length 'length', determines the  I  C capitalization code 'capcode', and if this is not >2, changes 'letter'   C to lower case.   C  #  C'capcode' can be :    	0  =  l.c.   C    			1  =  initial cap.   C    			2  =  u.c. #  C    			3  =  cap-after-the-hyphen 1  C    			4  =  init. cap and cap-after-the-hyphen   C    			5  =  mixed case   C  C    CALLING SEQUENCE:   C*  C  LNGSPL$LOWCASE             			Callers:3  C	(letter.rlu.ra,    		LNGSPL$ADD_WORD_USER        /  C	 length.rwu.r,			LNGSPL$DELETE_WORD_USER     0  C	 capcode.wwu.r)			LNGSPL$VERIFY_WORD_MASTER  &  C	    				LNGSPL$VERIFY_WORD_USER    )  C	        			LNGSPL$GET_CORRECTION         C    FORMAL PARAMETERS:#  C	letter:			Array containing word. *  C	length:			Length of word in characters.+  C	capcode:		Numeric code (0-5) describing    C				capitalization of word.   C	   C    IMPLICIT INPUTS:	  C	 None.   C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2(a-z) &  	BYTE		numcap,numspec,hyppos,cap(32)	  	CHARACTER*1	letter(32)  C?  c reduce input word to lower case,set capcode to indicate what   c had to be done 
  	numcap=0  	numspec=0 
  	hyppos=07  c scan word.locate hyphen,count special chars and caps   	do 10 i=1,length
  	cap(i)=0  	let=ichar(letter(i))  	if(let.eq.'55'o) hyppos=i +  	if((let.ge.'41'o .and. let.le.'100'o).or. ,  	1  (let.ge.'133'o .and. let.le.'140'o).or.)  	2  (let.ge.'173'o .and. let.le.'176'o))   	3       numspec=numspec+1 -  	if((let.ge.'101'o .and. let.le.'132'o) .or. -  	1  (let.ge.'300'o .and. let.le.'317'o) .or. )  	2  (let.ge.'321'o .and. let.le.'335'o))   	3       cap(i)=1  	numcap=numcap+cap(i)  10	continue  	capcode=0   	if (numcap-1) 70,20,30"  c initial cap or cap after hyphen
  20	capcode=5   	if(cap(1).eq.1) capcode=1 4  	if(hyppos.gt.0 .and. cap(hyppos+1).eq.1) capcode=4
  	go to 50  c all caps .  30	if(numcap.eq.2 .and. hyppos.gt.0) go to 40  	capcode=5 (  	if(numcap.eq.length-numspec) capcode=2
  	go to 50#  c initial cap and cap after hyphen 
  40	capcode=3 3  	if(cap(1).eq.0 .or. cap(hyppos+1).eq.0) capcode=5 :  c reduce all caps to lower case if capcode is two or less  50	if(capcode.gt.2) return     	do 60 i=1,length5  	if(cap(i).eq.1) letter(i)=char(ichar(letter(i))+32)   60	continue
  70	return     	END		!of lngspl$lowcase 