,  C	TITLE	Houghton Mifflin Utility (HMRAMVER)  C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CA  C	Houghton Mifflin lower level routine to verify whether a word  1  C	is present in the in-memory master dictionary:   C  C				LNGSPL$RAMVER   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C4  C X01.02	Cathy Baker	 9-FEB-84	Split into own file.#  C						Changed INCLUDE statements    C						to use logicals.  CB  C X01.03	Catherine Baker	 26-APR-84	New 385Kb dictionary support.  C@  C X01.04	Catherine Baker	 11-JUN-84	Added D_lines for code that!  C						is to be included in the  '  C						performance build. This avoids  (  C						the need for a separate copy of (  C						this module (RAMVERMOD). D-line &  C						code prevents search in cache.  C  C--  :  	INTEGER FUNCTION lngspl$ramver*4(letter,lengthw,hyphens,(  	1                indxfn,codefn,ondisk)  C++  C    FUNCTIONAL DESCRIPTION:   CK  C  For word 'letter' of length 'lengthw', generates 'indxfn' and 'codefn'  G  C  by calling LNGSPL$FUNCTN; uses these codes to search the in-memory  O  C  dictionary table 'vertab' and the 'cache' table. (If 'letter' ends in 's',  8  C  this is stripped off before calling LNGSPL$FUNCTN.)   CI  C If word is found in 'vertab', its hyphen map is returned in 'hyphens'. G  C If the word is found in 'cache' and its hyphen map is 1-byte of '1's J  C followed by 3 bytes of '0's, then the word is a misspelling discovered Q  C previously, so the boolean 'ondisk' is set to 0, and 'lngspl$_word_not_found'    C returned.  C  C    CALLING SEQUENCE:   C2  C status.wlc.v  = LNGSPL$RAMVER          Callers:2  C    		(letter.rlu.ra,		LNGSPL$VERIFY_WORD_MASTER4  C    		 lengthw.rwu.r,		LNGSPL$DELETE              4  C    		 hyphens.wlu.r,		LNGSPL$INSERT              3  C    		 indxfn.wlu.r,		LNGSPL$REPLACE              3  C    		 codefn.wlu.r,		LNGSPL$TRANSP                 C    		 ondisk.wbu.r)  C  C  C    FORMAL PARAMETERS:D  C	letter,lengthw:		Word to be verified and its length in characters=  C	hyphens:		Hyphen map of word if it is found in dictionary. :  C	indxfn,codefn:		Codes derived and used to locate word, $  C				returned as output parameters.8  C	ondisk:			Flag cleared if this word was one verified 4  C				before, not found then, and placed into cache.  C  C    IMPLICIT INPUTS:)  C	Vertab:			Master dictionary in memory.   C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C  C	LNGSPL$_WORD_NOT_FOUND   C	LNGSPL$_CORRECT_SPELLING   C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*1	letter(32)8  	INTEGER smap,indxfn,codefn,hyphens,offset,i,j,indcach,  	1       code,ind  	BYTE		ondisk  	INCLUDE 	'mastercom/list'   	INCLUDE 	'verifycom/list'   	INCLUDE 	'globalsym/list'   C;  c strip off word-final 's' ,set smap and decrement lengthw   c accordingly  	smap=0  	n=lengthw   	if(letter(n).ne.'s') go to 10   	smap='20000000'o
  	n=lengthw-1   c calculate code and ind .  10	call lngspl$functn(codefn,indxfn,letter,n),  	lngspl$ramver=%loc(lngspl$_word_not_found)  	if(lengthw.gt.21) return  	code=iand(codefn,'17777777'o)   	ind=iand(indxfn,'3777'o)8  c initialize in preparation for search of in-ram tables
  	ondisk=1
  	offset=1*  c look for code in position 'i' of vertab  20	i=ind+offset4    	if(iand(vertab(i),'17777777'o).ne.code) go to 301    	if(iand(vertab(i),'40000000'o).ne.0) go to 50 2  	if(iand(vertab(i),'20000000'o).eq.smap) go to 50+  c rehash within vertab,look for code again .  30	j=ind+3+ishft(iand(indxfn,'3770000'o),-12)  	if(j.ge.2047) j=j-2047  	i=j+offset2  	if(iand(vertab(i),'17777777'o).ne.code) go to 401    	if(iand(vertab(i),'40000000'o).ne.0) go to 50 2  	if(iand(vertab(i),'20000000'o).eq.smap) go to 50  40	offset=offset+2048  	if(offset.le.6144) go to 20 ?  C If this is a performance build, compiled /D-lines, the cache   C table is not searched.   D       return   1  c calculate new ind,look for code in cache table !  60	indcach=iand(indxfn,'377'o)+1 5  	if(iand(cache(indcach),'17777777'o).ne.code) return   c code matches. check 's' map4  	if(iand(cache(indcach),'40000000'o).ne.0) go to 705  	if(iand(cache(indcach),'20000000'o).ne.smap) return :  c match in cache table.check hyphen map for a misspelling/  70	hyphens=iand(cache(indcach),'37700000000'o) (  	if(hyphens.ne.'37700000000'o) go to 80
  	ondisk=0  	return%  c correct spelling.return hyphen map 0  80	lngspl$ramver=%loc(lngspl$_correct_spelling)  	return#  c word was found.supply hyphen map 2  50	lngspl$ramver = %loc(lngspl$_correct_spelling)(  	hyphens=iand(vertab(i),'37700000000'o)  	return     	END		!of lngspl$ramver