+  C	TITLE	Houghton Mifflin Utility (HMRULES)   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  C+  C	Houghton Mifflin lower level routine to    C  C				LNGSPL$RULES  C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C-  C X01.02	Cathy Baker    11-JAN-84	Fixed bug  "  C						- 'XION' rule not working.  C4  C X01.03	Cathy Baker	 9-FEB-84	Split into own file.  C  C--  0  	SUBROUTINE lngspl$rules(letter,outskel,length)  C++  C    FUNCTIONAL DESCRIPTION:   CK  C Generates a skeleton for a word 'letter' of length 'length', and places  F  C it in 'outskel', updating 'length' to give the length of 'outskel'.J  C A skeleton is required if the word is to be searched for in the master   C dictionary on disk.    CO  C First, creates an array of numbers 'typlet' that categorizes the characters    C in 'letter' as follows:  C  C  -1 = a vowel    C   1 = consonant  C   0 = 'y'!  C  98 = '-' or '/' or '.' or '''   CK  C Generates 'outskel' by applying a set of replacement rules to 'letter',  E  C (e.g. "search for all occurrences of 'ce', 'ci', 'cy' and replace  L  C the 'c' with 's'"). Some of these rules mean removing letters completely L  C and putting '+' s there instead. Others are not letter specific, and use J  C the array 'typlet'. (Note: the local array 'skelton' is used to store aN  C temporary skeleton as each rule is applied: this is not the same 'skelton' 2  C as in the common block LNGSPL$DATA_CORRECTOR.)   C  @  C Calls LNGSPL$CMPRESS at various intervals to remove the '+'s.  C  C Caller 				Output Skeleton   C ------				---------------9  C LNGSPL$VERIFY_WORD_MASTER 	for the word to be verified   CC  C LNGSPL$GET_CORRECTION 	for the misspelt word (so as to find all  /  C    				dictionary words with same skeleton)    C6  C Others 			for the modified word (to see if it is a 5  C    				dictionary word and therefore a correction    C    				suggestion)   C  C    CALLING SEQUENCE:   C						Callers:?  C  LNGSPL$RULES                   	LNGSPL$VERIFY_WORD_MASTER   9  C 	(letter.rlu.ra,			LNGSPL$GET_CORRECTION               #  C 	 outskel.wlu.ra,		LNGSPL$DELETE 0  C 	 length.mwu.r)			LNGSPL$INSERT              &  C    					LNGSPL$REPLACE             &  C    					LNGSPL$TRANSP                C  C    FORMAL PARAMETERS:7  C	letter:			Word array for which to generate skeleton. #  C	outskel:		Skeleton for 'letter'. 6  C	length:			Length of word on input, and of skeleton   C				on output.  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	DIMENSION	typlet(21)6  	CHARACTER*1	temp, letter(32),skelton(21),outskel(14)  C  	if(length.gt.21) return 9  c initialize skelton.typlet denotes vowels or consonants   	length2=length-1  	do 20 ii=1,21   	skelton(ii)=letter(ii)  20	typlet(ii)=1  	do 30 ii=1,length   	temp=letter(ii) 7  	if(temp.eq.'a' .or. temp.eq.'e' .or. temp.eq.'i' .or. 0  	1  temp.eq.'o' .or. temp.eq.'u') typlet(ii)=-1  	if(temp.eq.'y') typlet(ii)=07  	if(temp.eq.'-' .or.temp.eq.'.' .or. temp.eq.'''' .or.   	1  temp.eq.'/') typlet(ii)=98 
  30 	continue 	  c soft c   	do 40 ii=1,length2!  	if(skelton(ii).ne.'c') go to 40 8  	if(skelton(ii+1).eq.'e' .or. skelton(ii+1).eq.'i' .or.*  	1  skelton(ii+1).eq.'y') skelton(ii)='s'
  40 	continue   c non-word initial z   	do 50 ii=2,length (  	if(skelton(ii).eq.'z') skelton(ii)='s'  50	continue  c sequence 'qu'  	do 60 ii=1,length2!  	if(skelton(ii).ne.'q') go to 60 #  	if(skelton(ii+1).ne.'u') go to 60   	skelton(ii)='k'   	skelton(ii+1)='w'   	typlet(ii+1)=1  60	continue  c word initial wr7  	if(skelton(1).eq.'w'.and.skelton(2).eq.'r')skelton(1) 	  	1  ='+'   c word initial wh4  	if(skelton(1).eq.'w' .and. skelton(2).eq.'h' .and.&  	1  skelton(3).eq.'o') skelton(1)='+'  c sequence wh  	ii=0  65	ii=ii+1   	if(ii.gt.length-2) go to 70 9  	if(skelton(ii).ne.'w'.or.skelton(ii+1).ne.'h') go to 65 8  	if(skelton(ii+2).eq.'a' .or. skelton(ii+2).eq.'e' .or.1  	1 skelton(ii+2).eq.'i'.or.skelton(ii+2).eq.'y')   	2 skelton(ii+1)='+' 	  	ii=ii+1 
  	go to 65  c sequence 'tch'   70	ii=0  80	ii=ii+1   	if(ii.gt.length-2) go to 90 !  	if(skelton(ii).ne.'t') go to 80 :  	if(skelton(ii+1).ne.'c'.or.skelton(ii+2).ne.'h')go to 80  	skelton(ii)='+'   	skelton(ii+1)='k' 	  	ii=ii+2 
  	go to 80  c non-word initial tu  90	ii=2  100	ii=ii+1  	if(ii.gt.length-2) go to 120:  	if(skelton(ii).ne.'t'.or.skelton(ii+1).ne.'u') go to 1006  	if(skelton(ii+2).eq.'r'.or.skelton(ii+2).eq.'n' .or.9  	1  skelton(ii+2).eq.'m'.or.skelton(ii+2).eq.'l')goto110 :  	if(skelton(ii+2).ne.'e' .and. skelton(ii+2).ne.'a' .and.$  	1  skelton(ii+2).ne.'o') go to 100  	skelton(ii)='k'   	skelton(ii+1)='h'   	skelton(ii+2)='o'   	typlet(ii+1)=1	  	ii=ii+2   	go to 100   110	ii=ii+29  	if(typlet(ii+1).gt.0.or.skelton(ii+1).eq.'u') go to 100   	skelton(ii-2)='k'   	skelton(ii-1)='h'   	typlet(ii-1)=1	  	ii=ii+1   	go to 100   c word-final y   120	if(length.lt.3) go to 1309  	if(skelton(length).ne.'y' .and. skelton(length).ne.'i')   	1  go to 130  	skelton(length)='Y'   	typlet(length)=99   c word final ie  130	if(length.lt.4) go to 1409  	if(skelton(length2).ne.'i' .or. skelton(length).ne.'e')   	1  go to 140    	skelton(length)='Y'   	typlet(length)=99   	skelton(length2)='+'  c intervocalic y or i	  140	ii=1   150	ii=ii+1  	if(ii.gt.length) go to 170:  	if(skelton(ii).ne.'i' .and. skelton(ii).ne.'y')go to 1506  	if(typlet(ii-1).ge.0.or.typlet(ii+1).ge.0) go to 160  	skelton(ii)='Y'   	typlet(ii)=99 	  	ii=ii+1   	go to 150 $  160	if(typlet(ii-1).ne.1) go to 150  	skelton(ii)='i'   	typlet(ii)=-1 	  	ii=ii+1   	go to 150 $  c si or ti in position 3 and beyond	  170	ii=2   180	ii=ii+1  	if(ii.gt.length-3) go to 190:  	if(skelton(ii).ne.'s' .and. skelton(ii).ne.'t')go to 180:  	if(skelton(ii+1).ne.'i' .or. (skelton(ii+2).ne.'a' .and.6  	1  skelton(ii+2).ne.'o' .and. skelton(ii+2).ne.'u'))  	2  go to 180  	skelton(ii)='s'   	skelton(ii+1)='h'   	typlet(ii+1)=1	  	ii=ii+2   	go to 180   c word-final gue   190	if(length.lt.5) go to 1959  	if(skelton(length-2).eq.'g'.and.skelton(length2).eq.'u' 7  	1  .and. skelton(length).eq.'e') skelton(length2)='+'   c ue sequence  195	do 200 ii=1,length29  	if(skelton(ii).ne.'u'.or.skelton(ii+1).ne.'e')go to 200   	skelton(ii)='o'   	skelton(ii+1)='o' 
  200	continue   c sequences eu,ew,au,aw,ou,ow  	ii=1  240	ii=ii+1  	if(ii.gt.length) go to 2509  	if(skelton(ii).ne.'u'.and.skelton(ii).ne.'w') go to 240 :  	if(skelton(ii-1).ne.'e' .and. skelton(ii-1).ne.'a' .and.$  	1  skelton(ii-1).ne.'o') go to 240  	if(ii.eq.length) go to 2458  	if(skelton(ii+1).eq.'w' .or. skelton(ii+1).eq.'z' .or.!  	1  typlet(ii+1).ne.1) go to 240   245	skelton(ii-1)='o'  	skelton(ii)='o'   	typlet(ii)=-1 	  	ii=ii+2   	go to 240   c word final ea,ia   250	if(length.lt.4) go to 260&  	if(skelton(length).ne.'a') go to 2603  	if(skelton(length2).ne.'e' .and. skelton(length2)   	1  .ne.'i') go to 260   	skelton(length)='+'   	skelton(length2)='_'  	typlet(length2)=100   c word-final a :  260	if(skelton(length).ne.'a' .or. length.lt.4) go to 265  	skelton(length)='_'   	typlet(length)=100  c word-final ae  265	if(length.lt.5) go to 268:     	if(skelton(length2).ne.'a'.or.skelton(length).ne.'e')  	1         go to 268   	skelton(length)='_'   	typlet(length)=100  	skelton(length2)='+'  c word initial vowels7  268	call lngspl$cmpress(skelton,typlet,length,length2)   	if(typlet(1).ge.0) go to 285  	ii=0  270	ii=ii+1  	if(ii.gt.length) go to 280  	if(typlet(ii).ge.0) go to 280   	skelton(ii)='+'   	go to 270   280	skelton(ii-1)='_'  	typlet(ii-1)=100  c sequence 'dg'  285	do 290 ii=1,length23  	if(skelton(ii).eq.'d' .and. skelton(ii+1).eq.'g')   	1  skelton(ii)='+'
  290	continue   c the letter c   	do 300 ii=1,length(  	if(skelton(ii).eq.'c') skelton(ii)='k'
  300	continue %  c sequence of 2 identical consonants   	do 310 ii=1,length2 4  	if(typlet(ii).lt.0.or.skelton(ii).eq.'z')go to 3102  	if(skelton(ii).eq.skelton(ii+1)) skelton(ii)='+'
  310	continue 4  	call lngspl$cmpress(skelton,typlet,length,length2)  c sequence ks  	do 320 ii=1,length2 9  	if(skelton(ii).ne.'k'.or.skelton(ii+1).ne.'s') goto 320   	skelton(ii)='+'   	skelton(ii+1)='x' 
  320	continue   c sequence xion  	ii=1  330	ii=ii+1  	if(ii.gt.length-3) go to 340"  	if(skelton(ii).ne.'x') go to 330$  	if(skelton(ii+3).ne.'n') go to 330;  	if(skelton(ii+1).ne.'i'.or.skelton(ii+2).ne.'o') goto 330   	skelton(ii+1)='h'   	typlet(ii+1)=-1 	  	ii=ii+3   	go to 330   c word-initial ps:  340	if(skelton(1).eq.'p'.and.skelton(2).eq.'s')skelton(1)	  	1  ='+'t  c sequences rh,ght,ph	  410	ii=1R  420	ii=ii+1  	if(ii.gt.length) go to 450"  	if(skelton(ii).ne.'h') go to 420$  	if(skelton(ii-1).eq.'r') go to 430$  	if(skelton(ii-1).eq.'p') go to 440  	if(ii.eq.length) go to 4509  	if(skelton(ii-1).ne.'g'.or.skelton(ii+1).ne.'t')goto420   	skelton(ii)='e'   	typlet(ii)=-1t  	skelton(ii+1)='+'   	skelton(ii-1)='t'y	  	ii=ii+1v  	go to 420w  430	skelton(ii)='+'	  	ii=ii+1h  	go to 420o  440	skelton(ii-1)='+'  	skelton(ii)='f'i	  	ii=ii+1   	go to 420d  c sequence gn  450	do 455 ii=1,length21  	if(skelton(ii).eq.'g'.and.skelton(ii+1).eq.'n')h  	1  skelton(ii)='+'
  455	continuet  c word initial kn pnN4  	if(skelton(2).eq.'n' .and. (skelton(1).eq.'k' .or.'  	1  skelton(1).eq.'p')) skelton(1)='+'e  c sequence xs  	do 550 ii=1,length2o3  	if(skelton(ii).eq.'x' .and. skelton(ii+1).eq.'s')L  	1  skelton(ii+1)='+'
  550	continueT4  	call lngspl$cmpress(skelton,typlet,length,length2);  c vowels preceeded only by consonants or trace of init vow   	ii=0  560	ii=ii+1  	if(ii.gt.length) go to 580"  	if(skelton(ii).eq.'Y') go to 580  	if(typlet(ii).ge.0) go to 560r5  	if(skelton(ii).eq.'o'.or.skelton(ii).eq.'u')goto570N  	skelton(ii)='E'C  	typlet(ii)=102  	go to 580	  570	skelton(ii)='O'  	typlet(ii)=101  c vowel 'E'	  580	ii=1i  590	ii=ii+1  	if(ii.ge.length) go to 595"  	if(skelton(ii).ne.'E') go to 590$  	if(skelton(ii+1).ne.'r') go to 590  	temp=skelton(ii+2)4  	if((typlet(ii+2).eq.1 .and. temp.ne.'x' .and. temp7  	1   .ne.'h' .and. temp.ne.'r' .and. temp.ne.'w') .or. '  	1   (ii.eq.length-2)) skelton(ii)='O''  	go to 590n  c word-final 'o' or 'u':  595	if(skelton(length).ne.'o'.and.skelton(length).ne.'u')  	1       go to 600e  	skelton(length)='O'e  	typlet(length)=101  c word final 'oe'  600	if(length.lt.2) go to 605;     	if(skelton(length).ne.'e' .or. skelton(length2).ne.'o'e  	1  ) go to 605  	skelton(length2)='O'  	typlet(length2)=101w  	skelton(length)='+'t)  c 'E' or 'O' followed by consonants onlyo7  605	call lngspl$cmpress(skelton,typlet,length,length2)e	     	ii=0u  610	ii=ii+1  	if(ii.gt.length2) go to 630o6  	if(skelton(ii).ne.'O'.and.skelton(ii).ne.'E')goto610  	temp=skelton(ii)
  	pos=ii+1  	do 620 ii=pos,length6  	if(typlet(ii).ne.1 .and. typlet(ii).ne.98) go to 630
  620	continuep  	skelton(pos-1)='I'$  	if(temp.eq.'O') skelton(pos-1)='W'  	typlet(pos-1)=103 %  c delete all non-word initial vowelsc  630	do 640 ii=2,lengths%  	if(typlet(ii).le.0) skelton(ii)='+'c
  640	continueS4  	call lngspl$cmpress(skelton,typlet,length,length2)  c     	do 760 ii=1,14o  760	outskel(ii)=skelton(ii)  	return  e  	END		! of lngspl$rules