-  C	TITLE	Houghton Mifflin Utility (HMUSERVER)   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CC  C	Houghton Mifflin lower level routine to verify a word against a  ,  C	specific memory-resident user dictionary:  C  C				LNGSPL$USERVER  C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C4  C X01.02	Cathy Baker	 9-FEB-84	Split into own file.!  C						Changed INCLUDE statement   C						to use logical.   C--  8  	INTEGER FUNCTION lngspl$userver(indxfn,codefn,capcode,1  	1                usertab,hyphens,capdic,length)      C++  C    FUNCTIONAL DESCRIPTION:   CM  C As input details of the word to search for, takes the word's 'indxfn' and  Q  C 'codefn' (generated by caller by a call to LNGSPL$FUNCTN), plus its 'capcode'  C  C (generated by caller by a call to LNGSPL$LOWCASE) and 'length'.    CQ  C Searches in in-memory user dictionary 'usertab', and if word is found returns  O  C its hyphen map 'hyphens', plus its dictionary capitalization code 'capdic'.    CG  C Compares 'capdic' with 'capcode'; if there is a discrepancy between  L  C these, a relevant case status is returned to indicate how the input word   C differs.   C  C    CALLING SEQUENCE:   C7  C status.wlc.v  = LNGSPL$USERVER             	Callers: 3  C    		(indxfn.rlu.r,		LNGSPL$VERIFY_WORD_MASTER   3  C    		 codefn.rlu.r,		LNGSPL$VERIFY_WORD_USER     4  C    		 capcode.rwu.r,		LNGSPL$GET_CORRECTION      &  C    		 usertab,rlu.ra,	LNGSPL$DELETE4  C    		 hyphens.wlu.r,		LNGSPL$INSERT              3  C    		 capdic.wwu.r,		LNGSPL$REPLACE              0  C 		 length.rwu.r)		LNGSPL$TRANSP                C  C    FORMAL PARAMETERS:  C<  C	indxfn,codefn:		Codes used to determine location of word   C				in user dictionary. )  C	capcode:		Capitalization code of word. -  C	usertab:		User dictionary array to search. )  C	hyphens:		Hyphen map of word if found. <  C	capdic:			Dictionary capitalization code of word if found  C	length:			Length of word.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C  C 	LNGSPL$_WORD_NOT_FOUND    C 	LNGSPL$_CORRECT_SPELLING  C 	LNGSPL$_CASE_INCORRECT    C 	LNGSPL$_ALL_UPPER_CASE    C 	LNGSPL$_INITIAL_CAPITAL   C  C    SIDE EFFECTS:   C  C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER(a-z)   	DIMENSION	usertab(*)&  	INTEGER*2	capcode,capdic,length,cap2  	INCLUDE		'globalsym/list'   C
  c initialize /  	lngspl$userver = %loc(lngspl$_word_not_found)   	size=usertab(1)   	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)  	hyphens=0 
  	rehash=0  	code=iand(codefn,'17777777'o) %  	if(code.ge.'17777776'o) code=code-2   	ind=iand(indxfn,size) $  	if(ind.gt.maxindx) ind=ind-maxindx  	q=iand(code,'177'o)   	a=3-q 9  c if location 'i' of usertab is unused,word is not found   30	i=ind+5 :    	if(iand(usertab(i),'17777777'o).eq.'17777777'o) return+  c look for code in location 'i' of usertab 3  	if(iand(usertab(i),'17777777'o).eq.code) go to 60 (  c try next location if rehash < maxrhsh  	if(rehash.gt.maxrhsh) return  	rehash=rehash+1 	  	a=a+q+q   	ind=ind+a   c watch for table wrap around  40	if(ind.lt.maxindx) go to 30   	ind=ind-maxindx 
  	go to 40   c word found. supply hyphen map+  60	hyphens=iand(usertab(i),'37700000000'o) 4  	if(length.gt.9 .and. hyphens.ne.0) hyphens=usertab   	1    (size-ishft(hyphens,-24))3    	lngspl$userver = %loc(lngspl$_correct_spelling)   c check for case mismatch  	cap2=capcode  	if(capcode.gt.3) cap2=3 3  	capdic=ishft(iand(usertab(i),'00060000000'o),-22)   	if(cap2.eq.capdic) return -  	lngspl$userver=%loc(lngspl$_case_incorrect) 1  	if(cap2.eq.1 .and. capdic.eq.0) lngspl$userver= *  	1          %loc(lngspl$_initial_capital);  	if(cap2.eq.2) lngspl$userver=%loc(lngspl$_all_upper_case)   	return  	END		!of lngspl$userver 