	  C X01.05 J  C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  C  C   PROGRAM NAME:  C#  C	    HMUTIL - HM UTILITY ROUTINES   C  C   AUTHOR:  C(  C	    Nick Tatham - ex Houghton Mifflin  C  C   ABSTRACT:  CA  C	    Miscellaneous Houghton Routines for verifier and corrector   C  C   BUILD PROCEDURES:  C)  C	    Built as part of shareable library   C  C   CREATION DATE:   C  C	    24-JUN-83  C  C   REVISION HISTORY:  C!  C	    Version #		Date		Developer !  C	    ---------		----		--------- %  C	    X01.01		24-JUN-83	Nick Tatham	 $  C	    X01.02		 4-JUL-83	Nick Tatham.  C				Add support for error status return from  C				file read.%  C	    X01.03		 11-JAN-84	Cathy Baker !  C						Fixed bug in LNGSPL$RULES "  C						- 'XION' rule not working.  C			 ;  C           X01.04               12-JAN-84     Cathy Baker P  C                                              Fixed 'SCI' bug in LNGSPL$LOCATEM  C                                              - words with skeltons of 's'.   C)  C	    X01.05		 13-JAN-84     Cathy Baker #  C					       Added code to improve *  C					       hyphenation storage in user   C					       memory.   C  C   SPECIAL TECHNIQUES:  C  C	    None   CJ  C------------------------------------------------------------------------     <  	integer function lngspl$verify_word_master*4(word,usertab,  	1       uverflg,hyphens)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'   	implicit integer*2 (a-z)  	character*(*) word<  	integer*4 hyphens,usertab(*),lngspl$ramver,indxfn,codcach,6  	1         codefn,smap,lngspl$userver,hypind,indcach,  	2         sethyp(25),iostat $  	character*1 letter(32),skelton(14):  	byte setcap(25),setsuf(25),smap1(4),locflg,ondisk	! ,let  	logical*1 uverflg   	character*32 setlist(25)  	equivalence (smap1,smap)  	include 'mastercom.for'   	include 'verifycom.for'   	include 'globalsym.for' 
  c initialize 8  	lngspl$verify_word_master=%loc(lngspl$_illegal_string)  	hyphens=0   	lengthw=index(word,' ')-1 %  	if(lengthw.eq.-1) lengthw=len(word) ,  	if(lengthw.eq.0 .or. lengthw.gt.32) return9  	lngspl$verify_word_master=%loc(lngspl$_not_initialized)   	if(verinit.ne.25) return  	do 10 i=1,lengthw   10	letter(i)=word(i:i)   	do 20 i=lengthw+1,32  20	letter(i)=' ' 1  c look for word in the in-ram verification table 9  	lngspl$verify_word_master=lngspl$ramver(letter,lengthw, *  	1          hyphens,indxfn,codefn,ondisk)  	codcach=codefn(  	if(lngspl$verify_word_master .eq. %loc&  	1 (lngspl$_correct_spelling)) return&  c word not found.reduce to lower case-  	call lngspl$lowcase(letter,lengthw,capcode) >  c if all lower case or word must have a capital,try user next-  	if(capcode.eq.0 .or. capcode.gt.2) go to 25 9  	lngspl$verify_word_master=lngspl$ramver(letter,lengthw, *  	1          hyphens,indxfn,codefn,ondisk)  	codcach=codefn.  c if word found second time in ram,case error)  	if (lngspl$verify_word_master .ne. %loc *  	1   (lngspl$_correct_spelling)) go to 25  c case mismatch;    	lngspl$verify_word_master=%loc(lngspl$_initial_capital) 3  	if(capcode.eq.2) lngspl$verify_word_master = %loc +  	1                (lngspl$_all_upper_case)   	return,  c look for word in user specific dictionary  25	continue  	if(.not.uverflg) go to 30 7  	if(letter(lengthw).eq.'s') call lngspl$functn(codefn, !  	1        indxfn,letter,lengthw) 9  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn, 4  	1          capcode,usertab,hyphens,capdic,lengthw)(  	if(lngspl$verify_word_master .ne. %loc$  	1 (lngspl$_word_not_found)) return  30	if(capcode.le.2) go to 45 "  c try non-standard capitalization  	do 35 i=1,lengthw   	let=ichar(letter(i))-  	if((let.ge.'101'o .and. let.le.'132'o) .or. -  	1  (let.ge.'300'o .and. let.le.'317'o) .or. )  	2  (let.ge.'321'o .and. let.le.'335'o))   	3   letter(i)=char(let+32)  35	continue9  	lngspl$verify_word_master=lngspl$ramver(letter,lengthw, *  	1          hyphens,indxfn,codefn,ondisk)  	codcach=codefn&  	if(lngspl$verify_word_master.ne.%loc)  	1  (lngspl$_correct_spelling)) go to 40 8  	lngspl$verify_word_master=%loc(lngspl$_case_incorrect)  	return  40	continue    	if(.not.uverflg) go to 45 7  	if(letter(lengthw).eq.'s') call lngspl$functn(codefn, "  	1         indxfn,letter,lengthw)9  	lngspl$verify_word_master=lngspl$userver(indxfn,codefn, 4  	1          capcode,usertab,hyphens,capdic,lengthw))  	if (lngspl$verify_word_master .ne. %loc &  	1   (lngspl$_word_not_found)) return=  c calculate skeleton for input word and search the disk file   45	if(ondisk.eq.0) return    	lengths=lengthw +  	call lngspl$rules(letter,skelton,lengths) 
  	locflg=15  	nword=lngspl$locate(skelton,lengths,letter,lengthw, :  	1            setlist,sethyp,setcap,setsuf,locflg,iostat)$  	lngspl$verify_word_master = iostat  	if(nword.lt.0) return =  c if skeleton not on disk or none of the corresponding words    c match,then word is misspelled:  	lngspl$verify_word_master = %loc(lngspl$_word_not_found)  	if(lengthw.gt.21) return  	smap=0  	n=lengthw %  	if(letter(lengthw).ne.'s') go to 50   	smap='20000000'o
  	n=lengthw-1   50	hypind='37700000000'o   	if(nword.eq.0) go to 100'  c word found on disk.supply hyphen map   70	hyphens=sethyp(1) =  c supply 's' map for insertion into cache table.convert from 9  c 1 byte disk format to 4 bytes,shift to proper location   	smap1(3)=setsuf(1)$  	smap=ishft(iand(smap,'600000'o),6)<  	lngspl$verify_word_master = %loc(lngspl$_correct_spelling)8  c compare dictionary capitalization with input word for  c possible case mismatch #  	if(capcode.eq.setcap(1)) go to 80 :  	lngspl$verify_word_master = %loc(lngspl$_case_incorrect)(  	if (capcode.eq.1 .and. setcap(1).eq.0)?  	1   lngspl$verify_word_master = %loc(lngspl$_initial_capital) (  	if (capcode.eq.3 .and. setcap(1).eq.4)?  	1   lngspl$verify_word_master = %loc(lngspl$_initial_capital) 3  	if(capcode.eq.2) lngspl$verify_word_master = %loc   	1    (lngspl$_all_upper_case) ;  c if word was not all lower case,do not put in cache table   80	if(setcap(1).ne.0) return 9  c search hyphen table for match with hyphenation pattern :  c stored on disk.if no match,do not insert in cache table  	hypind=hyphens)  	if(hyphens.eq.0 .or. n.lt.10) go to 100 0  	hypind=mod(iand(hyphens,'17777777777'o),251)+1#  	if(hyphens.lt.0)hypind=hypind+187 %  	if(hypind.gt.251) hypind=hypind-251 .  	if(vertab(12288+hypind).eq.hyphens) go to 90  	hypind=hypind+1 .  	if(vertab(12288+hypind).eq.hyphens) go to 90  	hypind=hypind+2 .  	if(vertab(12288+hypind).eq.hyphens) go to 90  	return  90	hypind=ishft(hypind,24)   c insert in cache table"  100	indcach=iand(indxfn,'377'o)+18  	cache(indcach)=ior(iand(codcach,'17777777'o),ior(smap,  	1              hypind))   	return  	end      :  	integer function lngspl$ramver*4(letter,lengthw,hyphens,(  	1                indxfn,codefn,ondisk)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'   	implicit integer*2 (a-z)  	character*1 letter(32)8  	integer smap,indxfn,codefn,hyphens,offset,i,j,indcach,  	1       code,ind
  	byte ondisk   	include 'mastercom.for'   	include 'verifycom.for'   	include 'globalsym.for' ;  c strip off word-final 's' ,set smap and decrement lengthw   c accordingly  	smap=0  	n=lengthw   	if(letter(n).ne.'s') go to 10   	smap='20000000'o
  	n=lengthw-1   c calculate code and ind .  10	call lngspl$functn(codefn,indxfn,letter,n),  	lngspl$ramver=%loc(lngspl$_word_not_found)  	if(lengthw.gt.21) return  	code=iand(codefn,'17777777'o)   	ind=iand(indxfn,'7777'o)8  c initialize in preparation for search of in-ram tables
  	ondisk=1
  	offset=1*  c look for code in position 'i' of vertab  20	i=ind+offset4    	if(iand(vertab(i),'17777777'o).ne.code) go to 301    	if(iand(vertab(i),'40000000'o).ne.0) go to 50 2  	if(iand(vertab(i),'20000000'o).eq.smap) go to 50+  c rehash within vertab,look for code again .  30	j=ind+3+ishft(iand(indxfn,'3770000'o),-12)  	if(j.ge.4095) j=j-4095  	i=j+offset2  	if(iand(vertab(i),'17777777'o).ne.code) go to 401    	if(iand(vertab(i),'40000000'o).ne.0) go to 50 2  	if(iand(vertab(i),'20000000'o).eq.smap) go to 50  40	offset=offset+4096  	if(offset.le.12288) go to 201  c calculate new ind,look for code in cache table   	indcach=iand(indxfn,'377'o)+1 5  	if(iand(cache(indcach),'17777777'o).ne.code) return   c code matches. check 's' map4  	if(iand(cache(indcach),'40000000'o).ne.0) go to 705  	if(iand(cache(indcach),'20000000'o).ne.smap) return :  c match in cache table.check hyphen map for a misspelling/  70	hyphens=iand(cache(indcach),'37700000000'o) (  	if(hyphens.ne.'37700000000'o) go to 80
  	ondisk=0  	return%  c correct spelling.return hyphen map 0  80	lngspl$ramver=%loc(lngspl$_correct_spelling)6  	if(hyphens.ne.0 .and. n.ge.10) hyphens=vertab(12288+  	1  ishft(hyphens,-24))  	return#  c word was found.supply hyphen map 2  50	lngspl$ramver = %loc(lngspl$_correct_spelling)(  	hyphens=iand(vertab(i),'37700000000'o)6  	if(hyphens.ne.0 .and. n.ge.10) hyphens=vertab(12288+  	1      ishft(hyphens,-24))  	return  	end      2  	subroutine lngspl$functn(codefn,indxfn,letter,n)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'   	implicit integer(a-z)   	integer*2 k,n   	character*1 letter(32),  c function used to calculate code and index
  	codefn=0
  	indxfn=0  	if(n.eq.0) returnC  	k=1U3  	codefn=ishft(ichar(letter(1)),8)+ichar(letter(n))   	indxfn=codefne	  10	k=k+1M  	if(k.gt.n) returnR+  	alpha=ishft(iand(codefn,'77600000'o),-16)n9  	beta=ior(ichar(letter(k)),ishft(iand(codefn,'177777'o),   	1        8))  	codefn=alpha+alpha+alpha+betaC/  	if(codefn.gt.16777212) codefn=codefn-16777213 +  	alpha=ishft(iand(codefn,'77600000'o),-16)	2  	beta=ior(ichar(letter(n+1-k)),ishft(iand(codefn,  	1        '177777'o),8))N  	codefn=alpha+alpha+alpha+betaU/  	if(codefn.gt.16777212) codefn=codefn-16777213t  	indxfn=indxfn+codefn
  	go to 10  	end1    12  	subroutine lngspl$lowcase(letter,length,capcode)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'   	implicit integer*2(a-z) +  	byte numcap,numspec,hyppos,cap(32)	! ,letC  	character*1 letter(32)?  c reduce input word to lower case,set capcode to indicate what-  c had to be donee
  	numcap=0  	numspec=0w
  	hyppos=07  c scan word.locate hyphen,count special chars and caps   	do 10 i=1,length
  	cap(i)=0  	let=ichar(letter(i))  	if(let.eq.'55'o) hyppos=il+  	if((let.ge.'41'o .and. let.le.'100'o).or. ,  	1  (let.ge.'133'o .and. let.le.'140'o).or.)  	2  (let.ge.'173'o .and. let.le.'176'o))r  	3       numspec=numspec+1o-  	if((let.ge.'101'o .and. let.le.'132'o) .or.t-  	1  (let.ge.'300'o .and. let.le.'317'o) .or.i)  	2  (let.ge.'321'o .and. let.le.'335'o))2  	3       cap(i)=1  	numcap=numcap+cap(i)  10	continue  	capcode=0v  	if (numcap-1) 70,20,30"  c initial cap or cap after hyphen
  20	capcode=5	  	if(cap(1).eq.1) capcode=1 4  	if(hyppos.gt.0 .and. cap(hyppos+1).eq.1) capcode=4
  	go to 50  c all capsf.  30	if(numcap.eq.2 .and. hyppos.gt.0) go to 40  	capcode=5t(  	if(numcap.eq.length-numspec) capcode=2
  	go to 50#  c initial cap and cap after hyphen	
  40	capcode=3s3  	if(cap(1).eq.0 .or. cap(hyppos+1).eq.0) capcode=5=:  c reduce all caps to lower case if capcode is two or less  50	if(capcode.gt.2) return.    	do 60 i=1,length5  	if(cap(i).eq.1) letter(i)=char(ichar(letter(i))+32)l  60	continue
  70	return  	endn    i0  	subroutine lngspl$rules(letter,outskel,length)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'g  	implicit integer*2 (a-z)  	dimension typlet(21)6  	character*1 temp, letter(32),skelton(21),outskel(14)  	if(length.gt.21) return.9  c initialize skelton.typlet denotes vowels or consonantst  	length2=length-1  	do 20 ii=1,21d  	skelton(ii)=letter(ii)  20	typlet(ii)=1  	do 30 ii=1,lengthe  	temp=letter(ii) 7  	if(temp.eq.'a' .or. temp.eq.'e' .or. temp.eq.'i' .or.$0  	1  temp.eq.'o' .or. temp.eq.'u') typlet(ii)=-1  	if(temp.eq.'y') typlet(ii)=07  	if(temp.eq.'-' .or.temp.eq.'.' .or. temp.eq.'''' .or.i  	1  temp.eq.'/') typlet(ii)=98 
  30 	continuel	  c soft c_  	do 40 ii=1,length2!  	if(skelton(ii).ne.'c') go to 40o8  	if(skelton(ii+1).eq.'e' .or. skelton(ii+1).eq.'i' .or.*  	1  skelton(ii+1).eq.'y') skelton(ii)='s'
  40 	continue   c non-word initial z   	do 50 ii=2,lengthd(  	if(skelton(ii).eq.'z') skelton(ii)='s'  50	continue  c sequence 'qu'  	do 60 ii=1,length2!  	if(skelton(ii).ne.'q') go to 60l#  	if(skelton(ii+1).ne.'u') go to 60u  	skelton(ii)='k'l  	skelton(ii+1)='w'y  	typlet(ii+1)=1  60	continue  c word initial wr7  	if(skelton(1).eq.'w'.and.skelton(2).eq.'r')skelton(1)'	  	1  ='+'   c word initial wh4  	if(skelton(1).eq.'w' .and. skelton(2).eq.'h' .and.&  	1  skelton(3).eq.'o') skelton(1)='+'  c sequence wh  	ii=0  65	ii=ii+1f  	if(ii.gt.length-2) go to 70t9  	if(skelton(ii).ne.'w'.or.skelton(ii+1).ne.'h') go to 65	8  	if(skelton(ii+2).eq.'a' .or. skelton(ii+2).eq.'e' .or.1  	1 skelton(ii+2).eq.'i'.or.skelton(ii+2).eq.'y')v  	2 skelton(ii+1)='+'l	  	ii=ii+1_
  	go to 65  c sequence 'tch'n  70	ii=0  80	ii=ii+1)  	if(ii.gt.length-2) go to 90)!  	if(skelton(ii).ne.'t') go to 80 :  	if(skelton(ii+1).ne.'c'.or.skelton(ii+2).ne.'h')go to 80  	skelton(ii)='+'r  	skelton(ii+1)='k' 	  	ii=ii+2p
  	go to 80  c non-word initial tu  90	ii=2  100	ii=ii+1  	if(ii.gt.length-2) go to 120:  	if(skelton(ii).ne.'t'.or.skelton(ii+1).ne.'u') go to 1006  	if(skelton(ii+2).eq.'r'.or.skelton(ii+2).eq.'n' .or.9  	1  skelton(ii+2).eq.'m'.or.skelton(ii+2).eq.'l')goto110t:  	if(skelton(ii+2).ne.'e' .and. skelton(ii+2).ne.'a' .and.$  	1  skelton(ii+2).ne.'o') go to 100  	skelton(ii)='k'p  	skelton(ii+1)='h')  	skelton(ii+2)='o'd  	typlet(ii+1)=1	  	ii=ii+2l  	go to 100   110	ii=ii+29  	if(typlet(ii+1).gt.0.or.skelton(ii+1).eq.'u') go to 100t  	skelton(ii-2)='k'd  	skelton(ii-1)='h'd  	typlet(ii-1)=1	  	ii=ii+1o  	go to 100f  c word-final ye  120	if(length.lt.3) go to 1309  	if(skelton(length).ne.'y' .and. skelton(length).ne.'i')	  	1  go to 130  	skelton(length)='Y'   	typlet(length)=99   c word final ie  130	if(length.lt.4) go to 1409  	if(skelton(length2).ne.'i' .or. skelton(length).ne.'e')o  	1  go to 140 e  	skelton(length)='Y'k  	typlet(length)=99i  	skelton(length2)='+'  c intervocalic y or i	  140	ii=1i  150	ii=ii+1  	if(ii.gt.length) go to 170:  	if(skelton(ii).ne.'i' .and. skelton(ii).ne.'y')go to 1506  	if(typlet(ii-1).ge.0.or.typlet(ii+1).ge.0) go to 160  	skelton(ii)='Y'p  	typlet(ii)=99)	  	ii=ii+1   	go to 150f$  160	if(typlet(ii-1).ne.1) go to 150  	skelton(ii)='i'd  	typlet(ii)=-1a	  	ii=ii+1   	go to 150v$  c si or ti in position 3 and beyond	  170	ii=2   180	ii=ii+1  	if(ii.gt.length-3) go to 190:  	if(skelton(ii).ne.'s' .and. skelton(ii).ne.'t')go to 180:  	if(skelton(ii+1).ne.'i' .or. (skelton(ii+2).ne.'a' .and.6  	1  skelton(ii+2).ne.'o' .and. skelton(ii+2).ne.'u'))  	2  go to 180  	skelton(ii)='s'   	skelton(ii+1)='h'.  	typlet(ii+1)=1	  	ii=ii+2t  	go to 180h  c word-final guea  190	if(length.lt.5) go to 1959  	if(skelton(length-2).eq.'g'.and.skelton(length2).eq.'u'h7  	1  .and. skelton(length).eq.'e') skelton(length2)='+'y  c ue sequence  195	do 200 ii=1,length29  	if(skelton(ii).ne.'u'.or.skelton(ii+1).ne.'e')go to 200-  	skelton(ii)='o'2  	skelton(ii+1)='o's
  200	continuey  c sequences eu,ew,au,aw,ou,ow  	ii=1  240	ii=ii+1  	if(ii.gt.length) go to 2509  	if(skelton(ii).ne.'u'.and.skelton(ii).ne.'w') go to 2409:  	if(skelton(ii-1).ne.'e' .and. skelton(ii-1).ne.'a' .and.$  	1  skelton(ii-1).ne.'o') go to 240  	if(ii.eq.length) go to 2458  	if(skelton(ii+1).eq.'w' .or. skelton(ii+1).eq.'z' .or.!  	1  typlet(ii+1).ne.1) go to 240l  245	skelton(ii-1)='o'  	skelton(ii)='o'   	typlet(ii)=-1d	  	ii=ii+2o  	go to 240H  c word final ea,iai  250	if(length.lt.4) go to 260&  	if(skelton(length).ne.'a') go to 2603  	if(skelton(length2).ne.'e' .and. skelton(length2)c  	1  .ne.'i') go to 260r  	skelton(length)='+'f  	skelton(length2)='_'  	typlet(length2)=100D  c word-final aa:  260	if(skelton(length).ne.'a' .or. length.lt.4) go to 265  	skelton(length)='_'o  	typlet(length)=100  c word-final ae  265	if(length.lt.5) go to 268:     	if(skelton(length2).ne.'a'.or.skelton(length).ne.'e')  	1         go to 268o  	skelton(length)='_'   	typlet(length)=100  	skelton(length2)='+'  c word initial vowels7  268	call lngspl$cmpress(skelton,typlet,length,length2)e  	if(typlet(1).ge.0) go to 285  	ii=0  270	ii=ii+1  	if(ii.gt.length) go to 280  	if(typlet(ii).ge.0) go to 280e  	skelton(ii)='+'a  	go to 270n  280	skelton(ii-1)='_'  	typlet(ii-1)=100  c sequence 'dg'  285	do 290 ii=1,length23  	if(skelton(ii).eq.'d' .and. skelton(ii+1).eq.'g')e  	1  skelton(ii)='+'
  290	continue7  c the letter cl  	do 300 ii=1,length(  	if(skelton(ii).eq.'c') skelton(ii)='k'
  300	continue %  c sequence of 2 identical consonants	  	do 310 ii=1,length2n4  	if(typlet(ii).lt.0.or.skelton(ii).eq.'z')go to 3102  	if(skelton(ii).eq.skelton(ii+1)) skelton(ii)='+'
  310	continue04  	call lngspl$cmpress(skelton,typlet,length,length2)  c sequence ks  	do 320 ii=1,length2d9  	if(skelton(ii).ne.'k'.or.skelton(ii+1).ne.'s') goto 320f  	skelton(ii)='+'t  	skelton(ii+1)='x'.
  320	continue   c sequence xion  	ii=1  330	ii=ii+1  	if(ii.gt.length-3) go to 340"  	if(skelton(ii).ne.'x') go to 330$  	if(skelton(ii+3).ne.'n') go to 330;  	if(skelton(ii+1).ne.'i'.or.skelton(ii+2).ne.'o') goto 330l  	skelton(ii+1)='h'd  	typlet(ii+1)=-1f	  	ii=ii+3(  	go to 3307  c word-initial ps:  340	if(skelton(1).eq.'p'.and.skelton(2).eq.'s')skelton(1)	  	1  ='+'0  c sequences rh,ght,ph	  410	ii=1(  420	ii=ii+1  	if(ii.gt.length) go to 450"  	if(skelton(ii).ne.'h') go to 420$  	if(skelton(ii-1).eq.'r') go to 430$  	if(skelton(ii-1).eq.'p') go to 440  	if(ii.eq.length) go to 4509  	if(skelton(ii-1).ne.'g'.or.skelton(ii+1).ne.'t')goto420e  	skelton(ii)='e'r  	typlet(ii)=-1$  	skelton(ii+1)='+'	  	skelton(ii-1)='t' 	  	ii=ii+1p  	go to 4202  430	skelton(ii)='+'	  	ii=ii+1	  	go to 420r  440	skelton(ii-1)='+'  	skelton(ii)='f'r	  	ii=ii+1c  	go to 420e  c sequence gn  450	do 455 ii=1,length21  	if(skelton(ii).eq.'g'.and.skelton(ii+1).eq.'n')e  	1  skelton(ii)='+'
  455	continuee  c word initial kn pnn4  	if(skelton(2).eq.'n' .and. (skelton(1).eq.'k' .or.'  	1  skelton(1).eq.'p')) skelton(1)='+'V  c sequence xs  	do 550 ii=1,length2c3  	if(skelton(ii).eq.'x' .and. skelton(ii+1).eq.'s')d  	1  skelton(ii+1)='+'
  550	continuef4  	call lngspl$cmpress(skelton,typlet,length,length2);  c vowels preceeded only by consonants or trace of init vowu  	ii=0  560	ii=ii+1  	if(ii.gt.length) go to 580"  	if(skelton(ii).eq.'Y') go to 580  	if(typlet(ii).ge.0) go to 560r5  	if(skelton(ii).eq.'o'.or.skelton(ii).eq.'u')goto570f  	skelton(ii)='E'c  	typlet(ii)=102  	go to 5800  570	skelton(ii)='O'  	typlet(ii)=101  c vowel 'E'	  580	ii=1l  590	ii=ii+1  	if(ii.ge.length) go to 595"  	if(skelton(ii).ne.'E') go to 590$  	if(skelton(ii+1).ne.'r') go to 590  	temp=skelton(ii+2)4  	if((typlet(ii+2).eq.1 .and. temp.ne.'x' .and. temp7  	1   .ne.'h' .and. temp.ne.'r' .and. temp.ne.'w') .or..'  	1   (ii.eq.length-2)) skelton(ii)='O'l  	go to 590d  c word-final 'o' or 'u':  595	if(skelton(length).ne.'o'.and.skelton(length).ne.'u')  	1       go to 600   	skelton(length)='O'p  	typlet(length)=101  c word final 'oe'  600	if(length.lt.2) go to 605;     	if(skelton(length).ne.'e' .or. skelton(length2).ne.'o'c  	1  ) go to 605  	skelton(length2)='O'  	typlet(length2)=101c  	skelton(length)='+'g)  c 'E' or 'O' followed by consonants onlyh7  605	call lngspl$cmpress(skelton,typlet,length,length2)o	     	ii=0p  610	ii=ii+1  	if(ii.gt.length2) go to 630 6  	if(skelton(ii).ne.'O'.and.skelton(ii).ne.'E')goto610  	temp=skelton(ii)
  	pos=ii+1  	do 620 ii=pos,length6  	if(typlet(ii).ne.1 .and. typlet(ii).ne.98) go to 630
  620	continue2  	skelton(pos-1)='I'$  	if(temp.eq.'O') skelton(pos-1)='W'  	typlet(pos-1)=103c%  c delete all non-word initial vowelsp  630	do 640 ii=2,lengthc%  	if(typlet(ii).le.0) skelton(ii)='+'=
  640	continue 4  	call lngspl$cmpress(skelton,typlet,length,length2)  c     	do 760 ii=1,14	  760	outskel(ii)=skelton(ii)  	return  	end5    p:  	subroutine lngspl$cmpress(skelton,typlet,length,length2)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.0A  c  Unpublished .Restricted and confidential proprietary programs1<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'n  	implicit integer*2 (a-z)  	dimension typlet(21)  	character*1 skelton(21)o6  c compress out all occurences of '+' used to denote a  c deleted character  	next=1  	i=0 	  10	i=i+1t  	if(i.gt.length2) go to 40e   	if(skelton(i).ne.'+') go to 10,  c first '+' at position i.look for next one  	do 30 j=i,length2 "  	if(skelton(j+1).eq.'+') go to 20  	skelton(i)=skelton(i+next)  	typlet(i)=typlet(i+next)  	if(i+next.eq.length) go to 50o  	i=i+1e
  	go to 30  20	next=next+1r  30	continue%  40	if(skelton(length).ne.'+') returnu  50	length=length-next  	length2=length-1  	do 60 i=length+1,21)  	skelton(i)=' '  60	typlet(i)=999f  	return  	endn    g4  	integer function lngspl$locate*2 (skelton,lengths,6  	1       letter,lengthw,setlist,sethyp,setcap,setsuf,  	1       locflg,iostat)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.mA  c  Unpublished .Restricted and confidential proprietary programst<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'	  	implicit integer*2 (a-z)  	character*32 setlist(25)$  	character*1 skelton(14),letter(32)  	character*6 keye   	integer*4 lngspl$decode,iostat*  	integer*4 sethyp(25),wordskl(35),suftest)  	byte char7t5(127),nxtblk,sufstrp	! ,lett#  	byte locflg,setcap(25),setsuf(25)q  	include 'mastercom.for'e  	include 'globalsym.for'.8  	data char7t5/38*0,27,5*0,28,29,30,21*0,5,3*0,9,5*0,15,5  	1            7*0,21,0,1,5*0,31,0,0,2,0,4,0,6,7,8,0,f4  	2            10,11,12,13,14,0,16,17,18,19,20,0,22,  	3            23,24,25,26,5*0/n  	lngspl$locate=0i-  	if(lengthw.gt.21 .or. lengths.gt.14) returnt  	sufstrp=0t  	len1=lengths  	len2=lengthw  c do suffix stripping  	suftest=06%  	if(letter(lengthw).ne.'s') go to 50)-  	if(lengthw.lt.2 .or. lengths.lt.2) go to 60u(  	if(letter(lengthw-1).ne.'''') go to 404  	if(skelton(lengths).ne.'s' .or. skelton(lengths-1)  	1          .ne.'''') go to 60n  c suffix 's  	suftest=12  	len1=lengths-2
  	len2=len2-2s
  	go to 60  c suffix se(  40	if(skelton(lengths).ne.'s') go to 60  	suftest=3)  	len1=lengths-1
  	len2=len2-1	
  	go to 60
  c suffix ing-1  50	if(lengthw.le.3 .or. lengths .le. 2) go to 60+9  	if(letter(lengthw).ne.'g' .or. letter(lengthw-1).ne.'n'n,  	1  .or. letter(lengthw-2).ne.'i') go to 604  	if(skelton(lengths).ne.'g' .or. skelton(lengths-1)  	1 .ne.'n') go to 60s  	suftest=48  	len1=lengths-2
  	len2=len2-3.=  c convert characters in word and skeleton to 5 bit code and f  c move to array wordskl  60	continue  	do 70 i=1,35  70	wordskl(i)=0  	do 80 i=1,len1  	let=ichar(skelton(i))   	if(let.gt.127) returnu  80	wordskl(i)=char7t5(let)f  	do 90 i=1,len2  	let=ichar(letter(i))-96n  	if(letter(i).eq.'''') let=277  	if(letter(i).ge.'-' .and. letter(i).le.'/')let=let+79n$  	if(let.le.0 .or. let.gt.30) return  90	wordskl(14+i)=leto	  	nword=0s,  c use first 6 characters of skeleton as key  95	key=' 's
  	lenkey=6  	if(len1.lt.6) lenkey=len1(  	do 100 i=1,lenkeyi  100	key(i:i)=skelton(i)  	if(key.ge.'zzzzzz') return(  c find first disk sector to be searched!  	block=lngspl$bisrch(key,nxtblk)'.  c decode sector and look for matching records=  	iostat = lngspl$decode(wordskl,locflg,nxtblk,suftest,block,-1  	1           nword,setlist,sethyp,setcap,setsuf)t2  	if (iostat.ne.%loc(lngspl$_completed)) goto 1000  	lngspl$locate=nword(9  c for correction try adjusting s suffix and search againi  	if(locflg.ne.0) return  	if(sufstrp.ne.0) return'  	sufstrp=1(  	if(suftest.ne.3) go to 110  	suftest=0o  	wordskl(lengths)=19t
  	len1=len1+1	
  	go to 95<  110	if(skelton(lengths).ne.'s' .or. letter(lengthw).eq.'s')  	1          returnoC          if ((skelton(lengths).eq.'s') .and. (lengths.eq.1)) returnf  	suftest=3.  	wordskl(lengths)=0
  	len1=len1-1 
  	go to 95  1000	continue  	lngspl$locate = -1  	return  	end0    lA  	integer*4 function lngspl$decode(wordskl,locflg,nxtblk,suftest,i6  	1          block,nword,setlist,sethyp,setcap,setsuf)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.eA  c  Unpublished .Restricted and confidential proprietary programs+<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'o  	implicit integer (a-z)  	character*32 setlist(25).  	integer*4 sethyp(25),foundwo(35),predskl(35)$  	1         ,curdskl(35),wordskl(35)  	integer*4 status*  	byte locflg,nxtblk,setcap(25),setsuf(25)+  	integer*2 sector(256),nword,block,cur2(2)k  	include 'mastercom.for'i  	include 'globalsym.for',  	equivalence(curwrd,cur2))  	lngspl$decode = %loc(lngspl$_completed)t  c read block from disk($  5	read(2,rec=block,err=1000) sector  	do 10 j=1,35  10	predskl(j)=0  	preh=0  	pres=0  	prec=0
  	sectrn=0
  	hypres=0  	k=0l
  	recwon=1  	cur2(2)=0e  	cur2(1)=sector(recwon)*  15	curhyp=ishft(iand(curwrd,'70000'o),17)*  	if(iand(curwrd,'100000'o).eq.0) go to 20-  	entry=table(ishft(iand(curwrd,'7776'o),-1))	.  	curcap=ishft(iand(entry,'34000000000'o),-29).  	comlsk=ishft(iand(entry,'03600000000'o),-25).  	comlwo=ishft(iand(entry,'00174000000'o),-20).  	cursuf=ishft(iand(entry,'00003740000'o),-14).  	diflsk=ishft(iand(entry,'00000036000'o),-10)-  	diflwo=ishft(iand(entry,'00000001740'o),-5)l
  	difins=1,  	if(diflsk.eq.0 .and. diflwo.eq.0) difins=0.  	if(difins.eq.1) curdskl(1)=iand(entry,'37'o)
  	go to 30  c)  20	curcap=ishft(iand(curwrd,'7000'o),-9)h'  	comlsk=ishft(iand(curwrd,'0740'o),-5)   	comlwo=iand(curwrd,'37'o)(  	recwon=recwon+1l  	cur2(2)=00  	cur2(1)=sector(recwon)*  	cursuf=ishft(iand(curwrd,'176000'o),-10))  	diflsk=ishft(iand(curwrd,'001700'o),-6)t)  	diflwo=ishft(iand(curwrd,'000076'o),-1)i
  	difins=0  c  30	sumdif=diflsk+diflwo  	bits=0  	if(difins.eq.sumdif) go to 50a  	recwon=recwon+10  	cur2(2)=0)  	cur2(1)=sector(recwon)	  	bits=15   40	difins=difins+11
  	bits=bits-5s9  	curdskl(difins)=ishft(iand(curwrd,ishft('37'o,bits+1)),n"  	1                     -(bits+1))  	if(difins.eq.sumdif) go to 50f  	if(bits.gt.0) go to 40  	recwon=recwon+1n  	cur2(2)=0q  	cur2(1)=sector(recwon)	  	bits=15o
  	go to 40  c  50	if(bits.eq.0) go to 60
  	bits=bits-5'6  55	hypres=ior(ishft(hypres,5),ishft(iand(curwrd,ishft'  	1         ('37'o,bits+1)),-(bits+1)))m  	k=k+5l
  	go to 50  c'  60	if(iand(curwrd,'1'o).ne.0) go to 70,  	recwon=recwon+1t  	cur2(2)=0.  	cur2(1)=sector(recwon)	  	bits=10	
  	go to 55  c)  70	curhyp=ior(curhyp,ishft(hypres,29-k))s  	lensk=comlsk+diflsk3  	lenwo=comlwo+diflwol%  	masq=ishft('37777777777'o,32-lenwo).%  	curhyp=iand(ieor(curhyp,preh),masq)n
  	preh=curhyp	  	cursuf=ieor(cursuf,pres)
  	pres=cursuf.  	curcap=ieor(curcap,prec)
  	prec=curcapl  c  	k=0f  	if(diflsk.eq.0) go to 100c  	do 90 i=1,lensk3  	if(i.le.comlsk) go to 80  	k=k+1)(  	foundwo(i)=ieor(predskl(i),curdskl(k))  	predskl(i)=foundwo(i)   	if(k.eq.diflsk) go to 100t
  	go to 90  c  80	foundwo(i)=predskl(i)o  90	continue  c  100	if(diflwo.eq.0) go to 130  	lastad=lenwo+14)  	do 120 i=15,lastad  	if(i.le.comlwo+14) go to 110  	k=k+1.(  	foundwo(i)=ieor(predskl(i),curdskl(k))  	predskl(i)=foundwo(i)i  	if(k.eq.sumdif) go to 130   	go to 1201  c  110	foundwo(i)=predskl(i)
  120	continuei  c
  130	continue   	if(lensk.eq.14) go to 150-  	lensp1=lensk+1  	do 140 i=lensp1,14  	foundwo(i)=0  	predskl(i)=0
  140	continuel  c  150	if(lenwo.eq.21) go to 170  	lenwpl=lenwo+15'  	do 160 i=lenwpl,35  	foundwo(i)=0  	predskl(i)=0
  160	continuef  c match skeleton.  170	do 180 i=1,14(  	if(foundwo(i).ne.wordskl(i)) go to 200
  180	continueq  	totlen=lenwo+14i#  c match suffix as well as skeleton 9  	if(suftest.eq.0 .and. (iand(cursuf,21).ne.0)) go to 200c  	if(suftest.eq.0) go to 185)  	if(iand(cursuf,suftest).eq.0) go to 200   185	if(locflg.eq.0) go to 195
  c match wordo  	do 190 i=15,35(  	if(foundwo(i).ne.wordskl(i)) go to 200
  190	continue.  c match on all properties  195	nword=nword+1  	if(locflg.eq.2) return=  c load dictionary word from foundwo into setlist,translating)  c from 5 bits to 75  	do 500 i=15,totlen  	let=foundwo(i)+96w  	if(foundwo(i).eq.27) let=3912  	if(foundwo(i).ge.28 .and. foundwo(i).le.30) let=  	1      foundwo(i)+17%  	setlist(nword)(i-14:i-14)=char(let)e
  500	continuef  	i=lenwo+1)  	setlist(nword)(i:32)=' '(  c load hyphens,cap code, and suffix map  	sethyp(nword)=curhyp  	setcap(nword)=curcap  	setsuf(nword)=cursuf$  c append suffix to word if required-     	if(suftest.eq.3) setlist(nword)(i:i)='s'n/  	if(suftest.eq.12) setlist(nword)(i:i+1)='''s'O  	if(suftest.ne.48) go to 520r  	setlist(nword)(i:i+2)='ing'.#  c adjust hyphen map for ing suffix.)  	if((iand(cursuf,'40'o)).eq.0) go to 520)
  	hyping='1'ok5  	sethyp(nword)=ior(sethyp(nword),ishft(hyping,33-i))e  520	if(locflg.eq.1) returnl  c  200	recwon=recwon+1  	cur2(2)=0s  	cur2(1)=sector(recwon)
  	hypres=0  	k=0 "  	if(curwrd.ne.'177777'o) go to 15  	if(nxtblk.eq.0) return
  	nxtblk=0  	block=block+1(	  	go to 5g  1000	continue  	call errsns(,,,,status)o  	lngspl$decode = status  	return  	endn    e0  	integer function lngspl$bisrch *2 (key,nxtblk)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.lA  c  Unpublished .Restricted and confidential proprietary programsa<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'h  	implicit integer*2 (a-z)  	character*6 key,tabkey  	byte char5t7(32),nxtblkg  	integer*4 char5,shifti  	include 'mastercom.for'c9  	data char5t7/32,89,98,99,100,69,102,103,104,73,106,107,r9  	1            108,109,110,79,112,113,114,115,116,87,118,D.  	2            119,120,121,122,39,45,46,47,95/@  c binary search pointer table for first block with pointer less
  c than 'key'.
  	nxtblk=0  	lb=0  	ub=850  10	if(ub-lb.ge.2) go to 20h?  c no exact match in pointer table.first block with record lessd  c than key must be block lb  	lngspl$bisrch=lb  	if(lb.eq.0) lngspl$bisrch=1h  	return!  20	lngspl$bisrch=ishft(ub+lb,-1)0-  c convert pointers in table from 5 to 7 bits 
  	shift=25
  	do 30 i=1,6s9   	char5=iand(ishft(pointer(lngspl$bisrch),-shift),'37'o) $  	tabkey(i:i)=char(char5t7(char5+1))  30	shift=shift-55  	if(key.lt.tabkey) go to 40  	if(key.gt.tabkey) go to 50  c exact match in pointer tabler  	lngspl$bisrch=lngspl$bisrch-1g
  	nxtblk=1  	return  c bisect range of search)  40	ub=lngspl$bisrch
  	go to 10  50	lb=lngspl$bisrch
  	go to 10  	endp    e7  	integer function lngspl$initialize_user(size,usertab)t@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.MA  c  Unpublished .Restricted and confidential proprietary programsr<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'u  	implicit integer(a-z)s  	integer usertab(*)  	include 'globalsym.for'	    	usertab(1)=size-1)!  	usertab(2)=ishft(usertab(1),-4)3.          if (usertab(2).gt.255) usertab(2)=255$  	usertab(3)=usertab(1)-usertab(2)-7,  	usertab(4)=ishft(size,-1) + ishft(size,-2)  	usertab(5)=0    	do 10 i=6,usertab(3)  10	usertab(i)='17777777'o  	do 20 i=usertab(3)+1,sizem  20	usertab(i)=04    	lngspl$initialize_user = %loc(lngspl$_completed)  	return  	end,    18  	integer function lngspl$verify_word_user(word,usertab,  	1       hyphens)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.sA  c  Unpublished .Restricted and confidential proprietary programs(<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'e  	implicit integer(a-z)i  	character*(*) word  	dimension usertab(*)  	! byte let!  	integer*2 length,capcode,capdicl  	character*1 letter(32)  	include 'globalsym.for's
  c initialize-7  	lngspl$verify_word_user=%loc(lngspl$_not_initialized)lA  	if(usertab(2).ne.ishft(usertab(1),-4).and.(usertab(2).ne.255)) e       &  return   	length=index(word,' ')-1#  	if(length.eq.-1) length=len(word)s6  	lngspl$verify_word_user=%loc(lngspl$_illegal_string)*  	if(length.eq.0 .or. length.gt.32) return  	do 10 i=1,length  10	letter(i)=word(i:i)t  	do 20 i=length+1,32   20	letter(i)=' 'r  c reduce word to lower case,  	call lngspl$lowcase(letter,length,capcode);  c calculate code and position in table(i.e. ind ) for word)1  	call lngspl$functn(codefn,indxfn,letter,length)r&  c verify word against user dictionary?  	lngspl$verify_word_user=lngspl$userver(indxfn,codefn,capcode,l5  	1                    usertab,hyphens,capdic,length) >  	if(lngspl$verify_word_user .ne. %loc(lngspl$_word_not_found)&  	1          .or. capcode.le.2) return<  c if word is not found and capcode>2 , reduce to lower case  c and try again  	do 30 i=1,length  	let=ichar(letter(i))-  	if((let.ge.'101'o .and. let.le.'132'o) .or.c-  	1  (let.ge.'300'o .and. let.le.'317'o) .or.t)  	2  (let.ge.'321'o .and. let.le.'335'o))f"  	3         letter(i)=char(let+32)  30	continue1  	call lngspl$functn(codefn,indxfn,letter,length)t?  	lngspl$verify_word_user=lngspl$userver(indxfn,codefn,capcode,u5  	1                    usertab,hyphens,capdic,length)u  	return  	endn  5  	integer function lngspl$add_word_user(word,hyphens,	  	1       usertab)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'f  	implicit integer(a-z)k  	character*(*) word  	dimension usertab(*)  	integer*2 capcode,length  	character*1 letter(32)  	include 'globalsym.for'n  c check for not initialized4  	lngspl$add_word_user=%loc(lngspl$_not_initialized)A  	if(usertab(2).ne.ishft(usertab(1),-4).and.(usertab(2).ne.255)) s       &  return   c check for user table full(  	if(usertab(5).gt.usertab(4)) go to 110
  c initializeg  	length=index(word,' ')-1#  	if(length.eq.-1) length=len(word)	3  	lngspl$add_word_user=%loc(lngspl$_illegal_string)d  	if(length.gt.32) return   	do 10 i=1,length  10	letter(i)=word(i:i)t  	do 20 i=length+1,32k  20	letter(i)=' '2  	size=usertab(1)t  	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)   c reduce word to all lower case,  	call lngspl$lowcase(letter,length,capcode)  	cap4=capcode  	if(cap4.gt.3) cap4=3;  c calculate code and position in table(i.e. ind ) for word 1  	call lngspl$functn(codefn,indxfn,letter,length)c  	code=iand(codefn,'17777777'o)l%  	if(code.ge.'17777776'o) code=code-2e  	ind=iand(indxfn,size)i$  	if(ind.gt.maxindx) ind=ind-maxindx
  	rehash=0  	q=iand(code,'177'o)0  	a=3-q=9  c if location 'i' of usertab is unused,word can be added(  30	i=ind+50<    	if(iand(usertab(i),'17777777'o).eq.'17777777'o) go to 708  c if code is found in location 'i' ,word already exists3  	if(iand(usertab(i),'17777777'o).eq.code) go to 60i(  c try next location if rehash < maxrhsh!  	if(rehash.gt.maxrhsh) go to 110l  	rehash=rehash+1d	  	a=a+q+q.  	ind=ind+aq  c watch for table wrap around  40	if(ind.lt.maxindx) go to 30o  	ind=ind-maxindxc
  	go to 40  c word already exists4  60	lngspl$add_word_user = %loc(lngspl$_word_exists)9  c compare case of input word with dictionary case.change1  c dictionary case if necessaryi3  	capdic=ishft(iand(usertab(i),'00060000000'o),-22)d  	if(capdic.eq.cap4) returnh'  	if(capdic.eq.3 .or. cap4.eq.3) return0  	if(capdic.lt.cap4) returno+  c change case in dictionary to match input 0  	lngspl$add_word_user = %loc(lngspl$_completed)6  	usertab(i)=ior(iand(usertab(i),'37717777777'o),ishft  	1          (cap4,22))f  	return3  c insert code and capitalization into location 'i'('  70	usertab(i)=ior(code,ishft(cap4,22))f  	usertab(5)=usertab(5)+1 0  	lngspl$add_word_user = %loc(lngspl$_completed)  c)  c***************************************t%  c add word to user word list on disky)  c***************************************i  c'  c insert hyphenation into location 'i'm-  	if(length.lt.10 .or. hyphens.eq.0) go to 80'*  	mi=ior(hyphens,ishft(hyphens,length-33))2  	mi=ishft(iand(mi,'37777760000'o),-13) + iand(mi,  	1        '17777'o)  	if(mi.gt.8190) mi=mi-8191-  	mi=iand(mi,usertab(2))$  	if(usertab(size-mi).eq.0) go to 90+  	if(usertab(size-mi).eq.hyphens) go to 100e	  	mi=mi+1r$  	if(usertab(size-mi).eq.0) go to 90+  	if(usertab(size-mi).eq.hyphens) go to 100o	  	mi=mi+1e$  	if(usertab(size-mi).eq.0) go to 90+  	if(usertab(size-mi).eq.hyphens) go to 100	  	hyphens=0k;  80	usertab(i)=ior(usertab(i),iand(hyphens,'37700000000'o)))  	return  90	usertab(size-mi)=hyphens,  100	usertab(i)=ior(usertab(i),ishft(mi,24))  	return  c user memory space full0:  110	lngspl$add_word_user = %loc(lngspl$_user_memory_full)  	return  	endl  8  	integer function lngspl$delete_word_user(word,usertab)@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.iA  c  Unpublished .Restricted and confidential proprietary programs1<  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'c  	implicit integer(a-z)o  	character*(*) word  	dimension usertab(*)  	integer*2 length,capcode  	character*1 letter(32)  	include 'globalsym.for's  c check for not initialized7  	lngspl$delete_word_user=%loc(lngspl$_not_initialized).A  	if(usertab(2).ne.ishft(usertab(1),-4).and.(usertab(2).ne.255)) o       &  return1
  c initializer  	length=index(word,' ')-1#  	if(length.eq.-1) length=len(word)16  	lngspl$delete_word_user=%loc(lngspl$_illegal_string)  	if(length.gt.32)return  	do 10 i=1,length  10	letter(i)=word(i:i)t  	do 20 i=length+1,32   20	letter(i)=' '5  	size=usertab(1)l  	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)  c reduce word to lower case,  	call lngspl$lowcase(letter,length,capcode)  	cap4=capcode  	if(cap4.gt.3) cap4=3;  c calculate code and position in table(i.e. ind ) for word)1  	call lngspl$functn(codefn,indxfn,letter,length)e  	code=iand(codefn,'17777777'o)d%  	if(code.ge.'17777776'o) code=code-2p  	ind=iand(indxfn,size)u$  	if(ind.gt.maxindx) ind=ind-maxindx
  	rehash=0  	q=iand(code,'177'o)   	a=3-qw9  c if location 'i' of usertab is unused,word is not founds  30	i=ind+52<    	if(iand(usertab(i),'17777777'o).eq.'17777777'o) go to 608  c if code and capitalization match ,word can be deleted3  	if(iand(usertab(i),'17777777'o).ne.code) go to 35o3  	capdic=ishft(iand(usertab(i),'00060000000'o),-22)2-  c compare case of input word with dictionary=  	if(capdic.eq.cap4) go to 70o)  	if(capdic.eq.3 .or. cap4.eq.3) go to 600  	if(capdic.lt.cap4) go to 70 
  	go to 60(  c try next location if rehash < maxrhsh"  35	if(rehash.gt.maxrhsh) go to 60  	rehash=rehash+1c	  	a=a+q+q$  	ind=ind+ay  c watch for table wrap around  40	if(ind.lt.maxindx) go to 30C  	ind=ind-maxindxo
  	go to 40  c word not founds:  60	lngspl$delete_word_user = %loc(lngspl$_word_not_found)  	return   c delete code from location 'i'  70	usertab(i)='17777776'o3  	lngspl$delete_word_user = %loc(lngspl$_completed)c  c)  c***************************************e*  c delete word from user word list on disk)  c***************************************e  c  	return  	end5  8  	integer function lngspl$userver(indxfn,codefn,capcode,1  	1                usertab,hyphens,capdic,length)0@  c  'Houghton Mifflin Spelling Verification-Correction Copyright=  c  (c) Houghton Mifflin 1983 . All rights strictly reserved.nA  c  Unpublished .Restricted and confidential proprietary programs <  c  of Houghton Mifflin . Licenced for use solely in DIGITAL<  c  software . Reproduction , disclosure , or re-creation of=  c  embodied computer programs or algorithms is prohibited .'f  	implicit integer(a-z)h  	dimension usertab(*)&  	integer*2 capcode,capdic,length,cap2  	include 'globalsym.for't
  c initialize /  	lngspl$userver = %loc(lngspl$_word_not_found)l  	size=usertab(1)7  	maxindx=usertab(3)  	maxrhsh=ishft(size,-6)  	hyphens=05
  	rehash=0  	code=iand(codefn,'17777777'o)a%  	if(code.ge.'17777776'o) code=code-2e  	ind=iand(indxfn,size)=$  	if(ind.gt.maxindx) ind=ind-maxindx  	q=iand(code,'177'o)a  	a=3-q	9  c if location 'i' of usertab is unused,word is not found   30	i=ind+5:    	if(iand(usertab(i),'17777777'o).eq.'17777777'o) return+  c look for code in location 'i' of usertabo3  	if(iand(usertab(i),'17777777'o).eq.code) go to 60 (  c try next location if rehash < maxrhsh  	if(rehash.gt.maxrhsh) return  	rehash=rehash+1o	  	a=a+q+q   	ind=ind+ai  c watch for table wrap around  40	if(ind.lt.maxindx) go to 30u  	ind=ind-maxindx,
  	go to 40   c word found. supply hyphen map+  60	hyphens=iand(usertab(i),'37700000000'o)c4  	if(length.gt.9 .and. hyphens.ne.0) hyphens=usertab   	1    (size-ishft(hyphens,-24))3    	lngspl$userver = %loc(lngspl$_correct_spelling)u  c check for case mismatch  	cap2=capcode  	if(capcode.gt.3) cap2=3 3  	capdic=ishft(iand(usertab(i),'00060000000'o),-22)a  	if(cap2.eq.capdic) return(-  	lngspl$userver=%loc(lngspl$_case_incorrect)a1  	if(cap2.eq.1 .and. capdic.eq.0) lngspl$userver=z*  	1          %loc(lngspl$_initial_capital);  	if(cap2.eq.2) lngspl$userver=%loc(lngspl$_all_upper_case)r  	return  	end 