  C   PROGRAM Test_Hyphen_Maps   CJ  C Tests the storage of hyphen maps in the User memory, for a user memory F  C size of 64k bytes, and for random words of 20 characters in length.  C  G  C Creates random words, adding them to the user memory. Then verifies  J  C the words against the user memory to see if the hyphen map returned is =  C the one added, incorrect but non-zero, or has become zero.   CI  C Stores the hyphen maps for these random words that are returned OK in  H  C a table, so can determine if the number added and retreived from the 4  C User memory correctly, are in fact all different.  C  C CATHY BAKER        11-JAN-84   C            IMPLICIT INTEGER (a-z)   #         PARAMETER	user_size = 16384 6         INTEGER*4	user_memory(user_size)	! User memory   B         PARAMETER	word_len = 20           ! Length of random words>         PARAMETER	end_value = 12000	! No of words looped roundA         PARAMETER	tot_hyps = user_size/16 ! Hyphen map table size    <         INTEGER*4	hyphen_tab(tot_hyps)    ! Hyphen map table?         INTEGER*4	hyp_tab_count           ! No of maps in table    B         CHARACTER*32	word, message	        ! 'Word' is random word6         INTEGER*4	hyphen			! Hyphen map of random word8         INTEGER		new_hyphen      	! Returned from VERIFY   4         LOGICAL*1	corr			! Initialize with corrector   G         INTEGER*4	lngspl$initialize_verifier, lngspl$terminate_verifier ?         INTEGER*4	lngspl$add_word_user, lngspl$verify_word_user    #         EXTERNAL		lngspl$_completed *         EXTERNAL		lngspl$_correct_spelling%         EXTERNAl		lngspl$_word_exists   C'  C To generate random, lowercase words.   C         INTEGER*4 	ibit           CHARACTER*1      randlet         INTEGER*2	ix,iy           DATA 		ix,iy /2345,5671/      1	format(' ',A32,5X,Z8) $   2	format(' Initialize status: ',A)9   3      format(' No of words added to user memory: ',I5) =   4	format(' Percentage of words with lost hyphen map: ', I5) 3   5	format(' Error verifying word in user memory.') @   6      format(' No of words with mismatch, non-zero map: ',I5)5   7      format(' No of zero hyphen maps added: ',I5) 9   8      format(' No of zero hyphen maps read back: ',I5) #   9	format(' Add final status: ',A) %   10    	format(' Verify status: ',A) ;   11     format(' No. of different hyphen maps added: ',I5) -   12     format(' Hyphen map table is full.')      C7  C Initialize the verifier, counts and hyphen map table   C            err_ct = 0         count = 0          new_zero = 0         old_zero = 0         hyp_tab_count = 0             DO 25 i=1,tot_hyps   25	   hyphen_tab(i) = 0             corr = .true. H         status = lngspl$initialize_verifier ( 'LNGSPLAED', 'LNGSPLAEM', H       &                                   corr, user_size, user_memory )       4      	IF (status.eq.%loc(lngspl$_completed)) GOTO 50  C7  C Write error message and exit if initialization fails   C&          CALL etext( status, message )0      	mess_length =INDEX(message,' ')-1        	+          WRITE (6,2) message(1:mess_length)           GOTO  900     CH  C Loop round, creating a random word and its hyphen map, and adding to   C the user_memory.   C      50     CONTINUE    -  	DO 200 j=1,end_value			! No of random words          	    do 60 i=1,326   60   		word(i:i) = ' '			! Initialize word to spaces   2  	    do 100 i=1,word_len			! 'word_len' char word2   100		word(i:i) = randlet(26)         ! generated     	    hyphen = 03  	    do 110 i=1,word_len-2		! 'word_len' char word 9  		call randu(ix,iy,yfl)           ! hyphen map generated   		ibit = 0   		if (yfl.ge.0.5) ibit = 1   		hyphen = hyphen * 2 + ibit   110	    continue 0  	    hyphen = hyphen * (2**(32 - word_len + 1))   ,  C Record no. of zero hyphen maps generated.   5              IF (hyphen.eq.0) old_zero = old_zero + 1   		   C  G  C Add the word to the user memory. If it already exists, just ignore,  K  C and go get the next random word. Any other status apart from 'completed'   C take as 'user_memory_full'.  C  	    H   120        status = lngspl$add_word_user ( word, hyphen, user_memory )=              IF (status.eq.%loc(lngspl$_word_exists)) goto 50 <              IF (status.ne.%loc(lngspl$_completed)) goto 500      :      	    count = count + 1           	! No of words added     C=  C Verify that the word's hyphen map has been added correctly   C          new_hyphen = 0 H      	status = lngspl$verify_word_user ( word, user_memory, new_hyphen )   ;          IF (status.ne.%loc(lngspl$_correct_spelling)) THEN   	    WRITE(6,5)  *              CALL etext( status, message )4      	    mess_length =INDEX(message,' ')-1        	0              WRITE (6,10) message(1:mess_length)  	    GOTO 900          ENDIF     CJ  C Keep counts of incorrect non-zero maps returned (err_ct) and zero maps   C returned (new_zero).   C?          IF ((new_hyphen.ne.hyphen).and.(new_hyphen.ne.0)) THEN   	    err_ct = err_ct + 1   	    GOTO 200  	ENDIF    "          IF (new_hyphen.eq.0) THEN  	    new_zero = new_zero + 1   	    GOTO 200  	ENDIF 	             CD  C The map is correct and non-zero. Add it to 'hyphen_tab' (if it isK  C not already present), to see how many different hyphen maps are in fact  &  C added to the user_memory correctly.K  C Add to hyphen map table where first zero record found (i.e. at bottom).  %  C Make sure table is not full first.   C4              IF (hyp_tab_count.eq.tot_hyps) GOTO 200     	    DO 115 m = 1,tot_hyps                    =  		IF (hyphen.eq.hyphen_tab(m)) GOTO 200  ! Ignore duplicates ;  		IF (hyphen_tab(m).eq.0) THEN           ! Next empty slot   		    hyphen_tab(m) = hyphen (  		    hyp_tab_count = hyp_tab_count + 1  		    GOTO 200   		ENDIF      115	    CONTINUE        C End of random word loop      200	CONTINUE	        C  C Write out results.   C      500    CONTINUE      C%  C Write out final add word status...   C&          CALL etext( status, message )0      	mess_length =INDEX(message,' ')-1        	+          WRITE (6,9) message(1:mess_length)   C  C Counts...  C         	WRITE(6,3) count@      	WRITE(6,4) ((new_zero - old_zero + err_ct)  * 100) / count          WRITE(6,6) err_ct          WRITE(6,7) old_zero          WRITE(6,8) new_zero"          WRITE(6,11) hyp_tab_count3          IF (hyp_tab_count.eq.tot_hyps) WRITE(6,12)      C Complete the program       900    CONTINUE    ,      	status = lngspl$terminate_verifier ( )          CALL exit   	      	END      A  C***************************************************************   C*  C	FUNCTION TO RETURN A RANDOM CHARACTER.   C  C	NUM	26 - LOWERCASE ONLY&  C	NUM	52 - MIXED LOWER AND UPPERCASE   C#  	character*1 function randlet(num)   	integer*2 ix,iy   	character*1 letset(52)  	data ix,iy/2345,5671/   	data letset/  A       &	     'a','b','c','d','e','f','g','h','i','j','k','l','m', A       &	     'n','o','p','q','r','t','s','u','v','w','x','y','z', A       &	     'A','B','C','D','E','F','G','H','I','J','K','L','M', A       &	     'N','O','P','Q','R','T','S','U','V','W','X','Y','Z'/   	call randu(ix,iy,yfl)   	index = int(yfl*num)+1  	randlet = letset(index)   	return  	end         '        SUBROUTINE etext (ecode,message)            CHARACTER*(*)	message        INTEGER*4		ecode    *        EXTERNAL		lngspl$_correct_spelling (        EXTERNAL		lngspl$_initial_capital(        EXTERNAL		lngspl$_all_upper_case (        EXTERNAL		lngspl$_case_incorrect (        EXTERNAL		lngspl$_word_not_found #        EXTERNAL		lngspl$_completed  (        EXTERNAL		lngspl$_limit_exceeded %        EXTERNAL		lngspl$_word_exists  *        EXTERNAL		lngspl$_corrector_absent (        EXTERNAL		lngspl$_illegal_string )        EXTERNAL		lngspl$_not_initialized  *        EXTERNAL		lngspl$_user_memory_full ,        EXTERNAL		lngspl$_loop_count_reached &        EXTERNAL		lngspl$_compound_word$        EXTERNAL		lngspl$_end_of_line   +        ENCODE(len(message),1,message) ecode &      1 FORMAT('Undefined_error_',Z8.8)6        IF (ecode .EQ. %LOC(lngspl$_correct_spelling) )'       &    message = 'Correct_Spelling' 6        IF (ecode .EQ. %LOC(lngspl$_initial_capital) ) &       &    message = 'Initial_Capital'5        IF (ecode .EQ. %LOC(lngspl$_all_upper_case) )  %       &    message = 'All_Upper_Case' 5        IF (ecode .EQ. %LOC(lngspl$_case_incorrect) )  %       &    message = 'Case_Incorrect' 5        IF (ecode .EQ. %LOC(lngspl$_word_not_found) )  %       &    message = 'Word_Not_Found' 0        IF (ecode .EQ. %LOC(lngspl$_completed) )         &    message = 'Completed'5        IF (ecode .EQ. %LOC(lngspl$_limit_exceeded) )  %       &    message = 'Limit_Exceeded' 2        IF (ecode .EQ. %LOC(lngspl$_word_exists) ) "       &    message = 'Word_Exists'7        IF (ecode .EQ. %LOC(lngspl$_corrector_absent) )  '       &    message = 'Corrector_Absent' 5        IF (ecode .EQ. %LOC(lngspl$_illegal_string) )  %       &    message = 'Illegal_String' 6        IF (ecode .EQ. %LOC(lngspl$_not_initialized) ) &       &    message = 'Not_Initialized'7        IF (ecode .EQ. %LOC(lngspl$_user_memory_full) )  '       &    message = 'User_Memory_Full' 9        IF (ecode .EQ. %LOC(lngspl$_loop_count_reached) )  )       &    message = 'Loop_count_reached' 4        IF (ecode .EQ. %LOC(lngspl$_compound_word) ) $       &    message = 'Compound_word'2        IF (ecode .EQ. %LOC(lngspl$_end_of_line) ) "       &    message = 'End_of_line'   
        RETURN 
        END   