,  C	TITLE	Houghton Mifflin Utility (LHMCORVC)  C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  C;  C	Houghton Mifflin entry point routine to find corrections   C	for a misspelt word:   C  C			LNGSPL$GET_CORRECTION  C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C:  C X01.02	Cathy Baker	 9-FEB-84	Changed INCLUDE statements  C						to use logicals.  C;  C X01.03	Cathy Baker	 4-JUN-84	Made some simplifications,    C						approved by Houghton.   C--  8  	INTEGER FUNCTION lngspl$get_correction *4(word,caserr,.  	1  caseflg,ucorflg,usertab,try,list,hyphens)  C++  C    FUNCTIONAL DESCRIPTION:   CL  C Suggests a list of up to 30 words as suitable corrections for a misspelt N  C 'word'. Returns a correction list in 'list', plus an array of hyphen maps,   C 'hyphens'.   CM  C Parameters 'try' and 'list' are updated by this routine, until the return  Q  C status is 'lngspl$_limit_exceeded', meaning no more suggestions are available. O  C The entry point into the routine is determined by the value of 'try'. (Also, L  C the order of tries 3-7 is changed if the word is exactly 4 letters long.)  C
  C'try' 1 :   >  C    	initializes -  	this call's corrections list, 'setlist'  C    			hyphen array, 'sethyp' =  C    			related data from common block LNGSPL$DATA_CORRECTOR   CJ  C    	converts the word to lowercase, copying it into scratchpad 'modlet'  CC  C    	generates word's skeleton, in 'skelton' calling LNGSPL$RULES   CE  C    	If 'caserr' flag NOT set, immediately continues with 'try' 2.  >  C    	If 'caserr' flag set, means that the verifier returned M  C    	'lngspl$_case_incorrect' for this word. Searches for case corrections  
  C    	in:  C  C    		user dictionary !  C    		master dictionary on disk   C'try' 2 :   CE  C    	calls LNGSPL$TRANSP to transpose each pair of letters in turn  G  C    	and test against the dictionaries. If the transposed version is  D  C    	verified by a dictionary, it is added to 'setlist', i.e. the 9  C    	list of new suggestions from this particular call.   C 'try' 3 :  CC  C    	calls LNGSPL$REPLACE to replaced each letter with all other  F  C    	possible letters in turn. If the replaced version is verified,   C    	added to 'setlist'.  C 'try' 4 :  CA  C    	calls LNGSPL$DELETE to delete each letter in turn. If the  8  C    	deleted version is verified, added to 'setlist'.   C 'try' 5 :  CG  C    	calls LNGSPL$INSERT to insert each possible letter between each  K  C    	pair of letters in turn. If the inserted version is verified, added    C    	to 'setlist'.  C 'try' 6 :  CG  C    	calls LNGSPL$LOCATE to search the master dictionary on disk for  G  C    	each word having the same skeleton as the misspelt word.  Those  $  C    	found are added to 'setlist'.  C 'try' 7 :  CE  C    	calls LNGSPL$TARGET to apply a set of upto 72 rules to change  J  C    	the misspelt word's skeleton and generate another. After doing so, @  C    	the actions of 'try' 6 are done on the modified skeleton.  CJ  C The routine is not exited until a new set of corrections is generated, I  C which may be after one or more increments of 'try'. When at least one    C new correction is available:   CK  C    i)	the case of corrections is changed according to value of 'caseflg'   C    	calling LNGSPL$RESCASE J  C   ii) duplicate suggestions are removed, and new ones are added to the B  C    	parameter 'list', from 'setlist', by calling LNGSPL$DUPWORD  C  C    CALLING SEQUENCE:   C2  C status.wlc.v = LNGSPL$GET_CORRECTION		Calling..&  C    	 	(word.rt.dx,			LNGSPL$LOWCASE*  C    	    	 caserr.rbu.r,			LNGSPL$FUNCTN(  C    		 caseflg.rbu.r,			LNGSPL$USERVER&  C    		 ucorflg.rbu.r,			LNGSPL$RULES'  C    		 usertab.rlu.ra,		LNGSPL$LOCATE /  C    		 try.mlu.r,			corrector only routines.. $  C    		 list.mt.ds,			LNGSPL$TRANSP(  C    		 hyphens.wlu.ra)		LNGSPL$REPLACE  C    						LNGSPL$DELETE   C    						LNGSPL$INSERT   C    						LNGSPL$DUPWORD  C     						LNGSPL$TARGET  C    						LNGSPL$RESCASE  C  C    FORMAL PARAMETERS:  CQ  C 'try' -  storing the number of times that this routine has been called with a    C          particular word.L  C 'list' -  the list of corrections that the routine has so far suggested, 6  C     	    from all calls using this particular word.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C  C lngspl$_completedI  C lngspl$_limit_exceeded :	no more corrections, or maximum of 30 reached E  C lngspl$_illegal_string :  	'0 < word_length < 32 ' does not apply. @  C lngspl$_not_initialized :  	control variable 'verinit' <> 25.  C  9  C The status can also be that from a failed disk access.   C  C    SIDE EFFECTS:   C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER*2 (a-z)  	CHARACTER*(*)	word,list )  	INTEGER*4	lngspl$transp,lngspl$replace, '  	2		lngspl$delete,lngspl$insert,iostat   	BYTE		locflg,skeldone 7  	INTEGER		indxfn,codefn,lngspl$userver,try,usertab(*),   	2       	hyp4,hyphens(30)   	CHARACTER*1	modskel(14) "  	LOGICAL*1	caseflg,caserr,ucorflg  	INCLUDE		'verifycom/list'   	INCLUDE		'corectcom/list'   	INCLUDE		'globalsym/list'   C
  c initialize   	lengthw=index(word,' ')-1 %  	if(lengthw.eq.-1) lengthw=len(word) ?  c step thru the various stages of correction based on value of   c try6  	lngspl$get_correction = %loc(lngspl$_limit_exceeded)
  50	try=try+1   	do 60 i=1,25
  	sethyp(i)=0 
  	setcap(i)=0 
  	setsuf(i)=0   60	setlist(i)=' '9  	if(lengthw.eq.4) go to(100,190,500,600,200,300,400,700)   	1                ,try ,  	go to(100,190,200,300,400,500,600,700),try  	return
  c initialize 9  100	lngspl$get_correction = %loc(lngspl$_illegal_string) ,  	if(lengthw.eq.0 .or. lengthw.gt.32) return7  	lngspl$get_correction = %loc(lngspl$_not_initialized)   	if(verinit.ne.25) return6  	lngspl$get_correction = %loc(lngspl$_limit_exceeded)<  c list will contain cumulative list of candidates,separated$  c by blanks with duplicates removed
     	list=' '           skeldone=0   	do 110 i=1,30   110	hyphens(i)=0   	do 120 i=1,lengthw  120	letter(i)=word(i:i)  	do 130 i=lengthw+1,32   130	letter(i)=' '  c reduce word to lower case-  	call lngspl$lowcase(letter,lengthw,capcode)   	if(capcode.le.2) go to 140  	do 135 i=1,lengthw  	let=ichar(letter(i))-  	if((let.ge.'101'o .and. let.le.'132'o) .or. -  	1  (let.ge.'300'o .and. let.le.'317'o) .or. )  	2  (let.ge.'321'o .and. let.le.'335'o))   	3   letter(i)=char(let+32)
  135	continue   140	do 145 i=1,32  145	modlet(i)=letter(i)9  c omit case error correction if this is not a case error   	if(.not.caserr) go to 50+  c case error correction in user dictionary 2  	call lngspl$functn(codefn,indxfn,letter,lengthw)#          if(.not.ucorflg) go to 155 =  	lngspl$get_correction=lngspl$userver(indxfn,codefn,capcode, 1  	1                  usertab,hyp4,capdic,lengthw) ;  	if(lngspl$get_correction.eq.%loc(lngspl$_word_not_found)) 
  	1	go to 155   	do 150 i=1,32   150	setlist(1)(i:i)=letter(i)  	setcap(1)=capdic  	sethyp(1)=hyp4	  	nword=1   	go to 510 F  c case error correction in master dictionary; first generate skeleton  155   	lengths=lengthw +  	call lngspl$rules(letter,skelton,lengths)           skeldone=1 
  	locflg=15  	nword=lngspl$locate(skelton,lengths,letter,lengthw, :  	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(nword.lt.0) go to 1000   	if(nword.gt.0) go to 510
  	go to 500  c try transposing all pairs of adjacent letters2  190	iostat = lngspl$transp(nword,usertab,ucorflg)2  	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50   	go to 510 +  c replace each letter by all other letters 3  200	iostat = lngspl$replace(nword,usertab,ucorflg) 2  	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50   	go to 510 #  c delete each letter one at a time 2  300	iostat = lngspl$delete(nword,usertab,ucorflg)2  	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50   	go to 510 /  c insert all possible letters in each position 2  400	iostat = lngspl$insert(nword,usertab,ucorflg)2  	if(iostat.ne.%loc(lngspl$_completed)) go to 1000  	if(nword.eq.0) go to 50   	go to 510 8  c if this is a case error, we already have the skeleton   500     if (skeldone) go to 502  	lengths=lengthw +  	call lngspl$rules(letter,skelton,lengths)           skeldone=1 9  c look for a match with skelton in the master dictionary 8  502     if(lengthw.le.21 .and. lengths.le.14) go to 505
      	try = 8       	return
  505	locflg=0 5  	nword=lngspl$locate(skelton,lengths,letter,lengthw, :  	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(nword)1000,50,510<  c list of candidates is in setlist.based on caseflg,restore?  c according to either the dictionary or form of the input wordG>  510	call lngspl$rescase(setlist,setcap,capcode,caseflg,nword)>  c scan setlist for duplicates.add only new candidates to list
  c for outputa8  	call lngspl$dupword(setlist,sethyp,list,hyphens,nword)  	if(nword.eq.0) go to 50y%  	if(nword.lt.0 .or. try.eq.7) returnt1  	lngspl$get_correction = %loc(lngspl$_completed)e  	return)  c try targetted substitution on skeletont  600   	totwrd=0
  	locflg=0  	rulepos=1h  	rulenum=1a>  610	if(lngspl$target(modskel,lengthm,rulenum,rulepos).ne. 0)   	1        go to 620  	if(totwrd.eq.0) go to 50=  	if(try.lt.7)lngspl$get_correction = %loc(lngspl$_completed)A  	return;  c rule rulenum of targetted sub has produced new skeleton f'  c modskel.see if it matches in lexicono8  620	nword=lngspl$locate(modskel,lengthm,letter,lengthw,:  	1            setlist,sethyp,setcap,setsuf,locflg,iostat)  	if(nword)1000,610,640 1  c modskel was matched.add non-duplicates to listr>  640	call lngspl$rescase(setlist,setcap,capcode,caseflg,nword)8  	call lngspl$dupword(setlist,sethyp,list,hyphens,nword)  	totwrd=totwrd+nworda  	if(nword.ge.0) go to 610  	return  c all tries exhausted  700	returnA  1000	continue  	lngspl$get_correction =iostat   	return"  	END			! of lngspl$get_correction