-  C	TITLE	Houghton Mifflin Utility (LHMINIUSR)   C++  C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.   C
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  CA  C	Houghton Mifflin entry point routine to initialize a specific    C	user memory dictionary:  C  C			LNGSPL$INITIALIZE_USER   C  C ENVIRONMENT:   C8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.<  C	Built as part of the verifier corrector shareable library  C0  C AUTHOR: Nick Tatham		CREATION DATE: 24-JUN-83  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C*  C X01.01	Nick Tatham 	24-JUN-83	Original	  C;  C X01.02	Cathy Baker 	13-JAN-84      Added code to improve *  C					       hyphenation storage in user   C					       memory.   C4  C X01.03	Cathy Baker	 9-FEB-84	Split into own file."  C						Changed INCLUDE statement   C						to use a logical.   C--  7  	INTEGER FUNCTION lngspl$initialize_user(size,usertab)   C++  C    FUNCTIONAL DESCRIPTION:   CF  C    Initializes the user memory table 'usertab' of 'size' longwords   C    with: @  C    	          i) 7 longwords of control info based on 'size':#  C    			Array pos (1): 'size' - 1  ,  C    				  (2): size of hyphen map section.,  C    				  (3): index for position of last (  C    				       dictionary word stored./  C    				  (4): capacity for dictionary words. 0  C    				  (5): 0, i.e. no of dictionary words   C    					  currently stored.1  C    				  (6)/(7): 1, i.e. reserved for future. C  C                   ii) 1 s for the area that can be covered with  1  C    			dictionary words when the table is used. @  C    		   iii) 0 s for the remaining unused word area, and the   C    			hyphen map area.   C  C    CALLING SEQUENCE:   C(  C	status.wlc.v = LNGSPL$INITIALIZE_USER  C    			(size.rlu.r,   C 		 	 usertab.wlu.ra)   C  C    FORMAL PARAMETERS:2  C	size:			Size in longwords of user memory array.5  C    				Must be a power of 2 between powers 11 and  <  C    		      		15 inclusive, i.e. 2048, 4096, 8192, 16384,   C				or 32678. -  C	usertab:		User memory array start address.   C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C  C	LNGSPL$_COMPLETED  C  C    SIDE EFFECTS:   C	None.  C--  @  C  'Houghton Mifflin Spelling Verification-Correction Copyright=  C  (c) Houghton Mifflin 1983 . All rights strictly reserved. A  C  Unpublished .Restricted and confidential proprietary programs <  C  of Houghton Mifflin . Licenced for use solely in DIGITAL<  C  software . Reproduction , disclosure , or re-creation of=  C  embodied computer programs or algorithms is prohibited .'   C  	IMPLICIT INTEGER(a-z)   	INTEGER		usertab(*)   	INCLUDE		'globalsym/list'   C    	usertab(1)=size-1 !  	usertab(2)=ishft(usertab(1),-4) .          if (usertab(2).gt.255) usertab(2)=255$  	usertab(3)=usertab(1)-usertab(2)-7,  	usertab(4)=ishft(size,-1) + ishft(size,-2)  	usertab(5)=0    	do 10 i=6,usertab(3)  10	usertab(i)='17777777'o  	do 20 i=usertab(3)+1,size   20	usertab(i)=04    	lngspl$initialize_user = %loc(lngspl$_completed)  	return!  	END	! of lngspl$initialize_user 