B  C***	TITLE	DECspell V1.1 Master Dictionary Block Analysis Program     C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.      C++
  C FACILITY:	   C		lngspl$   C  C ABSTRACT:  C6  C		Analyses the master dictionary file, to provide a >  C		statistical number for each word relating to its position 9  C		in the block in which it was found. Writes an output  %  C		file whose records have the form:   CC  C	NOTE: 	The raw tape file for V1.1 dictionaries is of a different :  C		structure to that of the V1.0 dictionaries. Hence this-  C		program is not the same as SPL1ANDIC.FOR.   CJ  C  M N word      -  where M is the count of the number of computer words K  C                   decoded to locate the language word in the dictionary  N  C                   block, and N is a boolean set if two blocks were decoded.  C+  C  		If M is 0, the word was found in RAM.   C	   C ENVIRONMENT: 8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.  C4  C AUTHOR: CATHY BAKER		CREATION DATE:   21-MAY-1984  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C2  C X01.01	Cathy		21-MAY-84	Original: created from !  C						DECSPELL V1.0 equivalent    C 						program.   C5  C X01.02	Cathy		24-MAY-84	Updated to write out error %  C 						records that are not put in    C						analysed output file.   C--              	PROGRAM analyse_mast_dic     C++  C    FUNCTIONAL DESCRIPTION:   C  C Control program: @  C Opens the raw dictionary file, and initializes the verifier. E  C Calls a routine that processes the dictionary file and writes the  N  C output file as described in module EXTRACT. If there is an error verifying F  C or extracting a word, the word causing the error is written to the 2  C SYS$OUTPUT instead along with the error status.  C0  C Closes the files and terminates the verifier.  C  C    CALLING SEQUENCE:   C	Main program.  C  C    FORMAL PARAMETERS:  C	None.  C  C    IMPLICIT INPUTS:  C	None   C  C    IMPLICIT OUTPUTS:   C	None   C  C    SIDE EFFECTS:   C	None.  C--         	IMPLICIT INTEGER*4 (a-z)         	PARAMETER	out_file = 10      C<  C Define variables for routines lngspl$initialize_verifier,:  C lngspl$verify_word_master and lngspl$terminate_verifier  C      	LOGICAL*1	corr  !      	PARAMETER	user_size = 16384 &      	INTEGER*4	user_memory(user_size)        	LOGICAL*1	userflg 3      	INTEGER*4	inistat, lngspl$initialize_verifier 6          INTEGER*4	termstat, lngspl$terminate_verifier.  	INTEGER*4	verstat, lngspl$verify_word_master   +  C Define variables for processing records.      	CHARACTER*21	ext_word           INTEGER*4	ext_length   	INTEGER*4	hyphen_map+          INTEGER*4	readstat,decode_wordlist   	INTEGER*4	block_pos           LOGICAL*1	next_blk 1          COMMON 	/decodedata/ block_pos, next_blk    *        EXTERNAL 	        lngspl$_completed)        EXTERNAL		lngspl$_correct_spelling (        EXTERNAL		lngspl$_initial_capital'        EXTERNAL		lngspl$_all_upper_case         EXTERNAL		lib$signal    4   2    FORMAT(' Verifier could not be initialized.')*   3    FORMAT(' ERROR analysing word: ',A)    4    FORMAT(I3,' ',L1,' ',A)		       C#  C OPEN the input and output files.   c   -        CALL open_wordlist ('LNGSPL$WORDLIST')    3        OPEN(unit=out_file, file='LNGSPL$ANALRES',   F       &     defaultfile = 'MASD$:[DECSPELL.SPLV11.PRM]DICANRES.DAT',  G       &                        status ='new', carriagecontrol = 'list')      C  C Initialize the verifier.   C        corr      = .true. K        userflg   = .false.	! Don't verify against the user dictionary table    +        inistat = lngspl$initialize_verifier I       &	 ('LNGSPL$MASTER', 'LNGSPL$RAMFIL', corr, user_size, user_memory)        6          IF (inistat.NE.%loc(lngspl$_completed)) THEN   	    WRITE (6,2)   	    GOTO 999          END IF          C3  C Start MAIN LOOP: read records and verifies them. B  C Calls LNGSPL$VERIFY_WORD_MASTER to verify the word against the J  C master dictionary.  If the word is found in the disk file (NOT in RAM) D  C then a number representing the amount of decoding done to locate C  C that word is produced (thro' linking with a modified version of  B  C LNGSPL$DECODE). This is returned in 'blockpos', and the boolean=  C 'nxtblk' set if two blocks of the dictionary were decoded.   C0  C Writes the results record to the output file.  C      100	CONTINUE   ?  	readstat = decode_wordlist (ext_word, ext_length, hyphen_map)   	IF (readstat.EQ.0) GOTO 999         C  C Verify the word.   C          next_blk    = 0		          block_pos   = 0    %  	verstat = lngspl$verify_word_master B       &	     ( ext_word(1:ext_length), user_mem, userflg, hyphens)   7          IF (verstat.NE.%loc(lngspl$_correct_spelling)) 
       &  THEN -             WRITE(6,3) ext_word(1:ext_length) *             CALL lib$signal(%val(verstat))          ENDIF  C!  C Write results of verification.   C@  	WRITE(out_file, 4) block_pos, next_blk, ext_word(1:ext_length)        	GOTO 100	! END OF LOOP         999   	CONTINUE    .  C Terminate the verifier and close the files.   )  	termstat = lngspl$terminate_verifier ()   	CALL close_wordlist ()$  	CALL EXIT				! Closes output file.     	END 