9  C***	TITLE	LNGSPLPER - DECspell performance suite driver      C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.      C++
  C FACILITY:	 
  C		LNGSPL  C  C ABSTRACT:  C<  C		Performance suite driver for DECspell shareable library   C		routines  C	   C ENVIRONMENT: 8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.  C/  C AUTHOR: Nick Tatham		CREATION DATE: 2-FEB-84   C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C'  C X01.01	Nick Tatham	2-FEB-84	Original ?  C X01.02	Cathy 	       24-FEB-84	Support of instruction file,  (  C						plus calls to each test routine.  C--       	PROGRAM	lngspl$per     C++  C    FUNCTIONAL DESCRIPTION:   CC  C       Main program to drive performance suite tests. Calls each  A  C	performance test in turn and then outputs a resource summary.	   CE  C	Uses an instruction file given by logical 'lngspl$perins'. Expects 9  C	each record of this file to have the following format:   C  C	123456789012345#  C	RRRRRR NNNNNN 11111 22222 333333   CJ  C	where RRRRRR is the test name e.g. 'usrini' - user initialization test.5  C	      NNNNNN is the iteration count for this test  C  C	      11111 22222 33333 are the test parameters, separated by a  #  C	      single space between each.   CJ  C	NOTE: if a record item doesn't fill all the character spaces allocated H  C	(.e.g iteration count is not 6 figures) you should put leading zeros   C	or spaces as appropriate.  C  C    CALLING SEQUENCE:   C  C	Main program.  C  C    FORMAL PARAMETERS:  C  C	None   C  C    IMPLICIT INPUTS:  C  C	None   C  C    IMPLICIT OUTPUTS:   C  C	Writes results to SYS$OUTPUT   C  C    ROUTINE VALUE:  C  C	None   C  C    SIDE EFFECTS:   C  C	None   C--       C****	Declarations    %  	INTEGER*4	teststat		! Return status 9  	INTEGER*4	lngutl$report_stat	! Status reporting routine    .  	INTEGER*4	lngspl$per_masini	! Test routines   	INTEGER*4	lngspl$per_usrini   	INTEGER*4	lngspl$per_usrloa   	INTEGER*4	lngspl$per_masver   	INTEGER*4	lngspl$per_usrver   	INTEGER*4	lngspl$per_cortst    0  C Variables connected with the instruction file   1  	PARAMETER	instr_file = 1		! Unit Channel number :          CHARACTER*80	instr_line		! Record from instr file0          INTEGER*4	instr_length		! Record length7          CHARACTER*6	test_name		! Param from instr line !  	INTEGER*4	it_count 		!        " '  	CHARACTER*80	param_string		!        " "          CHARACTER*1	space(2)		!       	PARAMETER	param_max_lgth = 80       C Variables for test parameters   6  	INTEGER*4	user_mem_size		! User memory size in longs:  	PARAMETER	usr_size_length = 5	! Corresponds to I5 format5  	CHARACTER*80	dictspec_string		! Dictionary filename :  	CHARACTER*80	filespec_string		! Words test file filename3  	INTEGER*4	dict_length		! Dictionary filename lgth 3  	INTEGER*4	file_length		! Words test filename lgth -  	INTEGER*4	try_number		! Corrector try value               CHARACTER*80	rem_string0  	INTEGER*4	rem_length		! Temporary computations      4   1	FORMAT(Q,A)			! For reading line from instr file>   2	FORMAT(A6,A1,I6,A1,A)		! For decoding line from instr file   7   3	FORMAT(I5)			! For decoding param for 'masini' and        					! 'usrini'.    4      FORMAT I       &(//' MASTER INITIALIZATION TEST Iteration: ',I6,' Mem. Size: ',I5)       5 	FORMAT G       &(//' USER INITIALIZATION TEST Iteration: ',I6,' Mem. Size: ',I5)    8   6	FORMAT(I5,A1,A)			! For decoding param for 'usrloa',  					! 'usrver', and cortst'.   
   7	FORMATI       &(//' USER LOAD TEST Iteration: ',I6,' Mem. Size: ',I5,' Dict: ',A)    D   8	FORMAT(//' MASTER VERIFY TEST Iteration: ',I6,' Words File: ',A)   
   9	FORMAT>       &(//' USER VERIFY TEST Iteration: 'I6,' Mem. Size: ',I5,       & ' Dict: ',A)   "   10     FORMAT(' Words File: ',A)      11     FORMAT H       &(//' CORRECTOR TEST Iteration: 'I6,' Mem. Size: ',I5,' Dict: ',A)   .   12     FORMAT(' Try: ',I1,' Words File: ',A)   ?   13	FORMAT(I1,A1,A)			! For decoding extra params for 'cortst'        C+   C Open instruction file  C- 1  	OPEN (  unit=instr_file, file='lngspl$perins',  -       &		defaultfile='SPL$SRC:PERINSTRS.TXT',        &		status='old',       &		readonly )            C+ 2  C LOOP : Process instruction lines until no more   C-    100	CONTINUE   B  	READ (unit=instr_file, fmt=1, end=200) instr_length, instr_line    @  	DECODE (instr_length, 2, instr_line(1:instr_length), err=150) >       &		test_name, space(1), it_count, space(2), param_string       C+    C Master Initialization Test...  C/  C Requires one parameter: the user memory size   C  C 3	FORMAT(I5)			K  C 4	FORMAT(' MASTER INITIALIZATION TEST Iteration: ',I6,' Mem. Size: ',I5)   C- !  	IF (test_name.EQ.'masini') THEN    B  	    DECODE (usr_size_length, 3, param_string(1:usr_size_length),#       &		    err=150) user_mem_size    9  	    WRITE(6,4) it_count, user_mem_size		! Print header     <  	    teststat = lngspl$per_masini (it_count, user_mem_size)   =  	    CALL lngutl$report_stat (teststat)		! Print test status        C+   C User Initialization Test...  C0  C Requires one parameter: the user memory size.  C  C 3	FORMAT(I5)			H  C 5	FORMAT(' USER INITIALIZATION TEST Iteration: ',I6,'Mem. Size: ',I5)  C- ,  	ELSE IF (test_name.EQ.'usrini') THEN		       B  	    DECODE (usr_size_length, 3, param_string(1:usr_size_length),$       & 		    err=150) user_mem_size   9  	    WRITE(6,5) it_count, user_mem_size		! Print header     <  	    teststat = lngspl$per_usrini (it_count, user_mem_size)   =  	    CALL lngutl$report_stat (teststat)		! Print test status        C+   C User Load Test ...   CF  C Requires two parameters: the user memory size, and the filename of 4  C the user dictionary to load into the user memory.  C  C 6	FORMAT(I5,A1,A)			   C 7	FORMAT J  C     &(//' USER LOAD TEST Iteration: ',I6,' Mem. Size: ',I5,' File: ',A)  C-    &  	ELSE IF (test_name.EQ.'usrloa') THEN   !  	    DECODE (param_max_lgth, 6,  6       &		    param_string(1:param_max_lgth), err=150) 5       &		    user_mem_size, space(1), dictspec_string    0  	    dict_length = INDEX(dictspec_string,' ')-1   *  	    WRITE(6,7) it_count, user_mem_size, >       &		       dictspec_string(1:dict_length)	! Print header    -  	    teststat = lngspl$per_usrloa(it_count,  8       &                                   user_mem_size,,       &					 dictspec_string(1:dict_length))   =  	    CALL lngutl$report_stat (teststat)		! Print test status        C+   C Master Verify Test ...   C?  C Requires one parameter: the filename of the words to verify.   C  C 8	FORMAT B  C     &(//' MASTER VERIFY TEST Iteration: ',I6,' Words File: ',A)  C-    &  	ELSE IF (test_name.EQ.'masver') THEN   -  	    file_length = INDEX(param_string,' ')-1    7  	    WRITE(6,8) it_count, param_string(1:file_length)    	    						! Print header     .  	    teststat = lngspl$per_masver (it_count, *       &					  param_string(1:file_length))   =  	    CALL lngutl$report_stat (teststat)		! Print test status           C+   C User Verify Test ...   CH  C Requires three parameters: the user memory size, the filename of the D  C user dictionary to load, and the filename of the words to verify.  C  C 6	FORMAT(I5,A1,A)			   C 9	FORMAT K  C     &(//' USER VERIFY TEST Iteration: 'I6,' Mem. Size: ',I5,' Dict: ',A)   C#  C 10     FORMAT(' Words File: ',A)   C  C-    &  	ELSE IF (test_name.EQ.'usrver') THEN   !  	    DECODE (param_max_lgth, 6,  6       &		    param_string(1:param_max_lgth), err=150) 5       &		    user_mem_size, space(1), dictspec_string    4  	    dict_length     = INDEX(dictspec_string,' ')-17  	    filespec_string = dictspec_string(dict_length+2:) 4  	    file_length     = INDEX(filespec_string,' ')-1     	    WRITE(6,9) it_count,  A       &	    	       user_mem_size, dictspec_string(1:dict_length) 0  	    WRITE(6,10) filespec_string(1:file_length)  	    						! Print header     .  	    teststat = lngspl$per_usrver (it_count, !       &	    				  user_mem_size,  4       &	      				  dictspec_string(1:dict_length), -       &					  filespec_string(1:file_length))    =  	    CALL lngutl$report_stat (teststat)		! Print test status              C+   C Corrector Test ...   CG  C Requires four parameters: the user memory size, the user dictionary  I  C filename, the corrector try value, and the filename of the words file    C to correct.  C  C 6	FORMAT(I5,A1,A)			   C  C 11     FORMATI  C     &(//' CORRECTOR TEST Iteration: 'I6,' Mem. Size: ',I5,' Dict: ',A)   C/  C 12     FORMAT(' Try: ',I1,' Words File: ',A)   C  C 13   FORMAT(I,A1,A)  C-    &  	ELSE IF (test_name.EQ.'cortst') THEN   !  	    DECODE (param_max_lgth, 6,  6       &		    param_string(1:param_max_lgth), err=150) 5       &		    user_mem_size, space(1), dictspec_string    0  	    dict_length = INDEX(dictspec_string,' ')-13  	    rem_string  = dictspec_string(dict_length+2:) D  	    rem_length  = param_max_lgth - (usr_size_length+dict_length+2)   @  	    DECODE (rem_length, 13, rem_string(1:rem_length), err=150):       &              try_number, space(2), filespec_string  	    0  	    file_length = INDEX(filespec_string,' ')-1   +  	    WRITE(6,11) it_count, user_mem_size,  .       &	      		dictspec_string(1:dict_length)  	    WRITE(6,12) try_number, (       &			filespec_string(1:file_length)  	    						! Print header L-  	    teststat= lngspl$per_cortst (it_count, C'       &	    			         user_mem_size, T3       &	      				 dictspec_string(1:dict_length),  5       &                                   try_number,nI       &                                   filespec_string(1:file_length))d  t=  	    CALL lngutl$report_stat (teststat)		! Print test statusa  o  a  	ENDIF   C/  	GOTO 100		! END OF INSTR FILE PROCESSING LOOP       	  b  C+ 0  C ERROR decoding a line of the instruction file  C-h-   150	WRITE(6,151) instr_line(1:instr_length) )   151	FORMAT(/' Error decoding line: ',A)e
  	GOTO 100  i  C+ *  C Processing of instruction file complete  C-    200	CONTINUE*  	CALL EXIT		! Close down instruction file  G  	END 	! of lngspl$per